/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: haustierlizenz.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/haustierlizenz.c
// Info  : Eine Haustier-Lizenz.

inherit "std/thing";
inherit "std/more";

#include <properties.h>
#include <language.h>
#include <description.h>
#include <moving.h>

#include "/npc/haustier.h"

#define BS break_string

static object haustier_obj;

static string haustier_race;
static string haustier_name;
static string haustier_adj;

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_LONG,        "Diese Lizenz erlaubt es Dir offiziell, ein Haustier "
                         "zu halten.");
  SetProp(P_NAME,        "Haustier-Lizenz");
  SetProp(P_PLURAL,      "Haustier-Lizenzen");
  SetProp(P_NAME_ADJ,    0);
  SetProp(P_GENDER,      FEMALE);
  SetProp(P_DESCR,       0);
  SetProp(P_INFO,        "Deine Erlaubnis zur Haustierhaltung. (lies regeln, lies lizenz)");
  SetProp(P_WEIGHT,      1);
  SetProp(P_VALUE,       0);
  SetProp(P_NOBUY,       1);
  SetProp(P_NODROP,      BS("Du kannst die Lizenz hoechstens zerreissen."));
  SetProp(P_NEVERDROP,   1);
  SetProp(P_AUTOLOADOBJ, 1);

  haustier_obj  = 0;

  haustier_race = 0;
  haustier_name = 0;
  haustier_adj  = 0;

  AddId(({"lizenz", "haustierlizenz"}), ({"lizenzen", "haustierlizenzen"}));

  AddCmd("lies|lese&vertrag|lizenz|haustierlizenz",
    "do_lesen");
  AddCmd("zerstoere|vernichte|zerreisse&lizenz|vertrag|haustierlizenz",
    "do_zerreissen");
  AddCmd("rufe|ruf|hole&tier|haustier",
    "do_holen");
  AddCmd("schick|schicke&haustier&weg|heim",
    "do_schicken");
}

mixed *_query_autoloadobj ()
{
  return ({haustier_race, haustier_name, haustier_adj});
}

void _set_autoloadobj (mixed *data)
{
  if (!pointerp(data) || (sizeof(data) < 3) || !stringp(data[0]) ||
      !stringp(data[1]) || !stringp(data[2]))
    return;

  haustier_race = data[0];
  haustier_name = data[1];
  haustier_adj  = data[2];
}

void SetHaustierRace (string race)
{
  haustier_race = race;
}

void SetHaustierName (string name)
{
  haustier_name = name;
}

void SetHaustierAdj (string adj)
{
  haustier_adj = adj;
}

int do_lesen (string str)
{
  if (str == "regeln")
  {
    More("haustiervertrag.txt", 1);
    return 1;
  }

  if (! id(str))
    return 0;

  More("haustier_hund.txt", 1);

  return 1;
}

int do_zerreissen (string str)
{
  if (! id(str))
    return 0;

  write("Du zerreisst Deine Lizenz.\n");

  return remove();
}

int do_holen (string str)
{
  if (haustier_obj)
  {
    write("Das arme Tier hat doch nur ein bischen herumgeschnueffelt ...\n");
    haustier_obj->move(environment(this_player()), M_GO);
    return 1;
  }

  haustier_obj = clone_object("/npc/haustiere/" + haustier_race + ".c");
  if (haustier_obj)
  {
    write("Du rufst Deinen Hund. Sofort kommt er freundlich bellend um die Ecke.\n");
    this_player()->AddPursuer(haustier_obj);
    haustier_obj->move(environment(this_player()), M_GO);
  }

  return 1;
}

int do_schicken (string str)
{
/*
  if ((str == "hund nach hause") || (str == "hund weg"))
  {
    if (hund)
    {
      write("Du schickst Deinen Hund nach Hause.\n");
      this_player()->RemovePursuer(hund);
      hund->remove();
      if (hund)
        destruct(hund);
    }
    else
    {
      write("Dein Hund ist ja gar nicht in der Naehe !\n");
    }
  }
*/
  return 1;
}
