/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: essen.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
/*
  ESSEN UND TRINKEN
     Version 2.3

  Das ist ein File fuer Essen und Trinken. Um es zu verwenden, einfach ein
	inherit "players/anthea/essen";
  an den Fileanfang setzten. 
  Ausserdem sollte noch ein 
	#include players/anthea/foodprops.h 
  gesetzt werden.
 
  Die Properties in foodprops.h haben folgende Funktionen:
	P_IS_DRINK :    Das Ding soll ein Getraenk sein... -> es gibt die
			Aktion: trinke ... 

	P_IS_FOOD :     Das Ding soll etwas zum Essen sein... -> es gibt die
			Aktion: esse ... (oder iss ....)

	ACHTUNG: P_ISFOOD UND P_ISDRINK SCHLIESSEN SICH GEGENSEITIG AUS!! DAS
		 HEISST, WENN P_ISFOOD GESETZT IST WIRD P_ISDRINK GELOESCHT
		 UND UMGEKEHRT! D.H. ES MUSS NUR EINES VERWENDET WERDEN.

	P_EATER :       Die Meldung, die derjenige kriegt, der das Ding isst.

	P_MESSAGE:      Die Meldung, die die umstehenden erhalten.

	P_EMPTY_CONTAINER: Wenn man das aufgegessen/ausgetrunken hat, wird die
			Short-Description umgesetzt, so dass z.B. aus einer
			Flasche Cola eine Colaflasche wird ;)

	P_EMPTY_GENDER: Das leere Gefaess muss ja nicht das selbe Geschlecht
			haben wie das volle.

	P_EMPTY_ID:     Eine ID fuer das leere Gefaess, damit es auch irgendwie
			angesprochen werden kann.

	P_EMPTY_LONG:   Eine Long-Description, wenn das Ding leer ist.

	P_ALCO: Die Menge an Alkohol, die das Getraenk hat.
	
	P_WATER:        Die Menge an Fluessigkeit, die das Getraenk hat.

	P_FOOD_SIZE:    Wie gross die Pizza hier halt ist ;)

	P_STRENGHT:Soll die Mahlzeit eine Zusaetzliche heilwirkung haben?

	P_NO_CONTAINER: Wenn diese Property auf 1 ist, wird das Ding nach 
			dem Essen/Trinken zerstoert, bei 0 erhaelt man das
			P_LEERES_GEFAESS.

	P_ISFULL:       Zum Testen, ob das Ding noch voll ist oder nicht.

	P_BAD:          Es kann ja sein, dass das Ding verdorben ist oder
			einfach zum ko.... schmeckt. Dann wird P_SCHLECHT
			gesetzt, und P_STAERKE wird verwendet, um dem 
			Spieler zu zeigen, wie schlecht ihm ist.....
			Es wird im Abstand von 10 sek. 3x die Staerke von
			seinen Lebenspunkten abgezogen.

	P_BAD_MESSAGE:  Die Meldung, die der Spieler erhaelt, wenn ihm schlecht
			ist (auch die 3x ).

	P_POISON:       Der Giftlevel des Essens.... wenn es einen hat. Wird
                        jetzt an den Spieler weitergegeben... man kann also
                        endlich giftiges Essen bauen.

 
	ES MUSS EINE ID GESETZT SEIN, MIT DER DAS DING AUCH ANGESPROCHEN WERDEN
	KANN!!!!
*/

#include <properties.h>
#include "essenprop.h"

inherit "std/thing";
inherit "/npc/partymonster/std/essenprop";

int sl;

int ist_schlecht (object tp);

void init ()
{
  ::init();

  add_action("esse",  "esse");
  add_action("esse",  "iss");
  add_action("trink", "trink");
  add_action("trink", "trinke");
}

void create ()
{
  ::create();

  SetProp(P_EATER,           "Mjam Mjam Mampf"); 
  SetProp(P_MESSAGE,         "isst etwas auf");
  SetProp(P_IS_FOOD,         1);
  SetProp(P_IS_FULL,         1);
  SetProp(P_ALCO,            0);
  SetProp(P_WATER,           5);
  SetProp(P_FOOD_SIZE,       5);
  SetProp(P_STRENGTH,        0);
  SetProp(P_EMPTY_CONTAINER, "Leerer Teller");
  SetProp(P_EMPTY_GENDER,    1);
  SetProp(P_NO_CONTAINER,    1);
  SetProp(P_BAD,             0);
  SetProp(P_BAD_MESSAGE,     "Dir ist furchtbar schlecht.");
  SetProp(P_WEIGHT,          1);
  SetProp(P_VALUE,           10);
  SetProp(P_POISON,          0);
  SetProp(P_LONG,            "Was zu essen.");
  SetProp(P_NAME,            "Was zu essen");
  SetProp(P_ARTICLE,         ART_NONE);

  AddId("essen");
  AddId("trinken");

  sl=0;
}

int esse (string str)
{
  object tp;
  int    zw;
  string p_name;

	if(QueryProp(P_IS_FOOD)==0) return 0;
	if(QueryProp(P_IS_FULL) == 0) return 0;
	tp = this_player();
	p_name = tp->name(0,0);
	if (!str) return 0;
	if(!id(str)) return 0;
	if(QueryProp(P_BAD)==1) {
		write(QueryProp(P_EATER)+ ".\n");
		if(QueryProp(P_MESSAGE))
			say(p_name + " " + QueryProp(P_MESSAGE) + ".\n");
		else
			say(p_name + " isst " + QueryProp(P_NAME) + ".\n");
		ist_schlecht(tp);
		zw=QueryProp(P_POISON);
		if(zw>0) tp->SetProp(P_POISON,tp->QueryProp(P_POISON)+zw);
		if(QueryProp(P_NO_CONTAINER)) remove();
		else {
			SetProp(P_GENDER,QueryProp(P_EMPTY_GENDER));
			SetProp(P_LONG,QueryProp(P_EMPTY_LONG));
			SetProp(P_NAME,QueryProp(P_EMPTY_CONTAINER));
			SetProp(P_IS_FULL,0);
			AddId(QueryProp(P_EMPTY_ID));
			AddId(lower_case(QueryProp(P_EMPTY_CONTAINER)));
		}
		return 1;
	}
	if(!tp->eat_food(QueryProp(P_FOOD_SIZE))) return 1;
        zw=QueryProp(P_POISON);
        if(zw>0) tp->SetProp(P_POISON,tp->QueryProp(P_POISON)+zw);

	tp->heal_self(QueryProp(P_STRENGTH));
	write(QueryProp(P_EATER)+ ".\n");
	if(QueryProp(P_MESSAGE))
		say(p_name + " " + QueryProp(P_MESSAGE) + ".\n");
	else
		say(p_name + " isst " + QueryProp(P_NAME) + ".\n");
	if(QueryProp(P_NO_CONTAINER)) remove();
	else {
		SetProp(P_GENDER,QueryProp(P_EMPTY_GENDER));
		SetProp(P_LONG,QueryProp(P_EMPTY_LONG));
		SetProp(P_NAME,QueryProp(P_EMPTY_CONTAINER));
		SetProp(P_IDS,"objekt");
		AddId("ding");
                AddId(lower_case(QueryProp(P_EMPTY_CONTAINER)));
		AddId(QueryProp(P_EMPTY_ID));
		SetProp(P_IS_FULL,0);
  }

  return 1;
}

int trink (string str)
{
  object tp;
  int    zw;
  string p_name;

  tp = this_player();
  p_name = tp->name(0,0);

  if (!str) return 0;
  if (!id(str)) return 0;
  if (QueryProp(P_IS_DRINK)==0) return 0;
  if (QueryProp(P_IS_FULL)==0) return 0;
  if (!str) return 0;
  if (QueryProp(P_BAD)==1)
  {
    write(QueryProp(P_EATER)+ ".\n");
    if (QueryProp(P_MESSAGE))
      say(p_name + " " + QueryProp(P_MESSAGE) + ".\n");
    else
      say(p_name + " trinkt " + QueryProp(P_NAME) + ".\n");

    ist_schlecht(tp);
    zw=QueryProp(P_POISON);
    if (zw>0)
      tp->SetProp(P_POISON,tp->QueryProp(P_POISON)+zw);
    if (QueryProp(P_NO_CONTAINER))
      remove();
    else
    {
      SetProp(P_GENDER,QueryProp(P_EMPTY_GENDER));
      SetProp(P_LONG,QueryProp(P_EMPTY_LONG));
      SetProp(P_NAME,QueryProp(P_EMPTY_CONTAINER));
      SetProp(P_IS_FULL,0);

      AddId(QueryProp(P_EMPTY_ID));
      AddId(lower_case(QueryProp(P_EMPTY_CONTAINER)));
    }
    return 1;
  }

	if(QueryProp(P_ALCO) >0) if (!tp->drink_alcohol(QueryProp(P_ALCO)))
		return 1;
	if(QueryProp(P_ALCO) == 0) if (!tp->drink_soft(QueryProp(P_WATER)))
		return 1;
	SetProp(P_IS_FULL,0);
	tp->heal_self(QueryProp(P_STRENGTH));
	if(QueryProp(P_BAD)==1) ist_schlecht(tp);
	write(QueryProp(P_EATER) + ".\n");
	if (QueryProp(P_MESSAGE))
		say(p_name + " " + QueryProp(P_MESSAGE)+".\n");
	else
		say(p_name + " trinkt " + QueryProp(P_NAME) + ".\n");
	SetProp(P_VALUE,10);
        zw=QueryProp(P_POISON);
        if(zw>0) tp->SetProp(P_POISON,tp->QueryProp(P_POISON)+zw);
	if(QueryProp(P_NO_CONTAINER)) remove();
	else {
		SetProp(P_GENDER,QueryProp(P_EMPTY_GENDER));
		SetProp(P_LONG,QueryProp(P_EMPTY_LONG));
		SetProp(P_NAME,QueryProp(P_EMPTY_CONTAINER));
		SetProp(P_IS_FULL,0);
                SetProp(P_IDS,"objekt");
                AddId("ding");
                AddId(lower_case(QueryProp(P_EMPTY_CONTAINER)));
                AddId(QueryProp(P_EMPTY_ID));
  }
  return 1;
}

int ist_schlecht (object tp)
{
  string p_name,schlechtmeld;
  int staerke;
  object schlechter;

  p_name=tp->QueryName();
  staerke=QueryProp(P_STRENGTH);
  schlechtmeld=QueryProp(P_BAD_MESSAGE);
  //schlechter=clone_object("players/anthea/schlecht");
  //schlechter->move(tp);
  //schlechter->ist_schlecht(tp,p_name,staerke,schlechtmeld);
  return 1;
}
