/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pm.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/npc/pm.c
// Info  : Das neue Party-Monster.
// Autor : Big@MD

#pragma strong_types

inherit "std/netti";

#include <properties.h>
#include <description.h>
#include <combat.h>
#include <language.h>
#include <defines.h>
#include <moving.h>

#include "../def.h"

static  int grins_an;
string *allowed;
static  int singen;
string *songtext;

void   add_object     (string str);
int    do_geben       (string spieler, string objekt, int logmode);
void   do_geben_runde (string objekt);
string do_zielen      (object npc);
void   write_say      (object whom, string teil1, string dir, string wem, string teil2);

void create ()
{
  object ob;

  if (! clonep())
    return;

  ::create();

  grins_an = 1;
  singen   = 0;
  allowed  = ({});

  create_default_npc(20);
  set_living_name("partymonster");
  seteuid(getuid(this_object()));

  SetProp(P_NAME,       "Partymonster");
  SetProp(P_LONG,       "Das Partymonster ist da. Frohsinn! Stimmung! Es hat immer "
                        "alles fuer eine Party dabei und hat noch nie eine Party "
                        "ausgelassen ... Sagen Sie einfach ihre Wuensche dem "
                        "Partymonster und es erfuellt sie.");
  SetProp(P_PLURAL,     "Partmonster");
  SetProp(P_GENDER,     NEUTER);
  SetProp(P_ARTICLE,    ART_DEF);
  SetProp(P_DESCR,      0);
  SetProp(P_BODY,       20);
  SetProp(P_HANDS,      ({" mit einem Sangria-Eimer", 5}) );
  SetProp(P_MAX_HANDS,  2);
  SetProp(P_MAX_HP,     100);
  SetProp(P_HP,         100);
  SetProp(P_ALIGN,      1000);
  SetProp(P_AGGRESSIVE, 0);
  SetProp(P_NOCORPSE,   1);
  SetProp(P_DIE_MSG,    " raeumt auf und eilt zur naechsten Party.\n");
  SetProp(P_KILL_MSG,   "Wer hat noch nicht, wer will noch zu Lars ?");
  SetProp(P_SPELLRATE,  50); // 50 %
  SetProp(P_LOG_INFO,   LOG "partymonster.log");
  SetProp(P_RACE,       "partymonster");
  SetProp(P_XP,         1);
  SetProp(P_SIZE,       200);
  SetProp(P_AC,         100);
  SetProp(P_MSGOUT,     "eilt zur naechsten Party");
  SetProp(P_MSGOUT,     "eilt zur naechsten Party");
  SetProp(P_LEVEL,      20);

  AddId(({"monster", "pm", "partymonster"}),
        ({"monster", "pm", "partymonster"}));

  AddInfo("\ndefault",
    "schaut Dich erwartungsvoll an.");
  AddInfo("wunsch|wuensche",
    "sagt: Wuensche Dir doch einfach mal etwas:\n\n"
    "sag[e] Partymonster gib spieler|mir|allen objekt\n"
    "                    hole susanne|max\n"
    "                    hole stripper\n"
    "                    singe lied\n"
    "                    hoere auf zu singen\n"
    "                    verschwinde\n");

  add_object(OBJ "cola");
  add_object(OBJ "chips");
  add_object(OBJ "lolli");
  add_object(OBJ "pappnase");
  add_object(OBJ "mon_cherie");
  add_object(OBJ "flepi");
  add_object(OBJ "joint");
  add_object(OBJ "dickmann");
  add_object(OBJ "ei");
  add_object(OBJ "eis_erd");
  add_object(OBJ "eis_sch");
  add_object(OBJ "eis_van");
  add_object(OBJ "eis_wal");
  add_object(OBJ "kissen");
  add_object(OBJ "osterei");
  add_object(OBJ "reis");
  add_object(OBJ "rpause");
  add_object(OBJ "tafel");
  add_object(OBJ "torte");
  add_object(OBJ "twix");
  add_object(OBJ "yogurette");
  add_object(OBJ "fisch");

  if (! living(ob = previous_object()))
    if(! living(ob = environment(previous_object())))
     return;

  log_file(LOGFILE, dtime(time()) + " Partymonster geklont von " + ob->name() + "\n");

  call_out("die", MAX_PARTY_DAUER);
}

void give_notify (object obj)
{
  string ding;

  ding = obj->QueryProp(P_NAME);
  if (obj->id("geld"))
  {
    tell_room(environment(), "Das Partymonster sagt: Danke, aber ich bin unbestechlich.\n", ({this_object()}));
    obj = present("geld", this_object());
    give_obj(obj, this_player());
    return;
  }





  log_file(LOGFILE, dtime(time()) + " " + this_player()->name() + " hat mir \"" + ding + "\" gegeben.\n");
  write("Das Partymonster sagt: Prima! Danke fuer " + obj->name(WEN, 1) + ".\n");
  call_out("do_aktion", 4, this_object(), obj);
}

void add_object (string str)
{
  object obj;
  string err;

  if (err = catch(obj = clone_object(str)))
  {
    log_file(LOGFILE, "Clonen von " + to_string(obj) + " (" + str + ") fehlgeschlagen: " + err + "\n");
  }
  else
  {
    obj->move(this_object());

    obj->SetProp(P_NODROP,   0);
    obj->SetProp(P_VALUE,    0);
    obj->SetProp(P_PARTY_ID, 1);

    allowed += ({str});
  }
}

void pm_say (string str)
{
  say("Das Partymonster sagt: " + str + "\n");
}

void die ()
{
  object *list, obj;
  int i;

  if (singen == 1)
  {
    singen = 0;
    if (find_call_out("do_singe_zeile") != -1)
    {
      while (remove_call_out("do_singe_zeile") != -1)
        ;
    }
  }

  // Alles mitnehmen was noch rumliegt und vom Partymonster ausgegeben wurde.

  // list = all_inventory(environment());
  // for(i = 0; i < sizeof(list); i++)
  //   if (list[i]->QueryProp(P_PARTY_ID)) list[i]->remove();

  map_array(all_inventory(environment()),
    lambda(({'o}),
      ({#'?, ({#'call_other, 'o, "QueryProp", P_PARTY_ID}),
        ({#'call_other, 'o, "remove"})
      })
    )
  );

  // Alles im Partymonster weg.

  list = all_inventory(this_object());
  for (i = 0; i < sizeof(list); i++)
    list[i]->remove();

  // Gaeste aufraeumen.

  if ((obj=present("susanne")) && !query_once_interactive(obj))  
  {
    present("susanne")->remove();
    say("Susanne winkt und geht davon.\n");
  }

  if ((obj=present("max")) && !query_once_interactive(obj))  
  {
    present("max")->remove();
    say("Max gruesst und verlaesst euch.\n");
  }

  if ((obj=present("rosie")) && !query_once_interactive(obj))  
  {
    obj->remove();
    say("Rosie winkt euch zu.\n");
  }

  if ((obj=present("tom")) && !query_once_interactive(obj))  
  {
    obj->remove();
    say("Tom verneigt sich.\n");
  }

  log_file(LOGFILE, dtime(time()) + " Partymonster verschwindet.\n");

  ::die();
}

int do_singe_zeile (int line)
{
  say(BS("Das Partymonster singt: " + songtext[line]));

  if (sizeof(songtext) <= line+1)
  {
    singen = 0;
  }
  else
  {
    if (singen == 0)
    {
      pm_say("Ok, ich hoere ja schon auf.");
      pm_say("Du goennst mir bloss meinen Erfolg nicht!");
    }
    else
    {
      call_out("do_singe_zeile", 0, line+1);
    }
  }

  return 1;
}

int do_singen (string lied)
{
  string *files;
  string  text;

  switch (lied)
  {
    case "lied":
      files = get_dir(SONGS "*.txt");
      if (sizeof(files))
      {
        text = read_file(SONGS + files[random(sizeof(files))]);
      }
      else
      {
        pm_say("Huch. Mir fallen gar keine Lieder ein. Was mache ich denn jetzt nur?");
        return 1;
      }
      break;

    case "party":
      text = read_file(SONGS "party.txt");
      break;

    case "tamagotchi":
      text = read_file(SONGS "tamagotchi.txt");
      break;
  }

  songtext = efun::explode(text, "\n") - ({""});

  if (sizeof(songtext))
  {
    call_out("do_singe_zeile", 0, 0);
  }
  else
  {
    pm_say("Komisch. Jetzt hab' ich den Text vergessen...");
    return 1;
  }

  return 1;
}

void catch_tell (string str)
{
  string s1, s2, s3;
  string *ss;
  object obj;

  if (!str || str=="")
    return;

  str = lower_case(str);

  // Raum-Meldungen (emotes, usw.) abarbeiten und darauf reagieren.






  // Ab hier nur alles was man dem Partymonster sagt.

  if (sscanf(str, "%s sagt: partymonster gib %s %s\n", s1, s2, s3))
  {
    if (s3 == "alles")
    {
      pm_say("Das koennte Dir so passen ;-)");
      return;
    }

    if (s2 == "mir")
    {
      //call_out("do_geben", 0, this_player()->name(RAW) /*s1*/, s3, 1);
      do_geben(this_player()->name(RAW), s3, 1);
      return;
    }

    if (s2 == "allen")
    {
      //call_out("do_geben_runde", 0, s3);
      do_geben_runde(s3);
      return;
    }

    //call_out("do_geben", 0, s2, s3, 1);
    do_geben(s2, s3, 1);
    return;
  }

  // Befehle an das Partmonster abarbeiten.

  if (! sscanf(str, "%s sagt: partymonster %s", s1, s2))  // Bin ich gemeint ?
    return;

  if (sscanf(str, "%s sagt: partymonster hoere auf\n", s1))
  {
    pm_say("Womit soll ich denn aufhoeren?");
    return;
  }

  if (sscanf(str, "%s sagt: partymonster hoere auf %s singen\n", s1, s2))
  {
    if (singen == 0)
    {
      pm_say("Ich hab' doch gar nichts gesungen.");
    }
    else
    {
      singen = 0;
    }

    return;
  }

  if (sscanf(str, "%s sagt: partymonster singe %s\n", s1, s2))
  {
    if (singen == 1)
    {
      pm_say("Hoerst Du nicht, dass ich gerade ein Lied singe?");
      return;
    }

    switch (s2)
    {
      case "lied":
      case "party":
      case "tamagotchi":
        pm_say("Ok, Du hast es so gewollt!");
        singen = 1;
        call_out("do_singen", 1, s2);
        return;

      default:
        pm_say("Eigentlich kann ich gar nicht singen ...");
        return;
    }

    return;
  }

  if (sscanf(str, "%s sagt: partymonster hole susanne", s1))
  {
    if (present("susanne", environment()))
    {
      pm_say("Susanne ist doch schon da!");
      return;
    }

    if (! obj = find_living("susanne") || (obj && query_once_interactive(obj)))
    {
      obj = clone_object(NPC "susanne");
      if (obj)
      {
        obj->move(environment(), M_TPORT);
        obj->seteuid(getuid(obj));
      }
    }

    if (present("max", environment()))
      say("Susanne gibt Max einen dicken Kuss.\n", this_object());

    return;
  }

  if (sscanf(str, "%s sagt: partymonster hole max", s1))
  {
    if (present("max", environment()))
    {
      pm_say("Max ist doch schon da!");
      return;
    }

    if (! obj = find_living("max") || (obj && query_once_interactive(obj)))
    {
      obj = clone_object(NPC "max");
      if (obj)
      {
        obj->move(environment(), M_TPORT);
        obj->seteuid(getuid(obj));
      }
    }

    if (present("susanne", environment()))
      say("Max gibt Susanne einen dicken Kuss.\n", this_object());

    return;
  }

  if (sscanf(str, "%s sagt: partymonster hole stripper", s1))
  {
    if (present("rosie", environment()))
    {
      pm_say("Rosie ist doch schon da!");
    }
    else 
    {
      if (! obj = find_living("rosie") || (obj && query_once_interactive(obj)))
        obj = clone_object(NPC "rosie");
      if (obj)
      {
        obj->move(environment(), M_TPORT);
        obj->seteuid(getuid(obj));
      }
    }

    if (present("tom", environment()))
    {
      pm_say("Tom ist doch schon da!");
      return;
    }

    if (! obj = find_living("tom") || (obj && query_once_interactive(obj)))
      obj = clone_object(NPC "tom");
    if (obj)
    {
      obj->move(environment(), M_TPORT);
      say("Rosie streicht Tom luesternd durchs Haar.\n");
      obj->seteuid(getuid(obj));
    }

    return;
  }

  if (sscanf(str, "%s sagt: partymonster %s\n", s1, s2))
  {
    if (s2 == "verschwinde")
    {
      die();
      return;
    }

    if (! s2) s2 = " ";
    ss = explode(s2, "\n");
    if (sizeof(ss))
      s2 = implode(ss, " ");
    else
      return;

    say(capitalize(name()) + " sagt: Wer oder was soll das sein: \"" + s2 + "\"?\n");
  }
}

int do_geben (string spieler, string objekt, int logmode)
{
  object ziel;
  object obj;
  string filename;
  string descr;

  if (spieler == "" || spieler == 0)
  {
    pm_say("Wem?");
    return 0;
  }

  if (objekt == "" || objekt == 0)
  {
    pm_say("Was?");
    return 0;
  }

  obj = present(lower_case(objekt), this_object());
  if (obj == 0)
  {
    if (obj = present(lower_case(objekt)))
    {
      pm_say(capitalize(obj->name(WER, 0)) + " liegt doch am Boden rum.");
      return 0;
    }
    else
    {
      pm_say(capitalize(objekt) + " habe ich nicht!");
      return 0;
    }
  }

  if (obj->QueryProp(P_NODROP))
  {
    pm_say(capitalize(obj->name(WEN, 0)) + " darf ich nicht hergeben!");
    return 0;
  }

  if (! obj->QueryProp(P_PARTY_ID))
  {
    pm_say(capitalize(obj->name(WER, 0)) + " wurde mir zugeschummelt und ist somit nichts fuer Dich!");
    log_file(LOGFILE, dtime(time()) + " " + this_player()->name() + " hat mir " + obj->name(WEN,0) + " zugeschummelt. (" + to_string(obj) + ")\n");
    drop_obj(obj);
    if (environment(obj) == this_object())
      obj->remove();
    return 0;
  }

  ziel = present(lower_case(spieler), environment());
  if (ziel == 0)
  {
    pm_say(capitalize(spieler) + " sehe ich hier nicht!");
    return 1;
  }

  if (present(lower_case(objekt), ziel))
  {
    pm_say(capitalize(ziel->name(WER, 0)) + " hat doch schon " + obj->name(WEN, 0) + "!");
    return 1;
  }

  if (present("pappnase", ziel))
  {
    pm_say(capitalize(ziel->name(WER, 0)) + " hat eine Pappnase auf und kriegt nix mehr.");
    return 1;
  }

  filename = explode(file_name(obj), "#")[0];
  //write(sprintf("X-> %O, %O, %O, %O\n", file_name(obj), filename, member_array(filename, allowed), allowed));
  if (member_array(filename, allowed) == -1)
  {
    pm_say(obj->name() + " gebe ich nicht mehr her!");
    return 1;
  }

  obj = clone_object(filename);
  if (! obj) 
  {
    pm_say("Ich kann \"" + filename + "\" nicht klonen!");
    return 0;
  }

  descr = obj->QueryProp(P_DESCR);
  if ((descr == "") || (descr == 0))
    descr = "";
  else
    descr = " " + descr;

  write_say(ziel, "Das Partymonster gibt ", "Dir", ziel->name(WEM, 1), " " + obj->name(WEN, 0) + descr + ".\n");
  //do_say("Das Partymonster gibt "+ziel->name(WEM,1)+" " + obj->name(WEN, 0) + ".\n");

  obj->SetProp(P_VALUE,    1);
  obj->SetProp(P_NOBUY,    1);
  obj->SetProp(P_PARTY_ID, 1);

  obj->move(ziel, M_GIVE);

  if (! query_once_interactive(ziel))
    call_out("do_aktion", random(5)+4, ziel, obj);

  log_file(LOGFILE, logmode ? ziel->name(WER, 1) + " bekommt " + obj->name(WEN, 0) + " von " + this_player()->name() + ".\n"
                            : ziel->name(WER, 1) + " ");
  return 1;
}

void do_geben_runde (string objekt)
{
  object *list, env;
  int i;

  if (! (env = environment()))
    return;

  if (living(env))
    env = environment(env);

  list = all_inventory(env);
  for (i = 0; i < sizeof(list); i++)
    if (living(list[i]) && list[i] != this_object() && !(list[i]->QueryProp(P_INVIS)))
      if (! do_geben(list[i]->name(RAW) || "", objekt, 0))
        break;

  if (present(objekt, this_object()))
    log_file(LOGFILE, "Alle bekommen " + present(objekt, this_object())->name(WEN, 0) + " von "+ this_player()->name() + ".\n");
}

string testp (string *name)
{
  if (pointerp(name))
    return name[WER];
  return name||"";
}

int do_aktion (object npc, object obj)
{
  string objekt;

  objekt = lower_case(testp(obj->QueryProp(P_NAME)));
  write(sprintf("A-> %O\n", objekt));

  if (present(PARTY_CHEF))
    TM("Aktion: " + npc->name(WER,0) + "+" + objekt + ".\n");

  npc->seteuid(getuid(npc)); // Damit der NPC was tun kann!

  switch (objekt)
  {
    case "cola":
      npc->command_me("oeffne cola");
      npc->command_me("trinke cola");
      break;

    case "lolli":
      npc->command_me("lecke lolli");
      break;

    case "joint":
      npc->command_me("rauche joint");
      break;

    case "flepi":
      npc->command_me("oeffne flepi");
      npc->command_me("trink flepi");
      break;

    case "mon cherie":
      npc->command_me("iss cherie");
      break;

    case "softeis":
      npc->command_me("iss eis");
      break;

    case "osterei":
      npc->command_me("iss ei");
      break;

    case "kissen":
      npc->command_me("wirf kissen nach " + do_zielen(npc));
      break;

    case "sahnetorte":
      npc->command_me("wirf torte " + do_zielen(npc));
      break;

    case "reis":
      npc->command_me("wirf reis");
      break;

    case "ueberraschungsei":
      npc->command_me("iss ei");
      break;

    case "twix":
      npc->command_me("iss twix");
      break;

    case "dickmann":
      npc->command_me("wirf dickmann zu " + do_zielen(npc));
      break;

    case "fisch":
      npc->command_me("wirf fisch nach " + do_zielen(npc));
      break;
  }

  return 0;
}

string do_zielen (object npc)
{
  object *list, env;
  int i;

  if (! (env = environment()))
    return 0;

  if (living(env))
    env = environment(env);
 
  list = all_inventory(env);
  for (i = 0; i < sizeof(list); i++)
    if (!living(list[i]) || list[i] == npc || !query_once_interactive(list[i]))
      list -= ({list[i]});

  if (!sizeof(list))
    return npc->QueryProp(P_NAME);

  if (sizeof(list))
    return testp(list[random(sizeof(list))]->QueryProp(P_NAME));
}

void write_say (object whom, string teil1, string dir, string wem, string teil2)
{
  object *list, env;
  int i;

  tell_object(whom, teil1 + dir + teil2);

  if (! (env = environment()))
    return 0;

  if (living(env))
    env = environment(env);

  list = all_inventory(env);
  for (i = 0; i < sizeof(list); i++)
    if (query_once_interactive(list[i]) && list[i] != whom)
       tell_object(list[i], teil1 + wem + teil2);
}
