/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: cola.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/cola.c
// Info  : Cola-Flasche.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>
#include "../def.h"

int offen;

string aufzu ();

void create ()
{
  if (! clonep())
    return;

  ::create();

  offen=0;

  SetProp(P_NAME,    "Flasche Cola");
  SetProp(P_ARTICLE, ART_INDEF);
  SetProp(P_PLURAL,  "Flaschen Cola");
  SetProp(P_LONG,    "Eine @@aufzu@@ 0.33l Pfandflasche Cola.\n");
  SetProp(P_GENDER,  FEMALE);
  SetProp(P_WEIGHT,  100);
  SetProp(P_VALUE,   1);
  SetProp(P_DESCR,   0);

  AddId(({"cola", "colaflasche", "flasche"}), ({"colas", "colaflaschen", "flaschen"}));

  AddCmd("oeffne&cola|flasche|colaflasche",             "do_oeffnen",    "Was willst Du oeffnen?");
  AddCmd("schliesse|schliess&cola|flasche|colaflasche", "do_schliessen", "Was willst Du schliessen?");
  AddCmd("trinke|trink&cola|flasche|colaflasche",       "do_trinken",    "Was willst Du trinken?");
}

string aufzu ()
{
  if (offen) 
    return "offene";
  else 
    return "verschlossene";
}

int do_oeffnen (string str)
{
  if (offen)
  {
    write("Die Flasche ist bereits offen!\n");
    return 1;
  }

  offen=1;
  write(BS("Du nagst mit den Zaehnen solange an der Flasche, bis der Deckel abspringt."));
  say(this_player()->name() + " macht eine Cola auf.\n");

  return 1;
}
 
int do_schliessen (string str)
{
  if (! offen)
  {
    write("Die Flasche ist doch zu!\n");
    return 1;
  }

  offen=0;
  write(BS("Du klemmst den Deckel wieder auf die Flasche."));
  say(this_player()->name() + " macht die Cola wieder zu.\n");

  return 1;
}
 
int do_trinken (string str)
{
  if (! offen)
  {
    write("Die Flasche ist aber zu!\n");
    return 1;
  }

  write(BS("Du setzt die Flasche an den Mund und trinkst das kuehle Nass in einem "
           "Zug aus. Die Flasche verwandelt sich in einen GRUENEN PUNKT und verschwindet."));
  say(this_player()->name() + " trinkt eine Cola.\n");

  remove();

  return 1;
}
