/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: dicklook.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/dicklook.c
// Info  : Das Aussehen nach dem Dickmann-Futtern.
// Autor : Big@MD

inherit "std/unit";

#include <properties.h>
#include <language.h>

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetCoinsPerUnits(0, 1);
  SetGramsPerUnits(0, 1);

  AddId("schmiere");
  AddId("geschmiere");
  AddId(({"rest", "negerkuss", "dickmann"}), ({"reste", "negerkuesse", "dickmaenner"}));

  SetProp(P_NAME,   "Negerkuss-Geschmiere");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_NODROP, "So geht das nicht, aber versuch mal, die Reste aufzuessen...\n");
  SetProp(P_LONG,   "Du kannst das ekelhafte Zeug nicht mehr sehen.");

  AddCmd("iss|esse|ess&schmiere|geschmiere|rest|dickmann|negerkuss", "do_essen", "Was willst Du essen?");
}

int do_essen (string str)
{
  if (QueryProp(P_AMOUNT)>1)
  {
    write("Du isst etwas von dem Negerkuss-Geschmiere auf Deinem Kopf.\n");
    say(this_player()->name(WER)+" isst etwas von dem Dreck in "+
        this_player()->QueryPossPronoun(NEUTER, WEM) + " Gesicht.\n");
    AddAmount( -1 );
    return 1;
  }
  else
  {
    write("Du isst den letzten Rest von dem Schmier auf Deinem Kopf.\n");
    say(this_player()->name(WER)+" befreit "+
        this_player()->QueryPossPronoun(NEUTER, WEN)+
        " Gesicht von den Negerkussresten.\n");

    destruct(this_object());
    return 1;
  }
}

string extra_look ()
{
  return capitalize(environment()->QueryPronoun()) + " hat " +
    ((QueryProp(P_AMOUNT)==1) ? "einen Dickmann" : QueryProp(P_AMOUNT) + " Dickmaenner") +
    " im Gesicht kleben.\n";
}
