/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: ei.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/ei.c
// Info  : Ein Ueberraschungsei.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>
#include <wizlevels.h>
#include <moving.h>

#include "../def.h"

void create ()
{
  if (! clonep())
    return;

  ::create();

  seteuid(getuid(this_object()));

  SetProp(P_NAME,     "Ueberraschungsei");
  SetProp(P_ARTICLE,  ART_INDEF);
  SetProp(P_LONG,     "Ein Ueberraschungsei mit der Extraportion Milch. "
                      "Was steckt wohl da drin?");
  SetProp(P_PLURAL,   "Ueberraschungseier");
  SetProp(P_GENDER,   NEUTER);
  SetProp(P_VALUE,    600);
  SetProp(P_WEIGHT,   200);

  AddId(({"ei", "ueberraschungsei"}), ({"eier", "ueberraschungseier"}));

  AddCmd("iss|ess|esse&ei|ueberraschungsei", "do_essen", "Was willst Du essen?");
}

int do_essen (string str)
{
  string *obs;
  object ob;
  int num,sz;

  if (! this_player())
    return 0;

  if (! this_player()->eat_food(10))
    return 1;

  this_player()->heal_self(15);

  obs = ({
    "/obj/fackel",
    "/obj/schaufel",
    OBJ "cola",
    OBJ "flepi",
    OBJ "dickmann",
    OBJ "joint",
    OBJ "pappnase"

    // taschenmesser azange eckzaehne lederstiefel lederruestung loech_umhang
    // beere karotte teerfackel kleeblatt windelhose brot semmel fraggle otter
  });

  if (IS_SEER(this_player()))
  obs += ({
    "/obj/misc/wuerfel"
  });

  if (IS_WIZARD(this_player()))
  obs += ({
    "/obj/tools/sonnenbrille"
  });

  sz  = sizeof(obs);
  num = random(sz+5);
  ob  = (num < sz) ? clone_object(obs[num]) : 0;

  if (ob)
  {
    // LOG("ei", capitalize(this_player()->name())+" findet "+ob->name(WEN, 0)+".");
    if (living(ob))
    {
      if (environment(this_player()))
      {
        write("Du isst ein Ueberraschungsei und findest "+ ob->name(WEN)+".\n");
        ob->move(environment(this_player()), M_GO);
        ob->Kill(this_player());
      }
      else
      {
        write("Du isst ein Ueberraschungsei, aber findest nichts.\n");
        ob->remove();
      }
    }
    else
    {
      ob->move(this_player());
      write("Du isst ein Ueberraschungsei und findest "+
        ob->name(WEN)+".\n");
      if (environment(this_player()))
        ob->move(environment(this_player()));
      ob->move(this_player());
    }
  }
  else
  {
    // LOG("ei", capitalize(this_player()->name()) + " findet nichts.");
    write("Du isst ein Ueberraschungsei, aber findest nichts.\n");
  }

  say(this_player()->name() + " isst ein Ueberraschungsei.\n");

  remove();

  return 1;
}
