/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: fisch.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/fisch.c
// Info  : Ein stinkender Fisch.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>
#include <moving.h>
#include <defines.h>

#include "../def.h"

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_NAME_ADJ, "stinkend");
  SetProp(P_NAME,     "Fisch");
  SetProp(P_LONG,     "Ein vergammelter, stinkender Fisch. Du kannst ihn nach jemandem werfen.");
  SetProp(P_PLURAL,   "Fische");
  SetProp(P_DESCR,    0);
  SetProp(P_ARTICLE,  ART_INDEF);
  SetProp(P_GENDER,   MALE);
  SetProp(P_NODROP,   "Der Fisch flutscht Dir durch die Haende.\n");

  AddCmd("wirf|werfe&fisch|stinkefisch", "do_werfen", "Mit was willst Du werfen?");

  AddId(({"fisch", "stinkefisch"}), ({"fische", "stinkefische"}));
}

int do_werfen (string str)
{
  string was, wohin;
  object target;
  if (! str) return 0;

  if (sscanf(lower_case(str), "%s nach %s", was, wohin) == 2)
  {
    if (! id(was))
      return 0;

    if (! (target = present(wohin, environment(this_player()))) || !living(target))
    {
      write("Es gibt hier niemanden, der " + capitalize(wohin) + " heisst.\n");
      return 1;
    }

    write("Ihh. Du wirfst "+target->name(WEM,1) + " den stinkenden Fisch ins Gesicht.\n");
    say(PL->name()+" wirft "+target->name(WEM,1) + " einen stinkenden Fisch ins Gesicht.\n", target);
    tell_object(target, PL->name() + " wirft Dir einen stinkenden Fisch ins Gesicht.\n");

    destruct(this_object());

    return 1;
  }

  return 0;
}
