/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: flepi.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/flepi.c
// Info  : Eine Bierflasche.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>

#include "../def.h"

int offen;

string aufzu ();

void create ()
{
  if (! clonep())
    return;

  ::create();

  offen = 0;

  SetProp(P_NAME,    "Flasche");
  SetProp(P_DESCR,   "Flensburger Pilsener");
  SetProp(P_LONG,    "Eine @@aufzu@@ 0.33l Pfandflasche Pils direkt importiert aus Flensburg.");
  SetProp(P_PLURAL,  "Flaschen");
  SetProp(P_GENDER,  FEMALE);
  SetProp(P_WEIGHT,  100);
  SetProp(P_VALUE,   1);
  SetProp(P_ARTICLE, ART_INDEF);

  AddId(({"bier", "flepi", "flensburger", "bierflasche", "flasche"}),
        ({"bier", "biere" "flepis", "flensburger", "bierflaschen", "flaschen"}));

  AddCmd("oeffne&flepi|flasche|bier|pils|bierflasche",             "do_oeffnen",    "Was willst Du oeffnen?");
  AddCmd("schliesse|schliess&flepi|flasche|bier|pils|bierflasche", "do_schliessen", "Was willst Du schliessen?");
  AddCmd("trinke|trink&flepi|flasche|bier|pils|bierflasche",       "do_trinken",    "Was willst Du trinken?");
}

string aufzu ()
{
  if (offen)
    return "aufgeploppte";
  else
    return "geschlossen";
}

int do_oeffnen (string str)
{
  if (offen)
  {
    write("Die Flasche ist bereits offen!\n");
    return 1;
  }

  offen = 1;

  write(BS("Du setzt Deinen Daumen an und ploppst die Buddel auf."));
  say(this_player()->name() + " ploppt ein Flepi auf.\n");

  return 1;
}
 
int do_schliessen (string str)
{
  if (! offen)
  {
    write("Die Flasche ist doch zu!\n");
    return 1;
  }

  offen = 0;

  write("Du klemmst den Buegelverschluss wieder auf die Flasche.\n");
  say(this_player()->name() + " macht das Flepi wieder zu.\n");

  return 1;
}
 
int do_trinken (string str)
{
  if (! offen)
  {
    write("Die Flasche ist aber zu!\n");
    return 1;
  }

  write(BS("Du setzt die Flasche an den Mund und trinkst das kuehle Nass in einem "
           "Zug aus. Die Flasche verwandelt sich in einen GRUENEN PUNKT und verschwindet."));
  say(this_player()->name() + " trinkt ein Flepi.\n");

  remove();

  return 1;
}
