/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: kissen.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/kissen.c
// Info  : Ein Kissen.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>

string cstr;  

int do_werfen_random (string str);
int do_werfen        (string str);

void init ()
{
  ::init();

  switch (random(9))
  {
    case 0: cstr = "gruen";                 break;
    case 1: cstr = "rot";                   break;
    case 2: cstr = "blau";                  break;
    case 3: cstr = "gelb";                  break;
    case 4: cstr = "schwarz-weiss-kariert"; break;
    case 5: cstr = "orange-pink-gestreift"; break;
    case 6: cstr = "lila-gruen-getuepfelt"; break;
    case 7: cstr = "silbergrau";            break;
    case 8: cstr = "von Boing handgenaeht"; break;
  }

  SetProp(P_NAME_ADJ, cstr);
  SetProp(P_LONG,     "Dies ist ein wunderschoenes, " + cstr + " Kissen. "
                      "Du kannst versuchen es zu werfen.");
}

void create ()
{
  if (! clonep())
    return;

  ::create();

  cstr = "von Boing handgenaehtes";

  AddId(({"kissen"}), ({"kissen"}));

  SetProp(P_WEIGHT,    1);
  SetProp(P_VALUE,     1);
  SetProp(P_NAME,      "Kissen");
  SetProp(P_GENDER,    NEUTER);
  SetProp(P_BULKINESS, 200);
  SetProp(P_PLURAL,    "Kissen");

  AddCmd("wirf|werfe", "do_werfen");
  AddCmd("ww",         "do_werfen_random");
}

int do_werfen_random (string str)
{
  object *all, *liv;
  int i;

  if (str)
    return do_werfen("kissen nach "+str);

  liv = ({});
  all = all_inventory(environment(this_player()));
  for (i=0; i<sizeof(all); i++)
  {
    if (query_once_interactive(all[i]))
    {
      liv = liv+({all[i]});
    }
  }

  i = random(sizeof(liv));

  return do_werfen("kissen nach "+lower_case(liv[i]->query_real_name()));
}

int do_werfen (string str)
{
  string werfer_name;
  string victim_string, werfer_string;
  string was, at, wen;
  int    fehler;
  object victim;

  if (! str)
    return 0;

  fehler = 0;
  if (sscanf(str, "%s %s %s", was, at, wen) != 3)
    fehler = 1;
  if (! id(was) || at != "nach")
    fehler = 1;

  if (fehler)
  {
     notify_fail("Zum Werfen: wirf kissen nach <spielername>\n");
     return 0;
  }

  victim = present(wen,environment(this_player()));
  if (! victim)
  {
     write("Dieser Spieler ist nicht hier!\n");
     return 1;
  }

  werfer_name = this_player()->name();
  write("Du schmeisst ein Kissen nach " + victim->name(WEM) +".\n");
  say(werfer_name + " wirft ein Kissen nach " + victim->name(WEM) + ".\n");

  switch (random(5))
  {
    case 0:
      werfer_string = "Du verfehlst " + victim->name(WEN) + " meilenweit.\n";
      victim_string = werfer_name + " verfehlt Dich meilenweit.\n";
      this_object()->move(environment(this_player()));
      break;

    case 1:
      werfer_string = "Das Kissen streift " + victim->name(WEN)+ " am Ohrlaeppchen.\n";
      victim_string = "Das Kissen streift Dich am Ohrlaeppchen.\n";
      this_object()->move(victim);
      break;

    case 2:
      werfer_string = "PAFF! Du triffst " + victim->name(WEN) + " mitten ins Gesicht.\n";
      victim_string = "PAFF! Das Kissen trifft Dich mitten im Gesicht!\n";
      this_object()->move(victim);
      break;

    case 3:
      werfer_string = "WUSCH! Das Kissen trifft " + victim->name(WESSEN) + " Bauch mit voller Wucht.\n";
      victim_string = "WUSCH! Das Kissen fliegt mit voller Wucht gegen Deinen Bauch.\n";
      this_object()->move(victim);
      break;

    case 4:
      werfer_string =  victim->name() + " versucht wegzurennen, doch das Kissen trifft den Hinterkopf.\n";
      victim_string = "Du versuchst wegzurennen, aber das Kissen trifft Dich am Hinterkopf.\n";
      this_object()->move(victim);
      break;
  }

  write(werfer_string);
  tell_object(victim, victim_string);

  return 1;
}

