/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: mon_cherie.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/mon_cherie.c
// Info  : Ein Mon-Cherie.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <moving.h>
#include <defines.h>
#include <language.h>

#include "../def.h"

int eat_alcohol (int strength);

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_NAME,    "Mon Cherie");
  SetProp(P_PLURAL,  "Mon Cheries");
  SetProp(P_LONG,    "Ein Mon Cherie. Wenn es so schmeckt, wie es aussieht, kannst Du "
                     "Dich auf ein Geschmackserlebnis erster Guete einstellen.");
  SetProp(P_ARTICLE, ART_INDEF);
  SetProp(P_WEIGHT,  10);
  SetProp(P_VALUE,   5);
  SetProp(P_GENDER,  NEUTER );
  SetProp(P_DESCR,   0);

  AddId(({"mon cherie", "mon", "cherie", "moncherie"}),
        ({"mon cheries", "mon", "cheries", "moncheries"}));

  AddCmd("iss|esse|ess&mon|cherie|moncherie|mon cherie", "do_essen", "Was willst Du essen?");
}

int do_essen (string str)
{
  if (! eat_alcohol(2))
    return 1;

  if (! this_player()->eat_food(2))
    return 1;

  write(BS("Du isst genuesslich " + name(WEN, 0) + ". Es knackt herrlich, als Du hineinbeisst, und die "
           "Kirsche zergeht Dir auf der Zunge. Zusammen mit dem Alkohol gibt sie Dir das Gefuehl von "
           "Frische und Feuer."));
  say(this_player()->name(WER, 2) + " isst genuesslich " + name(WEN, 0) + ".\n");

  this_player()->heal_self(1);

  remove();

  return 1;
}

int eat_alcohol (int strength)
{
  int alc;

  alc = this_player()->QueryProp(P_ALCOHOL) + strength;
  if (alc >= this_player()->QueryProp(P_MAX_ALCOHOL))
  {
    tell_object(this_player(), "Du bist ja schon so blau, dass Du Deinen Mund nicht mehr findest.\n");
    return 0;
  }

  if (alc < 0)
    alc = 0;

  if (! alc)
    tell_object(this_player(), "Du bist stocknuechtern.\n");

  this_player()->SetProp(P_ALCOHOL, alc);

  return 1;
}
