/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: reis.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/reis.c
// Info  : Reis.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>
#include <moving.h>

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_PLURAL,   ({"handvoll bunter Reis", "handvoll bunten Reises", "handvoll buntem Reis", "handvoll bunten Reis"}));
  SetProp(P_NAME,     ({"handvoll bunter Reis", "handvoll bunten Reises", "handvoll buntem Reis", "handvoll bunten Reis"}));
  SetProp(P_NAME_ADJ, 0);
  SetProp(P_LONG,     "Der Reis ist sehr bunt und nicht essbar, denn er ist zum Werfen da!");
  SetProp(P_WEIGHT,   50);
  SetProp(P_GENDER,   FEMALE);
  SetProp(P_DESCR,    0);
  SetProp(P_ADJECTIVES, ({"handvoll", "bunt", "bunte", "bunter"}));

  AddId(({"reis", "reiskoerner", "koerner"}), ({"reis", "reiskoerner", "koerner"}));

  AddCmd("wirf|werfe&reis|reiskoerner|koerner",   "do_werfen", "Was willst Du werfen?");
  AddCmd("iss|esse|ess&reis|reiskoerner|koerner", "do_essen",  "Was willst Du essen?");
}

int do_essen (string str)
{
  write("Du sollst ihn werfen nicht essen!\n");
  say( this_player()->name(WER,2)+" weiss nicht was er mit dem Reis machen soll...\n");

  return 1;
}


int do_werfen (string str)
{
  string s1, s2;
  int i;

  i = sscanf(str, "%s %s weg", s1, s2);  // i==0, wenn 'wirf reis' und i==1, wenn 'wirf reis weg'.
  if ((i == 1))
    return 0;

  write("Du wirfst den Reis hoch in die Luft.\n");
  say(this_player()->name(WER,2)+" wirft eine handvoll bunten Reis durch die Luft.\n");

  move(environment(this_player()), M_PUT | M_SILENT);
  say("Bunter Reis prasselt auf Dich hernieder.\n");
  write("Der Reis prasselt auf die Koepfe der Anwesenden nieder.\n");

  return 1;
}
