/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: torte.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/torte.c
// Info  : Ein Sahnetorte zum Rumwerfen.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include "../def.h"

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_NAME,    "Sahnetorte");
  SetProp(P_PLURAL,  "Sahnetorten");
  SetProp(P_ARTICLE, ART_INDEF);
  SetProp(P_LONG,    "Diese Sahnetorte laedt gerade dazu ein, sie jemandem ins "
                     "Gesicht zu werfen.");
  SetProp(P_WEIGHT,  10);
  SetProp(P_VALUE,   10);
  SetProp(P_DESCR,   0);
  SetProp(P_GENDER,  FEMALE);

  AddId(({"torte", "sahnetorte", "kuchen"}), ({"torten", "sahnetorten", "kuchen"}));

  AddCmd("wirf|werfe", "do_werfen");
}

int do_werfen (string str)
{
  string what, who;
  object obj;

  if (sscanf(str, "%s nach %s", what, who) != 2)
  {
    write(BS("Was willst Du nach wem werfen?"));
    return 0;
  }

  if (! id(what))
  {
    write(BS("Mit was moechtest Du herumwerfen?"));
    return 0;
  }

  if (! (obj = present(who, environment(this_player()))))
  {
    write(BS("Der Spieler " + who + " ist doch gar nicht in diesem Raum!"));
    return 0;
  }

  write("Du wirfst " + obj->name() + " die Torte ins Gesicht.\n");
  tell_object(obj, this_player()->QueryProp(P_NAME) + " wirft Dir eine grosse Sahnetorte ins Gesicht.\n");
  say(this_player()->name(WER) + " wirft " + obj->name() + " eine grosse Sahnetorte ins Gesicht.\n", obj);

  remove();

  return 1;
}
