/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: yogurette.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/partymonster/obj/yogurette.c
// Info  : Ein Stueck Schokolade.
// Autor : Big@MD

inherit "std/thing";

#include <properties.h>
#include <language.h>

#include "../def.h"

int ausgepackt;

void create ()
{
  if (! clonep())
    return;

  ::create();

  SetProp(P_NAME,     "Riegel");
  SetProp(P_PLURAL,   "Riegel");
  SetProp(P_DESCR,    "Yogurette (eingewickelt)");
  SetProp(P_LONG,     "Hey, ein Stueck Yogurette(TM), sowas sollte man "
                      "immer im Kuehlschrank haben ...");
  SetProp(P_ARTICLE,  ART_INDEF);
  SetProp(P_WEIGHT,   5);
  SetProp(P_VALUE,    0);
  SetProp(P_GENDER,   MALE);

  AddId(({"schokolade", "stueck", "yogurette", "riegel"}),
        ({"schokolade", "stuecke", "yogurette", "riegel"}));

  AddCmd("iss", "do_essen");
  AddCmd("wickel|wickle|packe&schokolade|riegel|stueck|yogurette&aus", "do_wickeln", "Was willst Du auswickeln?");

  ausgepackt = 0;
}

int do_essen (string str)
{
  notify_fail("Was willst Du denn Essen? Schokolade?\n");
  if (!str || str=="" || !id(str))
    return 0;

  if (! ausgepackt)
  {
    write("Vielleicht solltest Du das Stueck vorher auswickeln?\n");
    return 1;
  }

  write(BS("Mjammm!! Schmeckt wirklich lecker... So leicht, nach "
    "Yoghurt... und Erdbeer... scheint auch kaum Kalorien zu "
    "haben. Das nennt man wirklich eine gesunde Schokolade ;)"));
  say(BS(this_player()->name()+" isst ein Stueck Schokolade. Es scheint "
      +this_player()->QueryPronoun(WEM)+" zu schmecken.\n"));

  return remove();
}

int do_wickeln (string str)
{
  if (ausgepackt)
  {
    write("Aber die Schokolade ist doch schon ausgepackt!\n");
    return 1;
  }

  ausgepackt = 1;

  write(BS("Du wickelst ein Stueck Schokolade aus. "
    "Das Papierchen verwandelt sich in einen gruenen Punkt und "
    "huepft froehlich von dannen."));
  say(this_player()->name() + " wickelt ein Stueck Schokolade aus.\n");

  SetProp(P_DESCR, "Yogurette (ausgepackt)");

  return 1;
}
