/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: anfaengerbuch.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
// Basierend auf Wunderland Mudlib
//
// OBJ/ANFAENGERBUCH.C     Das Buch fuer Anfaenger
//
// Dieses Buch prueft selbst, ob es genommen werden darf, und setzt
// sich P_NOGET oder P_NODROP selbst
//
// $Revision: 1.1.1.1 $
//
// $Log: anfaengerbuch.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/05 10:53:04  Largo
// noch zwei is_clone() -> clonep()
//
// Revision 1.1  1999/08/05 00:39:47  Largo
// Initial revision
//

#pragma strong_types

#include <properties.h>
#include <moving.h>
#include <books.h>
#include <config.h>

inherit "std/book";

static object pl;
static string text;

void create()
{
  if(!clonep()) return;
  ::create();
  SetProp(P_PLURAL, "Handbuecher");
  SetProp(P_DESCR, "fuer Anfaenger");
  SetProp(P_LONG,
	"Du haeltst ein leinengebundenes Buch in Deinen Haenden. "+
	"Der Titel heisst: 'Erste Schritte im Wunderland'. Du kannst "+
	"es mit 'oeffne buch' aufschlagen und mit 'lies buch' sequentiell, "+
	"also Seite fuer Seite lesen. Mit 'lies seite <nr>' kannst Du "+
	"speziell die Seite <nr> lesen. Mit 'schliesse buch' schlaegst "+
	"Du es wieder zu.");
  SetProp(P_NAME,"Handbuch");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_NOBUY, 1);
  SetProp(P_BOOK_BLANK_HEADERS,0);
  SetProp(P_BOOK_CONTENTS, "/etc/anfaengerbuch.text");
  AddId(({"handbuch","\nhintbook"}),"handbuecher");
}

int move(mixed dest, int meth) {
  object obj, env;
  int i;
  pl=0; // Reset
  if (!this_player() ||
    ( meth&M_NOCHECK && file_name(previous_object())!=MASTER) )
    return ::move(dest, meth);
  if (stringp(dest)) dest=find_object(dest);
  if (!dest) return ::move(dest, meth);
  
  // Rausfinden, wer der 'Besitzer' von dest ist (im Fall eines
  // Containers zB)
  obj=dest;
  while (obj && !living(obj)) obj=environment(obj);

  // Wohin ist kein Lebewesen, also immer moven
  if (!obj) {
    // Vorher schauen, obs da schon ein Buch gibt, dann verschwinden wir
    if (obj=present("\nhintbook", dest)) {
	dest=obj;
	call_out("remove",1); // Und weg
    }
    return ::move(dest, meth);
  }

  // Pruefen des Levels des Lebewesens
  if (obj->QueryProp(P_AGE)>172800) { // Spieler aelter als 2 Onlinetage
    pl=this_player();
    if (pl!=obj) text=capitalize(obj->name(WER))+" ist doch schon sehr "
      "erfahren.\n";
    else text="Fuer das Anfaengerbuch bist Du zu alt.\n";
    return ::move(dest, meth);
  }

  // Pruefen ob das Lebewesen schon ein Buch hat
  if (!deep_present("\nhintbook", obj)) {

    // Raum fragen, ob Lebewesen schon wieder ein Buch bekommen darf
    env=environment();
    if (env) i=env->GetHintbook(obj);

    // Alles Ok, also moven
    if (i!=-1) {
      i=::move(dest, meth);
      if (i==1 && env) env->NotifyHintbookGone(); // Raum bescheid sagen
      return i;
    }
  }

  // Move abwehren mit entsprechender Begruendung
  pl=this_player();

  if (i==-1) {
    // Raum sagte, Lebewesen darf noch kein neues Buch
    if (pl!=obj) text=capitalize(obj->name(WER))+" hat grade ein "
      "Buch erhalten.\n";
    else text="Du hast doch gerade ein Buch genommen.\n";
  } else {
    // Lebewesen hat schon ein Buch im deep_inv
    if (pl!=obj) text=capitalize(obj->name(WER))+" hat bereits ein Buch.\n";
    else text="Du hast doch schon ein Buch.\n";
  }
  return ::move(dest, meth);
}

// Propertiemethoden

static string _query_noget() {
  if(pl==this_player()) return text;
  pl=0;
  return 0;
}

static string _query_nodrop() {
  if(pl==this_player()) return text;
  pl=0;
  return 0;
}

void reset() {
  object e;
  mixed tmp;
  int i;
  if(!clonep()) return;
  if(!(e=environment(this_object()))) {
    remove();
    return;
  }
  if(pointerp(tmp=e->QueryProp(P_ITEMS))) {
    for(i=sizeof(tmp);i--;)
      if(tmp[i][RITEM_FILE]==explode(file_name(this_object()),"#")[0])
	return;
  }
  if(!query_once_interactive(e)) {
    if(!clonep(e))
      tell_room(e,"Ein Buch verschwindet in einen gekruemmten "
		  "L-Raum >SMACK<.\n");
    remove();
    return;
  }
}
