/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: coinmaster_WL.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
/***
 *
 * coinmaster.light.c (C) 1994 by Troy.
 *
 * This object is a currency-server. For details read the document file coinmaster.doc
 *
 */

/* Some SPEED changes:
** ExchangeValue()
** QueryMoney()
** PayCash()
**
** Fiona 8.96
*/

#pragma strong_types

#define NEED_PROTOTYPES

#include "/secure/wizlevels.h"
#include <properties.h>
#include <config.h>

#define TT(x) if(find_player("troy")) tell_object(find_player("troy"),(x))
#define FIONA(x) if(find_player("fiona")) tell_object(find_player("fiona"),(x))

// the coineage file
#define COINS "/etc/coineage_WL"
// log to file
#define CMLOG(x) write_log("/log/COINMASTER_WL",ctime(time())+": "+ \
geteuid(this_interactive())+" -> "+(x)+"\n")

// now some defines for array-references
#define C_BASE -1
#define C_FILE 0
#define C_SID  1
#define C_PID  2
#define C_GID  3
#define C_ABBR 4

private int max(int* arr);
private mapping MakeCoineage(mapping calc, int val);
private mapping CoinCeiling(mapping calc, int val);
private mapping CheckValues(mapping calc, int val);
private int find_cgid(string cgid);
private int *init_check(int value,int *marr);
private int match_object(object ob);
private mapping strip_player(object pl);
private string ladj(mixed s,int l);
private string radj(mixed s,int l);

mapping coins;

void save_info()
{
  save_object( COINS );
}

void create()
{
  if(clonep()) destruct(this_object());
  seteuid(getuid(this_object()));
  if(!restore_object( COINS ))
    coins=([]);
}

string QueryCurrency()
{
  return "M.D.-Muenzen";
}

private static int secure()
{
  if (!previous_object()) return 0;
  if (geteuid(previous_object())==ROOTID) return 1;
  if (geteuid(previous_object()) != geteuid(this_interactive())) return 0;
  if (this_interactive() != this_player()) return 0;
  if (!IS_ARCH(this_interactive())) return 0;
  return 1;
}

/**********************************
 * General administration methods *
 **********************************/

int AddCoin(int cbase, string cfile, string csid, string cpid, string cgid, string cabbr)
{
  int i;
  if(!secure()) return 0;
  if(!intp(cbase) || cbase<1 || member_array(cbase,(m_indices(coins)))>-1) return -1;
  if(!cfile || !stringp(cfile)) return -2;
  cfile=MASTER->_get_path(cfile,0);
  if(file_size(cfile)<0) return -2;
  if(!csid || !stringp(csid) || !strlen(csid)) return -3;
  if(!cpid || !stringp(cpid) || !strlen(cpid)) return -3;
  if(!cgid || !stringp(cgid) || !strlen(cgid)) return -4;
  if(find_cgid((cgid=lower_case(cgid)))) return -4;
  if(!cabbr || !stringp(cabbr) || !strlen(cabbr)) return -5;
  if(!m_sizeof(coins) && cbase!=1) return -6;
  else if(cbase !=1)
  {
    i=max((int*)m_indices(coins));
    if((cbase/i)*i!=cbase) return -6;
  }
  if(strlen(cabbr)>4) cabbr = cabbr[0..3];
  coins += ([ cbase: ({ cfile, csid, cpid, cgid, cabbr }) ]);
  save_info();
  CMLOG(sprintf("add: %d %O (%s)",cbase,coins[cbase],getuid(this_interactive())));
  return 1;
}

int RemoveCoin(int cbase)
{
  if(!secure()) return 0;
  if(!coins[cbase]) return -1;
  CMLOG(sprintf("remove: %d %O (%s)",cbase,coins[cbase],getuid(this_interactive())));
  coins = m_delete(coins,cbase);
  save_info();
  return 1;
}

int ChangeCoin(int cbase, string cfile, string csid, string cpid, string cgid, string cabbr)
{
  string *oval;
  if(!secure()) return 0;
  if(!intp(cbase) || cbase<1 || member_array(cbase,(m_indices(coins)))<0) return -1;
  if(!cfile || !stringp(cfile)) return -2;
  cfile=MASTER->_get_path(cfile,0);
  if(file_size(cfile)<0) return -2;
  if(!csid || !stringp(csid) || !strlen(csid)) return -3;
  if(!cpid || !stringp(cpid) || !strlen(cpid)) return -3;
  if(!cgid || !stringp(cgid) || !strlen(cgid)) return -4;
  if(!cabbr || !stringp(cabbr) || !strlen(cabbr)) return -5;
  if(strlen(cabbr)>4) cabbr = cabbr[0..3];
  oval = (string*)coins[cbase];
  coins[cbase] = ({ cfile, csid, cpid, cgid, cabbr });
  save_info();
  CMLOG(sprintf("change: %d %O to %O (%s)",cbase,oval,coins[cbase],getuid(this_interactive())));
  return 1;
}

void QueryCoins()
{
  int *marr;
  write("+--------------------------------------------------------------------------+\n"+
	"  BASE FILE                           SINGULAR-ID     PLURAL-ID       ABBR \n"+
	"+--------------------------------------------------------------------------+\n");
  for(marr = (int*)m_indices(coins);sizeof(marr);marr=marr[1..])
    write(sprintf(
	"  %s %s %s %s %s\n",radj(marr[0],4),ladj(coins[marr[0]][C_FILE],30),ladj(
	coins[marr[0]][C_SID],15),ladj(coins[marr[0]][C_PID],15),
	ladj(coins[marr[0]][C_ABBR],4)));
  write("+--------------------------------------------------------------------------+\n");
}

mapping query_coins()
{
  return coins;
}

int QueryMaxCoin()
{
  return 2000000000;
}

/*************************************
 * All-day money calculation methods *
 *************************************/

int IsCurrency(object ob)
{
  int *mind;
  string path;
  if(!ob || !objectp(ob) || !(path=explode(file_name(ob),"#")[0])) return 0;
  path += ".c";
  for(mind=(int*)m_indices(coins);sizeof(mind);mind=mind[1..])
    if(path==coins[mind[0]][C_FILE]) return mind[0];
  return 0;
}

/* mapping *ExchangeValue(int value)
 * Value should be given in basecoins.
 * Returns a mapping with n entries: n corresponds to the number of DIFFERENT
 * coins used. Each entry consists of the following:
 * ([ base_id : ({ number, pathname, gid }) ]) with base_id being the index (in 
 * basecoins) of the coin, number being the number of coins needed from this one,
 * pathname being the pathname of the coin-file, and gid being the general id
 * of the coin.
 * This function changes the value value into the minimum required number of
 * appropriate coins. (C) by Troy. THIS FUNCTION MAY NOT BE COPIED WITHOUT MY
 * NOTICE!
 */

mapping ExchangeValue_OLD(int value)
{
  mapping ret;
  int mind,temp,*marr,*vals;
  vals = ({});
  ret = ([]);
  mind = 0;
  if(!sizeof((marr=(int*)m_indices(coins)))) return 0; // no coins specified!
  if(!intp(value)) return 0;
  if((temp=value)<1) return 0; // silly values are not supported!
  marr=(int*)sort_array(marr,#'<);
  while(temp>0 && mind<sizeof(marr))
  {
    while(temp>=marr[mind])
    {
      vals += ({ marr[mind] });
      temp -= marr[mind];
    }
    mind++;      
  }
  for(temp=0;temp<sizeof(vals);temp++)
    if(ret[vals[temp]]) (int)ret[vals[temp]][0]++;
    else ret += ([ vals[temp]: ({ 1,coins[vals[temp]][C_FILE],coins[vals[temp]][C_GID] }) ]);
  return ret;
}

// SpeedUp: approx 4.2 times
// *grin* copy freely and without notice    Fini

mapping ExchangeValue(int value) {
	int* coinv, i, wert;
	mapping ret;
	ret=([]);
	if (!sizeof(coinv=sort_array(m_indices(coins), #'>))) return 0; // no coins specified!
	if(!intp(value)) return 0;
	if((value)<1) return 0; // silly values are not supported!
	for (i=sizeof(coinv); i-- && value;) {
		wert=coinv[i];
		if (wert>value) continue;
		ret+=([ wert: ({ value/wert, coins[wert][C_FILE], coins[wert][C_GID] }) ]);
		value=value%wert;
	}
	return ret;
}


/* This function evaluates the mapping cash and returns the wholesale value
 * measured in basecoins. The mapping must be of the following structure (!):
 * ([ coin_object: number_of_coins,... ])
 */

int EvalCoins(mapping cash)
{
  object *pieces;
  int ret;
  ret = 0;
  if(!mappingp(cash) || !m_sizeof(cash)) return 0;
  for(pieces=m_indices(cash);sizeof(pieces);pieces=pieces[1..])
    ret += (match_object(pieces[0])*cash[pieces[0]]);
  return ret;
}

/* This function does the same as the above, but instead takes a mapping like
 * ExchangeValue returns.
 */

int CompEvalCoins(mapping cash)
{
  int *pieces;
  int ret;
  ret = 0;
  if(!mappingp(cash) || !m_sizeof(cash)) return 0;
  for(pieces=(int*)m_indices(cash);sizeof(pieces);pieces=pieces[1..])
    ret += (pieces[0]*cash[pieces[0]][0]);
  return ret;
}

int QueryMoney_OLD(object pl)
{
  if(!pl || !objectp(pl)) return 0;
  return EvalCoins(strip_player(pl));
}

// SpeedUp: approx 17 times

int QueryMoney(object pl) {
	int i, j, am, ret,* mind, size;
	string* mval;
	object ob,* inv;
	mixed* ids;
	if (!pl || !objectp(pl)) return 0;
	ret=0;
	mval=({});
	mind=m_indices(coins);
	size=sizeof(mind);
	for (i=0; i<size; i++) {
		mval+=({coins[mind[i]][C_GID]});
	}
	inv=filter_objects(all_inventory(pl),"IsMoney");
	ids=map_objects(inv, "Query", P_IDS);
	for (i=0; i<size; i++) {
		for (j=sizeof(ids); j--;) {
			if ( member_array(mval[i], ids[j])!=-1 ) {
				if ((am=inv[j]->QueryProp(P_AMOUNT))>0) {
					ret+=am*mind[i];
				}
				break;
			}
		}
	}
	return ret;
}


/* This function takes appropriate coineage from player pl to pay the prize
 * It will return a two-dimensional array with each dimension built up like
 * ExchangeValue. The first ([0]) dimension denotes the coins to be taken 
 * from and the second ([1]) dimension denotes the coins to be returned to 
 * the player. If the array is empty, the player had not got enough money.
 */

mixed *PayCash_OLD(object pl, int price)
{
  mapping plcash,plcalc,taken,given;
  int plval,m;
  object *mind;
  taken = ([]);
  given = ([]);
  plcalc = ([]);
  if(!pl || !intp(price) || !objectp(pl) || price<1) return 0;
  plcash = strip_player(pl);
  if((plval = EvalCoins(plcash))<price) return 0; // Not enough money.
  for(mind=m_indices(plcash);sizeof(mind);mind=mind[1..])
    plcalc += ([ (m=match_object(mind[0])):({plcash[mind[0]],coins[m][C_FILE],
    					coins[m][C_GID]})]);

  if(!(taken=CheckValues(plcalc,price)) && !(taken=MakeCoineage(plcalc,price)))
    taken=CoinCeiling(plcalc,price);
  if((plval=CompEvalCoins(taken))>price)
    given = ExchangeValue(plval-price);
  return ({ taken,given });
}

// SpeedUp: 10 to 12 times   (not included speedup of ExchangeValue)

mixed* PayCash(object pl, int price) {
	int* mind, *plcoins, *taken, i, j, size,* vals, am;
	mixed* mval, ids;
	mapping take;
	object ob,* inv, *x;
	if (!pl || !intp(price) || !objectp(pl) || price<1) return 0;
	plcoins=({});
	taken=({0});
	mind=sort_array(m_indices(coins),#'>);
	mval=({});
	// plcoins[i]: Number of coins type mind[i] in player
	// mval[i]: ({ C_GID, C_FILE })
	size=sizeof(mind);
	for (i=0; i<size; i++) {
		mval+=({({coins[mind[i]][C_GID], coins[mind[i]][C_FILE]})});
		taken+=({0});
		plcoins+=({0});
	}
	// find money in player - kwiker than present()
	inv=filter_objects(all_inventory(pl),"IsMoney");
	ids=map_objects(inv, "Query", P_IDS);
	for (i=0; i<size; i++) {
		for (j=sizeof(ids); j--;) {
			if ( member_array(mval[i][0], ids[j])!=-1 ) {
				if ((am=inv[j]->QueryProp(P_AMOUNT))>0) {
					plcoins[i]=am;
				}
				break;
			}
		}
	}
	// vals[i]: Amount could be reached with coins plcoins[i] and all
	// smaller types
	vals=({plcoins[0]*mind[0]});
	for (i=1; i<size; i++) {
		vals+=({ vals[i-1]+plcoins[i]*mind[i] });
	}
	// taken[i]: Number of taken coins of plcoins[i]
	for (i=size; i--;) {
		if (!plcoins[i]) continue;
		taken[i]=price/mind[i];
		if (i && vals[i-1]<(price-taken[i]*mind[i])) taken[i]++;
		if (taken[i]>plcoins[i]) taken[i]=plcoins[i];
		price-=taken[i]*mind[i];
		if (price<=0) break;
	}
	if (price>0) return 0; // not enough money
	take=([]);
	for (i=0; i<size; i++) {
		if (taken[i]) take+=([ mind[i]: ({taken[i], mval[i][1], mval[i][0]}) ]);
	}
	return ({ take, (price==0?([]):ExchangeValue(-price)) });
}


void GiveCoins(mapping give, object pl)
{
  int *mval;
  if(!pl || !objectp(pl)) return;
  if(!give || !mappingp(give) || !m_sizeof(give)) return;
  for(mval=(int*)m_indices(give);sizeof(mval);mval=mval[1..])
    pl->AddCoins((string)give[mval[0]][1],(int)give[mval[0]][0]);
}

void TakeCoins(mapping take, object pl)
{
  int *mval;
  if(!pl || !objectp(pl)) return;
  if(!take || !mappingp(take) || !m_sizeof(take)) return;
  for(mval=(int*)m_indices(take);sizeof(mval);mval=mval[1..])
    pl->AddCoins((string)take[mval[0]][1],-(int)take[mval[0]][0]);
}

void DoPurchase(mixed *p, object pl)
{
  if(!pl || !objectp(pl)) return;
  TakeCoins(p[0],pl);
  GiveCoins(p[1],pl);
}

/***********************************************
 * PRIVATE Functions for internal calculations *
 ***********************************************/

private int max(int* arr)
{
  int ret;
  if(!sizeof(arr)) return 0;
  ret=arr[0];
  for(arr=arr[1..];sizeof(arr);arr=arr[1..]) if(arr[0]>ret) ret=arr[0];
  return ret;
}

private int min(int* arr)
{
  int ret;
  if(!sizeof(arr)) return 0;
  ret=arr[0];
  for(arr=arr[1..];sizeof(arr);arr=arr[1..]) if(ret>arr[0]) ret=arr[0];
  return ret;
}

private mapping CoinCeiling(mapping calc, int val)
{
  int *mind,*mchk,m;
  mind = ({});
  for(mchk=(int*)m_indices(calc);sizeof(mchk);mchk=mchk[1..])
    if(mchk[0]>val) mind += ({ mchk[0] });
  if(!sizeof(mind)) return 0;
  return ([ (m=min(mind)):({1,coins[m][C_FILE],coins[m][C_GID] }) ]);
}

private mapping MakeCoineage(mapping calc, int val)
{
  int *marr,mind,*vals,*i,temp,j;
  mapping ret,chk;
  marr=sort_array((int*)m_indices(calc),#'<);
  ret = ([]);
  chk = ([]);
  vals = ({});
  for(mind=0;mind<sizeof(marr);mind++)
    if(marr[mind]<=val)
      chk += ([ marr[mind]:calc[marr[mind]] ]);
  if(CompEvalCoins(chk)<val)
    return 0;
  mind = 0;
  temp=val;
  while(mind<sizeof(marr) && val<marr[mind]) mind++;
  while(mind<sizeof(marr) && val>=marr[mind])
  {
    while(val>=marr[mind])
    {
      vals += ({ marr[mind] });
      val -= marr[mind];
      if(!(--calc[marr[mind]][0])) break;
    }
    mind++;
  }
  if(val>0)
  {
    i=({});
    for(mind=0;mind<sizeof(marr);mind++)
      if(calc[marr[mind]][0] && marr[mind]>=val) i += ({ marr[mind] });
    if(!sizeof(i)) return 0;
    vals += ({ min(i) });
  }
  for(mind=0;mind<sizeof(vals);mind++)
    if(ret[vals[mind]]) (int)ret[vals[mind]][0]++;
    else ret += ([ vals[mind]: ({ 1,coins[vals[mind]][C_FILE],coins[vals[mind]][C_GID] }) ]);
  marr=sort_array((int*)m_indices(ret),#'>);
  mind=0;
  while(mind<sizeof(marr) && (j=CompEvalCoins(ret))>temp)
  {
    while(ret[marr[mind]] && j-marr[mind]>=temp)
    {
      if(!--ret[marr[mind]][0]) ret=m_delete(ret,marr[mind]);
      j-=marr[mind];
    }
    mind++;
  }
  return ret;
}

private mapping CheckValues(mapping calc, int val)
{
  mapping xval,ret;
  int *mind;
  if(!(xval = ExchangeValue(val))) return 0;
  ret = ([]);
  for(mind=(int*)m_indices(xval);sizeof(mind);mind=mind[1..])
    if(calc[mind[0]] && calc[mind[0]][0]>=xval[mind[0]][0])
      ret += ([ mind[0]:xval[mind[0]] ]);
    else return 0;
  return ret;
}

private int find_cgid(string cgid)
{
  mixed *vals;
  if(!m_sizeof(coins)) return 0;
  for(vals=m_values(coins);sizeof(vals);vals=vals[1..])
    if(vals[0][C_GID]==cgid) return 1;
  return 0;
}

private int match_object(object ob)
{
  int *mind,i;
  mixed *mval;
  string fname;
  if(!m_sizeof(coins)) return 0;
  mind=(int*)m_indices(coins);
  mval=m_values(coins);
  fname=explode(file_name(ob),"#")[0]+".c";
  for(i=0;i<sizeof(mval);i++)
    if(mval[i][C_FILE]==fname) return mind[i];
  return 0;
}

private mapping strip_player(object pl)
{
  object *inv,c;
  mapping ret;
  int *mind,i;
  mixed *mval;
  if(!pl || !objectp(pl)) return 0;
  ret = ([]);
  mind=(int*)m_indices(coins);
  mval=m_values(coins);
  if(!sizeof((inv=all_inventory(pl)))) return 0;
  for(i=0;i<sizeof(mval);i++)
    if((c=present(mval[i][C_GID],pl)) && c->QueryProp(P_AMOUNT)>0)
      ret += ([ c:c->QueryProp(P_AMOUNT) ]);
  if(!m_sizeof(ret)) return 0;
  return ret;
}


private static string charstr(string char, int times)
{
  string s;
  s = "";
  if(strlen(char)!=1) return "";
  for(;times>0;times--) s += char;
  return s;
}

private string ladj(mixed s,int l)
{
  return (s+charstr(" ",l))[0..(l-1)];
}

private string radj(mixed s,int l)
{
  return (charstr(" ",l)+s)[<l..];
}
