/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: fackelautomat.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/FACKELAUTOMAT.C -- Halbintelligenter Fackelautomat
//
// 18.12.1996 Holger@Wunderland
//
// $Revision: 1.1.1.1 $
//
// $Log: fackelautomat.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 10:58:50  Largo
// Initial revision
//
 
inherit "std/thing";

#include <properties.h>
#include <moving.h>
#include <wizlevels.h>
#include <defines.h>

#define BS  break_string

#define FACKEL "/obj/fackel"          // Pfad fuer Fackel
#define ZEIT 600                      // Zeit, die man warten muss

mapping besitzer;

void create()
{
    if(!clonep()) return;
    ::create();

    besitzer=([]);

    SetProp(P_PLURAL,"Fackelspender");
    SetProp(P_LONG,
        "Dieser Fackelspender ist halbintelligent und spendet daher "
        "nur eine Fackel zur Zeit. Auch spendet er nur Fackeln an "
        "Spieler, die noch nicht die Stufe 6 erreicht haben. Wenn Du "
        "eine Fackel haben willst, dann tippe \"will fackel\".");
    SetProp(P_NAME,"Fackelspender");
    SetProp(P_NAME_ADJ, "intelligent");
    SetProp(P_ADJECTIVES, ({"intelligenten","intelligentem"}));
    SetProp(P_GENDER, MALE);
    SetProp(P_ARTICLE,1);
    SetProp(P_NOGET,"Der Fackelspender will nicht von Dir genommen werden!");
    AddId(({"spender","fackelspender"}));
  	
    AddCmd("will|bitte|moechte&fackel","fackel");
}

int fackel()
{
    object fackel;
    string id;

    id=getuid(PL);
    if(IS_SEER(PL) || !interactive(PL))
    {
      write(BS("Tststs... Einige versuchens doch immer wieder...",BS_STDLEN,
        "Der Fackelspender schnarrt: ",BS_FOR_COMM));
      return 1;
    }
    if(deep_present("fackel",PL))
    {
      write(BS("Du hast doch noch eine Fackel!",BS_STDLEN,
        "Der Fackelspender schnarrt: ",BS_FOR_COMM));
      return 1;
    }
    if(present("fackel",environment()))
    {
      write(BS("Hier liegt doch irgendwo noch eine Fackel rum!",BS_STDLEN,
        "Der Fackelspender schnarrt: ",BS_FOR_COMM));
      return 1;
    }
    if (member(besitzer, id))
    {
      if ((time() - besitzer[id]) < ZEIT)
      {
        write(BS("Du hast doch vor kurzem erst eine bekommen!",BS_STDLEN,
          "Der Fackelspender schnarrt: ",BS_FOR_COMM));
        return 1;
      }
    }
    if(PL->QueryProp(P_LEVEL)>5)
    {
      write(BS("Du bist erfahren genug, um Dir Deine Fackel selbst "
        "zu besorgen.",BS_STDLEN,"Der Fackelspender schnarrt: ",BS_FOR_COMM));
      return 1;
    }
    if( (fackel=clone_object(FACKEL))->move(PL) < 1)
    {
      write("Du kannst die Fackel nicht mehr tragen!\n");
      if (fackel) fackel->remove(1);
      return 1;
    }
    write("Der Fackelspender spuckt eine Fackel in Deine Tasche.\n");
    say("Der Fackelspender spuckt eine Fackel in "+PL->name(WESSEN)+
        " Tasche.\n",PL);
    if (!(member(besitzer,id))) besitzer+=([id:time()]);
    else besitzer[id]=time();
    return 1;
}

void reset()
{
    object fackel;

    ::reset();
    if (!clonep()) return;
    if (environment()) {
        if (present("fackel",environment())) {
            tell_room(environment(), BS("Der Fackelspender macht ein "
              "seltsames saugendes Geraeuch und Du siehst wie ein "
              "paar Fackeln im Fackelspender verschwinden."));
            while(fackel=present("fackel",environment())) fackel->remove(1);
        }
    } else remove();
}
