/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: furz.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
// 
// OBJ/FURZ.C -- Der Furz der Spielersoul
//
// basierend auf der Wunderland MUDlib
//
// $Log: furz.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/05 11:12:50  Largo
// bugfix
//
// Revision 1.1  1999/08/05 11:07:14  Largo
// Initial revision
//

inherit "std/thing";

#include <properties.h>

private int    alter;
private object furzer;

void create()
{
	if(!clonep()) return;
	::create();

	SetProp(P_LONG, 0);
	SetProp(P_NAME, "Furz");
	SetProp(P_GENDER, MALE);
	SetProp(P_NOGET,"Haeh?\n");

	AddSmellDetail(({"furz","geruch","gestank"}),
		"Der Furz riecht _wirklich_ sehr widerlich.");

	AddId(({"_furz_","\nfurz"}));

	alter = 0;
	set_heart_beat(1);
}

int remove(int silent)
{
	set_heart_beat(0);
	return ::remove(silent);
}

void heart_beat()
{
	if (!alter)
		tell_room(environment(), "Fuerchterlicher Gestank erfuellt "
			"den Raum.\n");
	else
		if(!objectp(furzer))
		{
			remove(1);
			return;
		}
	alter++;

	if (!random(10))
	{
		switch(random (5))
		{
			case 0:
				tell_room(environment(), furzer->name(WESSEN)+
					" Furz stinkt wirklich grauenerregend.\n");
				break;
			case 1:
				tell_room(environment(),
					"Du haeltst Dir die Nase zu.\n");
				break;
			case 2:
				tell_room(environment(),
					"Widerliche Duenste erfuellen den "
					"Raum.\n");
				break;
			case 3:
				tell_room(environment(),
					"Der Furz riecht, als wuerde " +
					furzer->name()+" innerlich verfaulen.\n");
				break;
			default:
				tell_room(environment(),
					"Du musst Dich beinah uebergeben, "
					"als "+furzer->name(WESSEN)+
					" Furz in Deine Nase kriecht.\n"); 
		}
	}

	if (alter==45)
	{
		tell_room(environment(), furzer->name(WESSEN)+
			" widerlicher Furz hat sich endlich verzogen.\n");
		remove(1);
	}
}

void set_furzer (object wer)
{
	furzer = wer;
}
