/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: kalender.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/KALENDER.C --- Kalender fuer Eintragungen und Geburtstage
//
// Author: Bongo@Wunderland
// Date  : 29.05.1997
//
// $Revision: 1.1.1.1 $
//
// $Log: kalender.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/01 18:34:08  Largo
// Initial revision
//

inherit "std/thing";
inherit "/mail/nedit";

#include <properties.h>
#include <defines.h>

// Maximale Textlaenge pro Eintrag
#define MAX_TEXT_LENGTH 100

// Master-Objekt fuer die Verwaltung des Kalenders
#define KAL_MASTER "/secure/kal_master.c"

// Hilfsproperty fuer nedit-Funktion
#define P_SAVE_KAL_ARGS "save_kal_args"

// Laenge fuer break_string
#define WD BS_STDLEN

// Farben fuer Ueberschriften
#define KAL1 "kalender-ueberschriften"

string jahresdetail();
string gebdetail();
string textdetail();
string eintragdetail();


void create()
{
  if (!clonep()) return;

  ::create();

  SetProp(P_PLURAL, "Kalender");
  SetProp(P_NAME, "Kalender");
  SetProp(P_GENDER, MALE);
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  SetProp(P_NOGET, "Der Kalender ist fuer alle da.\n");
  SetProp(P_NOBUY, 1);
  SetProp(P_NOSELL, 1);

  AddId(({"kalender","jahreskalender","monatskalender","tageskalender",
          "\nbongo_kalender"}));

  AddDetail(({"draht","drahtgestell","gestell"}),
    "Der Kalender steht auf einem Drahtgestell. Es ist recht gross und sieht sehr "
   +"stabil aus, was bei einem so riesigen Kalender auch kein Wunder ist.");
  AddDetail(({"bild","bilder"}),
    "Auf dem Kalender sind Dutzende von huebschen Bilderchen gemalt. Sie zeigen "
   +"verschiedene Landschaften zu verschiedenen Jahreszeiten. Die Bilder symbolisieren "
   +"den Kreislauf des Lebens.");
  AddDetail(({"kreislauf","lauf"}),
    "Die Jahre kommen und gehen. So vergeht ein Leben nach dem anderen.");
  AddDetail(({"landschaften","landschaft","feld","felder","wiese","wiesen",
              "wald","waelder","berge","berg"}),
    "Die Bilder stellen die verschiedensten Landschaften dar. Schneebedeckte Berge, "
   +"bluehende Wiesen im Fruehling, Laubwaelder im Herbst, Felder im Sommer und "
   +"vieles mehr.");
  AddDetail(({"seite","seiten"}),
    "Jede Seite des Kalenders stellt ein Jahr mit 12 Monaten dar.");
  AddDetail(({"monat","monate","tabelle","tabellen"}),
    "Jeder Monat ist zu einer Tabelle zusammengefasst. Jeder Tag bildet dabei ein "
   +"kleines Kaestchen.");
  AddDetail(({"tag","tage","kasten","kaestchen","tageskasten",
              "tageskaestchen"}),
    "Jeder Tag des Kalenders besteht aus einem kleines Kaestchen, in das Du "
   +"Eintraege machen kannst.");
  AddDetail(({"schnur","schnuere"}),
    "An dem Drahtgestell sind zwei Schnuere angebunden, an denen ein Bleistift und "
   +"ein Radiergummi haengen.");
  AddDetail(({"bleistift","stift","schreiber"}),
    "Mit dem Bleistift kannst Du etwas in den Kalender eintragen.");
  AddDetail(({"radierer","radiergummi","gummi"}),
    "Mit dem Radiergummi kannst Du einen Eintrag aus dem Kalender ausradieren.");

  AddDetail(({"jahr","jahre"}),#'jahresdetail);
  AddDetail(({"geburtstag","geburtstage"}),#'gebdetail);
  AddDetail(({"text","texte"}),#'textdetail);
  AddDetail(({"eintrag","eintraege"}),#'eintragdetail);

  AddCmd(({"hilf","hilfe"}), "helfen");
  AddCmd(({"notier","notiere"}), "notieren");
  AddCmd(({"radier","radiere"}), "radieren");
  AddCmd(({"zeig","zeige"}), "zeigen");
  AddCmd(({"list","liste"}), "listen");
}


string long()
{
  int i, k, *years;
  string text;

  years = KAL_MASTER->get_years();

  text = sprintf("Auf einem Drahtgestell steht ein riesiger Kalender. Dutzende von kleinen "
        +"Bildern sind auf ihm abgebildet, welche alle verschiedene Landschaften zu "
        +"verschiedenen Jahreszeiten darstellen. Der Kalender ist in drei Seiten "
        +"zu je einem Jahr aufgeteilt %s. Jedes Jahr beinhaltet 12 Monate, welche "
        +"wiederum je in einzelne Tage unterteilt sind. In den kleinen "
        +"Tageskaestchen kannst Du ",(sizeof(years)==3?
        "("+to_string(years[0])+", "+to_string(years[1])+" und "+to_string(years[2])+")":
        ", aber leider scheint er im Moment kaputt zu sein"));

  i = 0;

  if (m_sizeof((KAL_MASTER->get_birthdays())))
  {
    text += "Geburtstage ";
    i = 1;
  }

  if ((k=m_sizeof((KAL_MASTER->get_entries()))))
  {
    if (i)
      text += "und kurze Texte ";
    else
      text += "kurze Texte ";

    i = 1;
  }

  if (i)
    text += "verzeichnet sehen. ";
  else
    text += "leider nichts verzeichnet sehen. Der Kalender ist noch vollkommen leer. ";

  text += "An der Seite des Gestells haengt ein Bleistift an einer langen Schnur und "
         +"ein Radiergummi an einer weiteren Schnur. Mit 'hilfe kalender' wirst Du "
         +"sehen, was der Kalender alles kann.";

  return text;
}


string jahresdetail()
{
  int *years;

  if (sizeof((years=KAL_MASTER->get_years()))!=3)
    return "Mit den Jahren scheint was nicht zu stimmen.";
  else
    return "Der Kalender beinhaltet die Jahre "
      +to_string(years[0])+", "+to_string(years[1])+" und "+to_string(years[2])+".";
}


string gebdetail()
{
  int i;

  if (!(i=sizeof(KAL_MASTER->get_birthdays())))
    return "Im Moment sind im Kalender keine Geburtstage eingetragen.";
  else if (i==1)
    return "Im Kalender ist ein Geburtstag eingetragen.";
  else
   return "Im Kalender sind einige Geburtstage eingetragen.";
}


string textdetail()
{
  if (!sizeof(KAL_MASTER->get_entries()))
    return "Im Moment sind im Kalender keine Texte eingetragen.";
  else
   return "Im Kalender sind einige Texte eingetragen.";
}


string eintragdetail()
{
  if (!sizeof(KAL_MASTER->get_birthdays()) && !sizeof(KAL_MASTER->get_entries()))
    return "Im Kalender sind zur Zeit keine Eintragungen zu sehen.";
  else
    return "Im Kalender sind ein paar Eintragungen zu sehen.";
}


/********************************************************************/
/*                                                                  */
/* void msg(string key, object player)                              */
/*                                                                  */
/* Die Funktion gibt abhaengig von key verschiedene Meldugen an den */
/* Raum aus.                                                        */
/*                                                                  */
/* key -----> Funktion, welche der Spieler benutzt                  */
/* player --> Spieler, der den Kalender benutzt                     */
/*                                                                  */
/********************************************************************/
void msg(string key, object player)
{
  object env;

  if (!player || !objectp(player))
    return;

  env = environment(player);

  if (key=="zeigen")
    tell_room(env, sprintf("%s blaettert im Kalender herum.\n",
      capitalize(player->name(WER,1))), ({player}));
  else if (key=="radieren")
    tell_room(env, sprintf("%s radiert im Kalender herum.\n",
      capitalize(player->name(WER,1))), ({player}));
  else if (key=="notieren")
    tell_room(env, sprintf("%s traegt etwas in den Kalender ein.\n",
      capitalize(player->name(WER,1))), ({player}));
}


/********************************************************************/
/*                                                                  */
/* string date_ret(int ret)                                         */
/*                                                                  */
/* Fehlermeldungen bei einem falsch angegebenen Datum.              */
/*                                                                  */
/* ret -----> Returnwert aus KAL_MASTER->valid_date(datum)          */
/*                                                                  */
/********************************************************************/
string date_ret(int ret)
{
  switch(ret)
  {
    case -1 : return "Es wurde kein Datum angegeben.\n";
    case -2 : return "Das Datum hat das falsche Format.\n";
    case -3 : return "Das Jahr wird nicht vom Kalender verwaltet.\n";
    case -4 : return "Den Monat verstehe ich nicht.\n";
    case -5 : return "Der Tag ist fuer diesen Monat ungueltig.\n";
    default : return "BUG BUG BUG...Melde Dich bei einem Magier.\n";
  }
}

/********************************************************************/
/*                                                                  */
/* int helfen(string str)                                           */
/*                                                                  */
/* Syntaxhilfen zum Kalender.                                       */
/*                                                                  */
/********************************************************************/
int helfen(string str)
{
  string text;
  object player;

  if (!stringp(str))
    return 0;

  if (!id(str))
    return 0;

  player = this_player();

  text = "\nDer Kalender versteht folgende Kommandos:\n"
   +"-----------------------------------------\n"
   +player->in_color(KAL1, "notiere geburtstag am <datum>\n")
   +"   <datum_ohne_jahr> -------------> Du traegst Deinen Geburtstag in den\n"
   +"                                    Kalender ein.\n"
   +player->in_color(KAL1, "notiere text am <datum>")
   +" ----------> Du kannst einen Text mit dem Editor\n"
   +"                                    eingeben und somit in den Kalender\n"
   +"                                    eintragen.\n"
   +player->in_color(KAL1, "radiere geburtstag aus")
   +" -----------> Du radierst Deinen Geburtstag aus dem\n"
   +"                                    Kalender aus.\n"
   +player->in_color(KAL1, "radiere text <nr> am <datum> aus")
   +" -> Du radierst den Text mit der Nummer <nr>\n"
   +"                                    am Tage <datum> aus dem Kalender aus.\n"
   +"                                    Die Nummer kannst Du mit dem Kommando\n"
   +"                                    zeige eintraege am <datum> ersehen.\n"
   +player->in_color(KAL1, "zeige monat")
   +" ----------------------> Du bekommst eine Uebersicht ueber den\n"
   +"                                    aktuellen Monat.\n"
   +player->in_color(KAL1, "zeige <m-name | m-nr> <jahr>")
   +" -----> Du bekommst eine Uebersicht ueber den\n"
   +"                                    Monat <m-name | m-nr> im Jahre <jahr>\n"
   +"                                    Wird <jahr> weggelassen, so wird das\n"
   +"                                    aktuelle Jahr genommen.\n"
   +player->in_color(KAL1, "zeige eintraege")
   +" ------------------> Du bekommst eine Liste der heutigen\n"
   +"                                    Eintraege.\n"
   +player->in_color(KAL1, "zeige eintraege am <datum>")
   +" -------> Du bekommst eine Liste der Eintraege\n"
   +"                                    am <datum>\n"
   +player->in_color(KAL1, "liste alle geburtstage")
   +" -----------> Dir werden alle Geburtstage mit\n"
   +"                                    Namen aufgelistet.\n"
   +player->in_color(KAL1, "liste alle eintraege")
   +" -------------> Dir werden alle Eintraege ohne Text\n"
   +"                                    aufgelistet.\n\n"
   +break_string("Die Monatsangaben koennen numerisch, englisch oder deutsch, "
   +"kurz oder lang angegeben werden. Kuerzel wie 'Dez' und 'Dec' werden ebenso "
   +"verstanden wie 'Dezember', 'December' oder einfach nur 12. "
   +"Bei den Angaben fuer das Datum gilt dieses auch. Wird nur ein Tag bei dem "
   +"Datum angegeben, wird der aktuelle Monat und das aktuelle Jahr automatisch "
   +"ermittelt. Werden nur Tag und Monat angegeben, wird das Jahr automatisch "
   +"ermittelt.",WD)
   +"\nBeispiel:\n"
   +"  01.11.97       oder\n"
   +"   1.11.1997     oder\n"
   +"  01. Nov 97     oder\n"
   +"   1.nov 1997    oder\n"
   +"   1.          (akt. Monat und akt. Jahr werden ermittelt) oder\n"
   +"   1.nov       (akt. Jahr wird ermittelt), usw. ...\n\n"
   +break_string("Wenn Du Deinen Geburtstag eingetragen hast und am bewussten "
   +"Tage ins Wunderland kommst, bekommen alle Spieler eine kleine Meldung. "
   +"Ignoriert werden kann diese Meldung folgendermassen:",WD)
   +"  ignoriere geburtstage --------------> Es werden alle Meldungen\n"
   +"                                        ignoriert\n"
   +"  ignoriere geburtstag.<spielername> -> Es werden Meldungen eines\n"
   +"                                        bestimmten Spielers ignoriert\n"
   +"  ignoriere <spielername> ------------> In Bezug auf den Kalender ist dies\n"
   +"                                        dies identisch mit\n"
   +"                                        geburtstag.<spielername>\n\n"
   +break_string("Der Kalender reagiert auf die Farbunterstuetzung und hat "
   +"5 Ereignisse, welche Du speziell fuer Dich setzen kannst. Mit "
   +"'hilfe farbe' siehst Du, wie man das macht.",WD)
   +"\nViel Spass\n\n"
   +"gez.: Bongo\n";

  this_player()->More(text);
  return 1;
}


/********************************************************************/
/*                                                                  */
/* int notiz_speichern(string text)                                 */
/*                                                                  */
/* Diese Funktion wird vom Editor nach der Eingabe eines Textes     */
/* aufgerufen, um den Text zu speichern.                            */
/*                                                                  */
/********************************************************************/
int notiz_speichern(string text)
{
  int *date, ret;
  string playername;
  object player;
  mixed args;

  player = this_player();
  args = player->QueryProp(P_SAVE_KAL_ARGS);
  player->SetProp(P_SAVE_KAL_ARGS, 0);

  if (!stringp(text))
    return 1;

  if (sizeof(args)<2)
  {
    write("BUG BUG BUG...Melde Dich bei einem Magier.\n");
    return 1;
  }

  date = args[0];
  playername = args[1];

  ret = KAL_MASTER->AddEntry(date[0], date[1]+1, date[2], playername, text);

  switch(ret)
  {
    case 1:
      write(break_string("Du traegst den Text mit dem Bleistift im "
       +"Kaestchen fuer den "+KAL_MASTER->get_date_str(date)+" ein.", WD));
      msg("notieren", player);
      break;
    case -3:
      write("Eintraege in der Vergangenheit sind nicht moeglich.\n");
      break;
    case -5:
      printf("Der Text darf %d Zeichen nicht ueberschreiten.\n",MAX_TEXT_LENGTH);
      break;
    case -6:
      write("Das Kaestchen fuer diesen Tag ist leider voll.\n");
      break;
    case -7:
      write("Mehr darfst Du an diesem Tag nicht eintragen.\n");
      break;
    default:
      write("Da ist etwas schief gelaufen. Melde Dich bei einem Magier.\n");
      break;
  }

  return 1;
}


/********************************************************************/
/*                                                                  */
/* int notieren(string str)                                         */
/*                                                                  */
/* Funktion zum Notieren eines Geburtstages oder eines Textes.      */
/*                                                                  */
/********************************************************************/
notieren(str)
{
  int *date, ret;
  string when, playername, text;

  notify_fail("Was willst Du notieren?\n");

  if (!str || !stringp(str))
    return 0;

  playername = this_player()->query_real_name();

  if (sscanf(str,"geburtstag am %s",when)==1)
  {
    if ((date=KAL_MASTER->valid_date(when,0))[0]<0)
    {
      write( date_ret(date[0]) );
      return 1;
    }

    ret = KAL_MASTER->AddBirthday(date[0]+1, date[1], playername);

    if (ret==-4)
      write("Dein Name ist schon im Kalender eingetragen.\n");
    else
    {
      write(break_string("Du traegst Deinen Geburtstag mit dem Bleistift "
       +"in das Kaestchen fuer den "+KAL_MASTER->get_date_str(date)
       +" ein.",WD));
      msg("notieren", this_player());
    }

    return 1;
  }
  else if (sscanf(str,"text am %s",when)==1)
  {
    if ((date=KAL_MASTER->valid_date(when,1))[0]<0)
    {
      write( date_ret(date[0]) );
      return 1;
    }

    this_player()->SetProp(P_SAVE_KAL_ARGS, ({ date, playername }));

    write(break_string("Gib jetzt Deinen Text ein, oder . ,wenn Du fertig "
     +"bist,~q zum Abbrechen und ~h fuer eine Hilfsseite.\n",WD)
     +"Hinweis: Der Text darf eine Laenge von 100 Zeichen nicht ueberschreiten.\n");

    nedit("notiz_speichern");
    return 1;
  }

  return 0;
}


/********************************************************************/
/*                                                                  */
/* int radieren(string str)                                         */
/*                                                                  */
/* Funktion zum Radieren eines Geburtstages oder eines Textes.      */
/*                                                                  */
/********************************************************************/
radieren(str)
{
  int *date, ret, number;
  string playername, when;

  notify_fail("Was willst Du ausradieren?\n");

  if (!str || !stringp(str))
    return 0;

  playername = this_player()->query_real_name();

  if (str=="geburtstag" || str=="geburtstag aus")
  {
    ret = KAL_MASTER->RemoveBirthday(playername);

    if (ret==-2 || ret==-3)
      write("Dein Geburtstag ist nicht im Kalender eingetragen.\n");
    else if (ret<=0)
      write("Da ging etwas schief. Frag am besten einen Magier.\n");
    else
    {
      write("Du radierst Deinen Geburtstag aus dem Kalender aus.\n");
      msg("radieren",this_player());
    }

    return 1;
  }
  else if (sscanf(str,"text %d am %s aus",number,when)==2 ||
           sscanf(str,"text %d am %s",number,when)==2)
  {
    if ((date=KAL_MASTER->valid_date(when,1))[0]<0)
    {
      write( date_ret(date[0]) );
      return 1;
    }

    ret = KAL_MASTER->RemoveEntry(date[0], date[1]+1, date[2], playername, number-1);

    if (ret==-4)
      write(break_string("Ein Text mit dieser Nummer ist nicht von Dir "
       +"im Kalender eingetragen worden.\n", WD));
    else if (ret<=0)
      write("Da ging etwas schief. Frag am besten einen Magier.\n");
    else
    {
      write(break_string("Du radierst den "+number+". Text aus dem Kaestchen vom "
       +KAL_MASTER->get_date_str(date)+" aus.",WD));
      msg("radieren",this_player());
    }

    return 1;
  }

  return 0;
}


/********************************************************************/
/*                                                                  */
/* int zeigen(string str)                                           */
/*                                                                  */
/* Funktion zum Darstellen eines Monats oder eines bestimmten       */
/* Eintrages im Kalender.                                           */
/*                                                                  */
/********************************************************************/
zeigen(str)
{
  int *date, m, y;
  string  when;
  mixed text, what;

  notify_fail("Was willst Du Dir zeigen lassen?\n");

  if (!str || !stringp(str))
    return 0;

  str = lower_case(str);

  if (str=="monat")
  {
    date = KAL_MASTER->get_date();
    this_player()->More( KAL_MASTER->GetMonth(date[1]+1, date[0]) );
    msg("zeigen", this_player());
    return 1;
  }
  else if (str=="eintrag" || str=="eintraege")
  {
    date = KAL_MASTER->get_date();
    text = KAL_MASTER->GetDay(date[0], (date[1]+1), date[2]);

    if (!stringp(text))
      switch(text)
      {
        case 0:
          write("Ungueltiges Jahr oder ungueltiger Monat...\n");
          break;
        case -1:
          write("Ungueltiger Tag...\n");
          break;
        case -2:
          write("Dieser Tag hat keine Eintraege.\n");
          break;
      }
    else
      this_player()->More(text);

    msg("zeigen", this_player());
    return 1;
  }
  else if (sscanf(str,"%s am %s",what,when)==2)
  {
    if (what!="eintrag" && what!="eintraege")
      return 0;

    if ((date=KAL_MASTER->valid_date(when,1))[0]<0)
    {
      write( date_ret(date[0]) );
      return 1;
    }

    text = KAL_MASTER->GetDay(date[0], date[1]+1, date[2]);

    if (!stringp(text))
      switch(text)
      {
        case 0:
          write("Ungueltiges Jahr oder ungueltiger Monat...\n");
          break;
        case -1:
          write("Ungueltiger Tag...\n");
          break;
        case -2:
          write("Dieser Tag hat keine Eintraege.\n");
          break;
      }
    else
      this_player()->More(text);

    msg("zeigen", this_player());
    return 1;
  }
  else if (sscanf(str,"%s %s",what,when)==2 ||
           sscanf(str,"%s",what)==1)
  {
    m = KAL_MASTER->check_month(what);
    y = KAL_MASTER->check_year(to_int(when));

    if (m<0 || y<0)
      return 0;

    this_player()->More( KAL_MASTER->GetMonth(m+1, y) );
    msg("zeigen", this_player());
    return 1;
  }

  return 0;
}


/********************************************************************/
/*                                                                  */
/* int listen(string str)                                           */
/*                                                                  */
/* Funktion zum Auflisten aller eingetragenen Geburtstage und       */
/* Eintraege.                                                       */
/*                                                                  */
/********************************************************************/
listen(str)
{
  notify_fail("Was moechtest Du auflisten?\n");

  if (!str || !stringp(str))
    return 0;

  str = lower_case(str);

  if (str=="alle geburtstage" || str=="alle geburtstage auf")
    this_player()->More( KAL_MASTER->ListAllBirthdays() );
  else if (str=="alle eintraege" || str=="alle eintraege auf")
    this_player()->More( KAL_MASTER->ListAllEntries() );
  else
    return 0;

  return 1;
}
