/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: listenbuch.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
// Basierend auf Morgengrauen Mudlib
//
// OBJ/LISTENBUCH.C --- object for all toplists
//
// Author: Bongo@Wunderland
//
// $Revision: 1.1.1.1 $
//
// $Log: listenbuch.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 11:11:09  Largo
// Initial revision
//

inherit "std/thing";

#include <properties.h>

//Der Array LISTS ist folgendermassen aufgebaut:
//LISTS = ({ Listenname , ({ ID's(immer als Array), Filename der Liste }) })

#define LISTS ({                                                             \
    ({"Die Topliste der Spieler",                                            \
          ({"topliste der spieler","toplisten der spieler","spielerliste",   \
          "spielerlisten","liste der spieler","listen der spieler",          \
          "spielertopliste","spielertoplisten"}),                            \
          "/etc/list_top.read"}),                                            \
    ({"Die Topliste der Seher",                                              \
          ({"topliste der seher","toplisten der seher","seherliste",         \
          "seherlisten","liste der seher","listen der seher",                \
          "sehertopliste","sehertoplisten"}),                                \
          "/etc/list_seher.read"}),                                          \
    ({"Die Helden der Menschenheit",                                         \
          ({"topliste der menschen","toplisten der menschen","menschenliste",\
          "menschenlisten","liste der menschen","listen der menschen",       \
          "menschentopliste","menschentoplisten","helden der menschen",      \
          "helden der menschheit"}),                                         \
          "/etc/list_human.read"}),                                          \
    ({"Die Helden des Vampirclans",                                          \
          ({"topliste der vampire","toplisten der vampire","vampirliste",    \
          "vampirlisten","liste der vampire","listen der vampire",           \
          "vampirtopliste","vampirtoplisten","helden der vampire",           \
          "helden des vampirclans"}),                                        \
          "/etc/list_vampir.read"}),                                         \
    ({"Die Topliste der Forscher",                                           \
          ({"topliste der forscher","toplisten der forscher","forscherliste",\
          "forscherlisten","liste der forscher","listen der forscher",       \
          "forschertopliste","forschertoplisten"}),                          \
          "/etc/forscherliste.read"}),                                       \
    ({"Die Kerbholz-Topliste",                                               \
          ({"topliste des kerbholzes","toplisten des kerbholzes",            \
          "liste des kerbholzes","listen des kerbholzes",                    \
          "kerbholz-topliste","kerbholz-toplisten","kerbholztopliste",       \
          "kerbholztoplisten","kerbholz-liste","kerbholz-listen",            \
          "kerbholzliste","kerbholzlisten"}),                                \
          "/players/gum/obj/kerbholz/top.liste"}),                           \
    ({"Die Kerbholz-Topmonsterliste",                                        \
          ({"topmonsterliste des kerbholzes","topmonsterlisten des kerbholzes", \
          "monsterliste des kerbholzes","monsterlisten des kerbholzes",      \
          "kerbholz-topmonsterliste","kerbholz-topmonsterlisten",            \
          "kerbholztopmonsterliste","kerbholztopmonsterlisten",              \
          "kerbholz-liste","kerbholz-listen","kerbholzliste",                \
          "kerbholzlisten"}),                                                \
          "/players/gum/obj/kerbholz/topmon.liste"}),                        \
    ({"Die \"Vier-gewinnt\"-Topliste",                                       \
          ({"4gwliste","4gw-liste","4gwtopliste","4gw-topliste",             \
          "vier-gewinnt-topliste","viergewinnt-topliste",                    \
          "viergewinnttopliste"}),                                           \
          "/players/gum/obj/spiele/4gw.liste"}),                             \
    ({"Die Kreuzelspiel-Topliste",                                           \
          ({"kreuzelliste","kreuzel-liste","kreuzeltopliste",                \
          "kreuzel-topliste", "kreuzelspieltopliste",                        \
          "kreuzelspiel-topliste"}),                                         \
          "/players/gum/obj/spiele/kreuzel.liste"}) })


void create()
{
  if (!clonep())
    return;

  ::create();

  SetProp(P_DESCR, "der Listen");
  SetProp(P_LONG,
    "Dies ist das Buch der Listen. Es ist in feinstes Leder gebunden. Metallbeschlaege "
    "halten die Seiten fest beieinander. Eine dicke Kette schuetzt das Buch vor einem "
    "Diebstahl. Das Podest, auf dem es liegt, ist gerade so gross, dass der Kleinste "
    "noch muehelos in dem Buch lesen kann. Mit <listen> und <zeige listen> kannst Du Dir "
    "die eingetragenen Listen anzeigen lassen.");

  SetProp(P_NAME, "Buch");
  SetProp(P_PLURAL, "Buecher");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_VALUE, 0);
  SetProp(P_WEIGHT, 0);
  SetProp(P_NOBUY, 1);
  SetProp(P_NOSELL, 1);
  SetProp(P_NOGET, "Das Buch ist an ein Podest angekettet.\n");

  AddId(({"buch","listenbuch","buch der listen","buch der liste","buch der spielerlisten",
          "\nlistenbuch"}),({"buecher","listenbuecher"}));

  AddDetail(({"liste","listen"}),
    "Du musst schon genauer angeben, welche Liste Du anschauen moechtest.");
  AddDetail(({"leder","lederband","lederumschlag","umschlag","lederbuchumschlag",
              "buchumschlag"}),
    "Das Buch der Listen ist in feinstes Leder eingebunden. Es sieht richtig edel aus.");
  AddDetail(({"metall","beschlag","beschlaege","metallbeschlag","metallbeschlaege"}),
    "Die Seiten des Buches werden mit starken Metallbeschlaegen zusammengehalten, wie es frueher im "
    "Mittelalter Brauch war. Das Buch scheint schon sehr alt zu sein.");
  AddDetail(({"kette","ketten","dicke kette","dicke ketten"}),
    "Das Buch ist mit einer dicken Kette an ein Podest gebunden. Nur so ist es vor einem "
    "Diebstahl geschuetzt.");
  AddDetail("podest",
    "Das Buch liegt auf einem kleinen Podest, das gerade gross genug ist, dass auch der "
    "Kleinste muehelos an die Listen herankommt.");
  AddDetail(({"kleinster","kleinste"}),
    "Naja, es gibt ja verschiedene Rassen im Wunderland und keine ist sonderlich gross.");

  AddCmd(({"listen","liste","zeige","zeig","oeffne","schlag","schlage"}),"inhalt");
  AddCmd(({"lies","lese","schau","unt","untersuche","untersuch",
           "betrachte"}),"listen");
}


int inhalt(string str)
{
  int i, k;
  string verb;

  if (((verb=query_verb())=="listen" || verb=="liste") && str)
    return 0;
  else if ((verb=="zeige" || verb=="zeig") &&
           (str!="listen" && str!="liste" && str!="inhalt" && str!="verzeichnis"))
    return 0;
  else if (verb=="oeffne" && !id(str))
    return 0;
  else if ((verb=="schlag" || verb=="schlage") &&
           !(str && stringp(str) && sscanf(str,"%s auf",str)==1 && id(str)))
    return 0;

  write("Du schlaegst das Inhaltsverzeichnis auf.\nFolgende Listen kannst Du "
    +"Dir anschauen.\n");

  tell_room(this_player(), this_player()->name(WER,1)+" liest im Buch der Listen.\n",
    ({this_player()}));

  if (!LISTS || !(k=sizeof(LISTS)))
  {
    write("Im Moment ist keine Liste in das Buch eingetragen.\n");
    return 1;
  }

  for (i=0;i<k;i++)
    printf("  Seite %2d. %s\n",i+1,LISTS[i][0]);

  write("\nMit <lies/schau/untersuche liste/seite/nummer> kannst Du die Listen\nansehen.\n");
  return 1;
}


int listen(string str)
{
  int i, k, page;
  string file;

  if (!stringp(str)) return 0;

  if (!pointerp(LISTS) || !(k=sizeof(LISTS)))
    return 0;

  file = "";

  if (sscanf(str,"seite %d",page)==1 || sscanf(str,"liste %d",page)==1 ||
      sscanf(str,"%d",page)==1)
  {
    if (page<=0 || page>k)
    {
      write("So viele Listen sind nicht im Buch eingetragen.\n");
      return 1;
    }

    file = LISTS[page-1][2];
  }
  else if ((query_verb()=="lies" || query_verb()=="lese") && this_object()->id(str))
  {
    write("Du musst schon die Seite angeben, die Du lesen moechtest.\n");
    return 1;
  }
  else
    for (i=0;i<k;i++)
    {
      if (member(LISTS[i][1],str)!=-1)
      {
        file = LISTS[i][2];
        break;
      }
    }

  if (!file || file=="")
    return 0;

  if(!this_player()->more(file))
    write("Die Liste ist im Moment leider leer.\n");
 
  tell_room(this_player(), this_player()->name(WER,1)+" liest im Buch der Listen.\n",
    ({this_player()}));
 
  return 1;
}
