/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: bier.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/MISC/BIER.C -- Bier her!
//
// Based on Wunderland Mudlib
//
// $Revision: 1.1.1.1 $
//
// $Log: bier.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/05 12:32:00  Largo
// bugfix
//
// Revision 1.1  1999/08/05 12:26:13  Largo
// Initial revision
//

#include <properties.h>
#include <defines.h>

inherit "std/thing";

string *sorten;
mixed orig_ids;
mapping badsorten;
string wahl;

void ungewaehlt();
void initSorten();

void create() {
  if (!clonep()) return;
  ::create();
  SetProp( P_GENDER, FEMALE );
  AddId( ({ "bier","flasche","humpen","bierflasche" }),
    ({ "biere","flaschen","humpen","bierflaschen" }));
  orig_ids=QueryProp(P_IDS); // P_IDS wird sich bald aendern?!?
  SetProp( P_WEIGHT, 600 );
  SetProp( P_VALUE, 10 );
  SetProp( P_NOBUY, 1 );
  ungewaehlt();
  AddCmd( "wuensche", "wuenschen" );
  AddCmd( "bierliste", "liste" );
  AddCmd( ({"trinke","trink"}), "trinken" );
  AddCmd( ({"proste","prost","prosit"}), "prosten" );
  initSorten();
  wahl = "";
}

void ungewaehlt() {
  SetProp(P_IDS, orig_ids);
  SetProp(P_NAME, "Bierflasche" );
  SetProp(P_PLURAL, "Bierflaschen" );
  SetProp(P_DESCR, 0);
  SetProp(P_NAME_ADJ, "magisch");
  SetProp(P_ADJECTIVES, ({"magische", "magischen", "magischem"}) );
  SetProp(P_LONG, "Diese magische Bierflasche ist momentan leer. Und das ist "
    "gut so, denn Du solltest Dich erst fuer Deine Lieblingssorte entscheiden, "
    "damit die magische Flasche Deinen Wuenschen entspricht. (Eine Speisekarte "
    "erhaeltst du mit \"bierliste\".)");
}

void initSorten() {
  sorten = ({ "krombacher", "becks", "jever", "flensburger", "warsteiner",
    "veltins", "bitburger", "rolinck", "iserlohner", "paulaner",
    "erdinger", "radler", "krefelder", "pinkus" ,"wernesgruener",
    "koelsch", "koestritzer", "vitamalz", "sterbehilfe", "einsiedler",
    "radeberger", "gersdorfer", "braustolz", "reudnitzer", "diebels",
    "hannen","guinness", "astra", "holsten"});
  badsorten = ([
    "rolink" : "Du meinst doch Rolick, oder?\n",
    "clausthaler" : "Die Bierflasche schuettelt sich vor Ekel.\n",
    "bauer" : "Die Bierflasche weigert sich, sowas zu enthalten!\n",
    "oettinger" : "OH NEIN! Nicht das noch!!!\n",
    "weisse" : "Das hat nichts mit Bier zu tun!\n",
    "weise" : "Das hat nichts mit Bier zu tun!\n",
    "zaubertrank" : "HAHA! :) Selten so gelacht! :-)\n",
    "zt" : "HAHA! :) Selten so gelacht! :-)\n" ]);
}

int liste() {
  string ans;
  int i;
  ans = "Es stehen momentan folgende Sorten zur Verfuegung: ";
  for( i=0; i<sizeof(sorten)-2; i++ )
    ans += CAP(sorten[i])+ ", ";
  ans += CAP(sorten[<2]) + " und " + CAP(sorten[<1]) + ".\n";
  write( break_string( ans ));
  return 1;
}

int wuenschen( string str ) {
  int i;
  string bad;
  notify_fail("Was willst Du Dir denn fuer ein Bier wuenschen?\n");
  if(!stringp(str)) return 0;
  str = lower_case(str);
  if(member_array(str, sorten)>-1) {
    wahl = str;
    write( "Eine gute Wahl! Und schon fuellt sich die Flasche mit frischem "+
      capitalize(wahl) + ".\n" );
    SetProp(P_NAME, "Flasche" );
    SetProp(P_PLURAL, "Flaschen" );
    SetProp(P_NAME_ADJ, 0);
    SetProp(P_ADJECTIVES, ({}) );
    SetProp(P_DESCR, "voll " + capitalize(wahl) );
    SetProp( P_LONG, "Du haeltst ein schoenes, grosses und vor allem kuehles "+
      capitalize(wahl) + " in Deinen Haenden.");
    AddId(wahl);
    return 1;
  }
  if( bad = badsorten[str] ) {
    write( bad );
    return 1;
  }
  if( member_array( str, ({ "pilz","bier","pils","alt","koelsch",
    "hefe","weizen","weizenbier" }) ) != -1 ) {
    write( "Ein bischen genauer sollte es schon sein.\n" );
    return 1;
  }
  write( "So ein Pech, die Sorte ist gerade aus.\n" );
  log_file( "obj/bier.log", dtime(time())+": "+
    PL->name(WER) + " moechte ein " + capitalize(str) + ".\n");
  return 1;
}

int trinken( string str ) {
  if( !str || !id(str) ) return 0;
  if( !strlen(wahl) ) {
    write( "Du nuckelst an einer leeren Bierflasche.\n" );
    say( PL->name(WER,2)+
      " nuckelt an einer leeren Bierflasche herum (So ein Kind!)\n");
    return 1;
  }
  write( "Ahhh, Du trinkst Dein "+capitalize(wahl)+
    " mit Genuss in einem Zug auf.\n");
  if( random(3) == 0 ) {
    write( "Du hoerst den Teufel leise lachen:\n"
      "  'Nichts geht schneller an die Niere,\n"
      "   als Don Rumata seine Biere.'\n");
  }
  say( PL->name(WER,2) + " trinkt " + PL->QPP( NEUTER, WEN ) + " "+
    capitalize(wahl) + ".\n" + capitalize(PL->QueryPronoun(WER))+
    " scheint es sichtlich zu geniessen.\n");
  ungewaehlt();
  wahl = "";
  return 1;
}

int prosten( string str ) {
  string arg;
  object obj;
  if( !strlen(wahl) ) {
    write( "Mit einer leeren Flasche?\n" );
    return 1;
  }
  if( !str ) {
    write( "Du prostest der Gemeinde zu.\n" );
    say( PL->name(WER,2) + " sagt Prost!\n" );
    return 1;
  }
  if( sscanf( str, "%s zu", arg ) == 1 )
    str = arg;
  if( !(obj=present(str,environment(PL))) || !living(obj) ) {
    write( "Keinen Saufbruder gefunden (So'n Frust).\n" );
    return 1;
  }
  write( "Du prostest " + obj->name(WEM,2) + " zu.\n" );
  tell_object( obj, PL->name(WER,2) + " prostet Dir zu.\n" );
  say( PL->name(WER,2) + " prostet " + obj->name(WEM,2) + " zu.\n", obj );
  return 1;
}
