/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: kissen.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/MISC/KISSEN.C -- Auf in die Schlacht!
//
// Based on Wunderland Mudlib
//
// $Revision: 1.1.1.1 $
//
// $Log: kissen.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:34:04  Largo
// Initial revision
//

inherit "std/thing";

#include <properties.h>
#include <moving.h>

int throw_it(string str);

string init_colour() {
  mixed cols;
  cols=({"gruen", "rot", "blau", "gelb",
    "schwarz-weiss-kariert", "orange-pink-gestreift",
    "lila-gruen-getuepfelt", "silbergrau", "weiss",
    "klein", "gescheckt"});
  return cols[random(sizeof(cols))];
}

void create() {
  string col;
  if (!clonep()) return;
  ::create();
  AddId("kissen");
  SetProp(P_WEIGHT, 1);
  SetProp(P_BULKINESS, 200);
  SetProp(P_VALUE, 6);
  SetProp(P_NAME, "Kissen");
  SetProp(P_PLURAL, "Kissen");
  col=init_colour();
  SetProp(P_NAME_ADJ, col);
  SetProp(P_ADJECTIVES, ({ col+"es", col+"en", col+"em", col+"e"}) );
  SetProp(P_LONG, "Dies ist ein wunderschoenes, "+col+"es Kissen.\n"+
    "Du kannst versuchen es zu werfen.");
  AddCmd("wirf|werfe", "throw_it"); 
  AddCmd("ww", "wirf_random");
}

int wirf_random(string str) {
  if(str)
    return throw_it("kissen nach "+str);
  else {
    object *all, *liv;
    all=all_inventory(environment(this_player()))-({ this_player() });
    liv=filter_array(all, #'query_once_interactive);
    if (!sizeof(liv)) {
      notify_fail("Niemand da...\n");
      return 0;
    }
    return throw_it("kissen nach "+
      getuid(liv[random(sizeof(liv))]));
  }
}

int throw_it(string str) {
  int treffer;
  string victim_name,werfer_name;
  string victim_string,werfer_string;
  string was,at,wen;
  object victim;

  notify_fail("WAS willst Du nach WEM werfen?\n");
  if(!str)
    return 0;
  if(sscanf(str,"%s %s %s",was,at,wen) != 3)
    return 0;
  if(!id(was) || ((at != "nach") && (at != "auf")))
    return 0;
  victim = find_living(lower_case(wen));
  if(!victim || !present(victim,environment(this_player()))) {
    write("Dieser Spieler ist nicht hier!\n");
    return 1;
  }
  if (victim==this_player()) {
    write("Dich selbst bewerfen?!?\n");
    return 1;
  }
  victim_name = capitalize(victim->name(WEM));
  werfer_name = this_player()->name(WER);
  treffer = random(5);
  write("Du schmeisst ein Kissen "+at+" "+victim_name +".\n");
  tell_room(environment(victim),
    werfer_name + " wirft ein Kissen "+at+" "+victim_name + ".\n",
    ({this_player(), victim}) );
  tell_object(victim, werfer_name + " wirft ein Kissen nach Dir.\n");
  if (treffer==0) {
    werfer_string = "Du verfehlst " + victim_name + " meilenweit.\n";
    victim_string = werfer_name + " verfehlt Dich meilenweit.\n";
  }
  if (treffer==1) {
    werfer_string = "Das Kissen streift " + victim_name + " am Ohrlaeppchen.\n";
    victim_string = "Das Kissen streift Dich am Ohrlaeppchen.\n";
  }
  if (treffer==2) {
    werfer_string = "PAFF! Du triffst " + victim_name + " mitten ins Gesicht.\n";
    victim_string = "PAFF! Das Kissen trifft Dich mitten im Gesicht!\n";
  }
  if (treffer==3) {
    werfer_string = "WUSCH! Das Kissen trifft " + victim_name + "'s Bauch mit voller Wucht.\n";
    victim_string = "WUSCH! Das Kissen fliegt mit voller Wucht gegen Deinen Bauch.\n";
  }
  if (treffer==4) {
    werfer_string = victim_name + " versucht wegzurennen, doch das Kissen trifft den Hinterkopf.\n";
    victim_string = "Du versuchst wegzurennen, aber das Kissen trifft Dich am Hinterkopf.\n";
  }
  write(werfer_string);
  tell_object(victim,victim_string);
  if (treffer) {
    if (move(victim, M_GIVE) < MOVE_OK)
      move(environment(this_player()), M_PUT);
  } else {
    move(environment(this_player()), M_PUT);
  }
  return 1;
}

