/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: muellschlucker.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Muellschlucker

inherit "std/npc";

#include <properties.h>
#include <moving.h>
#include <defines.h>

void create ()
{
  if (! clonep()) return;

  ::create();

  create_default_npc(1);

  seteuid(getuid(this_object()));

  SetProp(P_NAME, "Muellschlucker");
  SetProp(P_LONG,
    "Der Muellschlucker gehoert zu Familie der Kleinsaurier und zeichnet "
    "sich durch ein sehr grosses Maul und nahezu unbegrenzten Appetit aus. "
    "Das einzige, was er nicht mag, sind Dinge, die materiellen Wert haben. "
    "Alles andere kann man ihm mit 'fuettere muellschlucker mit <name>' "
    "in den Rachen stopfen.");
  SetProp(P_INFO, break_string(
    "Dieser Muellschlucker verschlingt auch lose herumliegende Dinge. Also "
    "pass auf, was Du wegwirfst."));
  SetProp(P_GENDER,  MALE);
  SetProp(P_RACE,    "saurier");
  SetProp(P_ARTICLE, ART_INDEF);
  SetProp(P_XP,      0);
  SetProp(P_BODY,    100);
  SetProp(P_HANDS,   ({" mit dem alles verschlingenden Gebiss",20}));
  SetProp(P_ALIGN,   0);
  SetProp(P_MSGIN,   "watschelt herein");
  SetProp(P_MSGOUT,  "watschelt");

  AddCmd(({"fuetter", "fuettere"}), "haps");

  AddId(({"muellschlucker", "schlucker", "kleinsaurier", "saurier"}),
        ({"muellschlucker", "schlucker", "kleinsaurier", "saurier"}));

  AddInfo("\ndefault",
    "grunzt nur vor sich hin.");

  enable_commands();
}

int haps (string str)
{
  string s1,s2;
  object ob;
  notify_fail("Syntax: fuettere muellschlucker mit <name>\n");
  if(!str)return 0;
  if(sscanf(str,"%s mit %s",s1,s2)!=2)return 0;
  if(!id(s1))return 0;
  notify_fail("So etwas hast Du nicht.\n");
  if((!ob=present(s2,this_player())) &&
     (!ob=present(s2,environment()))) return 0;
  if(ob->QueryProp(P_NODROP) || ob->QueryProp(P_NEVERDROP)){
    write("Das kannst Du nicht wegwerfen.\n");
    return 1;
  }
  if(living(ob)){
    write("Der Muellschlucker frisst keine Lebewesen.\n");
    return 1;
  }
  if(ob->QueryProp(P_VALUE)){
    write("Das ist zu wertvoll, das vertraegt der Muellschlucker nicht.\n");
    return 1;
  }
  if (ob->QueryProp(P_CURSED)) {
    write("Verfluchte Dinge bekommen dem Muellschlucker nicht!\n");
    return 1;
  }
  ob->remove();
  if(ob){
    write("Aus irgendeinem Grund scheint das dem Muellschlucker nicht "+
    "zu schmecken.\n");
    return 1;
  }
  write("Mit einem lauten Ruelpsen verschlingt der Muellschlucker alles.\n");

  return 1;
}

void reset()
{
  int i;
  object *inv;

  ::reset();

  inv=all_inventory(this_object());
  if(inv && sizeof(inv))
    for(i=sizeof(inv)-1;i>=0;i--)
      destruct(inv[i]);
  command("nimm alles");
}

void StartReaction(string verb, string gruppe, string adverb, int touch)
{
  if (find_call_out("react")!= -1) return;

  switch(gruppe)
  {
    case "fies":
      call_out("react", 0, "faucht Dich boese an",
        "faucht "+this_player()->name(WEN)+" boese an");
      break;
    case "aergerlich":
      call_out("react", 0, "zittert wie Espenlaub", "zittert wie Espenlaub");
      break;
    case "traurig":
      call_out("react", 0, "leckt Dir troestend das Gesicht",
	     "leckt "+this_player()->name(WEM, 2)+" troestend das Gesicht");
      break;
    case "albern":
      call_out("react", 0, "legt den Kopf schief und grinst Dich an",
             "legt den Kopf schief und grinst "+this_player()->name(WEN)+" an");
      break;
    case "neutral":
      call_out("react", 0, "grinst Dich an", "grinst "+this_player()->name(WEN)+" an");
      break;
    case "intim":
      call_out("react", 0, "kuesst Dich leidenschaftlich",
                   "kuesst "+this_player()->name(WEN)+" leidenschaftlich");
      break;
    case "froh":
      call_out("react", 0, "laechelt Dich froehlich an",
             "laechelt "+this_player()->name(WEN)+" froehlich an");
      break;
    case "aengstlich":
      call_out("react", 0, "floesst Dir neuen Mut ein",
             "floesst "+this_player()->name(WEM)+" neuen Mut ein");
      break;
    case "frech":
      call_out("react", 0, "fiept Dich an", "fiept "+this_player()->name(WEN)+" an");
      break;
    case "nett":
      call_out("react", 0, "knuddelt Dich", "knuddelt "+this_player()->name(WEN));
      break;
  }
}

void react(string victim, string others)
{
  if (present(this_player(), environment(this_object())))
  {
    tell_object(this_player(), break_string(this_player()->name(WER, 1) + " "+victim+".", 68));
    tell_room(environment(this_object()), break_string(this_player()->name(WER, 1)+" "+others+".", 68),
      ({this_player(), this_object()}));
  }
}

void StartReactionAll(string verb, string gruppe, string adverb, int touch)
{
  return StartReaction(verb, gruppe, adverb, touch);
}

