/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: seil.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
//
// 12.09.1997  (Bongo)
// File ueberarbeitet
//
inherit "std/thing";

#include <properties.h>
#include <defines.h>

#define BS break_string

object tied_to_ob;


void create()
{
  if (!clonep()) return;

  ::create();

  SetProp(P_LONG,
    "Du siehst ein ganz normales Seil. Du kannst es an Gegenstaenden festbinden.");

  SetProp(P_NAME, "Seil");
  SetProp(P_PLURAL, "Seile");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_WEIGHT, 300);
  SetProp(P_VALUE, 15);
  SetProp(P_BULKINESS, 50);

  AddId("seil", "seile");

  AddCmd(({"binde","bind","knot","knote","befestige"}),"tie");
}


string _query_descr()
{
  if (tied_to_ob)
    return "\b, das an "+tied_to_ob->name(WEM,1)+" festgebunden ist.\n";

  return (string)0;
}


mixed _query_noget()
{
  if (tied_to_ob)
    return "Das geht nicht, solange das Seil festgebunden ist.\n";

  return 0;
}


int tie(string str)
{
  string t1, t2;
  object obj, player, env;
  string verb;

  notify_fail("Binde was wo an oder binde was ab?\n");

  if (!str || !stringp(str))
    return 0;

  verb = query_verb();
  player = this_player();
  env = environment(player);

  if (sscanf(str,"%s an %s",t1,t2)==2)
  {
    if (!id(t1))
      return 0;

    if (tied_to_ob)
    {
      write("Das Seil ist bereits irgendwo festgebunden.\n");
      return 1;
    }

    if (t2=="mich")
    {
      write("Warum willst Du das denn machen?\n");
      return 1;
    }

    if (!(obj=present(t2, player)) && 
        !(obj=present(t2, env)))
      if (call_other(env, "id", t2))
        obj = env;

    if (!obj)
    {
      write("Wo willst Du das Seil anbinden?\n");
      return 1;
    }

    if (!call_other(obj, "tie", t2))
    {
      if (obj!=env)
        write(BS(sprintf("Du kannst das Seil nicht an %s festbinden.",
          obj->name(WEM,1))));
      else
        write("Du kannst das Seil nicht daran festbinden.\n");

      return 1;
    }

    if (environment()==player)
      this_object()->move(env);

    tied_to_ob = obj;

    write(BS(sprintf("Du bindest das Seil an %s fest.",tied_to_ob->name(WEM,1))));

    if (tied_to_ob!=env)
      tell_room(env, BS(sprintf("%s bindet das Seil an %s fest.",
        capitalize(player->name(WER,1)),tied_to_ob->name(WEM,1))),({player}));
    else
      tell_room(env,sprintf("%s bindet das Seil an etwas fest.\n",
        capitalize(player->name(WER,1))),({player}));

    return 1;
  }
  else if ((verb=="bind" || verb=="binde" || verb=="knot" || verb=="knoten") &&
           sscanf(str,"%s los",t1)==1)
  {
    if (!tied_to_ob)
    {
      write("Das Seil ist nirgendwo festgebunden.\n");
      return 1;
    }

    if (!call_other(tied_to_ob, "untie"))
    {
      write("Das klappt leider nicht.\n");
      return 1;
    }

    tied_to_ob = (object)(0);

    tell_object(player, "Du bindest das Seil los.\n");
    tell_room(env, sprintf("%s bindet das Seil los.\n",
      capitalize(player->name(WER,1))), ({player}));

    return 1;
  }

  return 0;
}


object query_tied_to_ob()
{
  return tied_to_ob;
}
