/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: std_bull_board.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/

string messages, new_hd, new_body, save_file, alias;
int num_messages;
object who;
int max_messages;
string short_desc;

move(dest){move_object(this_object(),dest);}

id(str) {
    return str == "brett" || str == "schwarzes Brett" || str == "schwarzes brett"||str==alias;
}

long() {
    write("Du kannst eine weitere Notiz anbringen mit 'note <Titel>'.\n");
    write("Oder eine Notiz lesen mit 'lies <Nummer>'. Oder mit\n");
    write("'loesche <nummer>' eine entfernen.\n");
    if (num_messages == 0) {
	write("Keine Nachrichten.\n");
	return;
    }
    write("Das bulletin board enthaelt " + num_messages);
    if (num_messages == 1)
	write(" Nachricht:\n\n");
    else
	write(" Nachrichten:\n\n");
    say(call_other(this_player(), "query_name") +
	  " studiert das schwarze Brett.\n");
    headers();
}

short() {
    return (short_desc);
}

get() {
    write("Es ist am Boden befestigt.\n");
    return 0;
}

init() {
    add_action("new"); add_verb("note");
    add_action("read"); add_verb("lies");
    add_action("remove"); add_verb("loesche");
}

reset(arg) {
    if (arg)
	return;
    short_desc="Das schwarze Brett";
    alias="brett";
    if (!save_file||save_file=="") save_file="bulletin";
    restore_object(save_file);
}

headers() {
    string hd, body, rest;
    int i, tmp;

    i = 1;
    rest = messages;
    while(rest != 0 && rest != "") {
	tmp = sscanf(rest, "%s:\n**\n%s\n**\n%s", hd, body, rest);
	if (tmp != 2 && tmp != 3) {
	    write("Corrupt.\n");
	    return;
	}
	write(i + ":\t" + hd + "\n");
	i += 1;
    }
}

new(hd) {
    if (!hd)
	return 0;
    if (who && environment(who) == environment(this_object())) {
	write("Warte auf "+call_other(who, "query_name") + " !\n");
	return 1;
    }
    if (num_messages == 40) {
	write("Das Brett ist randvoll. Nimm erstmal ne Notiz ab.\n");
	return 1;
    }
    if (strlen(hd) > 50) {
	write("Too long header to fit the paper.\n");
	return 1;
    }
    new_hd = hd;
    input_to("get_body");
    write("Bitte Notiz eingeben und '**' beenden.\n");
    write("]");
    new_body = "";
    return 1;
}

get_body(str) {
    if (str == "**") {
	new_hd = new_hd + "(" + call_other(this_player(), "query_name") +
	    ", " + extract(ctime(time()), 4, 9) + ")";
	messages = messages + new_hd + ":\n**\n" + new_body + "\n**\n";
	num_messages += 1;
	new_body = 0;
	new_hd = 0;
	save_object(save_file);
	write("Ok.\n");
	who = 0;
	return;
    }
    new_body = new_body + str + "\n";
    write("]");
    input_to("get_body");
}

read(str) {
    string hd, body, rest;
    int i, tmp;

    if (str == 0 || (sscanf(str, "%d", i) != 1 &&
		     sscanf(str, "note %d", i) != 1))
	return 0;
    if (i < 1 || i > num_messages) {
	write("So viele Notizen sind nicht auf dem Brett.\n");
	return 1;
    }
    rest = messages;
    while(rest != 0 && rest != "") {
	i -= 1;
	tmp = sscanf(rest, "%s:\n**\n%s\n**\n%s", hd, body, rest);
	if (tmp != 2 && tmp != 3) {
	    write("Corrupt.\n");
	    return;
	}
	if (i == 0) {
	    say(call_other(this_player(), "query_name") +
		  " reads a note titled '" + hd + "'.\n");
	    write("The note is titled '" + hd + "':\n\n");
	    write(body);
	    return 1;
	}
    }
    write("Hm. This should not happen.\n");
}

remove(str) {
    string hd, body, rest;
    int i, tmp;

    if (str == 0 || (sscanf(str, "%d", i) != 1 &&
		     sscanf(str, "note %d", i) != 1))
	return 0;
    if (i < 1 || i > num_messages) {
	write("Not that number of messages.\n");
	return 1;
    }
    rest = messages;
    messages = "";
    while(rest != 0 && rest != "") {
	i -= 1;
	tmp = sscanf(rest, "%s:\n**\n%s\n**\n%s", hd, body, rest);
	if (tmp != 2 && tmp != 3) {
	    write("Corrupt.\n");
	    return;
	}
	if (i == 0) {
	    say(call_other(this_player(), "query_name") +
		  " removed a note titled '" + hd + "'.\n");
	    write("Ok.\n");
	    messages = messages + rest;
	    num_messages -= 1;
	    save_object(save_file);
	    return 1;
	}
	messages = messages + hd + ":\n**\n" + body + "\n**\n";
    }
    write("Hm. This should not happen.\n");
}

