/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: baukasten.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// - LPC -
//
// Baukasten V1.1
//
// 17.11.1997 - Holger@Wunderland
//
// History:
// 
// V1.1 Holger: - Jeder Buchstabe nun mit eigenem Name [BK_RAUM_NAMEN]
//              - Raumnamen fortlaufend nummeriert ( _nn.c statt xx_yy.c )
//              - mehr eingedeutscht ;)
// V1.0 Holger: - First release

#include <properties.h>
#include <defines.h>

inherit "std/thing";

//Bauauftrag [sektion:({inhalt})]
mapping auftrag;

// Raumdefinitionen [buchstabe:({inherits}),string name, int zaehler]
mapping raum_defs;

// die Raeume [raumname:({x,y}),({ ({aus, pfad}), ({aus, pfad}), ... })]
mapping raeume;

// Der Bauplan in korrigierter Form (mit Zahlen)
string *plan;

int lies_bauauftrag(string auftragfile);
int lies_bauplan();
int lies_raum_defs();
int teste_karte();
string feld(int x, int y);
string is_raum(int x, int y);
int finde_raeume();
int suche_ausgaenge();
int schreib_raeume();
string *test_ausgang(int x, int y, string aus);

#define LOG "baukasten.log"

void create() {
    if(!clonep()) return;

    ::create();

    SetProp(P_LONG, "Das ist ein kleiner praktischer Baukasten. Mit ihm "
        "kannst Du einfache Raumstrukturen erstellen. Mit 'bkhilfe' "
        "erhaeltst Du eine Hilfeseite.\n"
        "Syntax: baue <bauauftragfile>");
    SetProp(P_NAME, "Baukasten");
    SetProp(P_PLURAL, "Baukaesten");
    SetProp(P_GENDER, MALE);
    SetProp(P_NODROP, "Den Baukasten wirst Du doch nicht weggeben?!?\n");
    SetProp(P_NEVERDROP, 1);
    AddId(({"baukasten","kasten"}), ({"baukaesten", "kaesten"}));

    AddCmd(({"baue","bau"}), "baue");
    AddCmd(({"bkhilfe","bkh"}),"hilfe");
}

baue(string str) {
    int i, k;
    string zeile, *keys, *stuff;

    notify_fail("Ohne Bauplan kann ich garnix machen!\n"
        "Syntax: baue <bauauftragfile>\n");
    if (!str) return 0;

      write("Starte Bau...\n");
    if (!lies_bauauftrag(str)) return 1;
      write("  Bauauftrag erfolgreich eingelesen.\n");
    if (!lies_bauplan()) return 1;
      write(break_string("  Bauplan '"+auftrag["[BK_KARTE]"][0]+
          "' erfolgreich eingelesen.",78));
    if (!lies_raum_defs()) return 1;
      write("  "+(string)sizeof(m_indices(raum_defs))+" Standardraeume.\n");
    if (!teste_karte()) return 1;
      write("  Der Bauplan '"+auftrag["[BK_KARTE]"][0]+"' scheint ok zu "
         "sein.\n");
    if (!finde_raeume()) return 1;
      write("  "+(string)sizeof(m_indices(raeume))+" Raeume gefunden.\n");
    if (!suche_ausgaenge()) return 1;
      write("  Die Ausgaenge wurden ermittelt.\n");
    if (!schreib_raeume()) return 1;
      log_file(LOG,dtime(time())+" : "+capitalize(PL->query_real_name())+
          " : Karte '"+auftrag["[BK_KARTE]"][0]+"' nach '"+
          auftrag["[BK_ZIEL_DIR]"][0]+"'\n");      
      write("  Alle Raeume wurden auftragsgemaess gebaut!\n");
      write("Auftrag ausgefuehrt! Einen schoenen Tag noch!\n");
    return 1;
}

hilfe(string was) {
    if (!was) {
        write("\nHolgers Baukasten. Moegliche Hilfethemen (SYNTAX: "
            "bkh(ilfe) <thema>):\n"
            "  auftrag, (bau-)plan, info, karte, konzept und "
            "sektion(en)\n\n");
            return 1;
    }
    switch(was) {
        case "auftrag":
            write("\nDer Bauauftrag:\n");
            write(break_string("Der Bauauftrag ist ein Textfile in dem "
                "das geplante Gebiet beschrieben ist. Der Bauplan ist "
                "unterteilt in verschiedene Sektionen (siehe dort). Fehlt "
                "eine der Sektionen, bricht der Baukasten die Bearbeitung "
                "ab. Beim Starten des Baus wird der Bauauftrag als "
                "einziger Parameter angegeben.\nBsp: baue "
                "/da/dort/bauauftrag.txt\n\n",77,2,1));
            break;
        case "bauplan":case "plan":case "karte":
            PL->More("Der Bauplan (Karte):\n"+
                break_string("Der Bauplan, bzw die Karte sollte nur aus "
                "Buchstaben und bestimmten Richtungszeichen bestehen. "
                "Zahlen werden grundsaetzlich moniert, da diese bei der "
                "internen Verarbeitung verwendet werden! Ebenso darf kein "
                "'X' verwendet wird, da dies eine Kreuzverbindung in der "
                "Karte darstellt (siehe Beispiel).\n\n"
                "Die Richtungszeichen:\n"
                "'-' - Osten oder Westen.\n"
                "'\\' - Nordwesten oder Suedosten.\n"
                "'|' - Norden oder Sueden\n"
                "'/' - Nordosten oder Suedwesten.\n"
                "'X' - Kreuzverbindung mehrerer Raeume (Beispiel).\n\n"
                "Eine Beispielkarte:\n"
                "                               |       \n"
                "                        -A-B-B-D-B-E-E \n"
                "                          \\    |   |X| \n"
                "                           C   D   E-E-\n"
                "                               |       \n\n"
                "Die Karte sollte sich eigentlich von selbst verstehen. Die "
                "4 'E' - Raeume sind kreuzverbunden, dass heisst man kann "
                "von jedem Raum in den anderen gelangen. Die 'toten' "
                "Endstuecken werden auch als Ausgaenge gesetzt, zeigen "
                "jedoch nach '/foo/nirvana'. Der entsprechende Bug soll "
                "spaeter daran erinner, dass es hier noch nicht weitergeht. "
                "Jeder Buchstabe muss natuerlich eine eigene Zeile in "
                "Sektion '[BK_INHERITS]' haben, um erfolgreich "
                "bearbeitet zu werden.\nNatuerlich kann man mit den oben "
                "angegebenen Zeichen nicht jede beliebige "
                "Wegekonstellation erzeugen, aber ein klein wenig "
                "Nacharbeit, kann bei soviel Komfort auch nichts schaden, "
                "oder? ;))\\n",77,2,1));
            break;
        case "info":
            write("\n  Raum-Baukasten von Holger@Wunderland ;)\n\n");
            break;
        case "konzept":
            write("Das Konzept:\n"+break_string("Die Idee ist, ein Tool "
                "zu haben, dass einem das laestige Raumgeruestgeschreibe "
                "abnimmt, das man bei groesseren Gebieten immer hat. "
                "Man fertigt einfach bestimmte wiederkehrende "
                "Standardraeume an. Dann zeichnet man eine Karte, in der "
                "man gleichen Raeumen gleiche Buchstaben zuordnet. Im "
                "Bauauftrag definiert man dann welcher Buchstabe welches "
                "oder welche Standardraeume inheriten soll. Zusaetzlich "
                "kann man definieren, welchen Kopf jedes File haben soll. "
                "Z.Bsp. fuer include-Anweisungen oder Kommentare. Wenn "
                "man diese Dokumentation korrekt umsetzt ist es moeglich, "
                "ein fertiges einfaches Raumgeruest zu bauen, das sofort "
                "begehbar ist. Natuerlich sollte das nicht dazu animieren, "
                "die Raeume so zu lassen und nicht individuell zu "
                "gestalten mit Details und anderem. Denn NICHTS ist fuer "
                "Spieler aetzender, als 100 absolut identische "
                "Raeume!!!\n\nViel Spass! Holger@Wunderland        "
                "(16.11.1997)\n\n",78,2,1));
            break;
        case "sektionen":case "sektion":
            PL->More("Die Sektionen:\n"+
                break_string("Es gibt im Bauauftrag derzeit 5 "
                "verschiedene Sektionen. Alle 5 muessen "
                "im Bauauftrag enthalten sein, sonst wird der Auftrag "
                "nicht ausgefuehrt. Nachfolgend wird jede Sektion einzeln "
                "beschrieben:\n\n"
                "[BK_KARTE]\n"
                "Diese Sektion enthaelt den Pfad des Bauplans nach dem "
                "gebaut werden soll (siehe Thema 'bauplan' und 'karte').\n"
                "Beispielsektion:\n"
                "    [BK_KARTE]\n"
                "    /d/wunderland/kogida/karte.txt\n\n"
                "[BK_ZIEL_DIR]\n"
                "Diese Sektion enthaelt den Pfad des Verzeichnisses, in "
                "das die fertigen Raeume geschrieben werden sollen.\n"
                "Beispielsektion:\n"
                "    [BK_ZIEL_DIR]\n"
                "    /d/wunderland/kogida/room/\n\n"
                "[BK_RAUM_NAMEN]\n"
                "Hier werden die Namen der Raeume festgelegt. Die Namen "
                "der Raeume werden mit einer fortlaufenden Nummer versehen "
                "und '.c' wird angehaengt. Fuer jeden Buchstaben der Karte "
                "MUSS ein Name angegeben werden. Ueberfluessige Zuweisungen "
                "werden ignoriert. Aus 'wald' wird dann wald_xx.c, wobei "
                "xx eine fortlaufende Nummer ist. Wird die Nummer laenger "
                "als 2 Stellen, wird der Name natuerlich entsprechend "
                "laenger  Der Pfad des Raumes muss NICHT angegeben werden, "
                "da dieser aus Sektion '[BK_ZIEL_DIR]' geholt wird.\n"
                "Beispielsektion:\n"
                "    [BK_RAUM_NAMEN]\n"
                "    R wald\n"
                "    W weg\n\n"
                "[BK_INHERITS]\n"
                "Das ist fuer das sinnvolle verwenden des Baukastens die "
                "wichtigste Sektion! Sie kann aus beliebig vielen Zeilen "
                "bestehen und hat folgenden Aufbau:\n"
                "<Buchstabe> <inheritfile1> [<inheritfile2>] ...\n"
                "Der Buchstabe repraesentiert einen Buchstaben aus dem "
                "Bauplan, der einen Raum darstellt. Die Inheritfiles, die "
                "angegeben werden, werden am Anfang des Raumes als: "
                "'inherit <inheritfile>\;' eingebaut. Es ist dabei darauf "
                "zu achten, dass Anfuehrungszeichen nicht ergaenzt werden, "
                "damit auch relatives Inheriten (z.b. STD(\"bla\")) "
                "moeglich ist.\n"
                "Beispielsektion:\n"
                "    [BK_INHERITS]\n"
                "    B \"std/room\" STD(\"baeume\") STD(\"haeuser\")\n\n"
                "B ist also der jeweilige Raum in der Karte und "
                "\"std/room\", STD(\"baeume\") und STD(\"haeuser\") "
                "werden darin inheritet. als:\n"
                "inherit \"std/room\"\;\n"
                "inherit STD(\"baeume\")\;\n"
                "inherit STD(\"haeuser\")\;\n"
                "Scheint komplizierter, als es ist! Am Ende folgt ein "
                "kompletter Beispielauftrag, in dem man sich das Ergebnis "
                "ansehen kann.\n\n"
                "[BK_FILE_HEAD]\n"
                "Diese Sektion enthaelt Textzeilen, die am Anfang des "
                "Raumes zusaetzlich eingefuegt werden sollen. Hier kann "
                "man z.B: einen Kommentar angeben oder Include-Anweisungen, "
                "die man moeglicherweise fuer das relative Inheriten von "
                "Standardraeumen braucht. Die Zeilen werden absolut "
                "unveraendert in den Raum eingebaut, muessen also LPC "
                "Konventionen entsprechen.\n"
                "Beispielsektion:\n"
                "    [BK_FILE_HEAD]\n"
                "    // 14.11.1997 Holger\n"
                "    #include <properties.h>\n"
                "    #include \"../files.h\"\n"
                "Diese 3 Zeilen werden an den Anfang eines jeden Raumes "
                "eingefuegt!.\n\nEin Beispiel-Bauauftrag:\n\n"
                "    [BK_KARTE]\n"
                "    /d/wunderland/bsw/tigerwald/bauplan.orig\n"
                "    [BK_ZIEL_DIR]\n"
                "    /d/wunderland/bsw/tigerwald/room/\n"
                "    [BK_RAUM_NAMEN]\n"
                "    R wald\n"
                "    W weg\n"
                "    [BK_INHERITS]\n"
                "    W STD+\"weg\"\n"
                "    R STD+\"wald\"\n"
                "    [BK_FILE_HEAD]\n"
                "    // 14.11.1997 Holger\n"
                "    #include <properties.h>\n"
                "    #include \"../files.h\"\n\n"
                "Dieser Bauauftrag liest den Bauplan "
                "'/d/wunderland/bsw/tigerwald/bauplan.orig' und wertet die "
                "Ausgaenge aus. In jeden Raum, der in der Karte als 'W' "
                "dargestellt ist, inheritet dann STD+\"weg\" und jeder Raum "
                "mit R inheritet STD+\"wald\". Alle Raeume enthalten die 3 "
                "Zeilen aus '[BK_FILE_HEAD]'. Die Raeume werden nach "
                "'/d/wunderland/bsw/tigerwald/room/' unter dem Namen "
                "wald[xx_yy].c geschrieben.\n",78,2,1));
            break;
        default:
            write("Dieses Hilfethema gibt es nicht!\n");
    }
    return 1;
}

int lies_bauauftrag(string auftragfile) {
    int line, i, k;
    string zeile, key;
    string *alles, *dummy;

    if (file_size(auftragfile)<1) {
      write("Der Bauauftrag existiert nicht, ist leer oder ein "
          "Verzeichnis!\n");
      return 0;
    }

    line=1;alles=({});
    for (;;) {
        if (!(zeile=read_file(auftragfile,line++,1))) break;
        alles+=({zeile[0..<2]});
    }

    key="";auftrag=([]);
    for (i=0;i<sizeof(alles);i++) {
        dummy=explode(alles[i]," ");
        if(!sizeof(dummy)) continue;
        switch(dummy[0]) {
            case "[BK_KARTE]": key="[BK_KARTE]"; break;
            case "[BK_ZIEL_DIR]": key="[BK_ZIEL_DIR]"; break;
            case "[BK_RAUM_NAMEN]": key="[BK_RAUM_NAMEN]"; break;
            case "[BK_INHERITS]": key="[BK_INHERITS]"; break;
            case "[BK_FILE_HEAD]": key="[BK_FILE_HEAD]"; break;
            default : 
                if(key) {
                    if (!member(auftrag,key)) auftrag[key]=({});
                    auftrag[key]+=({alles[i]});
                }
        }
    }
    if (!sizeof(auftrag["[BK_KARTE]"])) {
        write("Sektion [BK_KARTE] fehlt oder ist leer. Abbruch!\n");
        return 0;
    }
    if (!sizeof(auftrag["[BK_ZIEL_DIR]"])) {
        write("Sektion [BK_ZIEL_DIR] fehlt oder ist leer. Abbruch!\n");
        return 0;
    }
    if (!sizeof(auftrag["[BK_RAUM_NAMEN]"])) {
        write("Sektion [BK_RAUM_NAMEN] fehlt oder ist leer. Abbruch!\n");
        return 0;
    }
    if (!sizeof(auftrag["[BK_INHERITS]"])) {
        write("Sektion [BK_INHERITS] fehlt oder ist leer. Abbruch!\n");
        return 0;
    }
    if (!sizeof(auftrag["[BK_FILE_HEAD]"])) {
        write("Sektion [BK_FILE_HEAD] fehlt oder ist leer. Abbruch!\n");
        return 0;
    }
    return 1;
}

int lies_bauplan() {
    int pos, i, k;
    string block, planfile, byte;

    if (!(planfile=auftrag["[BK_KARTE]"][0])) {
        write("Es wurde im Bauauftrag kein Bauplan angegeben!\n");
        return 0;
    }
    if (file_size(planfile)<1) {
      write(break_string("Der angegebene Bauplan '"+planfile+"' existiert "
          "nicht, ist leer oder ein Verzeichnis!",78));
      return 0;
    }

    pos=0;block="";
    for (;;) {
        // byteweise, statt zeilenweise, da '\' und '|' verschluckt wurden
        if (!(byte=read_bytes(planfile,pos++,1))) break;
        // Keine Ziffern, da diese als Richtungszeichen verwendet werden!
        if (member_array(byte,({"1","2","3","4","5","6","7","8","9",
            "0"}))>-1) {
            write("Es duerfen keine Ziffern im Bauplan enthalten sein!\n"
                "Abbruch.\n");
            return 0;
        }
        if (byte=="\-") byte="1";      // '\' und '|' machten Aerger, deshalb
        if (byte=="\\") byte="2";      // werden hier gleich alle Richtungs-
        if (byte=="\|") byte="3";      // zeichen in Zahlen geaendert, 
        if (byte=="\/") byte="4";      // erscheint mir generell besser auch
        if (byte=="\X") byte="5";      // bei spaeterer Auswertung.
        block+=byte;
    }

    plan=explode(block,"\n");          // In Zeilen zerlegen!

    if (!sizeof(plan)) {
        write("Der Bauplan ist leer!\n");
        return 0;
    }

    return 1;
}

int lies_raum_defs() {
    string *raum;
    int k;

    raum_defs=([]);
    // Inherits einlesen
    for (k=0;k<sizeof(auftrag["[BK_INHERITS]"]);k++) {
        raum=explode(auftrag["[BK_INHERITS]"][k]," ");
            if (sizeof(raum)<2) {
                write("  Warnung! Nicht korrekte Zeile in "
                    "Sektion '[BK_INHERITS]' !\n");
                continue;
            }
            if (!member(raum_defs,raum[0])) raum_defs[raum[0]]=({({}),"",1});
            raum_defs[raum[0]][0]+=raum[1..];
    }
    // Filenamen einlesen
    for (k=0;k<sizeof(auftrag["[BK_RAUM_NAMEN]"]);k++) {
        raum=explode(auftrag["[BK_RAUM_NAMEN]"][k]," ");
            if (sizeof(raum)!=2) {
                write("  Warnung! Nicht korrekte Zeile in "
                    "Sektion '[BK_RAUM_NAMEN]' !\n");
                continue;
            }
            if (!member(raum_defs,raum[0])) {
                write("  Warnung! Ueberfluessige Zeile in Sektion "
                    "'[BK_RAUM_NAMEN]' !\n");
                continue;
            };
            raum_defs[raum[0]][1]+=raum[1];
    }
    raum=m_indices(raum_defs);
    if (!sizeof(raum)) {
        write("Im Bauauftrag wurden keine Raeume definiert!\n");
        return 0;
    }
    
    for (k=sizeof(raum);k--;) {
        if (!strlen(raum_defs[raum[k]][1])) {
            write("Im Bauauftrag ist fuer einen Raum kein Name definiert!\n");
            write("Fehler in Sektion '[BK_RAUM_NAMEN]' ! Abbruch!\n");
            return 0;
        }
    }
    return 1;
}

int teste_karte() {
    int x, x1, x2, y, y1, y2, i, k;
    string *dummy, *keys;

    x1=0;x2=0;y1=0;y2=0;
    dummy=({})+plan;
    keys=m_indices(raum_defs);

    // sind alle Raeume in der Karte auch definiert?
    for (i=0;i<sizeof(dummy);i++) {
        dummy[i]=regreplace(dummy[i]," ","",1);
        dummy[i]=regreplace(dummy[i],"1","",1);
        dummy[i]=regreplace(dummy[i],"2","",1);
        dummy[i]=regreplace(dummy[i],"3","",1);
        dummy[i]=regreplace(dummy[i],"4","",1);
        dummy[i]=regreplace(dummy[i],"5","",1);
        for (k=0;k<sizeof(keys);k++) {
            dummy[i]=regreplace(dummy[i],keys[k],"",1);
        }
        if (strlen(dummy[i])>0) {
            write("Die Karte enthaelt nichtdefinierte Raeume.\n");
            write((string)i+" - "+dummy[i]+".\n");
            return 0;
        }
    }
    return 1;
}

string feld(int x, int y) {
    int i, k;
    string zeile;

    if (y>sizeof(plan)-1 || y<0 || x<0) return "";
    zeile=plan[y];
    if (x>(strlen(zeile)-1)) return "";
    return to_string(zeile[x..x]);
}

string is_raum(int x, int y) {
    int i, k;
    string *index;
    
    index=m_indices(raeume);
    for (i=sizeof(index);i--;) {
        if (raeume[index[i]][1][0]==x && raeume[index[i]][1][1]==y) {
            return index[i];
        }
    }
    return (string)0;
}

int finde_raeume() {
    int i, k;
    string raumname, zeichen;
    raeume=([]);
    for (i=0;i<sizeof(plan);i++) {
        for (k=0;k<strlen(plan[i]);k++) {
            zeichen=feld(k,i);
            if (member_array(zeichen,m_indices(raum_defs))>-1) {
                raumname=raum_defs[zeichen][1];
                raumname+=sprintf("_%02d",raum_defs[zeichen][2])+".c";
                raeume[raumname]=({feld(k,i),({k,i}),({})});
                raum_defs[zeichen][2]+=1;
            }
        }
    }
    return 1;
}

int suche_ausgaenge() {
    string *raum, *aus;
    int i, x, y;

    raum=m_indices(raeume);
    for (i=0;i<sizeof(raum);i++) {
        x=raeume[raum[i]][1][0];
        y=raeume[raum[i]][1][1];
        aus=test_ausgang(x,y,"n");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"o");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"s");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"w");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"nw");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"no");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"sw");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
        aus=test_ausgang(x,y,"so");
        if (sizeof(aus)) raeume[raum[i]][2]+=({aus});
    }
    return 1;
}

int schreib_raeume() {
    string *raum, *aus, raumfile, filename;
    int i, k;

    raum=m_indices(raeume);
    for (i=0;i<sizeof(raum);i++) {
        filename=auftrag["[BK_ZIEL_DIR]"][0]+raum[i];
        raumfile="/* Raum erstellt durch: Baukasten V1.0 (C) "
            "Holger@Wunderland */\n\n";
        raumfile+=implode(auftrag["[BK_FILE_HEAD]"],"\n");
        raumfile+="\n";
        for (k=0;k<sizeof(raum_defs[raeume[raum[i]][0]][0]);k++) {
            raumfile+="inherit "+raum_defs[raeume[raum[i]][0]][0][k]+"\;\n";
        }

        raumfile+="\n\ncreate() {\n";
        raumfile+="\n    ::create();\n\n";
        aus=raeume[raum[i]][2];
        for (k=sizeof(aus);k--;) {
            raumfile+="    AddExit(\""+aus[k][0]+"\", \""+aus[k][1]+"\");\n";
        }
        raumfile+="\n}\n";
        if (file_size(filename)>-1 || file_size(filename)==-2) {
            write("'"+filename+"' existiert schon, oder ist ein "
                "Verzeichnis.\nAbbruch!\n");
            return 0;
        }
        if (!write_file(filename,raumfile)) {
            write("Fehler beim Schreiben von '"+filename+"'.\n");
            write("Moeglicherweise fehlen Zugriffsrechte. Abbruch!\n");
            return 0;
        }
    }
    return 1;
}

string *test_ausgang(int x, int y, string aus) {
    string *res, raumname, rnam;

    switch(aus) {
        case "n":
            if (feld(x,y-1)=="3") {
                res=({"norden"});
                rnam=is_raum(x,y-2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "o":
            if (feld(x+1,y)=="1") {
                res=({"osten"});
                rnam=is_raum(x+2,y);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "w":
            if (feld(x-1,y)=="1") {
                res=({"westen"});
                rnam=is_raum(x-2,y);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "s":
            if (feld(x,y+1)=="3") {
                res=({"sueden"});
                rnam=is_raum(x,y+2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "no":
            if (feld(x+1,y-1)=="4" || feld(x+1,y-1)=="5") {
                res=({"nordosten"});
                rnam=is_raum(x+2,y-2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "nw":
            if (feld(x-1,y-1)=="2" || feld(x-1,y-1)=="5") {
                res=({"nordwesten"});
                rnam=is_raum(x-2,y-2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "sw":
            if (feld(x-1,y+1)=="4" || feld(x-1,y+1)=="5") {
                res=({"suedwesten"});
                rnam=is_raum(x-2,y+2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        case "so":
            if (feld(x+1,y+1)=="2" || feld(x+1,y+1)=="5") {
                res=({"suedosten"});
                rnam=is_raum(x+2,y+2);
                if (rnam) raumname="./"+rnam;
                else raumname="/foo/nirvana";
                res+=({raumname});
            }
            break;
        default: res=({});
    }
    return res;
}
