/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: eptool.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// MD Mudlib
//
// OBJ/TOOLS/EPTOOL.C --- explore-system-tool
//
// Author: Bongo@Wunderland
//
//
// $Date: 1999/11/05 12:30:44 $
// $Revision: 1.1.1.1 $
// $Log: eptool.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/11 16:44:01  Largo
// Initial revision
//

inherit "std/thing";
inherit "std/shells/filesys/asynchron";

#include <properties.h>
#include <wizlevels.h>
#include <guilds.h>
#include <defines.h>
#include <config.h>
#include <player/explore.h>

#define MAX_LINE 5000

#define SETBIT(x, y)         set_bit(x, ((y)+6))
#define CLEARBIT(x, y)       clear_bit(x, ((y)+6))
#define TESTBIT(x, y)        test_bit(x, ((y)+6))


void create() {
  if (!clonep()) return;
  ::create();

  SetProp(P_LONG, "Das EP-Tool.\nTippe <ephilfe>, um zu sehen, was dieses Tool kann. "
    "Tippe <eprules> um die EP-Regeln zu lesen. Mit der Benutzung dieses Tools "
    "erkennst Du diese Regeln an! 8-)");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_NAME, PL->name(WESSEN)+" EP-Tool");
  SetProp(P_PLURAL, "");
  SetProp(P_ARTICLE, ART_NONE);
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  SetProp(P_NOBUY, 1);
  SetProp(P_NOSELL, "Das Ding ist viel zu wertvoll, um es zu verkaufen.\n");
  SetProp(P_NODROP, "Das Ding ist viel zu wertvoll, um es wegzuwerfen.\n");
  SetProp(P_NEVERDROP, 1);
  SetProp(P_AUTOLOADOBJ, 1);

  SetProp("ep_npcs", 0);
  SetProp("ep_others", 0);
  AddId(({"tool","eptool","ep-tool"}));

  AddCmd("ephilfe","_ephilfe_");
  AddCmd("eprules","_eprules_");

  AddCmd("SetEP","_setep_");
  AddCmd("TakeEP","_takeep_");
  AddCmd("ClearEP","_clearep_");
  AddCmd("SetFullEP","_setfullep_");
  AddCmd("GotEP","_gotep_");
  AddCmd("GotDistrictEP","_got_district_ep_");
  AddCmd("QueryEP","_queryep_");
  AddCmd("CompensatePlayer","_compensateplayer_");
  AddCmd("AddEP","_addep_");
  AddCmd("ActivateEP","_activateep_");
  AddCmd("DeactivateEP","_deactivateep_");
  AddCmd("ChangeEPPath","_changeeppath_");
  AddCmd("ChangeEPPoints","_changeeppoints_");
  AddCmd("DomainEPList","_domaineplist_");
  AddCmd("IsEPObject","_isepobject_");
  AddCmd("EP-Stat","_ep_stat_");
  AddCmd("CheckBalance","_check_balance_");
  AddCmd("CheckNPC","_check_npc_");

  seteuid(geteuid(this_player()));
}

int remove(int silent) {
  while(remove_call_out(#'asynchron)!=-1);
  while(remove_call_out("wait_for_balance_check")!=-1);
  return ::remove(silent);
}

private int secure(int who) {
  int ret;
  if(!this_interactive()) 
    return 0;
  if(this_interactive() != this_player()) 
    return 0;
  if(!IS_LEARNER(this_interactive())) {
    write("Dieses Tool ist nur fuer Magier bestimmt.\n");
    this_object()->remove();
    return 0;
  }
  if(who && query_wiz_level(this_interactive())<who) {
    write("Diese Funktion ist Magiern ab Level "+(string)who+" vorbehalten!\n");
    return 0;
  }
  return 1;
}

static int _setep_(string str) {
  int number;
  string player, file;
  object player_obj;
  mixed *ep_object;
  if(!secure(ARCH_LVL))
    return 1;
  notify_fail("Falsches Argument.\n");
  if(!str || !stringp(str)) return 0;
  if(sscanf(str,"%s %d",player,number)==2) {
    if(!(ep_object=EM->QueryEPNumber( number )) || !sizeof(ep_object)) {
      write("Diese Nummer gehoert zu keinem Objekt.\n");
      return 1;
    }
  }
  else if(sscanf(str,"%s %s",player,file)==2) {
    if(!(ep_object=EM->QueryEPObject( file )) || !sizeof(ep_object)) {
      write("Dieses Objekt ist nicht angemeldet.\n");
      return 1;
    }
    number=ep_object[sizeof(ep_object)-1];
  }
  else {
    write("Falsche Argumente.\n");
    return 1;
  }
  if (!(player_obj=find_player( lower_case(player) ))) {
    write("Der Spieler ist gerade nicht im Wunderland.\n");
    return 1;
  }
  if (!player_obj->SetEP( number )) {
    write("Forschungspunkte des Spielers haben sich nicht veraendert.\n");
    return 1;
  }
  write("OK.\n");
  return 1;
}


static int _takeep_(string str) {
  int number;
  string player, file;
  object player_obj;
  mixed *ep_object;
  if(!secure(ARCH_LVL))
    return 1;
  notify_fail("Falsches Argument.\n");
  if(!str || !stringp(str)) return 0;
  if(sscanf(str,"%s %d",player,number)==2) {
    if (!(ep_object=EM->QueryEPNumber( number )) || !sizeof(ep_object)) {
      write("Diese Nummer gehoert zu keinem Objekt.\n");
      return 1;
    }
  }
  else if (sscanf(str,"%s %s",player,file)==2) {
    if (!(ep_object=EM->QueryEPObject( file )) || !sizeof(ep_object)) {
      write("Dieses Objekt ist nicht angemeldet.\n");
      return 1;
    }
    number=ep_object[sizeof(ep_object)-1];
  }
  else {
    write("Falsche Argumente.\n");
    return 1;
  }
  if (!(player_obj=find_player( lower_case(player) ))) {
    write("Der Spieler ist gerade nicht im Wunderland.\n");
    return 1;
  }
  if (!player_obj->TakeEP( number )) {
    write("Forschungspunkte des Spielers haben sich nicht veraendert.\n");
    return 1;
  }
  write("OK.\n");
  return 1;
}

static int _clearep_(string str) {
  int i;
  string explored;
  object player_obj;
  if(!secure(ARCH_LVL)) 
    return 1;
  notify_fail("Falsches Argument.\n");
  if (!str || !stringp(str)) return 0;
  if (!(player_obj=find_player( lower_case(str) ))) {
    write("Der Spieler ist gerade nicht im Wunderland.\n");
    return 1;
  }
  player_obj->CheckEP();
  explored=player_obj->QueryProp(P_EXPLORED);
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  for (i=(strlen(explored)-1)*6; i--;) {
    if (TESTBIT(explored, i)) player_obj->TakeEP(i);
  }
  write("OK.\n");
  return 1;
}


static int _setfullep_(string str) {
  int i;
  string explored;
  object player_obj;
  if(!secure(ARCH_LVL)) 
    return 1;
  notify_fail("Falsches Argument.\n");
  if (!str || !stringp(str)) return 0;
  if (!(player_obj=find_player( lower_case(str) ))) {
    write("Der Spieler ist gerade nicht im Wunderland.\n");
    return 1;
  }
  player_obj->CheckEP();
  explored=player_obj->QueryProp(P_EXPLORED);
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  for (i=EXPLOREMASTER->QueryQuantity(); i>=0; i--) {
      player_obj->SetEP(i);
  }
  write("OK.\n");
  return 1;
}

static int _gotep_(string str) {
  int number;
  string player, file, explored;
  object player_obj;
  mixed  *values;
  if(!secure(LORD_LVL)) return 1;
  notify_fail("Falsche Argumente.\n");
  if (!str || !stringp(str)) return 0;
  if (sscanf(str,"%s %d",player,number)==2) {
    if (!(player_obj=find_player( lower_case(player) ))) {
      write("Der Spieler ist gerade nicht im Wunderland.\n");
      return 1;
    }
    if (!(values=EM->QueryEPNumber( number ))) {
      printf("Es ist kein Objekt mit der Nummer %d angemeldet.\n",number);
      return 1;
    }
  }
  else if (sscanf(str,"%s %s",player,file)==2) {
    if (!(player_obj=find_player( lower_case(player) ))) {
      write("Der Spieler ist gerade nicht im Wunderland.\n");
      return 1;
    }
    if (!(values=EM->QueryEPObject( file ))) {
      printf("Es ist kein Objekt %s angemeldet.\n",file);
      return 1;
    }
    number=values[3];
  }
  else return 0;
  player_obj->CheckEP();
  if (!(explored=player_obj->QueryProp(P_EXPLORED))) {
    write("Es sind zur Zeit keine Objekte beim Master angemeldet.\n");
    return 1;
  }
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  printf("%s hat %s %d EP des Objekts\n     %s    \n%s bekommen.\n",
    player_obj->name(),(values[1]==1?"den":"die"),values[1],
    values[0],(TESTBIT(explored, number)?"schon":"noch nicht"));
  return 1;
}

static int _got_district_ep_(string str) {
  int i, j;
  string who, text, explored, district;
  object player;
  mixed values;
  if(!secure(LORD_LVL)) return 1;
  notify_fail("Falsche Argumente.\n");
  if (!str || !stringp(str)) return 0;
  if (sscanf(str,"%s %s",who,district)!=2) return 0;
  if (!(player=find_player(who))) {
    write("Der Spieler ist nicht im Wunderland.\n");
    return 1;
  }
  explored=player->QueryProp(P_EXPLORED);
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  text="";
  for(i=0;i<(strlen(explored)-1)*6;i++)
    if (TESTBIT(explored, i)) {
      values=EM->QueryEPNumber( i );
      if (strstr(values[0],district)==0)
        text+=sprintf("%3d.  %-58s %2d   %2d\n",values[3],values[0],values[1],
          values[2]);
    }
  if(text!="")
    this_interactive()->More(
      "\nFolgende Forschungspunkte aus dem gesuchten Gebiet hat "+player->name()+
      "\nschon gefunden.\n"
      "========================================================================\n"
      "District: "+district+"\n\n"
      "Nr. Objekt                                                       EP Akt.\n"
      "------------------------------------------------------------------------\n"
      +text+
      "========================================================================\n");
  else
    write("Aus diesem Gebiet hat der Spieler noch keine Punkte.\n");
  return 1;
}    

static int _queryep_(string str) {
  int needed, level, procent, seer_ep;
  string explored;
  object player_obj;
  if(!secure(WIZARD_LVL)) return 1;
  notify_fail("Falsches Argument.\n");
  if(!str || !stringp(str)) return 0;
  if(!(player_obj=find_player( lower_case(str) ))) {
    write("Der Spieler ist gerade nicht im Wunderland.\n");
    return 1;
  }
  player_obj->CheckEP();
  explored=player_obj->QueryProp(P_EXPLORED);
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  printf("Infos ueber %s:\nP_EXPLORED:\n",player_obj->name());
  printf("%s",break_string(explored,60));
  level=player_obj->QueryProp(P_LEVEL);
  procent=player_obj->QueryProcentEP();
  printf("Level: %d\nGesamt: %d\nProzentualer Anteil (von %d): %d%s\n",
    level,player_obj->QuerySumEP(),EM->QueryMaxEP(),procent,"%");
  seer_ep = player_obj->QueryProp(P_EP_FOR_SEER);
  if (level>=MAX_LEVEL)
    needed=0;
  else
    needed=EM->QueryNeededEP(level+1)-player_obj->QueryProcentForSeerEP();
  printf("Noetige EP fuer Seherwerdung: %d\nNoetige Prozent fuer naechsten Level (von %d): %d%s\n",
    seer_ep,seer_ep,needed,"%");
  needed=(int)(seer_ep*needed/100);
  printf("Noetige EP fuer naechsten Level: %d\n",needed);
  printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  return 1;
}


static int _compensateplayer_(string str) {
  int i,j,level,needed,count,now,*not_explored;
  string explored;
  object player;
  if(!secure(ARCH_LVL)) 
    return 1;
  notify_fail("Falsche Argumente.\n");
  if (!str || !stringp(str)) return 0;
  notify_fail("Spieler ist nicht eingeschaltet.\n");
  if (!(player=find_player(lower_case(str)))) return 0;
  notify_fail("Der Spieler braucht keine EP.\n");
  if ((level=player->QueryProp(P_LEVEL))<0 || level>=MAX_LEVEL) return 0;
  if (player->QueryProcentForSeerEP()>=(needed=EM->QueryNeededEP(level+1))) return 0;
  if (player->QueryProp(P_EP_FOR_SEER)<=0) {
    "/secure/master"->renew_player_object( player->query_real_name() );
    printf("Playerobjekt wurde neu geladen. Bitte den Befehl wiederholen.\n");
    return 1;
  }
  player->CheckEP();
  explored=player->QueryProp(P_EXPLORED);
  if (explored[0]!='&') { write("Spieler hat noch altes P_EXPLORED!\n"); return 1; }
  not_explored = ({});
  for (i=EXPLOREMASTER->QueryQuantity()+1; i--;)
    if (!TESTBIT(explored, i)) not_explored+=({i});
  count = sizeof(not_explored);
  while(player->QueryProcentForSeerEP()<needed || !sizeof(not_explored)) {
    now = random(count);
    player->SetEP( not_explored[now] );
    not_explored-=({not_explored[now]});
    count--;
  }
  printf("OK.\n");
  return 1;
}


static int _addep_(string str) {
  int ret, points;
  string file;
  if(!secure(LORD_LVL)) 
    return 1;
  notify_fail("Falsche Argumente.\n");
  if(!str || !stringp(str)) 
    return 0;
  if(sscanf(str,"%s %d",file,points)!=2) 
   return 0;
  
  ret=EM->AddEP( file , points );
  switch(ret) {
    case -5:
      write("Objekt kann nicht geladen werden.\n");
      break;
    case -4:
      write("Die Punktanzahl ist nicht im erlaubten Bereich.\n");
      break;
    case -3:
      write("Das Objekt ist bereits angemeldet.\n");
      break;
    case -2:
      write("Falsche Argumente wurden uebergeben.\n");
      break;
    case -1:
      write("Fehler im Array-Handling aufgetaucht.\n");
      break;
    case 0:
      write("Keine Berechtigung zum Anmelden.\n");
      break;
    case 1:
      write("OK.\n");
      break;
    default:
      write("Irregulaerer Returnwert.\n");
      break;
  }
  return 1;
}


static int _activateep_(string str) {
  int ret;
  if (!secure(LORD_LVL)) return 1;
  notify_fail("Falsches Argument.\n");
  if (!str || !stringp(str)) return 0;
  ret=EM->ActivateEP( str );
  switch(ret) {
    case -3:
      write("Objekt ist noch nicht angemeldet.\n");
      break;
    case -2:
      write("Falsches Argument wurde uebergeben.\n");
      break;
    case -1:
      write("Fehler im Array-Handling aufgetaucht.\n");
      break;
    case 0:
      write("Keine Berechtigung zum Aktivieren.\n");
      break;
    case 1:
      write("OK.\n");
      break;
    default:
      write("Irregulaerer Returnwert.\n");
      break;
  }
  return 1;
}
    
  
static int _deactivateep_(string str) {
  int ret;
  if (!secure(LORD_LVL)) return 1;
  notify_fail("Falsches Argument.\n");
  if (!str || !stringp(str)) return 0;
  ret=EM->DeactivateEP( str );
  switch(ret) {
    case -3:
      write("Objekt ist noch nicht angemeldet.\n");
      break;
    case -2:
      write("Falsches Argument wurde uebergeben.\n");
      break;
    case -1:
      write("Fehler im Array-Handling aufgetaucht.\n");
      break;
    case 0:
      write("Keine Berechtigung zum Deaktivieren.\n");
      break;
    case 1:
      write("OK.\n");
      break;
    default:
      write("Irregulaerer Returnwert.\n");
      break;
  }
  return 1;
}


static int _changeeppath_(string str) {
  int ret;
  string old_file, new_file;
  if (!secure(LORD_LVL)) return 1;
  notify_fail("Falsche Argumente.\n");
  if (!str || !stringp(str)) return 0;
  if (sscanf(str,"%s %s",old_file,new_file)!=2) return 0;
  ret=EM->ChangeEPPath( old_file , new_file );
  switch(ret) {
    case -5:
      write("Neues Objekt kann nicht geladen werden.\n");
      break;
    case -4:
      write("Neues Objekt ist bereits angemeldet.\n");
      break;
    case -3:
      write("Objekt ist nicht angemeldet.\n");
      break;
    case -2:
      write("Falsche Argumente wurden uebergeben.\n");
      break;
    case -1:
      write("Fehler im Array-Handling.\n");
      break;
    case 0:
      write("Keine Berechtigung zum Umbenennen.\n");
      break;
    case 1:
      write("OK.\n");
      break;
    default:
      write("Irregulaerer Returnwert.\n");
      break;
  }
  return 1;
}


static int _changeeppoints_(string str) {
  int ret, points;
  string file;
  if(!secure(LORD_LVL)) return 1;
  notify_fail("Falsche Argumente.\n");
  if (!str || !stringp(str)) return 0;
  if (sscanf(str,"%s %d",file,points)!=2) return 0;
  ret=EM->ChangeEPPoints( file , points );
  switch(ret) {
    case -4:
      write("Neue Punkte sind ausserhalb des erlaubten Bereichs.\n");
      break;
    case -3:
      write("Objekt ist nicht angemeldet.\n");
      break;
    case -2:
      write("Falsche Argumente wurden uebergeben.\n");
      break;
    case -1:
      write("Fehler im Array-Handling.\n");
      break;
    case 0:
      write("Keine Berechtigung zum Umbenennen.\n");
      break;
    case 1:
      write("OK.\n");
      break;
    default:
      write("Irregulaerer Returnwert.\n");
      break;
  } 
  return 1;
}

static int _domaineplist_(string str) {
  int ret;
  if(!secure(LORD_LVL))
    return 1;
  notify_fail("Falsches Argument. ( Bsp: 'DomainEPList wunderland' )\n");
  if(!str || !stringp(str)) 
    return 0;
  if(strstr(str,"/")>-1)
    return 0;
  ret=EM->get_dep_list(str);
  switch(ret) {
    case 0:
      write("Keine Berechtigung zum Erstellen der Liste.\n");
      break;
    case -1:
      write("Diese Region existiert nicht.\n");
      break;
    case -2:
      write("Parameter-Fehler.\n");
      break;
    case -3:
      write("Log Verzeichnis /d/"+str+"/LORD/lists/ existiert nicht.\n");
      break;
    default:
      write("Liste /d/"+str+"/LORD/lists/forschung wird erstellt.\n");
  }
  return 1;
}

static int _isepobject_(string str) {
  int number;
  string file;
  mixed *values;
  if (!secure(WIZARD_LVL)) return 1;
  notify_fail("Falsches Argument.\n");
  if (!str || !stringp(str)) return 0;
  if (sscanf(str,"%d",number)==1)
  {
    if (!(values=EM->QueryEPNumber( number )))
    {
      printf("Das Objekt mit der Nummer %d ist nicht angemeldet.\n",number);
      return 1;
    }
    printf("Filenummer: %d  File: %s\nPunkte: %d\n%s\n",
       values[3],values[0],values[1],"Das Objekt ist "+(values[2]?"":"de")+"aktiviert.");
  }
  else if (sscanf(str,"%s",file)==1)
  {
    if (!(values=EM->QueryEPObject( file )))
    {
      printf("Das Objekt %s ist nicht angemeldet.\n",file);
      return 1;
    }
    printf("Filenummer: %d  File: %s\nPunkte: %d\n%s\n",
       values[3],values[0],values[1],"Das Objekt ist "+(values[2]?"":"de")+"aktiviert.");
  } 
  else return 0;
  return 1;
}

static int _ep_stat_() {
  int i, quantity, max_ep;
  if (!secure(WIZARD_LVL)) return 1;
  quantity=EM->QueryQuantity();
  max_ep=EM->QueryMaxEP();
  printf("Anzahl der zur Zeit angemeldeten EP-Objekte: %d\n"
        +"Anzahl der zur Zeit erhaltbaren EP: %d\n",quantity,max_ep);
  printf("Notwendige Prozent je Level:\n\n");
  for (i=1;i<=MAX_LEVEL;i++)
    if ((i+1)<=MAX_LEVEL)
      printf("  Level %-10d %3d%-9s  Level %-10d %3d%s\n",
        i,EM->QueryNeededEP(i),"%",++i,EM->QueryNeededEP(i),"%");
    else 
      printf("  Level %-10d %3d%s\n",i,EM->QueryNeededEP(i),"%");
  return 1;
}


void check_file_for_balance(string file, string path, string savefile) {
  int i,ep,xp;
  string obj_str, line;
  object obj;
  if (file[0]=='.') {
    write_file(savefile, sprintf("File %s wurde nicht bearbeitet.\n",
      file));
    return;
  }
  obj_str=path+"/"+file;
  if ((obj=find_object(obj_str))) obj->remove();
  if (obj || (obj=find_object(obj_str))) destruct(obj);
  i=0;
  while(line=read_file(obj_str,i++,1)) {
    if (strstr(line,"GiveEP()")!=-1)
    {
      write_file(savefile, sprintf("File %-30s vergibt Punkte mit GiveEP().\n",
        file));
      SetProp("ep_others", (QueryProp("ep_others") + 1));
      return;
    }
  }
  if (catch((obj=clone_object(obj_str))))
  {
    write_file(savefile, sprintf("File %-30s kann nicht geladen werden.\n",
      file));
    return;
  }
  if (!obj)
  {
    write_file(savefile, sprintf("File %-30s konnte nicht bearbeitet werden.\n",
      file));
    return;
  }
  if (living(obj) && !obj->QueryProp(P_EP_FUNC) && (xp=obj->QueryProp(P_XP)))
  {
    ep=EM->query_npc_ep(xp);
    if (ep)
    {
      write_file(savefile, sprintf("File %-30s meldet sich mit %d NPC-EP's an.\n",
        file,ep));
      SetProp("ep_npcs", (QueryProp("ep_npcs") + ep));
    }
  }
  obj->remove();
  if (obj || (obj=find_object(obj_str))) destruct(obj);
  return;
}


void wait_for_balance_check(object player, string filename) {
  if (player && objectp(player) && filename && stringp(filename)) {
    write_file(filename, sprintf("\n\n"
      "Gesamtpunkte der NPCs: %d\n"
      "Anzahl sonstiger Objekte mit GiveEP: %d\n",
      QueryProp("ep_npcs"),QueryProp("ep_others")));
    tell_object(player, sprintf("CheckBalance beendet.\n"
      "Ergebnisse stehen in '%s'.\n",filename));
  }

  SetProp("ep_npcs",0);
  SetProp("ep_others",0);
} 

static int _check_balance_(string path) {
  int i,j,p;
  string *files, *allowed, filename;
  if (!secure(LORD_LVL)) return 1;
  if (find_call_out("wait_for_balance_check")!=-1) {
    write("Es wird noch an einem Check gearbeitet.\n");
    return 1;
  }
  allowed=({ "/players/" , "/d/" });
  if (!path || !stringp(path)) path="";
  path=MASTER->_get_path(path,getuid(this_player()));
  if(!MASTER->valid_write(path, geteuid(PL))) {
    write("Du hast unter diesem Pfad keine Berechtigung, sorry.\n");
    return 1;
  }
  p=0;
  for(j=sizeof(allowed),i=0;i<j;i++)
    if (strstr(path,allowed[i])==0) {
      p=1;
      break;
    }
  if (!p) {
    printf("Verzeichnis '%s' ist fuer diese Aktion gesperrt.\n",path);
    return 1;
  }
  files = get_dir(path+"/*.c");
  if (!files || !sizeof(files)) {
    printf("Keine Objekte in '%s' gefunden.\n",path);
    return 1;
  }
  filename="/players/"+this_player()->query_real_name()+"/balance_output";
  if (!write_file(filename,
    sprintf("\n\nAktion CheckBalance mit dem EP-Tool\n"
            "===================================\n\n"
            "Datum: %s\n\n"
            "Pfad: ' %s '\n\n",dtime(time()),path)))
  {
    write(break_string(sprintf("Ergebnisse koennen nicht in %s "
     +"eingetragen werden.\n",filename),BS_STDLEN));
    return 1;
  }
  write("Ergebnisbestaetigung kommt in 1 Minute...\n");
  call_out("wait_for_balance_check",60,this_player(),filename);
  asynchron(files,#'check_file_for_balance,({path,filename}));
  return 1;
}

static int _check_npc_(string arg) {
  object ob, env, *alle;
  string pfad;
  int eps, xps;
  mixed epinfo;

  notify_fail("Argumente: Object oder Id des NPCs (im Raum).\n");
  if(!arg || strlen(arg)<1)
    return 0;
  if(!secure(LORD_LVL))
    return 1;
  pfad=MASTER->_get_path(arg, getuid(PL));
  if(!(ob=present(arg, PL)))
    if(!(environment(PL) && ob=present(arg, environment(PL))))
      ob=find_object(pfad);
  if(!ob) {
    write("Kein Ziel gefunden.\n");
    return 1;
  }
  if(!living(ob) || query_once_interactive(ob)) {
    write((string)ob+" ist kein NPC oder nur die Blueprint.\n");
    return 1;
  }
  pfad=explode(file_name(ob),"#")[0];
  write("Objekt gefunden  : "+(string)ob+"\n");
  
  if(MASTER->valid_write(pfad, geteuid(PL))) {
    epinfo=EM->QueryEPObject(pfad);
    if(pointerp(epinfo))
      write("EP-Master Status : "+"Listennummer "+epinfo[3]+", "+
        epinfo[1]+" FP, "+(epinfo[2]?"aktiv\n":"inaktiv\n"));
    else
      write("EP-Master Status : nicht angemeldet\n");
  }
  xps=ob->QueryProp(P_XP);
  write("Erfahrungspunkte : "+xps+"\n");
  write("Status P_EP_FUNC : "+ob->QueryProp(P_EP_FUNC)+"\n");
  eps=EM->query_npc_ep(xps);
  write("Vorschlag (Kampf): "+eps+
    (eps==1?" Forschungspunkt":" Forschungspunkte")+"\n");
  return 1;
}

int _ephilfe_() {
  this_player()->More(
       "Folgende Kommandos stehen Dir mit dem EP-Tool zur Verfuegung:\n"
       "=============================================================\n\n"
       "Spielerbeeinflussende Kommandos:\n\n"
       "  SetEP <spieler> <nummer oder pfad>   (nur fuer Erzmagier)\n"
       "    - Setzt dem Spieler die angemeldeten EP eines Objekts.\n"
       "      Das zweite Argument ist die Stelle im String (nummer)\n"
       "      oder der Pfad des Objekts.\n\n"
       "  TakeEP <spieler> <nummer oder pfad>   (nur fuer Erzmagier)\n"
       "    - Nimmt dem Spieler die angemeldeten EP eines Objekts.\n"
       "      Das zweite Argument ist die Stelle im String (nummer)\n"
       "      oder der Pfad des Objekts.\n\n"
       "  ClearEP <spieler>   (nur fuer Erzmagier)\n"
       "    - Nimmt dem Spieler ALLE bereits gefundenen EP.\n\n"
       "  SetFullEP <spieler>   (nur fuer Erzmagier)\n"
       "    - Setzt dem Spieler ALLE noch nicht gefundenen EP.\n\n"
       "  GotEP <spieler> <nummer oder pfad>\n"
       "    - Prueft, ob ein Spieler die EP's eines bestimmten Objekts\n"
       "      bereits erhalten hat. Das zweite Argument beinhaltet dabei\n"
       "      die Stelle des Objekts im String (nummer) oder den Pfad des\n"
       "      Objekts.\n\n"
       "  GotDistrictEP <spieler> <district>\n"
       "    - Listet alle gefundenen EP's eines Spielers in einem\n"
       "      Verzeichnis.\n"
       "      Beispiel: GotDistrictEP <player> /d/wunderland/kogida\n"
       "         Es werden alle gefundenen EP's aus diesem Verzeichnis\n"
       "         und den Unterverzeichnissen angezeigt.\n\n"
       "  QueryEP <spieler>\n"
       "    - Gibt eine kleine Statistik ueber den Spieler aus.\n\n"
       "  CompensatePlayer <spieler>   (nur fuer Erzmagier)\n"
       "    - Gibt dem Spieler die notwendigen Forschungspunkte fuer den\n"
       "      Level. Es werden zufaellig welche aus der Masse gewaehlt.\n\n"
       "Kommandos fuer den Master:\n\n"
       "  AddEP <pfad> <punkte>\n"
       "    - Meldet ein Objekt beim Master an. Die Anzahl der zu\n"
       "      vergebenen Punkte muss mit angegeben werden.\n"
       "      VORSICHT: Objekte koennen nicht wieder geloescht werden.\n\n"
       "  ActivateEP <pfad>\n"
       "    - Aktiviert ein beim Master bereits angemeldetes Objekt.\n"
       "      Dadurch koennen die EP wieder an Spieler vergeben werden\n"
       "      und zaehlen auch wieder zur Gesamtmenge aller EP.\n\n"
       "  DeactivateEP <pfad>\n"
       "    - Deaktiviert ein beim Master bereits angemeldetes Objekt.\n"
       "      Dadurch koennen die EP nicht mehr an Spieler vergeben werden\n"
       "      und sie zaehlen auch nicht mehr zur Gesamtmenge aller EP.\n\n"
       "  ChangeEPPath <alter_pfad> <neuer_pfad>\n"
       "    - Veraendert den Pfad eines bereits angemeldeten Objekts.\n\n"
       "  ChangeEPPoints <pfad> <neue_punkte>\n"
       "    - Veraendert die zu vergebenen EP eines bereits angemeldeten\n"
       "      Objekts.\n\n"
       "  DomainEPList <region>   (ab Regionsmagier)\n"
       "    - Erstellt im LORD Verzeichnis der Region unter lists eine Liste\n"
       "      mit den angemeldeten FPs der Region. Siehe dazu 'eprules'.\n\n"
       "  IsEPObject <nummer oder Pfad>\n"
       "    - Kontrolliert, ob das Objekt bereits angemeldet ist und gibt\n"
       "      dessen Werte aus. Als Argument kann die Stelle im String (nummer)\n"
       "      oder der Pfad des Objekts angegeben werden.\n\n"
       "  EP-Stat\n"
       "    - liefert eine kleine Statistik ueber die beim Master angemeldeten\n"
       "      EP\n\n"
       "  CheckBalance <pfad>\n"
       "    - Ermittelt die EP's, mit denen sich NPC's anmelden und die Anzahl\n"
       "      der GiveEP() funktionen in anderen Objekten. Es sollte immer in\n"
       "      einem Verhaeltnis 50:50 ausgepraegt sein. Der Pfad kann relativ\n"
       "      zum aktuellen Arbeitspfad angegeben werden. Da dieser Check\n"
       "      bei grossen Verzeichnissen sehr arbeitsintensiv sein kann, wird\n"
       "      es asynchron gemacht. Das Ergebnis wird ins Home des Magiers\n"
       "      geschrieben.\n\n"
       "  CheckNPC <id oder object>\n"
       "    - Liefert die Erfahrungspunkte des NPCs, dessen P_EP_FUNC Status\n"
       "      und macht einen Vorschlag wie viele FPs bei diesem NPC fuer das\n"
       "      Toeten (!!!) vergeben werden 'sollten'.\n"
       "    - Hat der Magier Schreibrechte auf das Object, wird zusaetzlich\n"
       "      angezeigt, ob das Objekt bereits angemeldet ist, welche Nummer\n"
       "      es in der FP-Liste hat, wie viele FPs vergeben werden und ob es\n"
       "      aktiv oder inaktiv ist.\n\n");
  return 1;
}

int _eprules_() {
  PL->More("/doc/RULES/forschungspunkte", 1);
  return 1;
}
