/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: fernrohr.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// /OBJ/TOOLS/FERNROHR.C
//
// Dieses Fernrohr ist die Magierfassung des Fernrohrs aus
// /d/berge/bongo/obj/fernrohr. Es gibt keine Einschraenkungen
// wie bei dem Seher-Fernrohr.
//
// Author: Bongo@Wunderland
//
// $Date: 1999/11/05 12:30:44 $
// $Revision: 1.1.1.1 $
/* $Log: fernrohr.c,v $
/* Revision 1.1.1.1  1999/11/05 12:30:44  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:10  en
/* MUDLib CVS Preperation
/*
 * Revision 1.1  1999/08/01 00:22:26  Largo
 * Initial revision
 *
 */

inherit "std/thing";

#include <properties.h>
#include <wizlevels.h>
#include <defines.h>

#define BS break_string

object owner;

 
void create()
{
  if (!clonep()) return;

  ::create();

  owner = this_player();
 
  SetProp(P_LONG,
    "Durch das Fernrohr kannst Du andere Spieler ausfindig machen. Da "
   +"es jedoch grosse Magie beinhaltet ist es dabei vollkommen egal, "
   +"ob Waende, Baeume oder sogar Berge dazwischenliegen. "
   +"Syntax: finde <spieler> oder finde npc <npc>");

  SetProp(P_NAME, owner->name(WESSEN, 1)+" Fernrohr");
  SetProp(P_PLURAL, "");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  SetProp(P_BULKINESS, 0);
  SetProp(P_NOBUY, 1);
  SetProp(P_NOSELL, 1);
  SetProp(P_ARTICLE, ART_NONE);
  SetProp(P_AUTOLOADOBJ, 1);
  SetProp(P_NEVERDROP, 1);
  SetProp(P_NODROP, "So eine Kostbarkeit kannst Du doch nicht einfach wegwerfen.\n");

  AddId(({"fernrohr","\nmagierfernrohr"}));

  AddCmd("finde","suche");
}


int secure()
{
  object player, env;

  env = environment();
  player = this_player();

  if (!env || env!=player || !query_once_interactive(player) ||
      (!IS_LEARNER(player) && !player->QueryProp(P_TESTPLAYER)))
    return 0;

  return 1;
}


void reset()
{
  object env;

  if (secure())
  {
    owner = environment();
    SetProp(P_NAME, owner->name(WESSEN,1)+" Fernrohr");
  }

  return ::reset();
}
 
 
int suche(string str)
{
   string beschreibung, wen;
   object spieler, ort;
 
   notify_fail("Syntax: finde <spieler> oder finde npc <npc>\n");
 
   if (!secure())
   {
     this_object()->remove();
     return 0;
   }

   if (!stringp(str)) return 0;
 
   str = lower_case(str);
 
   if (sscanf(str,"npc %s", wen))
   {
//    NPC nicht geladen, oder nicht existent
      if (!(spieler=find_living(wen)))
      {
         write(BS(
           "Der gesuchte NPC ist entweder nicht geladen oder es gibt "
          +"ihn nicht."));
         return 1;
      }
   }
   else
   {
//    Spieler mit diesem Namen nicht vorhanden, netztot.
      if (!(spieler=find_player((wen=str))))
      {
         write(BS(
           "Der gesuchte Spieler ist netztot oder es gibt ihn "
          +"nicht."));
         return 1;
      }
   }
 
// Unsinnige Suche nach sich selbst
   if (spieler==this_player())
   {
      write(BS("Das Fernrohr ist zwar magisch, aber Dich selber kannst "
        +"Du damit nicht finden. Schau Dich einfach um."));
      return 1;
   }
 
// Unbestimmte Fehler abpruefen...
   if (!(ort=environment(spieler)) || !(beschreibung=ort->int_long(this_player(),0)))
   {
      write("Unbestimmter Fehler... Versuche es spaeter noch einmal.\n");
      return 1;
   }
 
// Der-die-das Gesuchte ist im selben Raum
   if (ort==environment(this_player()))
   {
      write(capitalize(spieler->name(WER,1))+" steht genau neben Dir. Schau Dich nur um.\n");
      return 1;
   }
 
// Raumbeschreibung ohne Ausgaenge ausgeben
   write("------------------------------------------------------------------------------\n"
     +BS("Du schaust gespannt in das Fernrohr und wunderst Dich wie "
     +"immer, dass alles in Deiner Umgebung transparent wird. Sogar "
     +"der staerkste Granit und das dickste Blei werden einfach "
     +"durchleuchtet. Nach einer kleinen Suche findest Du "
     +capitalize(spieler->name(WEN,1))+" dann auch endlich.")+"\n"
     +beschreibung
     +"------------------------------------------------------------------------------\n");
 
   return 1;
}
