/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: hypno.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/TOOLS/HYPNO.C ---- Hypnoschuler (Spell/Skill-Tool)
//
// Author: Bongo@Wunderland
//
// $Log: hypno.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/01 00:29:08  Largo
// Initial revision
//
//

inherit "std/thing";

#include <properties.h>
#include <defines.h>
#include <wizlevels.h>
#include <guilds.h>
#include <living/skills.h>

#define GUILDMASTER "/secure/guildmaster"

object owner;

void create()  {
  if (!clonep()) return;

  ::create();

  owner = this_player();
 
  SetProp(P_LONG,
     "Dies ist ein Hypnoschuler fuer Magier. Damit koennen sie in "
    +"kuerzester Zeit alle Zaubersprueche des Wunderlandes lernen oder auch wieder "
    +"verlernen. Mit 'hypnohilfe' kannst Du Dir die Funktionen anzeigen lassen.");

  SetProp(P_NAME, owner->name(WESSEN, 1)+" Hypnoschuler");
  SetProp(P_PLURAL, "");
  SetProp(P_GENDER, MALE);
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  SetProp(P_NOBUY, 1);
  SetProp(P_NODROP, "So eine Kostbarkeit kannst Du doch nicht einfach wegwerfen.\n");
  SetProp(P_NEVERDROP, 1);
  SetProp(P_NOSELL, 1);
  SetProp(P_AUTOLOADOBJ, 1);
  SetProp(P_SKILLS_ID, "hypno");

  AddId(({"hypno","schuler","hypnoschuler"}));

  AddCmd(({"erlerne","erlern"}),"erlernen");
  AddCmd(({"verlerne","verlern"}),"verlernen");
  AddCmd("anzeige","anzeigen");
  AddCmd("hypnohilfe","hypnohilfe");
  AddCmd("anmeldung","source");
}


int secure()
{
  object player, env;

  env = environment(this_object());
  player = this_player();

  if (!env || env!=player || !query_once_interactive(player) ||
      (!IS_LEARNER(player) && !player->QueryProp(P_TESTPLAYER)))
    return 0;

  return 1;
}


void reset()
{
  object env;

  if (secure())
  {
    owner = environment();
    SetProp(P_NAME, owner->name(WESSEN,1)+" Hypnoschuler");
  }

  return ::reset();
}


int hypnohilfe()
{

  if (!secure())
  {
    write("Der Hypnoschuler merkt, dass Du kein Magier bist und verschwindet.\n");
    remove(1);
    return 1;
  }

  this_player()->More("Folgende Befehle stehen Dir zur Verfuegung:\n"
       +"-------------------------------------------\n"
       +"erlerne <alles | spruch | gilde>\n"
       +"    ----> Du erlernst alle Sprueche, einen speziellen Spruch\n"
       +"          oder aber alle Sprueche einer bestimmten Gilde mit\n"
       +"          den angemeldeten Trefferwahrscheinlichkeiten.\n\n"
       +"erlerne <alles | spruch | gilde> <promille>\n"
       +"    ----> Du erlernst alle Sprueche, einen speziellen Spruch\n"
       +"          oder aber alle Sprueche einer bestimmten Gilde mit \n"
       +"          der in Promille angegebenen Trefferwahrscheinlichkeit.\n\n"
       +"verlerne <alles | spruch | gilde>\n"
       +"    ----> Du verlernst alle Sprueche, einen speziellen Spruch\n"
       +"          oder aber alle Sprueche einer bestimmten Gilde.\n\n"
       +"anzeige \n"
       +"    ----> Du bekommst einen Ueberblick ueber alle Sprueche,\n"
       +"          die Du kennst.\n\n"
       +"anzeige <name>\n"
       +"    ----> Du bekommst einen Ueberblick ueber alle Sprueche,\n"
       +"          die der Spieler oder Magier beherrscht.\n\n"
       +"anmeldung <spruch>\n"
       +"    ----> Du kannst sehen, wie der Spruch beim\n"
       +"          Skillmaster angemeldet wurde.\n\n"
       +"anzeige liste\n"
       +"    ----> Du bekommst eine Liste aller angemeldeten Sprueche.\n");
  return 1;
}


mixed get_guild_skills(string guild)
{
  int i, j;
  string *skills, *guilds;
  mapping guilds_map;

  if (!stringp(guild)) return -1;

  guilds_map = GUILDMASTER->QueryGuilds(1);

  if (!mappingp(guilds_map)) return -2;

  guilds = m_indices(guilds_map);

  if (!member(guilds_map,guild))
  {
    guilds = m_indices(guilds_map);
    guild = lower_case(guild);

    for (j=sizeof(guilds),i=0;i<j;i++)
      if (strstr(lower_case(guilds[i]),guild)==0)
      {
        guild = guilds[i];
        break;
      }

    if (!member(guilds_map,guild))
      return -2;
  }

  guild = guilds_map[guild][GM_NAME];

  if (catch(call_other(guild,"???")))
    return -3;

  return guild->QueryProp(P_GUILD_SKILLS);
}


int erlernen(string str)
{
  int i, j, prom, *proms;
  string *spells, spell;
  object player;
  mixed values;
  mapping abil;

  notify_fail("Was willst Du erlernen?\n");

  if (!secure())
  {
    write("Der Hypnoschuler merkt, dass Du kein Magier bist und verschwindet.\n");
    this_object()->remove(1);
    return 1;
  }

  if (!stringp(str)) return 0;

  if (str=="alles" || sscanf(str,"alles %d",prom)==1)
  {
    prom = (str=="alles"?-1:(prom>1000?1000:(prom<-1?-1:prom)));
    abil = SM->QueryAbilities();
    spells = ({});
    proms = ({});

    if (mappingp(abil))
    {
      values = m_indices(abil);

      if (prom==-1)
        for (j=sizeof(values),i=0;i<j;i++)
          proms += ({ abil[values[i]][P_SM_BEGIN] });
      else
        for (j=sizeof(values),i=0;i<j;i++)
          proms += ({ prom });

      spells += values;
    }

    if (!sizeof(spells))
    {
      write("Es sind gerade keine Spells/Skills angemeldet.\n");
      return 0;
    }
  }
  else if (sscanf(str, "%s %d", spell, prom)==2 || spell=str)
  {
    prom = (spell==str?-1:(prom>1000?1000:(prom<-1?-1:prom)));

    if (SM->Valid(spell)<0)
    {
      values = get_guild_skills(spell);

      if (!pointerp(values))
      {
        write("So eine Gilde ist nicht angmeldet oder laesst sich nicht laden.\n");
        return 1;
      }

      spells = values;
      proms = ({});

      if (prom==-1)
        for (j=sizeof(spells),i=0;i<j;i++)
          proms += ({ SM->QueryProp(spells[i], P_SM_BEGIN) });
      else
        for (j=sizeof(spells),i=0;i<j;i++)
          proms += ({ prom });
    }
    else
    {
      spells = ({ spell });
      proms = ({ (prom==-1?SM->QueryProp(spell,P_SM_BEGIN):prom) });
    }
  }

  player = this_player();

  for (j=sizeof(spells),i=0;i<j;i++)
  {
    if (player->GiveAbility( spells[i] ,proms[i])<=-2)
      printf("Etwas ist schief gegangen. Du lernst '%s' nicht.\n",spells[i]);
    else
      printf("Du lernst den Spruch '%s' mit %d Promille.\n",spells[i],proms[i]);
  }
    
  return 1;
}


int verlernen(string str)
{
  int i, j;
  string *spells, *spells_to_delete;
  object player;
  mixed values;
  mapping spells_map;

  notify_fail("Was willst Du verlernen?\n");

  if (!secure())
  {
    write("Der Hypnoschuler merkt, dass Du kein Magier bist und verschwindet.\n");
    this_object()->remove(1);
    return 1;
  }

  if (!stringp(str)) return 0;

  player = this_player();

  spells_map = player->QueryProp(P_SKILLS);

  if (!mappingp(spells_map) || !m_sizeof(spells_map))
  {
    write("Du kennst doch ueberhaupt keine Sprueche.\n");
    return 1;
  }

  spells = m_indices(spells_map);

  if (str!="alles")
  {
    if (SM->Valid(str)<0)
    {
      values = get_guild_skills(str);

      if (!pointerp(values))
      {
        write("So eine Gilde ist nicht angmeldet oder laesst sich nicht laden.\n");
        return 1;
      }

      spells_to_delete = ({});

      for (j=sizeof(spells),i=0;i<j;i++)
        if (member(values,spells[i])!=-1)
          spells_to_delete += ({ spells[i] });

      spells = spells_to_delete;
    }
    else
      spells = ({ str });
  }

  for (j=sizeof(spells),i=0;i<j;i++)
  {
    player->GiveAbility(spells[i], -2);
    printf("Du verlernst den Spruch '%s'.\n",spells[i]);
  }

  return 1;
}


string get_list_row(mapping spells_map, string spellname, int width, int all)
{
  int i, sec;
  string type;

  if (!stringp(spellname) || !strlen(spellname) ||
      !mappingp(spells_map) || !m_sizeof(spells_map) ||
      !spells_map[spellname] || !sizeof(spells_map[spellname]) ||
      !width)
  {
    if (all)
      return sprintf("| %-*s | %5d | %4d | %6d | %5d | %-17s |\n",
                     width, spellname, 0, 0, 0, 0, "unbekannt");
    else
      return sprintf("| %-*s | %4d | %-15s | %-24s |\n",
             width, spellname, 0, "unbekannt", "unbekannt");
  }

  switch(SM->Valid(spellname))
  {
    case 0: type = "SPELL"; break;
    case 1: type = "SKILL"; break;
    case 3: type = "ATTACK"; break;
    case 4: type = "DEFEND"; break;
    default: type = " ??? "; break;
  }

  if (all)
    return sprintf("| %-*s | %5d | %4d | %6d | %5d | %-8s |\n",
                     width, spellname,
                     spells_map[spellname][P_SM_LEVEL],
                     spells_map[spellname][P_SM_BEGIN],
                     spells_map[spellname][P_SM_COST],
                     spells_map[spellname][P_SM_DELAY],
                     type);
  else
    return sprintf("| %-*s | %4d | %-8s | %-:8s | %-22s |\n",
           width, spellname, spells_map[spellname][S_PROM],
           type, (sizeof(spells_map[spellname][S_GIDS])?
                  spells_map[spellname][S_GIDS][0]:""),
           ((sec=spells_map[spellname][S_TIME])?dtime(sec)[5..]:"unbekannt"));
}


int anzeigen(string str)
{
  int *idx, i, j, k, l, p, width, help, all;
  string *spellnames, *guildnames, *guildskills, text, text2, file;
  object player, person;
  mapping spells_map, guilds_map;

  player = this_player();

  if (!secure())
  {
    write("Der Hypnoschuler merkt, dass Du kein Magier bist und verschwindet.\n");
    remove(1);
    return 1;
  }

  all = 0;

  if (!str)
    person = player;
  else if (str=="liste" || str=="alles")
    all = 1;
  else
  {
    if (!IS_LEARNER(player))
    {
      write("Als Testspieler darfst Du nur Deine eigenen Sprueche anzeigen lassen.\n");
      return 1;
    }

    if (!(person=find_player(str)) && !(person=present(str,environment(player))))
    {
      write("So jemanden kannst Du nicht finden.\n");
      return 1;
    }
  }
  
  if (all)
  {
    spells_map = ([]);
    spells_map += SM->QueryAbilities();

    if (!spells_map || !m_sizeof(spells_map))
    {
      write("Es sind keine Sprueche angemeldet.\n");
      return 1;
    }
  }
  else
  {
    spells_map = person->QueryProp(P_SKILLS);

    if (!spells_map || !m_sizeof(spells_map))
    {
      if (person==player)
        write("Du hast noch keine Sprueche gelernt.\n");
      else
        printf("%s hat noch keine Sprueche gelernt.\n",capitalize(person->name(WER,1)));

      return 1;
    }
  }

  spellnames = sort_array(m_indices(spells_map),#'>);
  width = 13;
  idx = ({});

  for (j=sizeof(spellnames),i=0;i<j;i++)
  {
    idx += ({ 0 });

    if ((help=strlen(spellnames[i]))>width)
      width = help;
  }

  guilds_map = GUILDMASTER->QueryGuilds(1);
  help = 56 + width;
  
  if(all) help-=11;

  if (all)
    text = sprintf("+%*'='s+\n", help, "");
  else
  {
    text2 = ((text2=person->QueryProp(P_GUILD)) ?
            ((!stringp(text2) || text2=="/std/guild") ?
            "keine" : text2) : "keine");
    text = sprintf("\n+%*'='s+\n"
                  +"| Ziel : %-*s |\n"
                  +"| Gilde: %-*s |\n"
                  +"| Stufe: %-*d |\n"
                  +"+%*'='s+\n",
                  help, "",
                  (help-9), capitalize(person->name(WER,1)),
                  (help-9), text2,
                  (help-9), person->QueryProp(P_LEVEL),
                  help, "");
  }

  if (!guilds_map || !m_sizeof(guilds_map))
  {
    if (all)
      text += sprintf("| %|*s |\n"
                     +"+%*'='s+\n"
                     +"| %|*s | %|5s | %|4s | %|6s | %|5s | %|11s |\n"
                     +"+%*'-'s+\n",
                     (help-2), "Spells/Skills aus unbekannter Gilde",
                     help, "",
                     width, "Spells/Skills", "Level", "Prob", "Kosten",
                     "Delay", "Typ", help, "");
    else
      text += sprintf("| %|*s |\n"
                     +"+%*'='s+\n"
                     +"| %|*s | %|4s | %|8s | %|8s | %|22s |\n"
                     +"+%*'-'s+\n",
                     (help-2), "Spells/Skills aus unbekannter Gilde",
                     help, "",
                     width, "Spells/Skills", "Prob", "Typ", "1. ID", "Letzte Anwendung",
                     help, "");

    for (i=0;i<j;i++)
      text += get_list_row(spells_map, spellnames[i], width, all);

    text += sprintf("+%*'='s+\n", help, "");
  }
  else
  {
    guildnames = sort_array(m_indices(guilds_map), #'>) - ({"/std/guild"});

    if (guilds_map[text2])
    {
      guildnames -= ({ text2 });
      guildnames = ({ text2 }) + guildnames;
    }

    if (!guildnames || !(l=sizeof(guildnames)))
    {
      if (all)
        text += sprintf("| %|*s |\n"
                       +"+%*'='s+\n"
                       +"| %|*s | %|5s | %|4s | %|6s | %|5s | %|8s |\n"
                       +"+%*'-'s+\n",
                       (help-2), "Spells/Skills aus unbekannter Gilde",
                       help, "",
                       width, "Spells/Skills", "Level", "Prob", "Kosten",
                       "Delay", "Typ", help, "");
      else
        text += sprintf("| %|*s |\n"
                       +"+%*'='s+\n"
                       +"| %|*s | %|4s | %|8s | %|8s | %|22s |\n"
                       +"+%*'-'s+\n",
                       (help-2), "Spells/Skills aus unbekannter Gilde",
                       help, "",
                       width, "Spells/Skills", "Prob", "Typ", "1. ID", "Letzte Anwendung",
                       help, "");

      for (i=0;i<j;i++)
        text += get_list_row(spells_map, spellnames[i], width, all);

      text += sprintf("+%*'='s+\n", help, "");
    }
    else
    {
      for (k=0;k<l;k++)
      {
        file = guilds_map[guildnames[k]][GM_NAME];
        
        if (catch(call_other(file, "???")))
          text += sprintf("| %|*s |\n"
                          +"+%*'='s+\n",
                          (help-2), (guildnames[k]+" laesst sich nicht laden"),
                          help, "");
        else
        {
          guildskills = file->QueryProp(P_GUILD_SKILLS);

          if (guildskills && pointerp(guildskills))
          {
            if (all)
              text2 = sprintf("| %|*s |\n"
                             +"+%*'='s+\n"
                             +"| %|*s | %|5s | %|4s | %|6s | %|5s | %|8s |\n"
                             +"+%*'-'s+\n",
                             (help-2), ("Spells/Skills der "+guildnames[k]),
                             help, "",
                             width, "Spells/Skills", "Level", "Prob", "Kosten",
                             "Delay", "Typ", help, "");
            else
              text2 = sprintf("| %|*s |\n"
                             +"+%*'='s+\n"
                             +"| %|*s | %|4s | %|8s | %|8s | %|22s |\n"
                             +"+%*'-'s+\n",
                             (help-2), ("Spells/Skills der "+guildnames[k]),
                             help, "",
                             width, "Spells/Skills", "Prob", "Typ", "1. ID", "Letzte Anwendung",
                             help, "");

            p = 0;

            for (i=0;i<j;i++)
              if (member(guildskills,spellnames[i])!=-1 && !idx[i])
              {
                idx[i]++;
                p = 1;
                text2 += get_list_row(spells_map, spellnames[i], width, all);
              }

            if (p)
              text += text2 + sprintf("+%*'='s+\n", help, "");
          }
        }
      }

      if (all)
        text2 = sprintf("| %|*s |\n"
                       +"+%*'='s+\n"
                       +"| %|*s | %|5s | %|4s | %|6s | %|5s | %|8s |\n"
                       +"+%*'-'s+\n",
                       (help-2), "Spells/Skills aus unbekannter Gilde",
                       help, "",
                       width, "Spells/Skills", "Level", "Prob", "Kosten",
                       "Delay", "Typ", help, "");
      else
        text2 = sprintf("| %|*s |\n"
                       +"+%*'='s+\n"
                       +"| %|*s | %|4s | %|8s | %|8s | %|22s |\n"
                       +"+%*'-'s+\n",
                       (help-2), "Spells/Skills aus unbekannter Gilde",
                       help, "",
                       width, "Spells/Skills", "Prob", "Typ", "1. ID", "Letzte Anwendung",
                       help, "");

      p = 0;

      for (i=0;i<j;i++)
        if (!idx[i])
        {
          p = 1;
          text2 += get_list_row(spells_map, spellnames[i], width, all);
        }

      if (p)
        text += text2 + sprintf("+%*'='s+\n", help, "");
    }
  }

  player->More(text);
  return 1;
}


int source(string str)
{
  int j;
  mixed *s;
  mapping spells_map;
  string tmp;

  notify_fail("Von welchem Spruch moechtest Du die Anmeldung sehen?\n");

  if (!stringp(str)) return 0;

  if (!secure())
  {
    write("Der Hypnoschuler merkt, dass Du kein Magier bist und verschwindet.\n");
    remove();
    return 1;
  }

  spells_map = SM->QueryAbilities();

  if (!mappingp(spells_map) || !member(spells_map,str))
  {
      write("So ein Spruch ist nicht angemeldet worden.\n");
      return 1;
  }

  write ("Der Spruch wurde folgendermassen angemeldet.\n");
  s = spells_map[str];

    printf("AddAbility()\n"
           "Name        : %s\n"
           "Description : %s\n"
           "BeginValue  : %d\n"
           "BeginLevel  : %d\n"
           "Costs       : %d\n"
           "Factor      : %d\n"
           "Stat        : %s\n"
           "Delay       : %d\n"
           "Magic       : %s\n"
           "Type        : %d\n"
           "File        : %s\n"
           "Item        : %s\n"
           "Verben      : %s\n"
           "Flags       : %d\n",
           str, to_string(s[P_SM_DESCRIPTION]),
           s[P_SM_BEGIN], s[P_SM_LEVEL], s[P_SM_COST], s[P_SM_FACTOR],
           to_string(s[P_SM_STAT]), s[P_SM_DELAY],
           (pointerp(s[P_SM_MAGIC]) ?
             PL->CountUp(s[P_SM_MAGIC]) :
             to_string(s[P_SM_MAGIC])),
           s[P_SM_TYPE], to_string(s[P_SM_FILE]),
           to_string(s[P_SM_ITEM]),
           (sizeof(s)>P_SM_VERBS && stringp(tmp=PL->CountUp(s[P_SM_VERBS])) ?
             tmp : "keine"),
           (sizeof(s)>P_SM_FLAGS ?
             s[P_SM_FLAGS] :
             0) );
              
   return 1;
}
