/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: newstool.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// OBJ/TOOLS/NEWSTOOL.C -- News-Daemon Tool
//
// Based on Wunderland MudLib
//
/*
 * $Date: 1999/11/05 12:30:44 $
 * $Revision: 1.1.1.1 $
 * $Log: newstool.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:44  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:10  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/08/01 10:49:12  Largo
 * Initial revision
 *
 */

inherit "std/thing";

#include <properties.h>
#include <defines.h>
#include <news.h>
#include <config.h>

#define DAEMON "/secure/news"

void create()
{
  if (!clonep()) return;
  ::create();
  SetProp(P_LONG,
    "Das News-Gruppen-Tool. Moegliche Befehle:\n"
    "  addg <grname> <ownername>   : Gruppe erzeugen\n"
    "  removeg <grname>            : Gruppe loeschen\n"
    "  addw <grname> <username>    : Schreibberechtigten eintragen\n"
    "  removew <grname> <username> : Schreibberechtigten austragen\n"
    "  addd <grname> <username>    : Loeschberechtigten eintragen\n"
    "  removed <grname> <username> : Loeschberechtigten austragen\n"
    "  addr <grname> <username>    : Leseberechtigten eintragen\n"
    "  remover <grname> <username> : Leseberechtigten austragen\n"
    "  setg <grname> <loeschlev> <schreiblev> <leselev> <maxmsg> <expire>\n"
    "  showg [<grname>]            : Zeigt Infos ueber eine Gruppe an\n");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_NAME, "Newsgruppen-Tool");
  SetProp(P_PLURAL, "");
  SetProp(P_ARTICLE, ART_DEF);
  SetProp(P_NODROP,"Is nich!\n");
  SetProp(P_NEVERDROP,1);
  SetProp(P_AUTOLOADOBJ,1);
  AddId(({"newsgruppentool","news-gruppen-tool","manip","newstool","tool"}));

  AddCmd("addg","addg");
  AddCmd("removeg","removeg");
  AddCmd("addw","addw");
  AddCmd("removew","removew");
  AddCmd("addd","addd");
  AddCmd("removed","removed");
  AddCmd("addr","addr");
  AddCmd("remover","remover");
  AddCmd("setg","setg");
  AddCmd("showg","showg");

}

int addr(string str) {
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("addr <groupname> <username>\nAnschliessend darf der User unabhaengig vom Wizlevel die Gruppe lesen.\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->AddAllowed(st1,({}),({}),arr)){
    case 0: write("Param err\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int remover(string str) {
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("remover <gruppenname> <username>\nDanach darf der User die Gruppe nur noch lesen, wenn sein Wizlevel dies erlaubt.\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->RemoveAllowed(st1,({}),({}),arr)){
    case 0: write("Parameter error\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int addd(string str)
{
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("addd <gruppe> <user>\nUser darf Artikel loeschen (unabh vom Wizlevel)\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->AddAllowed(st1,arr,({}),({}))){
    case 0: write("Param err\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int removed(string str)
{
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("removed <gruppe> <user>\nUser darf nur noch Artikel loeschen, wenn sein Wizlevel das erlaubt.\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->RemoveAllowed(st1,arr,({}),({}))){
    case 0: write("Param err\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int addw(string str)
{
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("addw <gruppe> <user>\nUser darf Artikel schreiben (unabh vom Wizlevel)\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->AddAllowed(st1,({}),arr,({}))){
    case 0: write("Param err\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int removew(string str)
{
  mixed *arr;
  string st1, st2;

  if (!str || str=="" || sscanf(str,"%s %s",st1,st2) !=2){
    write("removew <gruppe> <user>\nUser darf nur noch Artikel schreiben, wenn sein Wizlevel dies erlaubt.\n");
    return 1;
  }

  arr=explode(st2," ")-({""});
  switch (DAEMON->RemoveAllowed(st1,({}),arr,({}))){
    case 0: write("Param err\n"); break;
    case 1: write("Ok.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such board\n"); break;
  }
  return 1;
}

int setg(string str)
{
  string name;
  int dlevel, wlevel, rlevel, maxmessages, expire;

  if (!str || str=="" ||
      sscanf(str,"%s %d %d %d %d %d",name,dlevel,wlevel,rlevel,maxmessages,expire) != 6) {
    write("setg <gruppe> <loeschlevel> <schreiblevel> <leselevel> <maxmessages> <expire>\nGruppenparameter setzen, Bedeutung (Defaultwerte in Klammern):\n\
    name              : Der Name der Newsgroup\n\
    loeschlevel  (20) : Wizlevel, ab dem User Artikel loeschen koennen\n\
    schreiblevel ( 0) : Wizlevel, ab dem User Artikel schreiben koennen\n\
    leselevel    ( 0) : Wizlevel, ab dem User Artikel lesen koennen\n\
    maxmessages  (40) : Maximale Anzahl Artikel in einer Newsgruppe\n\
    expire       (-1) : Expiretime in Tagen, -1 = nie\n");
    return 1;
  }
  expire=86400*expire;
  switch(DAEMON->SetGroup(name, dlevel, wlevel, rlevel, maxmessages,expire)){
    case 1: write("Ok"); break;
    case 0: write("Param error.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such group\n"); break;
  }
  return 1;
}

int removeg(string str)
{
  if (!str)
  {
    write("removeg <gruppenname>\nGruppe LOESCHEN.\n");
    return 0;
  }
  switch(DAEMON->RemoveGroup(str)){
    case 1: write("Ok. Bitte nicht vergessen, das Savefile der Newsgroup von Hand zu entfernen !\n"); break;
    case 0: write("Param error.\n"); break;
    case -1: write("No permission\n"); break;
    case -2: write("No such group"); break;
  }
  return 1;
}

int addg(string str)
{
  string name, owner;

  if (!str || str=="" || sscanf(str,"%s %s",name,owner)!=2)
  {
    write("addg <gruppe> <user>\nGruppe anlegen, <user> wird Besitzer der Gruppe\n");
    return 1;
  }
  switch ("secure/news"->AddGroup(name, owner)){
    case 1: write("Ok.\n"); break;
    case 0: write("Param error.\n"); break;
    case -1: write("No permission.\n"); break;
    case -2: write("Group already there\n"); break;
    case -3: write("Owner not found.\n"); break;
    case -4: write("Savefile already in use.\n"); break;
  }
  return 1;
}
  
int showg(string str) {
  mixed group, alle;
  int i;

  alle=DAEMON->GetGroups();
  
  if(!sizeof(alle)) {
    write("Es sind derzeit keine Rubriken verfuegbar.\n");
    return 1;
  }
  
  if(str && strlen(str) && member_array(str, alle)>-1 && 
    pointerp(group=DAEMON->GetBoardInfo(str)) && sizeof(group)) {
      write(sprintf(
        "Gruppe : %s\n"
        "  Besitzer     : %s\n"
        "  Savefile     : %s.o\n"
        "  Expire-Delay : %d\n"
        "%s%s%s"
        "  Loeschlevel  : %d\n"
        "  Schreiblevel : %d\n"
        "  Leselevel    : %d\n"
        "  MaxMessages  : %d\n"
        "  Zugriffe     : %d\n",
        group[G_NAME],
        group[G_OWNER],
        NEWSPATH+group[G_SAVEFILE],
        group[G_EXPIRE],
        break_string("  Loescher     : "+implode(group[G_DELETERS],", "),BS_STDLEN, 0, BS_FOR_COMM),
        break_string("  Schreiber    : "+implode(group[G_WRITERS],", "),BS_STDLEN, 0, BS_FOR_COMM),
        break_string("  Leser        : "+implode(group[G_READERS],", "),BS_STDLEN, 0, BS_FOR_COMM),
        group[G_DLEVEL],
        group[G_WLEVEL],
        group[G_RLEVEL],
        group[G_MAX_MSG],
        group[G_ACCESS]));
    return 1;
  }
  write("Folgende Gruppen kannst Du ansehen:\n");
  write(break_string(implode(alle, ", ")));
  return 1;
}
  
