/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: padd.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// /OBJ/TOOLS/PADD.C --- Tool for Potions-Handling
//
// Author: Bongo@Wunderland
//
// $Date: 1999/11/05 12:30:44 $
// $Revision: 1.1.1.1 $
/* $Log: padd.c,v $
/* Revision 1.1.1.1  1999/11/05 12:30:44  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:10  en
/* MUDLib CVS Preperation
/*
 * Revision 1.2  1999/08/01 10:54:03  Largo
 * P_ARTICLE auf ART_NONE gesetzt
 *
 * Revision 1.1  1999/08/01 10:52:36  Largo
 * Initial revision
 *
 */

inherit "std/thing";

#include <properties.h>
#include <wizlevels.h>

#define PM "/secure/potionmaster"

private static int secure();
static int _add_(string numstr);
static int _activate_(string numstr);
static int _deactivate_();
static int _change_(string old_path);
static int _dump_();
static int dump();
int _paddhilfe_();


void create()
{
  ::create();
  SetProp(P_LONG, "Tippe <paddhilfe>, um zu sehen, was dieses Tool kann.\n");
  SetProp(P_GENDER, NEUTER);
  SetProp(P_NAME, this_player()->name(WESSEN,2)+" Padd");
  SetProp(P_PLURAL, "");
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  SetProp(P_ARTICLE, ART_NONE);
  SetProp(P_NOBUY, 1);
  SetProp(P_NOSELL, "Das Ding ist viel zu wertvoll, um es zu verkaufen.\n");
  SetProp(P_NODROP, "Das Ding ist viel zu wertvoll, um es wegzuwerfen.\n");
  SetProp(P_NEVERDROP, 1);
  SetProp(P_AUTOLOADOBJ, 1);
  AddId(({"tool","padd","padd-tool","potion-tool"}));

  AddCmd("paddhilfe","_paddhilfe_");

  AddCmd("AddPotion","_add_");
  AddCmd("ActivatePotion","_activate_");
  AddCmd("DeactivatePotion","_deactivate_");
  AddCmd("ChangePotionPath","_change_");
  AddCmd("MakeList","_dump_");
  
}


private static int secure()
{
    if (!previous_object()) return 0;
    if (geteuid(previous_object())==ROOTID) return 1;
    if (geteuid(previous_object()) != geteuid(this_interactive())) return 0;
    if (this_interactive() != this_player()) return 0;
    if (!IS_ARCH(this_interactive())) return 0;
    return 1;
}


static int _add_(string numstr)
{
  int ret, number;
  string file;

  if (!secure())
    { printf("Keine Rechte.\n"); return 1; }

  if (!query_once_interactive(environment()))
    { printf("Kein aktiver Magier.\n"); return 1; }

  if (!numstr || sscanf(numstr,"%d",number)!=1 || !intp(number))
    { printf("Falsches Argument angegeben.\n"); return 1; }
  
  if (!(file=file_name(environment(environment(this_object())))))
    { printf("Du hast kein Environment.\n"); return 1; }

  switch((ret=PM->AddPotionroom(file)))
  {
    case  0: printf("Keine Rechte im Potionmaster.\n"); return 1;
    case -1: printf("Kein Raum gefunden.\n"); return 1;
    case -2: printf("Raum kann nicht geladen werden.\n"); return 1;
    case -3: printf("Raum ist bereits angemeldet.\n"); return 1;
    default:
    {
      if (ret>0)
        printf("Raum eingetragen. Naechster Raum: %d\n",ret);
      else
      {
        printf("Unbestimmter Fehler aufgetreten.\n");
        return 1;
      }
      break;
    }
  }

  switch((ret=PM->ActivateRoom(file, number)))
  {
    case  0: printf("Keine Rechte im Potionmaster.\n"); break;
    case -1: printf("Listennummer im falschen Bereich.\n"); break;
    case -2: printf("Raum ist nicht angemeledet.\n"); break;
    case -3: printf("Raum ist bereits aktiviert.\n"); break;
    default:
      if (ret>0)
      {
        printf("Raum aktiviert in Liste %d\n",number);
        dump();
      }
      else
        printf("Unbestimmter Fehler aufgetreten.\n");
      break;
  }

  return 1;
}


static int _activate_(string numstr)
{
  int ret, number;
  string file;

  if (!secure())
    { printf("Keine Rechte.\n"); return 1; }

  if (!query_once_interactive(environment()))
    { printf("Kein aktiver Magier.\n"); return 1; }

  if (!numstr || sscanf(numstr,"%d",number)!=1 || !intp(number))
    { printf("Falsches Argument angegeben.\n"); return 1; }

  if (!(file=file_name(environment(environment(this_object())))))
    { printf("Du hast kein Environment.\n"); return 1; }

  switch((ret=PM->ActivateRoom(file, number)))
  {
    case  0: printf("Keine Rechte im Potionmaster.\n"); break;
    case -1: printf("Listennummer im falschen Bereich.\n"); break;
    case -2: printf("Raum ist nicht angemeledet.\n"); break;
    case -3: printf("Raum ist bereits aktiviert.\n"); break;
    default: 
      if (ret>0)
      {
        printf("Raum aktiviert in Liste %d.\n",number);
        dump();
      }
      else
        printf("Unbestimmter Fehler aufgetreten.\n");
  }

  return 1;
}


static int _deactivate_()
{
  int ret;
  string file;

  if (!secure())
    { printf("Keine Rechte.\n"); return 1; }

  if (!query_once_interactive(environment()))
    { printf("Kein aktiver Magier.\n"); return 1; }

  if (!(file=file_name(environment(environment(this_object())))))
    { printf("Du hast kein Environment.\n"); return 1; }

  switch((ret=PM->DeactivateRoom(file)))
  {
    case  0: printf("Keine Rechte im Potionmaster.\n"); break;
    case -1: printf("Raum ist nicht angemeldet.\n"); break;
    case -2: printf("Raum ist nicht aktiviert.\n"); break;
    default: 
      if (ret>0)
      {
        printf("Raum deaktiviert.\n");
        dump();
      }
      else
        printf("Unbestimmter Fehler aufgetreten.\n");
  }

  return 1;
}


static int _change_(string old_path)
{
  int ret;
  string file;

  if (!secure())
    { printf("Keine Rechte.\n"); return 1; }

  if (!query_once_interactive(environment()))
    { printf("Kein aktiver Magier.\n"); return 1; }

  if (!old_path || !stringp(old_path))
    { printf("Falsche Argumente angegeben.\n"); return 1; }

  if (!(file=file_name(environment(environment()))))
    { printf("Du hast kein Environment.\n"); return 1; }

  switch((ret=PM->ChangeRoomPath(old_path, file)))
  {
    case  0: printf("Keine Rechte im Potionmaster.\n"); break;
    case -1: printf("Falsche Angabe fuer den alten Raum.\n"); break;
    case -2: printf("Kann diesen Raum nicht finden.\n"); break;
    case -3: printf("Alter Raum ist nicht angemeldet.\n"); break;
    case -4: printf("Dieser Raum ist bereits angemeldet.\n"); break;
    case -5: printf("Kann neuen Raum nicht laden.\n"); break;
    default:
      if (ret>0)
      {
        printf("Raum umgemeldet mit Nummer: %d.\n"
          +"Bitte mit Tool aktivieren, wenn noetig.\n",ret);
        dump();
      }
      else
        printf("Unbestimmter Fehler aufgetreten.\n");
  }

  return 1;
}


static int _dump_()
{
  if (!secure())
    { printf("Keine Rechte.\n"); return 1; }

  if (!query_once_interactive(environment()))
    { printf("Kein aktiver Magier.\n"); return 1; }

  dump();
  return 1;
}


static int dump()
{
   PM->DumpList();
   printf("Neue Liste in /secure/ARCH wurde erzeugt.\n");
   return 1;
}


int _paddhilfe_()
{
  this_player()->More(
         "Das Padd ist ein Tool zur Beeinflussung der Zaubertraenke im\n"
        +"Wunderland. Dieses Tool ist nur fuer Erzmagier und hoeher zu\n"
        +"benutzen. Folgende Kommandos kannst Du ausfuehren.\n"
        +"=======================================================================\n\n"
        +"  AddPotion <nummer>\n"
        +"       Mit dem Kommando lassen sich neue Zaubertraenke beim\n"
        +"       Potionmaster anmelden und sofort auch aktivieren.\n"
        +"       Eine neue Liste in /secure/ARCH wird auch gleich mit\n"
        +"       erstellt. Das Argument 'nummer' ist die Nummer der\n"
        +"       Liste, in die der Trank eingetragen werden soll.\n"
        +"       Vorsicht bei diesem Kommando. Traenke koennen nicht mehr\n"
        +"       abgemeldet werden. Sie koennen nur deaktiviert werden.\n"
        +"       Es wird der Trank in dem Raum angemeldet, in dem Du Dich\n"
        +"       befindest. Eine Fernanmeldung ist somit nicht moeglich.\n\n"
        +"  ActivatePotion <nummer>\n"
        +"       Hiermit kann ein deaktivierter Trank wieder aktiviert\n"
        +"       werden. Nach AddPotion ist dieses Kommando nicht mehr\n"
        +"       notwendig. Das Argument 'nummer' ist die Nummer der Liste,\n"
        +"       in welche der Trank aktiviert werden soll. Ist alles gut\n"
        +"       gegangen, wird gleich eine Liste in /secure/ARCH erstellt.\n"
        +"       Es wird immer der Trank in dem Raum aktiviert, in dem Du Dich\n"
        +"       gerade befindest.\n\n"
        +"  DeactivatePotion\n"
        +"       Mit diesem Kommando wird der Trank in dem Raum, in dem Du\n"
        +"       Dich gerade befindest, deaktiviert und ist somit nicht mehr\n"
        +"       fuer Spieler zu bekommen. Es wird anschliessend eine neue\n"
        +"       Liste in /secure/ARCH erstellt.\n\n"
        +"  ChangePotionPath <alter_pfad>\n"
        +"       Mit diesem Kommando kann man einen bereits angemeldeten Trank,\n"
        +"       ob aktiviert oder nicht, ummelden. Liegt der Raum mit dem\n"
        +"       Trank nun in einem neuen Verzeichnis, kann man diesen ummelden.\n"
        +"       Das zu uebergebene Argument ist der volle Filename des alten\n"
        +"       Raums (mit Pfad). Er wird durch den Raum, in dem Du Dich\n"
        +"       gerade befindest ersetzt. Eine eventuelle Aktivierung muss\n"
        +"       darauf per Hand mit diesem Tool durchgefuehrt werden. Es wird\n"
        +"       eine neue Liste in /secure/ARCH erstellt.\n\n"
        +"  MakeList\n"
        +"       Hiermit kannst Du eine neue Liste in /secure/ARCH erstellen.\n\n"
        +"HINWEIS: Moechte man einen Trank in eine andere Liste verschieben, so\n"
        +"         kann man dieses durch Deaktivieren und anschliessendem\n"
        +"         Aktivieren in der neuen Liste erreichen.\n");
  return 1;
}
