/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pathtool.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// /OBJ/TOOLS/PATHTOOL - MERKT SICH RAEUME
//
// $Date: 1999/11/05 12:30:44 $
// $Revision: 1.1.1.1 $
//
// $Log: pathtool.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:44  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:10  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/01 14:02:02  Largo
// tliste und tpfade beschleunigt und modernisiert
//

/***********************************************************************
 *                                                                     *
 * Dieses Objekt ist ein Transmitter, der sich Raeume merken kann, die *
 * der Benutzer (Magier) frei definieren kann. Die urspruengliche Idee *
 * stammt von Bongo@Wunderland. Dieses Objekt kann sich die Pfade aber *
 * frei definiert merken. Das Denktool von Troy@Wunderland ist hier    *
 * auch mit eingeflossen.                                              *
 *                                                                     *
 * Erzeugt am 01.12.1994 (C) Troy@Wunderland, Troy@MorgenGrauen        *
 *                                                                     *
 ***********************************************************************/
 
#pragma strong_types
 
#include <properties.h>
#include <moving.h>
#include <wizlevels.h>
#include <defines.h>
 
inherit "std/thing";
 
string *pfade,olddir;
mapping rooms;
 
private string genitiv(string str)
{
  if(!strlen(str)) return 0;
  if(member_array(str[<1],({'s','x','z'}))<0) return str+"s";
  return str+"'s";
}
 
void security()
{
  string owner;
  object pl;
  if(!interactive((pl=environment())) || !IS_LEARNER(pl))
    {
      remove(1);
      return;
    }
  owner=getuid(pl);
  SetProp(P_NAME, capitalize(genitiv(owner))+" Transmitter");
  SetProp(P_LONG, capitalize(genitiv(owner))+
	  " tragbarer Transmitter/Denker v1.3.\n");
  pl->AddPursuer(this_object());
}
 
int _set_autoloadobj(mixed arg)
{
  if(!pointerp(arg) || sizeof(arg)!=2 ||
     !mappingp(arg[0]) && !pointerp(arg[1])) return 0;
  return (rooms=(mapping)arg[0])&&(pfade=arg[1]);
}
 
mixed _query_autoloadobj()
{
  return ({ rooms, pfade });
}
 
void create()
{
  if(!clonep()) return;
  ::create();
  rooms=([]);
  pfade=({});
  olddir="\n";
  SetProp(P_PLURAL, "");
  SetProp(P_ARTICLE, ART_NONE);
  SetProp(P_NODROP, "So ein Ding ist viel zu kostbar zum wegwerfen.\n");
  SetProp(P_NOSELL, "So ein Ding ist viel zu kostbar zum verkaufen.\n");
  SetProp(P_NEVERDROP, 1);
  SetProp(P_GENDER, 1);
  AddId(({"transmitter","denker","pathtool","\npathtool"}));
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);
  AddCmd("go","trans");
  AddCmd("thelp","hilfe");
  AddCmd("tliste","zeige");
  AddCmd("tmerke","raumadd");
  AddCmd("tloesche","raumremove");
  AddCmd(({"tpfade","tpfadliste"}),"showpath");
  AddCmd("goto","goto");
  AddCmd("tshow","showroom");
  call_out("security",0);
}
 
string long()
{
  if(this_player()!=environment()) return ::long();
  this_player()->More(break_string(
    "Dies ist Dein persoenlicher Transmitter/Denker v1.3. Mit dem Befehl "
    "\"thelp\" bekommst Du eine Liste der Kommandos. Die Kommandos "
    "funktionieren nur, wenn Du Dich im Magiermodus befindest. Dieses Tool "
    "verwaltet zwei Listen: Erstens eine dynamische Liste der letzten zehn "
    "(10) Raeume, in denen Du warst. Diese Raeume sind mit 1 bis 10 "
    "durchnumeriert und koennen mit goto <nr> angesprochen werden. "
    "Der erste Raum (1) in dieser Liste ist immer der aktuelle Raum, in dem "
    "Du Dich befindest.\n"
    "Zweitens: Eine feste Liste mit selber definierbaren Ids fuer "
    "bestimmte Raeume. zu diesen Raeumen kann man mit go <id> gehen."));
  return "";
}
 
mapping QueryRooms()
{
  return rooms;
}
 
string *QueryPaths()
{
  return pfade;
}
 
private void AddQ(string str)
{
  string *ret;
  if(sizeof(pfade) && str==pfade[0]) return;
  for(ret=({ str });sizeof(pfade);pfade=pfade[1..])
    ret += ({ pfade[0] });
  pfade=ret[0..9];
}
 
private void store(string str)
{
  if(strstr(str,"#")>-1)
  {
    tell_object(environment(),break_string(
	str+" ist geclont und wird daher nicht gemerkt"));
    return;
  }
  AddQ( str );
}
 
void init()
{
  ::init();
  if(interactive(this_player()) && !IS_LEARNER(this_player()))
    remove(1);
}
 
int hilfe(string str)
{
  if(!stringp(str) || (str=lower_case(str))=="")
    {
      this_player()->More(
        "Du hast folgende Moeglichkeiten:                  \n"
	"==================================================\n"
	"go <raumid>               : gehe zu Raum mit ID   \n"
	"goto <raumnr>             : gehe zu Raum mit Nr.  \n"
	"thelp [<topic>]           : Hilfe                 \n"
	"tliste                    : zeige feste Liste     \n"
	"tloesche <raumid>         : loesche Raum          \n"
	"tmerke <raumid> [<raum>]  : merke Raum            \n"
	"tpfade                    : zeige dynamische Liste\n"
	"tshow (<raumnr>|<raumid>) : zeige Raum mit Nr.    \n"
	);
      return 1;
    }
  notify_fail("Zu diesem Thema ist keine Hilfe verfuegbar.\n");
  if(member_array(str,({"go","goto","thelp","tliste","tloesche","tmerke",
			"tpfade","tshow"}))<0) return 0;
  switch(str)
    {
    case "tshow":
      this_player()->More(
	"SYNTAX: tshow (<raumnr>|<raumid>)\n\n"+
	"LISTE: dynamisch/fix\n\n"+break_string(
	"BESCHREIBUNG: tshow <raumnr> zeigt die Langbeschreibung des Raumes "
	"mit der Nummer <raumnr> in der dynamischen Liste an.\n"
	"tshow <raumid> zeigt die Langbeschreibung des Raumes mit der ID "
	"<raumid> in der gemerkten eigendefinierten Liste an."));
      return 1;
    case "tpfade":
      this_player()->More(
	"SYNTAX: tpfade\n\n"+
	"LISTE: dynamisch\n\n"+break_string(
	"BESCHREIBUNG: tpfade zeigt die Liste der dynamisch gemerkten Raeume "
	"an."));
      return 1;
    case "tmerke":
      this_player()->More(
	"SYNTAX: tmerke <raumid> [<raumpfad>]\n\n"
	"LISTE: fix\n\n"+break_string(
	"BESCHREIBUNG: tmerke <raumid> <raumpfad> fuegt den Raum <raumpfad> "
	"unter der ID <raumid> in die Liste der gemerkten eingendefinierten "
	"Raeume ein. Dies geschieht nur, wenn der Raum ladbar und kein Clone "
	"ist und wenn die ID <raumid> noch nicht vergeben wurde.\n"
	"tmerke <raumid> fuegt den aktuellen Raum unter der ID <raumid> in "
	"die Liste ein.\n"
	"Die Raum-ID sollte nicht laenger als 10 Zeichen sein."));
      return 1;
    case "tloesche":
      this_player()->More(
	"SYNTAX: tloesche <raumid>\n\n"
	"LISTE: fix\n\n"+break_string(
	"BESCHREIBUNG: tloesche <raumid> loescht den Raum mit der ID "
	"<raumid> aus der Liste der gemerkten eigendefinierten Raeume.."));
      return 1;
    case "tliste":
      this_player()->More(
	"SYNTAX: tliste\n\n"
	"LISTE: fix\n\n"+break_string(
	"BESCHREIBUNG: tliste zeigt die Liste der gemerkten eigendefinierten "
	"Raeume mit ihren Ids."));
      return 1;
    case "thelp":
      this_player()->More(
	"SYNTAX: thelp [<topic>]\n\n"
	"LISTE: ---\n\n"+break_string(
	"BESCHREIBUNG: thelp <topic> listet die Toolhilfe zum Thema <topic>. "
	"thelp allein listet die moeglichen Befehle."));
      return 1;
    case "go":
      this_player()->More(
	"SYNTAX: go <raumid>\n\n"
	"LISTE: fix\n\n"+break_string(
	"BESCHREIBUNG: go <raumid> bewegt den Benutzer in den Raum, der in "
	"der fixen Liste die ID <raumid> traegt. Fuer diesen Befehl wurde "
	"\"go\" geweahlt, da sonst eine Datei im aktuellen Verzeichnis "
	"mit goto nicht ansprechbar waere."));
      return 1;
    case "goto":
      this_player()->More(
	"SYNTAX: goto <raumnr>\n\n"
	"LISTE: dynamisch\n\n"+break_string(
	"BESCHREIBUNG: goto <raumnr> bewegt den Benutzer in den Raum, der in "
	"der dynamischen Liste die Nummer <raumnr> traegt. Jeder betretene "
	"nicht geclonte Raum wird in Reihenfolge in der dynamischen Liste "
	"aufbewahrt. Hierbei ist 1 der aktuelle Raum. Mit goto 1 geht man "
	"also wieder in denselben Raum. Dieser wird dann nicht noch einmal "
	"gespeichert. Mit goto 2 erreicht man den letzten raum, usw."));
      return 1;
    }
  return 0;
}
 
int remove(int silent)
{
  object env;
  if((env=environment()) && interactive(env))
    env->RemovePursuer(this_object());
  return ::remove(silent);
}
 
varargs int move(mixed dest, int method)
{
  object env;
  if(!(env=environment()) || !interactive(env))
    return ::move(dest,method);
  if(!objectp(dest) && !(dest=find_object(dest))) return 0;
  if(interactive(dest) && getuid(dest)!=getuid(env)) // New owner?
    {
      rooms=([]);
      pfade=({});
      env->RemovePursuer(this_object());
      call_out("security",0);
      return ::move(dest,method);
    }
  store(file_name(dest));
  return ::move(env,M_SILENT|M_NOCHECK);
}
 
int goto(string str)
{
  object pl,r;
  int i; 
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  notify_fail("WELCHEN Raum haettens' denn gern?\n");
  if(str=="0")
    {
      write("Bitte nur positive Zahlen!\n");
      return 1;
    }
  if(!stringp(str) || (str=lower_case(str))=="" || !(i=to_int(str)))
    return 0;
  if(i<1)
    {
      write("Bitte nur positive Zahlen!\n");
      return 1;
    }
  if(!sizeof(pfade) || i>sizeof(pfade))
    {
      write("Soviele Raeume habe ich mir nicht gemerkt.\n");
      return 1;
    }
  call_other(pfade[--i],"???");
  if(!(r=find_object(pfade[i])))
    {
      write(break_string("Der Raum Nr."+str+
			 " ["+pfade[i]+"] ist fehlerhaft!"));
      return 1;
    }
  return pl->move(r,M_TPORT | M_NOCHECK);
}
 
int showroom(string str)
{
  object pl,r;
  int i; 
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  notify_fail("WELCHEN Raum haettens' denn gern?\n");
  if(str=="0")
    {
      write("Bitte nur positive Zahlen!\n");
      return 1;
    }
  if(!stringp(str) || (str=lower_case(str))=="") return 0;
  if(!(i=to_int(str)))
    {
      if(!rooms[str]) return 0;
      catch(call_other(rooms[str],"???"));
      if(!(r=find_object(rooms[str])))
	{
	  write(break_string("Der Raum mit der ID ["+str+
			     "] : ["+rooms[str]+"] ist fehlerhaft!"));
	  return 1;
	}
    }
  else
    {
      if(i<1)
	{
	  write("Bitte nur positive Zahlen!\n");
	  return 1;
	}
      if(!sizeof(pfade) || i>sizeof(pfade))
	{
	  write("Soviele Raeume habe ich mir nicht gemerkt.\n");
	  return 1;
	}
      catch(call_other(pfade[--i],"???"));
      if(!(r=find_object(pfade[i])))
	{
	  write(break_string("Der Raum Nr."+str+
			     " ["+pfade[i]+"] ist fehlerhaft!"));
	  return 1;
	}
    }
  pl->More("Der Raum sieht so aus:\n"+r->int_long(pl,pl));
  return 1;
}

private string 	__path_help(string path, string *arr)
{
  return sprintf("    %i.)        %s\n",
    member_array(path, arr)+1,
    strlen(path) > (BS_STDLEN-15) ?
      efun::implode(efun::explode(efun::implode(efun::explode(break_string(
        efun::implode(efun::explode(path, "/"), " "), BS_STDLEN-15)[0..<2],
          " "), "/"), "\n"), "/\n               ") : path);
}
 
int showpath()
{
  object pl;
  string s,*help,h;
  int i; 
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  if(!sizeof(pfade))
    {
      write("Ich habe mir noch keine Pfade gemerkt.\n");
      return 1;
    }

  s = sprintf("Folgende Raeume habe ich mir gemerkt: %+' '*s\n"
              "%'-'*s\n"
              "%-' '*s<\n"
              "%'-'*s\n",
    BS_STDLEN-38, "Transmitter/Denker 1.3", BS_STDLEN, "",
    BS_STDLEN-1, "> LFDNR <    > PFAD",
    BS_STDLEN, "");

  s += efun::implode(map_array(pfade, #'__path_help, pfade), "");

  printf("%s\n", s);

  s += sprintf("%'-'*s\n", BS_STDLEN, "");

  pl->More(s);
  return 1;
}
 
int raumremove(string str)
{
  object pl;
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  notify_fail("WELCHE Raum-ID soll ich loeschen?\n");
  if(!stringp(str) || (str=lower_case(str))=="") return 0;
  if(strlen(str)>10) str=str[0..9];
  if(!rooms[str])
    {
      write("Einen Raum mit der ID ["+str+"] kenne ich aber nicht.\n");
      return 1;
    }
  write("Ok. Loesche ID ["+str+"] und Raum ["+rooms[str]+"].\n");
  rooms=m_delete(rooms,str);
  this_player()->save_me();
  return 1;
}
 
int raumadd(string str)
{
  int i; 
  string id,raum,*ids;
  object r, env;
  if(!IS_LEARNER(this_player()) ||
     !this_player()->QueryProp(P_WANTS_TO_LEARN)) return 0;
  notify_fail("WAS soll ich mir merken?\n");
  if(!stringp(str) || (str=lower_case(str))=="") return 0;
  if((i=sscanf(str,"%s %s",id,raum))!=2)
  {
    id = str;
    raum = load_name(environment(this_player()));
  }
  else
    raum="/secure/master"->make_path_absolute(load_name(env));
  if(strlen(id)>10)
    write("ID ["+id+"] wird auf ["+(id=id[0..9])+"] gekuerzt.\n");

  if(member_array(id,(ids = m_indices(rooms)))>-1)
    {
      write("ID ["+id+"] ist schon vorhanden. Bitte erst loeschen.\n");
      return 1;
    }
  rooms+=([ id:raum ]);
  write("Ok. Raum gemerkt.\n");
  this_player()->save_me();
  return 1;
}

private string __zeige_help(string id, mapping map)
{
  string path;

  path = map[id];

  return sprintf("  %s.)       %s\n",
    id,
    strlen(path) > (BS_STDLEN-10) ?
      efun::implode(efun::explode(efun::implode(efun::explode(break_string(
        efun::implode(efun::explode(path, "/"), " "), BS_STDLEN-10)[0..<2],
          " "), "/"), "\n"), "/\n            ") : path);
}

int zeige()
{
  object pl;
  string *ids,s;
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  if(!m_sizeof(rooms))
    {
      write("Du hast noch keine Raeume definiert.\n");
      return 1;
    }

  s = sprintf("Du hast folgende Raeume definiert: %+' '*s\n"
              "%'-'*s\n"
              "%-' '*s<\n"
              "%'-'*s\n",
    BS_STDLEN-41, "Transmitter/Denker 1.3", BS_STDLEN, "",
    BS_STDLEN-1, "> ID <    > PFAD",
    BS_STDLEN, "");
  
  s += efun::implode(map_array(sort_array(m_indices(rooms), #'>),
    #'__zeige_help, rooms), "");

  s += sprintf("%'-'*s\n", BS_STDLEN, "");

  this_player()->More(s);
  return 1;
}
 
int trans(string str)
{
  int i; 
  string ziel,*ids;
  object raum,start,pl;
  if(!IS_LEARNER((pl=this_player())) ||
     !pl->QueryProp(P_WANTS_TO_LEARN)) return 0;
  notify_fail("WOHIN willst Du gehen?\n");
  if(!stringp(str) || (str=lower_case(str))=="" ||
     (i=member_array(str,(ids=m_indices(rooms))))<0) return 0;
  call_other(rooms[ids[i]],"???");
  if(raum=find_object(rooms[ids[i]]))
    {
      if(raum==environment(this_player()))
	{
	  write("Da bist Du doch schon.\n");
	  return 1;
	}
      tell_room(environment(this_player()),break_string(
		capitalize(this_player()->name(WER,1))+" aktiviert "+
		this_player()->QueryPossPronoun(1,3)+" tragbaren "
		"Transmitter. Ein Loch in der Wirklichkeit erscheint und "
		"das herausstroemende grelle Licht blendet Deine Augen, "
		"die Du sofort schliesst. Aber das hilft auch nicht viel, "
		"denn das Leuchten fuellt Dich ganz und gar aus und scheint "
		"direkt in Deinem Kopf zu entstehen und nicht hinter dem "
		"Loch. Trotz geschlossener Augen siehst Du "+
		this_player()->name(WEN,1)+" in das "
		"Licht gehen. Ein lauter Knall ist zu hoeren und "+
		this_player()->QueryPronoun()+" ist "
		"verschwunden. Darauf schliesst sich das Loch wieder und "
		"alles was zurueckbleibt ist ein Gefuehl der "
		"Unwirklichkeit. Ein tolles Erlebnis.\n"),
		({this_player()}));
      this_player()->move(raum,M_GO | M_SILENT);
      tell_room(raum,break_string(
		"Von irgendwoher frischt "
		"ein Wind auf und zerzaust Dir die Haare. Ploetzlich oeffnet "
		"sich ein Loch zu einer anderen Welt und ein grelle Leuchten "
		"blendet Dich. Aus dem Licht kommt "+
		this_player()->name(WER)+" mit langsamen und "
		"wuerdevollen Schritten heraus und fummelt an einem kleinen "
		"Geraet herum: einem tragbaren Transmitter. Mit einem leisen "
		"PIEP geht ein rotes Licht aus und das Loch in der "
		"Wirklichkeit verschwindet als waere es nie dagewesen.\n"),
		({this_player()}));
    }
  else
    write("Objekt ["+rooms[ids[i]]+"] ["+ids[i]+"] ist fehlerhaft.\n");
  return 1;
}
