/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: questtool.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
/*
 *  M.D. Mudlib
 *
 *  Basierend auf Wunderland Mudlib
 *
 *  /OBJ/TOOLS/QUESTTOOL.C - Ein Tool zum Verwalten von Quests
 *
 * $Date: 1999/11/05 12:30:44 $
 * $Revision: 1.1.1.1 $
 *
 * $Log: questtool.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:44  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:10  en
 * MUDLib CVS Preperation
 *
 * Revision 1.1  1999/08/01 14:08:19  Largo
 * Initial revision
 *
*/
inherit "std/thing";
inherit "std/more";

#include <defines.h>
#include <properties.h>
#include <wizlevels.h>
#include <questmaster.h>

#define END (QM_GUILD+1)

#pragma strong_types

void Load_NumKey     ();
int  Add_Quest       ( string str );
void ReadNewQuest    ( string str );
int  Remove_Quest    ( string str );
int  Change_Quest    ( string str );
int  Restore_Quest   ( string str );
int  Set_Quest       ( string str );
int  Remove_Quest    ( string str );
int  Query_Quest     ( string str );
int  Query_Keys      ( string str );
int  Query_Quests    ( string str );
int  ActivateQuest   ( string str );
int  DeactivateQuest ( string str );
int  GetReturn       ( string str );

string  name;
int     qp;
int     xp;
int     level;
int     need;
string  *allowed;
string  info;
string  wizard;
int	is_gq;
mapping num_key;

object owner;
int    counter;
mixed  *savequest;
string savekey;
int    do_change;
string changekey;

void create()
{
  string str;

  if(!clonep()) return;
  thing::create();
  SetProp(P_GENDER,NEUTER);
  owner = PL;
  AddId("questtool");
  AddId("qt");
  SetProp(P_ARTICLE,0);
  SetProp(P_GENDER, NEUTER);
  str=capitalize(((str=getuid(owner))[<1]=='s'||str[<1]=='x'||str[<1]=='z')?str+="'":str+="s");
  SetProp(P_NAME, str+" QuestTool");
  SetProp(P_PLURAL, "");
  SetProp(P_LONG,
   "Das QuestTool dient der Administration von Quests. (by Kirk, 24.06.94)\n"
  +"implementierte Kommandos:\n"
  +"  AddQ                          : Neuen Questeintrag einfuegen\n"
  +"  RemoveQ     <quest>           : Questeintrag loeschen\n"
  +"  ChangeQ     <quest>           : Questeintrag aendern\n"
  +"  ReStoreQ                      : Zuletzt geloeschten oder geaenderten\n"
  +"                                : Questeintrag restaurieren\n"
  +"  SetQ        <spieler> <quest> : Quest als 'geloest' markieren\n"
  +"  DelQ        <spieler> <quest> : Quest als 'nicht geloest' markieren\n"
  +"  QueryQ      <quest>           : Questeintrag anzeigen\n"
  +"  QueryK                        : Alle Keys und Indices anzeigen\n"
  +"  QueryAllQ                     : Alle Eintraege vollstaendig anzeigen\n"
  +"  ActiVateQ   <quest>           : Quest im Questmaster aktivieren\n"
  +"  DeactiVateQ <quest>           : Quest im Questmaster deaktivieren\n\n"
  +"  fuer <quest> kann der Index verwendet werden, den QueryK liefert!\n\n"
  +"  (Alle Kommandos koennen abgekuerzt werden.)\n"
	+"   -> Beispiel: DeactiVateQ == DVQ == dvq == deactivateq\n");

  SetProp(P_NEVERDROP, 1);
  SetProp(P_NODROP, 
  "Mit Hilfe des QuestTools koennen Quests eingetragen, oder geloescht\n"+
  "werden. Du brauchst es vielleicht noch, deshalb wirfst Du es nicht weg.\n");
  SetProp(P_NOBUY, 1);
  AddCmd(({ "AddQ", "addq", "AQ", "aq" }),                 "Add_Quest");
  AddCmd(({ "RemoveQ", "removeq", "RQ", "rq" }),           "Remove_Quest");
  AddCmd(({ "ChangeQ", "changeq", "CQ", "cq" }),           "Change_Quest");
  AddCmd(({ "ReStoreQ", "restoreq", "RSQ", "rsq" }),       "Restore_Quest");
  AddCmd(({ "SetQ", "setq", "SQ", "sq" }),                 "Set_Quest");
  AddCmd(({ "DelQ", "delq", "DQ", "dq" }),                 "Del_Quest");
  AddCmd(({ "QueryQ", "queryq", "QQ", "qq" }),             "Query_Quest");
  AddCmd(({ "QueryK", "queryk", "QK", "qk" }),             "Query_Keys");
  AddCmd(({ "QueryAllQ", "queryallq", "QAQ", "qaq" }),     "Query_Quests");
  AddCmd(({ "ActiVateQ", "activateq", "AVQ", "avq" }),     "ActivateQuest");
  AddCmd(({ "DeactiVateQ", "deactivateq", "DVQ", "dvq" }), "DeactivateQuest");
  counter = QM_NAME;
  savekey = "";
  do_change = 0;
  num_key = ([]);
}

int _query_autoloadobj() { return 1; }

void init()
{
  object tp;

  if(!(tp = PL) || tp != environment())
    return;

  thing::init();

  if ( !IS_WIZARD(tp) || tp != owner )
    return (void) call_out("do_remove",1);
}

static void do_remove()
{
  write ( name()+" zerfaellt zu Staub.\n");
  say ( name()+" zerfaellt in "+PL->name(WESSEN)+
       " unbefugten Haenden zu Staub.\n");
  call_out("remove",1);
}

private static void Load_NumKey()
{
  string *keys;
  int i;

  if ( !(keys = (string*) QM->QueryAllKeys()) ) return;
  for ( i = 0, num_key = ([]); i < sizeof(keys); i++ )
    num_key += ([(i+1)+"":keys[i]]);
}

int Add_Quest(string str)
{
  write ( "Neue Quest: (Abbruch mit '.' oder '~q')\n" );
  write ( "Key : " ); 
  input_to ( "ReadNewQuest" );
  return 1;
}

void ReadNewQuest (string str)
{
  mixed *oldquest;
  int errstat;
  int active;

  if ( str == "~q" || str == "." )
  {
    counter   = QM_NAME;
    if(do_change)
    {
      do_change = 0;
      changekey = "";
      savekey = "";
      savequest = ({});
    }
    return;
  }

  switch ( counter )
  {
    case QM_NAME:
      if((!str||!strlen(str)) && do_change)
	name = savekey;
      else
	name = str;
      counter++;
      write ( "Punkte (>0): " ); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_QP:
      if((!str||!strlen(str)) && do_change)
	qp = (int) savequest[QM_QP];
      else
	sscanf ( str, "%d", qp );
      counter++;
      write ( "Erfahrung (>=0): " ); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_XP: 
      if((!str||!strlen(str)) && do_change)
	xp = (int) savequest[QM_XP];
      else
	sscanf ( str, "%d", xp );
      counter++;
      write ( "Filenamen (file1,file2,... (ohne .c)): " ); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_ALLOW:
      if((!str||!strlen(str)) && do_change)
	allowed = (string *) savequest[QM_ALLOW];
      else
	allowed = explode ( str, "," );
      counter++;
      write ( "Info : " ); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_INFO:
      if((!str||!strlen(str)) && do_change)
	info = (string) savequest[QM_INFO];
      else
	info = str;
      counter++;
      write ( "Stufe (0<=lev<=20): " ); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_LEVEL:
      if((!str||!strlen(str)) && do_change)
	level = (int) savequest[QM_LEVEL];
      else
	sscanf ( str, "%d", level );
      counter++;
      write ( "Pflicht ([012]):\n"
	     +"0: Quest ist freiwillig, QP zaehlen zur Berechnung von max_QP\n"
	     +"1: Quest muss geloest werden (unabhaengig von der 80\%-Regel.\n"
	     +"   QP zaehlen zur Berechnung von max_QP.\n"
	     +"2: Quest ist freiwillig, QP zaehlen nicht zur Berechnung von max_QP.\n"); 
      input_to ( "ReadNewQuest" );
      break;
    case QM_NEED:
      if((!str||!strlen(str)) && do_change)
	need = (int) savequest[QM_NEED];
      else
	sscanf ( str, "%d", need );
      counter++;
      write ( "Magier : " );
      input_to ( "ReadNewQuest" );
      break;
    case 6: //Wiz??
      if((!str||!strlen(str)) && do_change)
	wizard = (string) savequest[QM_WIZ];
      else
	wizard = str;
      counter++;
      write("allgemeine Quest (0) oder Gildenquest (1)?\n");
      input_to( "ReadNewQuest" );
      break;
    case 7: // GildenQuest??
      if (!str||!strlen(str) && do_change)
	is_gq = to_int(savequest[QM_GUILD]);
      else
	is_gq = to_int(str);
      counter++;
      write ( "Eintragen (j/n)? " );
      input_to ( "ReadNewQuest" );
      break;
    case END:
      counter=QM_NAME;

      if ( str != "j" && str != "ja" && str != "y" && str != "yes" )
        return;

      active = 0;
      if ( do_change && changekey && strlen(changekey) )
      {
        oldquest = (mixed *) QM->QueryQuest ( changekey );

        if ( !pointerp ( oldquest ) || !sizeof ( oldquest ) )
        {
          write ( "Alten Eintrag nicht gefunden.\n" );
          return;
        }

        errstat = (int) QM->RemoveQuest( changekey );

	do_change = 0;
	changekey = "";

        switch ( errstat )
        {
          case  0: write ( "Zugriff auf alten Eintrag verweigert.\n" ); return;
          case -1: write ( "Parameterfehler beim Loeschen.\n" ); return;
          case -2: write ( "Alten Eintrag nicht gefunden.\n" ); return;
          default: write ( "Alter Eintrag geloescht.\n" );
        }
	active = oldquest[QM_ACTIVE];
	savequest = oldquest;
	savekey   = changekey;
      }

      // add new Quest deactivated by default and keep old active flag
      // if changing an existing entry
      errstat= (int)QM->AddQuest(name,qp,xp,allowed,info,level,need,active,
				 wizard,is_gq);

      switch ( errstat )
      {
        case  0: write ( "Zugriff verweigert.\n" ); break;
        case -1: write ( "Key ungueltig oder strlen(key) < 5.\n" ); break;
        case -2: write ( "QP ungueltig oder < 1.\n" ); break;
        case -3: write ( "XP ungueltig.\n" ); break;
        case -4: write ( "Filename(n) ungueltig.\n" ); break;
        case -5: write ( "Info ungueltig.\n" ); break;
	case -6: write ( "Stufe ungueltig oder < 0 oder > 20.\n" ); break;
        case -7: write ( "Aktiv-Flag < 0 oder > 1.\n" ); break;
        case -8: write ( "Magiername ungueltig.\n" ); break;
        default: write ( "Eintrag eingefuegt.\n" );
      }
    default:
      return;
  }
}

int Remove_Quest ( string str )
{
  mixed *oldquest;
  string newstr;
  int errstat;

  if ( !str || !stringp ( str ) )
  {
    write ( "Syntax: RemoveQ <name>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newstr = num_key[str+""]) )
    newstr = str;

  oldquest = (mixed *) QM->QueryQuest ( newstr );

  if ( !pointerp ( oldquest ) || !sizeof ( oldquest ) )
  {
    write ( "Keine Quest dieses Namens gefunden.\n" );
    return 1;
  }

  errstat = (int) QM->RemoveQuest( newstr );

  switch ( errstat )
  {
    case  0: write ( "Zugriff verweigert.\n" ); break;
    case -1: write ( "Parameterfehler.\n" ); break;
    case -2: write ( "Quest nicht gefunden.\n" ); break;
    default: write ( "Quest entfernt.\n" );
  }

  savequest = oldquest;
  savekey   = newstr;

  return 1;
}

int Change_Quest ( string str )
{
  mixed *oldquest;
  string newstr;

  if ( !str || !stringp ( str ) )
  {
    write ( "Syntax: ChangeQ <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newstr = num_key[str+""]) )
    newstr = str;

  oldquest = (mixed *) QM->QueryQuest ( newstr );

  if ( !pointerp( oldquest ) || !sizeof ( oldquest ) )
  {
    write ( "Keine Quest dieses Namens gefunden.\n" );
    return 1;
  }

  do_change = 1;
  changekey = newstr;
  savekey = newstr;
  savequest = oldquest;

  write ( "Aktueller Eintrag:\n");
  write ( "Key       : "+newstr+"\n" );
  write ( "Punkte    : "+oldquest[QM_QP]+"\n" );
  write ( "Erfahrung : "+oldquest[QM_XP]+"\n" );
  write ( "Filenamen : "+implode(oldquest[QM_ALLOW],",")+"\n" );
  write ( "Info      : "+oldquest[QM_INFO]+"\n" );
  write ( "Stufe     : "+oldquest[QM_LEVEL]+"\n" );
  write ( "Pflicht   : "+oldquest[QM_NEED]+"\n" );
  write ( "Magier    : "+capitalize(oldquest[QM_WIZ])+"\n" );

  write ( "\nNeue Quest:     (mit '.' oder '~q' kann abgebrochen werden)\n" );
  write ( "Key       : " );
  input_to ( "ReadNewQuest" );

  return 1;
}

int Restore_Quest ( string str )
{
  int errstat;

  if ( !savekey || !strlen(savekey) )
  {
    write ( "\nTut mir leid!\n" );
    write ( "Nichts zum Restaurieren gefunden ...\n" );
    return 1;
  }

  errstat = (int)QM->AddQuest( savekey, (int) savequest[QM_QP], 
			                (int) savequest[QM_XP],
			           (string *) savequest[QM_ALLOW], 
			             (string) savequest[QM_INFO],
			                (int) savequest[QM_LEVEL], 
			                (int) savequest[QM_NEED],
			             (string) savequest[QM_ACTIVE], 
			                (int) savequest[QM_WIZ],
                                     (string) savequest[QM_GUILD] );

  switch ( errstat )
  {
    case  0: write ( "Zugriff verweigert.\n" ); break;
    case -1: write ( "Key ungueltig oder strlen(key) < 5.\n" ); break;
    case -2: write ( "QP ungueltig oder < 1.\n" ); break;
    case -3: write ( "XP ungueltig.\n" ); break;
    case -4: write ( "Filename(n) ungueltig.\n" ); break;
    case -5: write ( "Info ungueltig.\n" ); break;
    case -6: write ( "Stufe ungueltig oder < 0 oder > 20.\n" ); break;
    case -7: write ( "Aktiv-Flag < 0 oder > 1.\n" ); break;
    case -8: write ( "Magiername ungueltig.\n" ); break;
    default: write ( "'"+savekey+"' restauriert.\n" );
  }
  savekey = "";
  return 1;
}

int Set_Quest ( string str )
{
  string quest, player, newquest;
  object ob;
  int errstat;

  if ( !stringp(str) || str=="" || sscanf( str, "%s %s", player, quest ) != 2 )
  {
    write ( "Syntax: SetQ <player> <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newquest = num_key[quest+""]) )
    newquest = quest;

  if ( ( ob = find_player ( player ) ) )
    errstat = (int) ob->GiveQuest ( newquest );
  else
    return 1;

  switch ( errstat )
  {
    case -1: write ( "Quest war bereits als 'geloest' markiert.\n" ); break;
    case -2: write ( "Questname ungueltig.\n" ); break;
    case -3: write ( "Unbefugter Zugriff.\n" ); break;
    case -4: write ( "Unbefugter Zugriff auf deaktivierte Quest.\n" ); break;
    case  1: write ( "Ok, Quest als 'geloest' markiert.\n" ); break;
    default: write ( "Unbekannter Fehler.\n" );
  }

  return 1;
}

int Del_Quest(string str) {
  string quest, player, newquest;
  object ob;
  int errstat;
  mixed tmp;

  if(!stringp(str) || !strlen(str) || sscanf(str, "%s %s", player, quest)!= 2) {
    write("Syntax: DelQ <player> <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if(!(newquest=num_key[quest+""]))
    newquest=quest;

  if(ob=find_player(player))
    errstat=ob->DeleteQuest(newquest);
  else
    return 1;

  switch(errstat) {
    case -1: 
      write("Quest war nicht als 'geloest' markiert.\n"); 
      break;
    case -2: 
      write("Quest ist nicht angemeldet.\n"); 
      break;
    case -3: 
      write("Unbefugter Zugriff.\n"); 
      break;
    case  1:
      write("Ok, Quest als 'nicht geloest' markiert.\n");
      tmp=QM->QueryQuest(newquest);
      if(!pointerp(tmp) || !sizeof(tmp)) {
	write("Achtung! Quest war nicht angemeldet.\n");
        write("XPs muessen per Hand zurueckgesetzt werden!\n");
      }
      break;
    default: 
      write ( "Unbekannter Fehler.\n" );
  }
  return 1;
}

int Query_Quest ( string str )
{
  mixed *quest;
  string newstr;
  int i;

  if ( !str || !stringp ( str ) )
  {
    write ( "Syntax: QueryQ <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newstr = num_key[str+""]) )
	newstr = str;

  quest = (mixed *) QM->QueryQuest( newstr );

  if ( !pointerp( quest ) || !sizeof ( quest ) )
  {
    write ( "Keine Quest dieses Namens gefunden.\n" );
    return 1;
  }

  write ( "Aktueller Eintrag:\n");
  write ( "Key       : "+newstr );
  if(quest[QM_ACTIVE])
    write (" (aktiviert)\n");
  else
    write (" (deaktiviert)\n");
  write ( "Punkte    : "+quest[QM_QP]+"\n" );
  write ( "Erfahrung : "+quest[QM_XP]+"\n" );
  write ( break_string ( implode( quest[QM_ALLOW], " " ), 78, "Filenamen : " ) );
  write ( break_string ( quest[QM_INFO], 78, "Info      : " ) );
  write ( "Stufe     : "+quest[QM_LEVEL]+"\n" );
  switch ( (int) quest[QM_NEED] )
  {
    case 0:
      write ( "Pflicht   : optional, zaehlt zu den "+QP_PERCENT+"%\n" );
      break;
    case 1:
      write ( "Pflicht   : zwingend, zaehlt zu den "+QP_PERCENT+"%\n" );
      break;
    case 2:
      write ( "Pflicht   : optional, zaehlt nicht zu den "+QP_PERCENT+"%\n" );
      break;
    default:
      write ( "Pflicht   : unbekannter Status\n" );
  }
  write ( "Magier    : "+capitalize(quest[QM_WIZ])+"\n" );
  write ( "GildenQuest: "+(quest[QM_GUILD]==0 ? "nein" : "ja")+"\n");
  return 1;
}

int Query_Keys ( string str )
{
  string *keys, active;
  mixed *quest;
  int i;

  if ( !(keys = (string *) QM->QueryAllKeys()) )
    return 1;

  write ( "\n" );
  for ( i = 0; i < sizeof(keys); i++ )
  {
    quest = (mixed *) QM->QueryQuest(keys[i]);
    if(quest[QM_NEED])
      active="*";
    else
      active=" ";
    write ( sprintf ( "(%2d) Key : %s %s\n", i+1, active,keys[i] ) );
  }

  return 1;
}

int Query_Quests ( string str )
{
  mixed *quest;
  string *keys, rstr;
  int i;

  if ( !(keys = (mixed *) QM->QueryAllKeys()) )
    return 1;

  for ( i = 0, rstr = ""; i < sizeof(keys); i++ )
  {
    quest = (mixed *) QM->QueryQuest(keys[i]);
    rstr += "\nKey         : "+keys[i];
    rstr += (quest[QM_ACTIVE]) ? " (aktiviert)\n" : " (deaktiviert)\n";
    rstr += "Punkte      : "+quest[QM_QP]+"\n" +
            "Erfahrung   : "+quest[QM_XP]+"\n" +
	       break_string ( implode( quest[QM_ALLOW], " " ), 78, 
            "Filenamen   : " ) +
	       break_string ( quest[QM_INFO], 78, 
	    "Info        : " ) +
	    "Stufe       : "+quest[QM_LEVEL]+"\n";
    
    switch ( (int) quest[QM_NEED] )
    {
      case 0:
        rstr += "Pflicht     : optional, zaehlt zu den "+QP_PERCENT+"%\n";
	break;
      case 1:
	rstr += "Pflicht     : zwingend, zaehlt zu den "+QP_PERCENT+"\%\n";
	break;
      case 2:
	rstr += "Pflicht     : optional, zaehlt nicht zu den "+QP_PERCENT+"%\n";
	break;
      default:
	rstr += "Pflicht     : unbekannter Status\n";
    }
    rstr += "Magier      : "+capitalize(quest[QM_WIZ])+"\n";  
    rstr += "Gildenquest : "+(quest[QM_GUILD]==0 ? "nein" : "ja")+"\n";
  }
  More( rstr, 0 );
  return 1;
}

int ActivateQuest( string str )
{
  mixed *quest;
  string newstr;
  int errstat;

  if ( !str || !stringp ( str ) )
  {
    write ( "Syntax: ActiVateQ <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newstr = num_key[str+""]) )
	newstr = str;

  switch( QM->SetActive( newstr, 1 ) )
  {
    case -3: write ( "Ungueltiger Flag.\n" ); break;
    case -2: write ( "Quest war bereits aktiviert.\n" ); break;
    case -1: write ( "Keine Quest dieses Namens gefunden.\n" ); break;
    case  0: write ( "Zugriff verweigert\n" ); break;
    case  1: write ( "Quest '"+newstr+"' aktiviert.\n" ); break;
    default: write ( "unbekannter Fehlerstatus.\n" );
  }
  return 1;
}

int DeactivateQuest( string str )
{
  mixed *quest;
  string newstr;
  int errstat;

  if ( !str || !stringp ( str ) )
  {
    write ( "Syntax: DeactiVateQ <quest>\n" );
    return 1;
  }

  Load_NumKey();

  if ( !(newstr = num_key[str+""]) )
	newstr = str;

  switch( QM->SetActive( newstr, 0 ) )
  {
    case -3: write ( "Ungueltiger Flag.\n" ); break;
    case -2: write ( "Quest war bereits deaktiviert.\n" ); break;
    case -1: write ( "Keine Quest dieses Namens gefunden.\n" ); break;
    case  0: write ( "Zugriff verweigert\n" ); break;
    case  1: write ( "Quest '"+newstr+"' deaktiviert.\n" ); break;
    default: write ( "unbekannter Fehlerstatus.\n" );
  }
  return 1;
}
