/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: details.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
0707070000010020651004000007630007220000010003010567626645200005400000026752/usr/mud/mudlib/obj/tools/roommaker/doors.c /* This file contents the functions necessary for to get doors and their paths
 *
 * Part of RoomMaker V0.96 (c) Sique 1/1993
 *
 * Author: Sique 1/93
 *
 * Last Update: Jan 20 1993
 */

static string *door;     /* contains the door commands */
static string *dpath;    /* contains the door paths */
static string *dshort;   /* contains the door short descriptions */ 
static mixed  *dlong;    /* contains the door long descriptions */
static string *dkey;     /* contains the key ids for the doors */
static int    *dstatus;  /* contains the door status */
static string *statlist; /* contains the possible door stats */

#include "/obj/tools/roommaker/roommaker.h"
static void getdshort();
static void getdlong();
static void getdkey();
static void getstatus(string str);
static void gotogetstatus();
mixed SetProp(string prop, mixed arg);

/* Configures the getstring() */

static void enter_door()
{
  SetLabel("prompt","Door #" + (sizeof(door)+1) + ": ");
  SetLabel("nostring","nodoor");
  SetLabel("ready","gotomenu");
  SetLabel("undo","gotomenu");
  SetLabel("redisplay","door_redisplay");
  SetLabel("delete","delete_door");
  SetLabel("save_file","normal_save_string");
  SetLabel("insert_string","insert_door");
  SetLabel("delete_return","gotogetstring");
  gotogetstring();
}

/* Shows all doors and asks which of then should be deleted */

static void delete_door()
{
  int i;
  if(!sizeof(door))
  {
    write("No doors are given.\n");
    return (void)call_other(this_object(),QueryLabel("delete_return"));
  }
  if(sizeof(door) == 1) write("This door is");
  else write("These doors are");
  write(" given:\n");
  for(i=0;i<sizeof(door);i++)
    write((i+1) + ". " + door[i] + " ... " + dpath[i] + ", \"" +
          dshort[i] + "\"\n");
  write("Which door should be deleted?\n");
  input_to("delete_door2");
}

/* This fun REALLY deletes the door #number */

static void delete_door_really(int number)
{
  write("Deleting " + door[number] + " ...\n");
  SetLabel("deleted_door",({door[number],dpath[number]}));
  door = door[0..number-1] + door[number+1..];
  dpath = dpath[0..number-1] + dpath[number+1..];
  dshort = dshort[0..number-1] + dshort[number+1..];
  dlong = dlong[0..number-1] + dlong[number+1..];
  dkey = dkey[0..number-1] + dkey[number+1..];
  dstatus = dstatus[0..number-1] + dstatus[number+1..];
  if(QueryLabel("delete_return") == "gotogetstring")
    SetLabel("prompt","Door #" + (sizeof(door)+1) + ": ");
}

/* Tries to delete the given door */

static void delete_door2(string str)
{
  int number;                   /* number of the given door */
  if(sscanf(str,"%d",number) && number <= sizeof(door))
  {
    delete_door_really(number-1);
    return (void)call_other(this_object(),QueryLabel("delete_return"));
  }
  number = (member_array(str,door));
  if(number == -1)
  {
    write("There is no door named " + str + "!\n");
    return (void)call_other(this_object(),QueryLabel("delete_return"));
  }
  delete_door_really(number);
  return (void)call_other(this_object(),QueryLabel("delete_return"));
}

/* Shows all door commands and his paths */

static void door_redisplay()
{
  int i;
  if(!sizeof(door))
  {
    write("No doors are given.\ndoor #1: ");
    input_to("getstring");
    return;
  }
  if(sizeof(door) == 1) write("This door is");
  else write("These doors are");
  write(" given:\n");
  for(i=0;i<sizeof(door);i++)
    write(door[i] + " ... " + dpath[i] + ", \"" + dshort[i] + "\"\n");
  gotogetstring();
}

/* If the player doesn't enter anything to getstring() (str == "") this fun
 * prints out an error message and returns to getstring()
 */

static void nodoor()
{
  write("Every door need a name. Please enter them!\n");
  gotogetstring();
}

/* Configures getstring() for to take the path */

static void getdpath()
{
  SetLabel("prompt","Path #" + sizeof(dpath) + ": ");
  SetLabel("nostring","nodpath");
  SetLabel("ready","nodpath");
  SetLabel("undo","nodpath");
  SetLabel("redisplay","door_redisplay2");
  SetLabel("delete","delete_door");
  SetLabel("save_file","door_save");
  SetLabel("insert_string","insert_door2");
  gotogetstring();
}

/* If an door command str already exists the fun asks for overwrite permission
 * If str doesn't exists yet, the fun stores string str in string *door and
 * sets the associated path to "<no path>". Asks for the path.
 */

static void insert_door(string str)
{
  int i;

  switch(str) {
  case "n": str = "north"; break;
  case "s": str = "south"; break;
  case "e": str = "east"; break;
  case "w": str = "west"; break;
  case "u": str = "up"; break;
  case "d": str = "down"; break;
  }
  i = member_array(str,door);
  SetLabel("door",str);
  if(i != -1)
  {
    write("We have already an door named " + str + "!\n");
    write(door[i] + " ... " + dpath[i] + ", \"" + dshort[i] + "\"\n");
    write("Do you want to overwrite them? (y/n) ");
    input_to("double_door");
    return;
  }
  door += ({str});
  dpath += ({"<no path>"});
  dshort += ({"<no description>"});
  dlong += ({({"<It's a door without any description.>"})});
  dkey += ({"0"});
  dstatus += ({0});
  return getdpath();
}

/* If the player doesn't enter anything to getstring() (str == "") or he tried
 * to end the enter_door()-loop, this fun prints out an error message and
 * returns to getstring()
 */

static void nodpath()
{
  write("Every door needs a path. Please enter them!\n");
  gotogetstring();
}

/* If the last door was already in the string *door we asked the player for
 * overwrite access. Now we look at his answer...
 */

static void double_door(string str)
{
  if(str == "y")
  {
    insert_alist(QueryLabel("door"),door);
    return getdpath();
  }
  if(str == "n") return enter_door();
  write("Do you want to overwrite them?? (y/n) ");
  input_to("double_door");
}

/* This fun shows a list of all given doors and his paths and returns to
 * getstring()
 */

static void door_redisplay2()
{
  int i;
  string dummy;
  dummy = dpath[member_array(QueryLabel("door"),door)];
  dpath[member_array(QueryLabel("door"),door)] = "<no path>";
  if(sizeof(door) == 1) write("This door is");
  else write("These doors are");
  write(" given:\n");
  for(i=0;i<sizeof(door);i++)
    write(door[i] + " ... " + dpath[i] + ", \"" + dshort[i] + "\"\n");
  dpath[member_array(QueryLabel("door"),door)] = dummy;
  gotogetstring();
}

/* This fun prevents a writing of the actual file without a senseful path to
 * the at last given door
 */

static void door_save()
{
  write("You can't save. The door needs a path!\n");
  gotogetstring();
}

/* T