/*******************
** Eldarea MUDLib **
********************
**
** /obj/tools/vk.c - versionskontrolltool
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** Dieses Tool erlaubt ueber die erqd-Schnittstelle das Ausfuehren von 
** CVS oder RCS Befehlen
**
** CVS History
**
** $Log:$
**
**
*/
 
#pragma strict_types
 
#include <properties.h>
#include <moving.h>
#include <wizlevels.h>
#include <erq.h>

#include "./vk.h"
 
inherit "std/secure_thing";

// Need to know these in callback function
static object user;
static string lastcmd;

nomask static int secure()
{
  if ( !this_player()
    || !IS_WIZARD(this_player())
    || !this_interactive()
    || this_player()!=this_interactive() )
    return FALSE;
  return TRUE;
}
   
nomask void create()
{
  if(!clonep(this_object())) return;
  if (!secure())
  {
    remove(); 
    return;
  }
  ::create();

  SetProp(P_PLURAL, "");
  SetProp(P_ARTICLE, 0);
  SetProp(P_NAME,"VK-Tool "+VERSION);
  SetProp(P_LONG,
   "Das ist das Versionskontrolltool (vk) "+VERSION+". Eine Uebersicht der "
   "Befehle gibt es mit 'hilfe vk'.");
  SetProp(P_NODROP, "Das moegt Ihr nicht ablegen.\n");
  SetProp(P_NOSELL, "Das moegt Ihr nicht verkaufen.\n");
  SetProp(P_NEVERDROP, 1);
  SetProp(P_GENDER, NEUTER);
  AddId(({"Tool","\nversion","version","vk","vktool","tool","versionstool"}));
  SetProp(P_WEIGHT, 0);
  SetProp(P_VALUE, 0);

  AddCmd("hilfe","cmdHelp");

#ifdef RCS
  AddCmd("rcs","cmdRCS");
#endif
#ifdef CVS
  AddCmd("cvs","cmdCVS");
#endif

}

nomask void init()
{
  if (!secure())
  {
    remove();
    return;
  }
  ::init();
  user=this_player();
  return;
}

nomask int remove()
{
  if (!::remove())
  {
    destruct(this_object());
    if (this_object())
      return FALSE;
  }
  return TRUE;
}

nomask public int cmdHelp(string str)
{
  if (!secure())
    return FALSE;

  switch (str)
  {
    case "vk":
      HEAD("Allgemeine Hilfe");
      printf(break_string(
        "Das Versionskontrolltool ermoeglicht den Zugriff auf CVS oder RCS "
        "auf dem Mudrechner, je nach dem welches System verwendet wird. "
        "Hilfe zu den Versionskontrollsystemen gibt es mit 'hilfe rcs|cvs', "
        "mehr Infos zu diesem Tool gibt es mit 'hilfe vkinfo'." ));
      FOOT;
      break;
    case "vkinfo":
      HEAD("Informationen ueber das VK-Tool");
      printf(break_string(
        "Das VK-Tool wurde urspruenglich von Cirion@Silberland entwickelt. "
        "Dies ist Version "VERSION+" vom "DATE". Sie wird momentan gepflegt "
        "von "+capitalize(MAINTAINER)+". Das VK-Tool ermoeglicht den "
        "Zugriff auf die Versionskontrollsysteme RCS und CVS ueber den "
        "erq-Daemon (external request daemon). Es ist zur Nutzung "
        "freigegeben, solange Hinweise auf den Ursprung des Tools erhalten "
        "bleiben. Bug Reports moegen bitte an Cirion@Silberland geschickt "
        "werden. Eine komplette Versionsgeschichte kann mit 'hilfe vkhist' "
        "eingesehen werden." ));
      FOOT;
      break;
    case "vkhist":
      HEAD("VK-Tool version history");
      printf(VHIST);
      FOOT;
      break;
    case "rcs":
      HEAD("RCS");
#ifdef RCS
      printf(break_string(
        "RCS-Hilfe."));
#else
      printf("RCS ist in dieser Version des Tools deaktiviert.\n");
#endif
      FOOT;
      break;
    case "cvs":
      HEAD("CVS");
#ifdef CVS
      printf(break_string(
        "CVS-Hilfe."));
#else
      printf("CVS ist in dieser Version des Tools deaktiviert.\n");
#endif
      FOOT;
      break;
    default:
      return FALSE;
      break;
  }
  return TRUE;
}

#ifdef RCS
nomask public int cmdRCS(string str)
{
  string resfile;

  if (!secure())
    return FALSE;

  if (!str)
    str="";

  lastcmd="rcs "+str;
  
  send_erq(ERQ_EXECUTE,
           "ls",
           #'erq_call_back);

  return TRUE;
}
#endif

#ifdef CVS
nomask public int cmdCVS(string str)
{
  string resfile;

  if (!secure())
    return FALSE;

  if (!str)
    str="";

  lastcmd="cvs "+str;
  resfile=sprintf("players/%s/.vkres",getuid(user));
  if (file_size(resfile))
    rm(resfile);

  send_erq(ERQ_EXECUTE,
           str/*sprintf("cvs %s > ./%s",str,resfile)*/,
           #'erq_call_back);

  return TRUE;
}
#endif

nomask void erq_call_back(int * response_data, int len)
{
  string res,resfile;
  int i;

  tell_object(user,sprintf("%O %O\n",response_data, len));
/*
  resfile=sprintf("players/%s/.vkres",getuid(user));

  if (!file_size(resfile))
  { // wait one cycle
    call_out("erq_call_back",2,response_data,len);
    return;
  }

  res=read_file(resfile);
  //rm(resfile);
 
  DB(sprintf("%O",response_data));  

  if (!res || res == "")
  {
    tell_object(user,"CMD "+lastcmd+" failed to produce output.\n");
    return;
  }

  tell_object(user,res);*/
  return;
}