/*******************
** Eldarea MUDLib **
********************
**
** obj/tools/xtool - the x tool
**
** CVS DATA
** $Date: 2001/08/21 11:53:28 $
** $Revision: 1.5 $
**
** CVS History
**
** $Log: xtool.c,v $
** Revision 1.5  2001/08/21 11:53:28  eldarea
** replaced literal characters 0x01, 0x02, 0x03
**
** Revision 1.4  2001/02/06 08:57:54  elatar
** applied strong_types requirements
**
** Revision 1.3  2000/12/19 17:57:12  elatar
** Fix of wrong move() redefinition
**
** Revision 1.2  2000/12/19 17:51:36  elatar
** inherits std/secure_thing
**
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
*/

/*------------------------------------------*/
/* the original Xtool is copyrighted by Hyp */
/*------------------------------------------*/

#pragma strict_types

inherit "std/secure_thing";

#include <properties.h>
#if !defined(QUERYCACHED)
#define QUERYCACHED 4096
#endif
#if !defined (SETCACHED)
#define SETCACHED 4096
#endif
#include <moving.h>
#include "/secure/wizlevels.h"
#include "/secure/config.h"
#include <userinfo.h>
#include <defines.h>

#include "xtool/tool.h"

#include "xtool/toollib.h"

#define XDBG 1

static object  cloner;
static object  msgto=NULL;
static string *manpath=({TOOL_PATH+"/man.d/",
			 "/doc/efun/",
			 "/doc/lfun/",
			 "/doc/w/",
			 "/doc/helpdir/",
			 "/doc/LPC/",
			 "/doc/std/",
			 "/doc/concepts/",
			 ""});
static string  morefile=NULL;
static string *scriptline=NULL;
static string *history=allocate(MAX_HISTORY);
static int     moreflag=FALSE;
static int     moreoffset=1;
static int     term=NULL;
static int     scriptsize=NULL;
static int     nostore=FALSE;
static int     xlight=0;
static int     pipe_in=FALSE;
static int     pipe_out=FALSE;
static int     pipe_ovr=TRUE;
static string  pipe_if=NULL;
static string  pipe_of=NULL;
static int     xtk=FALSE;
static mixed  *variable=({({}),({})});
static string *cmds;
private static mapping line_buffer=([]);
private static string line_buffer_name="";
private static string more_searchexpr="";
int    morelines=MORE_LINES;
int    modi=(MODE_FIRST|MODE_PROTECT|MODE_SHORT);

#include "xtool/toollib.c"
#include "xtool/toolcmd.c"
#include "xtool/wlcmds.c"

#define SafeReturn(x) \
{ \
  cmds=({}); \
  pipe_in=FALSE; \
  pipe_of=NULL; \
  pipe_ovr=TRUE; \
  pipe_out=FALSE; \
  pipe_of=NULL; \
  return (x); \
}

/*----------------------------------------------------------------------
 * check some security aspects
 */

int security()
{
  object prev;
  
  if(prev=PREV)
  {
//    if(!cloner)   *** Wozu?   Fini 12/98 ***
//      return TRUE;
//    if(getuid(prev)==ROOTID||IS_ARCH(prev))
//       return TRUE;
    if(prev==ME) return TRUE;
    return getuid(prev)==getuid()&&geteuid(prev)==geteuid()&&cloner==RTP
        &&getuid(cloner)==getuid();
        // *** Abfrage uid(cloner)==uid neu Fini 12/98 ***
  }
  else
    return cloner==NULL;
}

/*----------------------------------------------------------------------
 * own write function
 */

int Write(string str)
{
  if(!str||str=="")
    return FALSE;
  if(!cloner)
    write(str);
  else
    tell_object(cloner, str);
  return TRUE;
}

/*----------------------------------------------------------------------
 * own command function
 */

int Command(string str)
{
  int i;
  TK("Command: str: "+(str?str:"(NULL)"));
  nostore++;
  if(MODE(MODE_ECHO))
    WLN("Doing: "+str);
  i=(int)cloner->command_me(str);
  nostore--;
  return i;
}

/*----------------------------------------------------------------------
 * object searching
 */

object XFindObj(string str)
{
  object obj, env;
  string *strs;
  int i, s, cnt;
  
  if(!str)
    return NULL;
  TK("XFindObj: str: "+(str?str:"(NULL)"));
  env=ENV(cloner);
  str=string_replace(str, "\\.", "\001");
  str=string_replace(str, "\\^", "\002");
  str=string_replace(str, "\\$", "\003");
  str=string_replace(str, "\\\\", "\\");
  s=sizeof(strs=strip_explode(str, "."));
  while(s--)
  {
/*    if(strs[i]=="m"||strs[i]=="me")
**      strs[i]=RNAME(cloner);
**    else if(strs[i]=="h"||strs[i]=="here")
**      strs[i]=file_name(ENV(cloner));
** Was soll der Scheiss denn? :-(   Fiona */
    if(obj=FindObj(strs[i++], env))
      env=obj;
    else
      break;
  }
  return obj;
}

varargs object FindObj(string str, object env)
{
  object obj, *inv;
  string tmp;
  int num, e;
  
  if(!(str&&env))
    return NULL;
  str=string_replace(str, "\001", ".");
  while(str[e++]=='^')
    ;
  str=SUBSTR(str, --e, -1);
  str=string_replace(str, "\002", "^");
  if(obj=VarToObj(str))
    ;
  else if(str[0]=='\003')
    str=string_replace(str, "\003", "$");
  else if(sscanf(str, "%d", num)&&(inv=all_inventory(env)))
  {
    if(num>0&&num<=sizeof(inv))
      obj=inv[num-1];
    else
    {
      WDLN("Specified object number out of range [1-"+sizeof(inv)+"]");
      return NULL;
    }
  }
  if(obj||(obj=present(str, env))||
     (obj=find_player(LOWER(str)))||
     (obj=find_living(str))||
     (obj=find_object(long_path(str))))
  {
    while(e--)
    {
      if(!(obj=ENV(obj)))
      {
	W("Specified object has no environment [");
	while(e--)
	  W("^");
	WDLN(str+"]");
	return NULL;
      }
    }
  }
  else
    WDLN("Specified object does not exist ["+str+"]");
  return obj;
}

/*----------------------------------------------------------------------
 * object variable handling
 */

object VarToObj(string str)
{
  if(!(str&&str[0]=='$'))
    return NULL;
  switch(str)
  {
    case "$m":
    case "$me":
    return cloner;
    case "$h":
    case "$here":
    return ENV(cloner);
    default:
    return assoc(SUBSTR(str, 1, -1), variable);
  }
}

string VarToFile(string str)
{
  return source_file_name(VarToObj(str));
}

string VarToPureFile(string str)
{
  return pure_file_name(VarToObj(str));
}

/*----------------------------------------------------------------------
 * object description printing
 */

void PrintObj(object obj, string file)
{
  object item, tmp;
  string str;
  int i;

  SECURE1();
  if(!obj)
    return;
  PrintShort("Xlook: ", obj, file);
  if(!file||file=="")
    WLN("Long :");
  else
    write_file(file,"Long :\n");
  if(query_once_interactive(obj))
    str=capitalize(getuid(obj));
  else
  {
    if(str=(string)obj->QueryProp(P_INT_LONG)) ;
    else if(str=(string)obj->QueryProp(P_LONG)) ;
    else str="- no long description -";
  }
  if (str[<1]!='\n') str+="\n";
  if(!file||file=="")
    W(str);
  else
    write_file(file,str);
  FORALL(item, obj)
  {
    if(!i)
      if(!file||file=="")
        WLN("Content:");
      else
	write_file(file,"Content:\n");
    PrintShort(ARIGHT(++i+". ", 4, " "), item, file);
  }
}

string ObjFile(object obj)
{
  return "["+short_path(file_name(obj))+"]";
}

void PrintShort(string pre, object obj, string file)
{
  string str;
  int i;

  SECURE1();
  if(!obj)
    return;
  if(MODE(MODE_SHORT))
  {
    if (query_once_interactive(obj))
      str=capitalize(getuid(obj));
    else
    {
      if(!((str=(string)obj->QueryProp(P_INT_SHORT))||
           (str=(string)obj->name(WER, NAME_INDEF|NAME_DESCR))))
	if(is_player(obj))
	  str=CRNAME(obj)+" (invisible)";
	else
	  str="- invisible -";
    }
    str=ALEFT(str+" ", 34, ".")+" ";
  }
  else
    str="";
  if(interactive(obj))
    str+="i";
  else if(living(obj))
    str+="l";
  else
    str+=".";
  str+=(shadow(obj, 0) ? "s" : ".");
  str=pre+CAP(str)+" "+ObjFile(obj);
  i=strlen(str);
  if (i>77)
    str=str[0..76]+sprintf("%s%=-*s", sprintf("%*s", 40+strlen(pre), ""),
      37-strlen(pre), str[77..]);
  if(!file||file=="")
    WLN(str);
  else
    write_file(file,str+"\n");
}

void DeepPrintShort(object env, int indent, string pre, string file)
{
  int i;
  object item;
  string str;
  
  SECURE1();
  if(!env)
    return;
  for(i=indent,str=""; i--; str+="  ");
  if(pre)
    str+=pre;
  if(!file||file=="")
    W(str);
  else
    write_file(file,str);
  i++;
  PrintShort("",env,file);
  FORALL(item, env)
    DeepPrintShort(item,indent+1,ARIGHT((++i)+". ",4," "),file);
}

string break_string_hard(string str, int len, string pre)
{
  int s,p,t;
  string tmp;

  if(!str||!(s=strlen(str)))
    return "";
  t=len-(p=strlen(pre))-1;

  tmp="";
  while(p+s>len)
  {
    tmp+=pre+str[0..t]+"\n";
	str=str[t+1..];
	s-=t;
  }
  if(strlen(str))
    tmp+=pre+str[0..]+"\n";
  return tmp;
}
  
void dprop(string key, mixed data, object obj)
{
  if(pipe_out&&pipe_of)
    write_file(pipe_of,break_string_hard(mixed_to_string(obj->QueryProp(key),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
  else
    W(break_string_hard(mixed_to_string(obj->QueryProp(key),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
}

string propflags(string key, object ob)
{
  int tmp;
  string *flags;
  tmp=(int)ob->Query(key,1);
  flags=({});
  tmp&SAVE ?           flags+=({"SAV"}) : flags+=({"   "});
  tmp&PROTECTED ?      flags+=({"PRO"}) : flags+=({"   "});
  tmp&SECURED ?        flags+=({"SEC"}) : flags+=({"   "});
  tmp&NOSETMETHOD ?    flags+=({"NSM"}) : flags+=({"   "});
  tmp&SETMNOTFOUND ?   flags+=({"SMN"}) : flags+=({"   "});
  tmp&QUERYMNOTFOUND ? flags+=({"QMN"}) : flags+=({"   "});
  tmp&QUERYCACHED ?    flags+=({"QCA"}) : flags+=({"   "});
  tmp&SETCACHED ?      flags+=({"SCA"}) : flags+=({"   "});
  return ""+implode(flags,"|");
}

void dprop2(string key, mixed data, object ob)
{
  if(pipe_out&&pipe_of)
    write_file(pipe_of,break_string_hard(mixed_to_string(propflags(key,ob),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
  else
    W(break_string_hard(mixed_to_string(propflags(key,ob),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
}

mixed propmethods(string key, object ob)
{
  return (mixed)ob->Query(key,2);
}

void dprop3(string key, mixed data, object ob)
{
  if(pipe_out&&pipe_of)
    write_file(pipe_of,break_string_hard(mixed_to_string(propmethods(key,ob),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
  else
    W(break_string_hard(mixed_to_string(propmethods(key,ob),MAX_RECURSION),78,ALEFT(key+" ",18,".")+" = "));
}

void DumpProperties(object obj, int flag)
{
  SECURE1();
  if(!obj)
    return;
  PIPE_DELETE(pipe_of);
  switch (flag) {
    case 0:
      walk_mapping(((mapping *)(obj->__query_properties()))[0],#'dprop,obj); //')
      break;
    case 1:
      walk_mapping(((mapping *)(obj->__query_properties()))[0],#'dprop2,obj); //')
      break;
    case 2:
      walk_mapping(((mapping *)(obj->__query_properties()))[0],#'dprop3,obj); //')
      break;
  }
}

/*----------------------------------------------------------------------
 * moving objects
 */

// Fiona: Erweitert um angebbare opt
int MoveObj(object obj1, object obj2, int silent, int opt)
{
  int err;
  object oldenv;

  SECURE2(FALSE);
  if(!(obj1&&obj2))
    return FALSE;
  oldenv=ENV(obj1);
  err=(int)obj1->move(obj2, opt);
  if(!silent)
    switch(err)
    {
      case ME_PLAYER:
      WDLN("Object returned ME_PLAYER");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_TOO_HEAVY:
      WDLN("Object returned ME_TOO_HEAVY");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_CANT_TPORT_IN:
      WDLN("Object returned ME_CANT_TPORT_IN");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_CANT_TPORT_OUT:
      WDLN("Object returned ME_CANT_TPORT_OUT");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_CANT_BE_DROPPED: // Fiona: weitere Fehlermeldungen
      WDLN("Object returned ME_CANT_BE_DROPPED");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_CANT_BE_TAKEN:
      WDLN("Object returned ME_CANT_BE_TAKEN");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_CANT_BE_INSERTED:
      WDLN("Object returned ME_CANT_BE_INSERTED");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case ME_TOO_BULKY:
      WDLN("Object returned ME_TOO_BULKY");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
      case MOVE_OK:
	  WDLN("Object returned MOVE_OK");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return TRUE;
      case MOVE_OK_SILENT:
	  WDLN("Object returned MOVE_OK_SILENT");
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return TRUE;
      default:
      WDLN(sprintf("Object returned unknown return value (%O)",err));
      if(oldenv && oldenv != ENV(obj1))
	WDLN("Object has been moved");
      else WDLN("Object has not been moved");
      return FALSE;
    }
  return TRUE;
}

/*----------------------------------------------------------------------
 * save destructing of objects
 */

void Destruct(object obj)
{
  if(!obj)
    return;
  catch(obj->remove());
  if(objectp(obj) && obj && !query_once_interactive(obj))
    destruct(obj);
}

void DeepClean(object obj)
{
  if(!obj)
    return;
  filter_array(filter_array(deep_inventory(obj), "is_not_player", ME),
	       "Destruct", ME);
  if(is_not_player(obj))
    Destruct(obj);
}

/*----------------------------------------------------------------------
 * Show the inheritance tree of objects
 */

object *SubNodes(object obj)
{
  int s;
  object *objs;
  string *inlist;
  
  if(!obj)
    return NULL;
  inlist=inherit_list(obj);
  s=sizeof(inlist);
  objs=({});
  while(s-->1)
    objs=({find_object(inlist[s])})+objs;
  return objs;
}

void Inheritance(object obj, string func, string pre)
{
  int i, s;
  object *ln;
  string str;
  
  if(!obj)
    return;
  str=pre+" "+ObjFile(obj);
  if(func)
  {
    str=ALEFT(str+" ", 50, ".");
    if(function_exists(func, obj)==file_name(obj))
      str+=ARIGHT(" "+func, 19, ".");
    else
      str+=ARIGHT("", 19, ".");
  }
  if(pipe_out&&pipe_of)
    write_file(pipe_of,str+"\n");
  else
    WLN(str);
  ln=SubNodes(obj);
  for(i=0; i<sizeof(ln); i++)
    ln=ln-SubNodes(ln[i]);
  s=sizeof(ln);
  for(i=0; i<s; i++)
    Inheritance(ln[i], func, pre+".....");
}

/*----------------------------------------------------------------------
 * file name handling
 */

string XFile(string file)
{
  TK("XFile: file: "+(file?file:"(NULL)"));
  if(file)
    switch(file[0])
    {
      case '@':
	return source_file_name(XFindObj(SUBSTR(file, 1, -1)));
      case '$':
	return source_file_name(XFindObj(file));
      default:
	return explode(long_path(file),"#")[0];
    }
  return NULL;
}

string XFindFile(string file)
{
  TK("XFindFile: file: "+(file?file:"(NULL)"));
  if(file=XFile(file))
  {
    if(file_size(file)>=0)
      return file;
    if(SUBSTR(file, -3, -1)!=".c"&&file_size(file+".c")>0)
      return file+".c";
  }
  WDLN("File not found or not readable ["+short_path(file)+"]");
  return NULL;
}

/*----------------------------------------------------------------------
 * file printing, searching and executing
 */

void XMoreFile(string file, int flag)
{
  int s,size;
  
  SECURE1();
  if(!file)
    return;
  
  // term=(string)cloner->QueryProp(P_TTY)!="dumb";
  if((size=(file_size(morefile=long_path(file))))>0)
  {
    if(size>100000)
      WDLN("Warning: large file");
    MoreFile(NULL);
  }
  else if(flag)
    WDLN("Cannot read file");
}

string read_buffer(string filename, int start, int number)
{
  mixed tmp;
  string result;
  int current;

  if(!filename||filename=="")
    return "";
  if(number<=1)
    number=1;
  number--;
  result="";
  if(filename!=line_buffer_name)
  {
    // TK("read_buffer: initializing");
    line_buffer=([]);
    line_buffer_name=filename;
    current=0;
  }
  else
    current=start;

  while(current<=start+number && stringp((tmp=load_buffer(current++))))
    if(current>=start)
      result+=tmp;
  return result;
}

string load_buffer(int line)
{
  int i, current, start, length, *idx;

  if(intp(line_buffer[line]))
  {
    // TK("load_buffer: Notfound: "+line);
    current=line;
    while(current>0&&intp(line_buffer[--current]));
    for(i=current;i<=line;i++)
    {
      // TK("load_buffer: trying: "+i);
      if(i>0)
        idx=line_buffer[i-1];
      else
        idx=({0,0});
      length=read_line((start=idx[0]+idx[1]));
      // TK("load_buffer: "+start+"/"+length);
      line_buffer[i]=({start,length});
    }
  }
  idx=line_buffer[line];
  return
    read_bytes(line_buffer_name,idx[0],idx[1]);
}

int read_line(int offset)
{
  mixed loc_buf;
  int length, pos;

  // TK("read_line: "+offset);
  length=0;
  while(!intp((loc_buf=read_bytes(line_buffer_name,offset+length,1024))))
  {
    if((pos=member(loc_buf,'\n'))>=0)
      return length+pos+1;
    length+=1024;
  }
  return length;
}

void MoreFile(string str)
{
  int i, off;
  string f, l, r;
  
  SECURE1();
  if(str)
  {
    if(term)
      W("M[1M");
    switch(str[0])
    {
      case 'q':
      case 'x':
      moreflag=FALSE;
      moreoffset=1;
      if(morefile==TMP_FILE||morefile==PIPE_FILE)
	rm(morefile);
      return NULL;
      break;
      case 'P':
      case 'U':
      moreflag=FALSE;
      moreoffset=moreoffset-morelines;
      case 'p':
      case 'u':
      moreoffset=moreoffset-2*morelines;
      break;
      case 'D':
      case 'N':
      moreoffset+=morelines;
      case 0:   /* RETURN */
      case 'd':
      if(moreflag)
      {
	moreflag=FALSE;
	moreoffset=1;
	if(morefile==TMP_FILE)
	  rm(morefile);
	return;
      }
      break;
      case '/':
      moreoffset--;
      more_searchexpr=SUBSTR(str, 1, -1);
      case 'n':
      i=moreoffset-morelines+1;
      if(more_searchexpr=="")
      {
        WDLN("No previous regular expression");
        return;
      }
      if(!regexp(({"dummy"}), more_searchexpr))
	WDLN("Bad regular expression");
      else
	while((l=read_file(morefile, i++, 1))&&
              !sizeof(regexp(({l}), more_searchexpr)))
	  ;
      if(l)
      {
	WLN("*** Skipping ...");
	moreoffset=i-1;
      }
      else
      {
	WLN("*** Pattern not found");
	moreoffset-=morelines;
      }
      break;
      case '0'..'9':
      sscanf(str, "%d", i);
      moreoffset=i;
      break;
    }
  }
  else
  {
    moreoffset=1;
    moreflag=FALSE;
  }
  if(moreoffset<1)
    moreoffset=1;
  if(CatFile())
    W("*** More: q,u,U,d,D,/<regexp>,<line> ["+(moreoffset-1)+"] *** ");
  else
  {
    W("*** More: q,u,U,d,D,/<regexp>,<line> ["+(moreoffset-1)+"=EOF] *** ");
    moreflag=TRUE;
  }
  input_to("MoreFile");
  return;
}

int CatFile()
{
  int end;
  string l;
  
  end=moreoffset+morelines;
  while(moreoffset<end)
    if((l=read_file(morefile, moreoffset, 1))!="")
    {
      moreoffset++;
      if (stringp(l) && l[<1]!='\n') l+="\n";  // Neu (Fini)
      W(l);
    }
    else
      return FALSE;
  l=read_file(morefile, moreoffset+1, 1);
  if (stringp(l) && l!="")  // Test auf stringp neu (Fini)
    return TRUE;
  else
    return FALSE;
}

int XGrepFile(string pat, string file, int mode)
{
  int i, j, f, s;
  string tfile, *tmp, *ts, t;
  
  SECURE2(FALSE);
  TK("XGrepFile: pat: "+pat+" file: "+file+" mode: "+mode);
  if(!(pat&&file))
    return FALSE;
  tfile=TMP_FILE;
  for(i=1,f=0; t=read_file(file, i, 200); i+=200)
    if(s=sizeof(tmp=strip_explode(t,"\n")))
    {
      for(j=0;j<s;j++)
      {
	if(sizeof(ts=regexp(({(mode&XGREP_ICASE?lower_case(tmp[j]):tmp[j])}),pat)))
	{
	  if(!(mode&XGREP_REVERT))
	   {
	     if(!f++)
	       write_file(tfile, "*** File: "+file+" ***\n");
	     write_file(tfile, tmp[j]+"\n");
	   }
	}
	else if(mode&XGREP_REVERT)
	{
	  if(!f++)
	    write_file(tfile, "*** File: "+file+" ***\n");
          write_file(tfile, tmp[j]+"\n");
	}
      }
    }
  return TRUE;
}

void XExecFile(int line)
{
  int i;
  
  if(!scriptline)
    return;
  for(i=line; i<scriptsize&&i<line+EXEC_LINES; i++)
  {
    if(!scriptline[i])
      continue;
    if(!Command(scriptline[i]))
    {
      scriptline=NULL;
      return;
    }
  }
  if(i<scriptsize)
    call_out("XExecFile", EXEC_TIME, i);
  else
    scriptline=NULL;
}

void XmtpScript(string dir, string file, string opt)
{
  int s, t;
  string *files;
  
  s=sizeof(files=get_dir(dir+"/*"));
  while(s--)
  {
    t=strlen(files[s])-1;
    if(files[s] == ".." || files[s] == "." || files[s][t] == '~' ||
       (files[s][0] == '#' && files[s][t] == '#'))
      continue;
    if(file_size(dir+"/"+files[s])==-2)
    {
      write_file(file, "mkdir "+files[s]+" ; cd "+files[s]+"\n");
      XmtpScript(dir+"/"+files[s], file, opt);
      write_file(file, "cd ..\n");
    }
    else
      write_file(file, "mtp -r "+opt+" "+dir+"/"+files[s]+"\n");
  }
}

/*----------------------------------------------------------------------
 *  player properties handling
 */

string PlayerIdle(object obj)
{
  string str;
  int i, tmp;
  
  if(!obj)
    return NULL;
  if((i=query_idle(obj))>=60)
  {
    str=ARIGHT(""+(i/3600), 2, "0");
    i-=(i/3600)*3600;
    str+="'"+ARIGHT(""+(i/60), 2, "0");
  }
  else
    str=".....";
  return str;
}

string PlayerAge(object obj)
{
  string str;
  int i, tmp;
  
  if(!obj)
    return NULL;
  i=(int)obj->QueryProp(P_AGE);
  str=" "+ARIGHT(""+(i/43200), 3, ".");
  i-=(i/43200)*43200;
  return str+":"+ARIGHT(""+(i/1800), 2, "0");
}

string crname(object who)
{
  string uid, lname;

  if((uid=getuid(who))==ROOTID && 
     file_name(who)[0..7]=="/secure/" &&
     (lname=(string)who->loginname()))
    return CAP(lname);
  return CAP(uid);
}

string PlayerWho(object obj)
{
  object tmp;
  string str, stmp;
  
  str=ARIGHT(""+LEVEL(obj)  ,  3, " ");
  str+=ALEFT(" "+crname(obj)+" ", 12, ".");
  str+=PlayerAge(obj);
  str+=((int)obj->QueryProp(P_GENDER)==1 ? " m " : " f ");
  str+=(obj->QueryProp(P_FROG))  ? "f" : ".";
  str+=(obj->QueryProp(P_GHOST)) ? "g" : ".";
  str+=(obj->QueryProp(P_INVIS)) ? "i" : ".";
  str+=(query_editing(obj)||query_input_pending(obj) ? "e" : ".");
  str+=(obj->QueryProp(P_AWAY))  ? "a" : ".";
  str+=" "+PlayerIdle(obj)+" ";
  str+=(tmp=ENV(obj)) ? ObjFile(tmp) : "- fabric of space -";
  return str;
}

string PlayerMail(object obj, int flag)
{
  string pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  return pre+"mail: "+obj->QueryProp(P_MAILADDR);
}

string PlayerIP(object obj, int flag)
{
  string pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  return pre+"host: "+query_ip_name(obj)+" ("+query_ip_number(obj)+")";
}

string PlayerRace(object obj, int flag)
{
  string tmp, pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  pre=pre+"race: "+ALEFT(obj->QueryProp(P_RACE)+" ", 10, ".")+" guild: ";
  tmp=(string)obj->QueryProp(P_GUILD);
  return tmp ? pre+tmp : pre+"- none -";
}

string PlayerDomain(object obj, int flag)
{
  int i, s;
  mixed *uinfo;
  string *domains, pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  pre+="domainlord of: ";
  uinfo=(mixed*)MASTER->get_userinfo(getuid(obj));
  if(uinfo&&(domains=uinfo[3])&&(s=sizeof(domains)))
  {
    for(i=0; i<s; i++)
    {
      pre += CAP(domains[i]);
      if(i<s-1)
	pre += ", ";
    }
  }
  return pre;
}

string PlayerStats(object obj, int flag)
{
  string pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  pre+="hp="+ARIGHT(obj->QueryProp(P_HP), 3, "0");
  pre+="/"+ARIGHT(obj->QueryProp(P_MAX_HP), 3, "0");
  pre+=" sp="+ARIGHT(obj->QueryProp(P_SP), 3, "0");
  pre+="/"+ARIGHT(obj->QueryProp(P_MAX_SP), 3, "0");
  pre+=" food="+ARIGHT(obj->QueryProp(P_FOOD), 3, "0");
  pre+="/"+ARIGHT(obj->QueryProp(P_MAX_FOOD), 3, "0");
  pre+=" drink="+ARIGHT(obj->QueryProp(P_DRINK), 3, "0");
  pre+="/"+ARIGHT(obj->QueryProp(P_MAX_DRINK), 3, "0");
  pre+=" exps="+obj->QueryProp(P_XP);
  return pre;
}

string PlayerSnoop(object obj, int flag)
{
  string tmp, pre;
  object victim;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  pre=pre+"is snooped by: ";
  if(victim=query_snoop(obj))
    pre+=ARIGHT(" "+crname(victim), 12, ".");
  else
    pre+="............";
  return pre;
}

string PlayerCmdAvg(object obj, int flag)
{
  string pre;
  
  pre=(flag) ? ALEFT(crname(obj)+" ", 12, ".")+" " : "";
  return pre+"cmdavg: "+(int)obj->_query_command_average();
}


/*----------------------------------------------------------------------
 * msg input to objects
 */

void XMsgSay(string str)
{
  if(str=="."||str=="**")
  {
    WLN("[End of message]");
    say("[End of message]\n");
  }
  else
  {
    say(str+"\n");
    input_to("XMsgSay");
  }
}

void XMsgTell(string str)
{
  if(str=="."||str=="**")
  {
    WLN("[End of message]");
    tell_object(msgto, "[End of message]\n");
  }
  else
  {
    tell_object(msgto, str+"\n");
    input_to("XMsgTell");
  }
}

void XMsgShout(string str)
{
  if(str=="."||str=="**")
  {
    WLN("[End of message]");
    shout("[End of message]\n");
  }
  else
  {
    shout(str+"\n");
    input_to("XMsgShout");
  }
}

/*----------------------------------------------------------------------
 * object id
 */
int id(string str)
{
  int i;
  if(!security()&&MODE(MODE_SCANCHK)&&RTP&&!IS_ARCH(RTP))
    WDLN(crname(RTP)+" scanned you (id) ["+query_verb()+"] "+
	 (PREV ? ObjFile(PREV) : "[destructed object]"));
  str=LOWER(str);
  if (cloner) i=(int)cloner->my_inv_nr(this_object());
  return str==LOWER(TOOL_NAME) || i && str=="i"+i;
}

/*----------------------------------------------------------------------
 * short and long description
 */

string name()
{
  if(cloner)
  {
    if((!security())&&MODE(MODE_SCANCHK)&&!IS_ARCH(RTP))
      WDLN(crname(RTP)+" scanned you (short) ["+query_verb()+"] "+
	   (PREV ? ObjFile(PREV) : "[destructed object]"));
    return cloner->name(WESSEN)+" "+TOOL_TITLE+" ["+
      SUBSTR(ctime(time()), 11, 18)+"]";
  }
  return TOOL_TITLE;
}

string long()
{
  return _query_long();
}

string _query_long()
{
  if(cloner&&!security()&&MODE(MODE_SCANCHK)&&!IS_ARCH(RTP))
  {
    WDLN(crname(RTP)+" scanned you (long) ["+query_verb()+"] "+
	 (PREV ? ObjFile(PREV) : "[destructed object]"));
  }
  return 
    "This is "+TOOL_NAME+" version "+TOOL_VERSION+
    " (maintained by Kirk@MorgenGrauen)\n"+
    "Copyright of original sources by Hyp.\n"+
    "Gamedriver patchlevel: "+__VERSION__+" master object: "+__MASTER_OBJECT__+
    "\n\nDo 'xhelp' for more information.\n";
}

mixed* _query_ids() {
  return ({LOWER(TOOL_NAME)});
}

/*----------------------------------------------------------------------
 * light stuff
 */

int _query_light()
{
  return xlight;
}

int _set_light(int x)
{
  return xlight;
}

/*----------------------------------------------------------------------
 * Autoloading
 */

mixed *_query_autoloadobj()
{
  return AUTOLOAD_ARGS;
}

void _set_autoloadobj(mixed *args)
{
  WLN(TOOL_TITLE+" ...");
  if(!pointerp(args))
    ;
  else if(sizeof(args)<3) // Fiona
    ;
  else if(!stringp(args[0]))
    ;
  else if(!intp(args[1]))
    ;
  else if(!intp(args[2]))
    ;
  else
  {
    if((string)args[0]!=TOOL_INTERNAL)
    {
      WLN("*****************************");
      WLN("***      NEW EDITION      ***");
      WLN("***  do 'xtool news' for  ***");
      WLN("***   more information    ***");
      WLN("*****************************");
    }
	if (intp(args[1]) && intp(args[2])) { // Fiona
      modi=(int)args[1];
      morelines=(int)args[2];
      return;
	}
  }
  W("(bad autoload, using default)\n");
}

/*----------------------------------------------------------------------
 * creation, updating and initialization stuff
 */

void update_tool(mixed *args, object obj)
{
  SECURE1();
  if(!(obj&&args))
    return;
  Destruct(PREV);
  _set_autoloadobj(args);
  move(obj);
}

void create()
{
  object obj;

  if (!clonep())
    return;
  ::create();
  
  if(member_array('#', file_name())<0)
    return;
  if(!cloner&&!((cloner=TP)||(cloner=environment()))&&!interactive(cloner))
    destruct(ME);
  if(!IS_LEARNER(cloner))
    destruct(ME);
  SetProp(P_PLURAL, "");
  SetProp(P_NODROP,"Das waere zu gefaehrlich.\n");
  SetProp(P_NEVERDROP,1);
  SetProp(P_NOBUY,1);
  if(file_size(SAVE_FILE+".o")>0)
  {
    WDLN("Loading "+TOOL_TITLE+" settings");
    restore_object(SAVE_FILE);
  }
  if(MODE(MODE_FIRST))
    call_out("move",0,cloner);
  cloner->AddPursuer(ME); // 'movement-hook'
  call_out("add_insert_hook",1,ME);
}

void TK(string str)
{
  object obj;

  if (!xtk)
    return;
  tell_object(cloner,"XTOOL: "+str+"\n");
}

int Xtk(string str)
{
  xtk=!xtk;
  WDLN("Xtool internal tracing "+(xtk?"enabled":"disabled"));
  return TRUE;
}

void add_insert_hook(object obj)
{
  if(objectp(obj))
    cloner->AddInsertHook(obj);
}

int PreventFollow(object x)
{
  if(MODE(MODE_FIRST))
    move(cloner);
  return 1;
}

void init()
{
  object first, prev;
  
  if(member_array('#', file_name())<0) return;
  first=first_inventory(ENV(ME));
  if(MODE(MODE_PROTECT)&&is_player(first)&&!IS_ARCH(first))
  {
    WDLN("WARNING: "+crname(first)+" tried to move into your inventory");
    tell_object(first, "You cannot move yourself into "+
		crname(cloner)+"'s inventory.\n");
    call_out("DropObj",0,first);
    return;
  }
  else if(MODE(MODE_FIRST)&&first!=ME)
    move(cloner);
  else actions();
}

void DropObj(object obj)
{
  if(!obj||!objectp(obj))
    return;
  obj->move(ENV(cloner),M_NOCHECK|M_NO_SHOW);
}

#define ACTIONS\
([\
  "xcallo"    : "Xcallouts";0;1,\
  "xcallouts" : "Xcallouts";0;1,\
  "xcall"     : "Xcall";0;1,\
  "xcat"      : "Xcat";1;1,\
  "xcd"       : "Xcd";0;0,\
  "cd"        : "cd_snoop";0;0,\
  "xcle"      : "Xclean";0;0,\
  "xclo"      : "Xclone";0;0,\
  "xuclo"     : "Xuclone";0;0,\
  "xcm"       : "Xcmds";0;1,\
  "xdb"       : "Xdbg";0;0,\
  "xdc"       : "Xdclean";0;0,\
  "xdd"       : "Xddes";0;0,\
  "xde"       : "Xdes";0;0,\
  "xdl"       : "Xdlook";0;1,\
  "xdo"       : "Xdo";0;0,\
  "xdu"       : "Xdupdate";0;0,\
  "xec"       : "Xecho";0;0,\
  "xev"       : "Xeval";0;1,\
  "xfo"       : "Xforall";0;0,\
  "xgo"       : "Xgoto";0;0,\
  "xhb"       : "Xhbeats";0;1,\
  "xgr"       : "Xgrep";1;1,\
  "xhead"     : "Xhead";1;1,\
  "xhe"       : "Xhelp";0;0,\
  "xi"        : "Xinventory";0;1,\
  "xid"       : "Xids";0;0,\
  "xids"      : "Xids";0;0,\
  "xinf"      : "Xinfo";0;0,\
  "xinfo"     : "Xinfo";0;0,\
  "xinh"      : "Xinherit";0;1,\
  "xinherit"  : "Xinherit";0;1,\
  "xlag"      : "Xlag";0;0,\
  "xli"       : "Xlight";0;0,\
  "xloa"      : "Xload";0;0,\
  "xloo"      : "Xlook";0;1,\
  "xlp"       : "Xlpc";0;0,\
  "xma"       : "Xman";0;0,\
  "xmor"      : "Xmore";1;0,\
  "xmov"      : "Xmove";0;0,\
  "xms"       : "Xmsg";1;0,\
  "xmt"       : "Xmtp";0;0,\
  "xproc"     : "Xproc";0;1,\
  "xprof"     : "Xprof";0;0,\
  "xprop"     : "Xprops";0;1,\
  "xquit"     : "Xquit";0;0,\
  "xsc"       : "Xscan";0;0,\
  "xse"       : "Xset";0;0,\
  "xsh"       : "Xsh";0;0,\
  "xso"       : "Xsort";1;1,\
  "xta"       : "Xtail";1;1,\
  "xtk"       : "Xtk";0;0,\
  "xto"       : "Xtool";0;0,\
  "xtrac"     : "Xtrace";0;0,\
  "xtran"     : "Xtrans";0;0,\
  "xup"       : "Xupdate";0;0,\
  "xwc"       : "Xwc";1;0,\
  "xwh"       : "Xwho";0;1,\
  ])

string PrepareLine(string str)
{
  return str;
}

string QuoteLine(string str)
{
  string *tmp,*tmp2;
  int i, i2, len, len2, qd, qs;

  str=string_replace(str,"\\\\","BSHL");
  str=string_replace(str,"\\\"","DBLQ");
  str=string_replace(str,"\\\'","SGLQ");
  str=string_replace(str,"\\|","PIPE");
  str=string_replace(str,"||","OROR");
  str=string_replace(str,"->","LARR");
  str=string_replace(str,"\\$","DOLR");
  tmp=regexplode(str,"(\"|')");
  len=sizeof(tmp);
  qd=qs=0;
  for(i=0;i<len;i++)
  {
    if(i%2)
    {
      if(tmp[i]=="'")
        qd=(!qs?!qd:qd);
      else
        qs=(!qd?!qs:qs);
      if((tmp[i]=="\""&&!qd)||(tmp[i]=="'"&&!qs))
        tmp[i]="";
    }
    else
    {
      if(!qd)
      {
	len2=sizeof(tmp2=regexplode(tmp[i],"\\$[^ ][^ ]*"));
	for(i2=0;i2<len2;i2++)
          if(i2%2)
          {
	    TK("QuoteLine: "+tmp2[i2][0..]);
	    tmp2[i2]=(string)XFindObj((tmp2[i2])[0..]);
		// Oben beide letzte Indizes auf [0..] geaendert... Fiona
          }
	tmp[i]=implode(tmp2,"");
      }
    }
  }
  if(qd||qs)
    return NULL;
  str=implode(tmp,"");
  TK("QuoteLine: str: "+str);
  return str;
}

string UnquoteLine(string str)
{
  str=string_replace(str,"BSHL","\\");
  str=string_replace(str,"DBLQ","\"");
  str=string_replace(str,"SGLQ","\'");
  str=string_replace(str,"DQUO","");
  str=string_replace(str,"SQUO","");
  str=string_replace(str,"PIPE","|");
  str=string_replace(str,"OROR","||");
  str=string_replace(str,"LARR","->");
  str=string_replace(str,"DOLR","$");
  TK("UnquoteLine: str: "+str);
  return str;
}

string *ExplodeCmds(string str)
{
  string *tmp;
  
  tmp=regexplode(str,"\\||>|>>");
  while(tmp[<1]=="")
    tmp=tmp[0..<2];
  return tmp;
}

int ParseLine(string str)
{
  string verb, arg;
  int ret;
  
  TK("ParseLine: str: "+(str?str:""));
  if(!sizeof(cmds))
  {
    // this is a single command or beginning of a command pipe
    verb=query_verb();

    // return on unknown commands
    if(!verb||!strlen(verb)||!GetFunc(verb,TRUE))
      return FALSE;

    // str=(string)this_player()->_unparsed_args();  // Fiona
    pipe_in=FALSE;
    pipe_of=NULL;
    pipe_ovr=TRUE;
    pipe_out=FALSE;
    pipe_of=NULL;
    // pass arguments to some special functions unparsed 
    if(member(({"xlpc","xcall","xeval","xev","xeva","xlp"}),verb)>=0) // Fiona
    {
#ifdef XDBG
      TK("ParseLine: special func: "+verb);
#endif
      ret=CallFunc(verb,str);
      SafeReturn(ret);
    }
    // ok, here we go
    pipe_in=pipe_out=FALSE;
    pipe_if=pipe_of=NULL;
    pipe_ovr=TRUE;
    if(file_size(PIPE_FILE)>=0)
      rm(PIPE_FILE);
    if (str&&str!="")     
    {
      if(!(str=QuoteLine(str)))
      {
        WDLN("Unterminated quotation");
        SafeReturn(TRUE);
      }
      cmds=ExplodeCmds(str);
    }
    else
      cmds=({""});
    arg=strip_string(cmds[0]);
  }
  else
  {
    cmds[0]=strip_string(cmds[0]);
    TK("ParseLine: cmds[0]: "+cmds[0]);
    if(sscanf(cmds[0],"%s %s",verb,arg)!=2)
    {
      verb=cmds[0];
      arg="";
    }
  }
  cmds=cmds[1..];
  TK("ParseLine: verb: "+verb);
  if (!verb||!strlen(verb)||!GetFunc(verb,TRUE))
    SafeReturn(FALSE);
  TK("ParseLine(1): arg: "+arg+" cmds: "+sprintf("%O",cmds));
  switch(sizeof(cmds))
  {
    case 0:
    ret=CallFunc(verb,strip_string(UnquoteLine(arg)));
    SafeReturn(ret);
    break;
    
    case 1:
    WDLN("Missing rhs of command pipe");
    SafeReturn(TRUE);
    break;
    
    default:
    pipe_out=TRUE;
    switch(cmds[0])
    {
      case "|":
      pipe_of=PIPE_FILE;
      pipe_ovr=TRUE;
      cmds=cmds[1..];
      break;
      
      case ">":
      pipe_ovr=TRUE;
      if(sizeof(cmds)!=2)
      {
	WDLN("Illegal IO redirection");
	SafeReturn(TRUE);
      }
      pipe_of=cmds[1];
      cmds=({});
      break;
      
      case ">>":
      pipe_ovr=FALSE;
      if(sizeof(cmds)!=2)
      {
	WDLN("Illegal IO redirection");
	SafeReturn(TRUE);
      }
      pipe_of=cmds[1];
      cmds=({});
      break;
    }
  }
  TK("ParseLine(2): arg: "+arg+" cmds: "+sprintf("%O",cmds));
  if(!CallFunc(verb,strip_string(arg)))
    SafeReturn(FALSE);
  pipe_in=pipe_out;
  pipe_if=pipe_of;
  pipe_ovr=FALSE;
  pipe_out=FALSE;
  pipe_of=NULL;
  if(sizeof(cmds))
    call_out("ParseLine",0);
  else
    SafeReturn(TRUE);
  return TRUE;
}

int CallFunc(string verb, string str)
{
  string fun;

  fun=GetFunc(verb,FALSE);
#ifdef XDBG
  TK("CallFunc: verb: "+verb+" str: "+str);
  TK("CallFunc: resolved function: "+(fun?fun:"(unresolved)"));
#endif
  if(str=="")
    str=NULL;
  return fun?(int)call_other(ME,fun,str):FALSE;
}

string GetFunc(string verb, int test)
{
  string fun,*keys,key;
  int i;

  TK("GetFunc: verb: "+verb);
  if (!(fun=(string)ACTIONS[verb,0]))
    for (i=sizeof(keys=m_indices(ACTIONS))-1;i>=0;i--)
    {
      if (keys[i]==verb[0..strlen(keys[i])-1])
      {
        fun=ACTIONS[keys[i],0];
	key=keys[i];
        break;
      }
    }
  else
    key=verb;

  if(test)
    return fun;
  
  if (key)
  {
#ifdef XDBG
    TK("GetFunc: fun: "+fun+" (key: "+key+")\n"+
       "pipe_in: "+(pipe_in?"TRUE  ":"FALSE ")+(pipe_if?pipe_if:"(NULL)")+"\n"+
       "pipe_out: "+(pipe_out?"TRUE  ":"FALSE ")+(pipe_of?pipe_of:"(NULL)")+"\n"+
       "pipe_ovr: "+(pipe_ovr?"TRUE":"FALSE"));
#endif
    if (pipe_in&&!ACTIONS[key,PIPE_IN])
    {
      // this command does not read pipes
      notify_fail("Illegal rhs of command pipe \""+fun+"\"\n");
      return 0;
    }
    else if (pipe_out&&!ACTIONS[key,PIPE_OUT])
    {
      // this command does not feed pipes
      notify_fail("Illegal lhs of command pipe \""+fun+"\"\n");
      return 0;
    }
  }
  return fun;
}

void actions()
{
  if (!cloner||!RTP||cloner==RTP||query_wiz_level(cloner)<=query_wiz_level(RTP))
    add_action("ParseLine","",1);
  add_action("CommandScan", "", 1);
}

/*----------------------------------------------------------------------
 *  the checking stuff
 */

void InsertNotify(object obj)
{
  /*TODO: reimplement
  if(!cloner)
    return;
  if(MODE(MODE_FIRST))
    call_out("move",0,cloner);
  if(MODE(MODE_INVCHECK))
    write_newinvobj(obj);
  */
}

void VarCheck(int show)
{
  int i, s;
  
  for(i=0, s=sizeof(variable[0]); i<s; i++)
  {
    if(variable[1][i]) continue;
    if(show) WDLN("*** Variable $"+variable[0][i]+" has been destructed");
    variable=remove_alist(variable[0][i], variable);
    i--;s--;
  }
}


int write_newinvobj(object obj)
{
  if(obj) WDLN("*** New object in inventory "+ObjFile(obj));
}

/*----------------------------------------------------------------------
 *  catch all commands, absorb forces and check history
 */

int CommandScan(string arg)
{
  string verb, cmd;
  object rtp;
  rtp=RTP;

  if(!cloner&&!(cloner=rtp)) destruct(ME);

  if((!MODE(MODE_PROTECT))||security()||
     query_wiz_level(cloner)<query_wiz_level(rtp))
  {
    verb=query_verb();
    if(verb&&DoHistory(verb+(arg ? " "+arg : "")))
      return TRUE;
    nostore=FALSE;
    return FALSE;
  }
  else
  {
    if(rtp)
    {
      WDLN("Your "+TOOL_TITLE+" protects you from a force by "+crname(rtp)+
	   " ["+query_verb()+(arg ? " "+arg+"]" : "]"));
      tell_object(rtp, crname(cloner)+"'s "+TOOL_TITLE+
		  " absorbes your force.\n");
    }
    else
    {
      WDLN("Your "+TOOL_TITLE+" protects you from a force ["+
	   query_verb()+(arg ? " "+arg+"]" : "]"));
    }
    return TRUE;
  }
}

int DoHistory(string line)
{
  int i;
  string cmd, *strs;
  
  SECURE2(FALSE);
  if(!line)
    return TRUE;
  else if(line=="%!")
  {
    WLN("Current command history:");
    for(i=MAX_HISTORY; i; --i)
      if(history[i-1])
      {
	W(" "+ARIGHT(""+i, 2, " ")+": ");
	if(strlen(history[i-1])>70)
	  WLN(ALEFT(history[i-1], 70, " "));
	else
	  WLN(history[i-1]);
      }
    return TRUE;
  }
  else if(SUBSTR(line, 0, 1)=="%%"&&(cmd=history[0]+SUBSTR(line, 2, -1)))
  {
    Command(cmd);
    return TRUE;
  }
  else if(line[0]=='^'&&(strs=strip_explode(line, "^")))
  {
    if(sizeof(strs)&&strs[0]&&(cmd=history[0]))
    {
      if(sizeof(strs)==2)
	cmd=string_replace(cmd, strs[0], strs[1]);
      else
	cmd=string_replace(cmd, strs[0], "");
      nostore--;
      Command(cmd);
      nostore++;
      return TRUE;
    }
  }
  else if(line[0]=='%'&&(sscanf(SUBSTR(line, 1, -1), "%d", i)))
  {
    i= i>0 ? i : 1;
    i= i<=MAX_HISTORY ? i : MAX_HISTORY;
    if(cmd=history[i-1])
      Command(cmd);
    return TRUE;
  }
  else if(line[0]=='%')
  {
    for(i=0; i<MAX_HISTORY; i++)
    {
      if(history[i]&&
	 SUBSTR(history[i], 0, strlen(line)-2)==SUBSTR(line, 1, -1))
      {
	Command(history[i]);
	return TRUE;
      }
    }
  }
  else if(nostore<1)
    history=({line})+history[0..MAX_HISTORY-2];
  return FALSE;
}

