/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: troy_spells.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// OBJ/TROY_SPELLS.C - Spells von Troy (Ruestung)
//
// Based on MorgenGrauen Mudlib
// 
// Autoren: Troy & Andara & Arachna
/*
 * $Date: 1999/11/05 12:30:44 $
 * $Revision: 1.1.1.1 $
 * $Log: troy_spells.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:44  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:10  en
 * MUDLib CVS Preperation
 *
 * Revision 1.7  1998/07/02 15:00:42  Holger
 * MK-Spellbook Pfad geaendert
 *
 * Revision 1.6  1998/06/10 18:31:54  Holger
 * Bugfix bei Troyruestung
 *
 * Revision 1.5  1998/06/01 14:21:00  Holger
 * _cast_troyruestung() eingebaut, da 'ruestung' der ABG anders als 
 * 'ruestung' aus der Alice-Quest behandelt wird 
 * (als 'troyruestung' angemeldet!)
 *
 * Revision 1.4  1997/03/24 15:47:47  Bongo
 * Added function remove()
 *
 * Revision 1.3  1997/03/24 15:43:22  Bongo
 * Bug fixes
 *
 * Revision 1.2  1997/02/12 12:40:03  Bongo
 * Zusammenarbeit mit dem Spellbook der Magiekundigen verbessert
 *
 * Revision 1.1  1996/11/04 10:45:57  Bongo
 * Initial revision
 *
 * Revision 1.1  1995/04/17  20:32:32  Andara
 * Initial revision
 *
 */

/* troy_spells enthaelt ein Beispiel fuer einen Zeitabhaengigen Spell
 * - create: loescht alle noch existierenden call_out's und setzt 
 *           armour auf ([])
 * - _cast_ruestung:
 *   wird aufgerufen, wenn Spieler magische Ruestung haben will,
 *   wenn Spieler dies darf, wird er in das mapping 'ruestung'
 *   aufgenommen, die maximale Zeit gesetzt, und (falls noch kein
 *   call_out laeuft) ein call_out der Funktion "_weaken" gestartet
 * - _weaken
 *   mapping armour wird nach Spielern durchsucht, die ihre Zeit
 *   ueberschritten haben, ausserdem wird die Zeit bis zum nachsten
 *   call_out ermittelt
 *   Ist kein Player mehr im Mapping armour vorhanden, wird der call_out
 *   removed.
 * - Es ist immer nur EIN call_out aktiv (wenn ueberhaupt)
 *
 * Anmeldung bei SkillMaster:
 *  AddSkill("ruestung", "Fuer eine kurze Zeit verbessert sich deine Ruestung auf magische Weise",
 *    300, 12, 18, 8, "int", 60, "magic", "/obj/troy_spells.c", 0, "")
 */

#include <living/skills.h>
#include <language.h>
#include <properties.h>
#include "/std/sys_debug.h"

#define SPELLBOOK "/gilden/magiekundige/spells/spellbook"

int min_call_out;

/* Struktur: ([ nameofprotected : ({ time_till_end, old_ac }) ]) */
mapping armour;
int tmp;

create()
{
  while(remove_call_out("_weaken")!=-1);
  seteuid(getuid(this_object()));
  armour=([]);
  min_call_out = 10;
}

int ArmourTimeOut(object aprotected, int tm)
{
  int tmp;
  if ((tmp=armour[aprotected][0]) <= tm) return 1;
  if ((tmp-tm)<min_call_out) min_call_out = tmp-tm;
  return 0;
}

void WeakProtected(object aprotected)
{
  if (!member(armour,aprotected)) return;
  if(aprotected)
    tell_object(aprotected, "Deine magische Ruestung loest sich auf.\n");
  aprotected->SetProp(P_BODY, armour[aprotected][1] );
  armour = m_delete(armour, aprotected);

// Eintrag fuer die Abfrage der aktuellen Sprueche der Magiekundigen
  SPELLBOOK->delete_spell(aprotected, "ruestung");
}

_weaken()
{
  mapping to_weak;
  int tm;
  min_call_out = 100;

  tm = time();
  to_weak = filter_mapping(armour, #'ArmourTimeOut, tm);
  walk_mapping(to_weak, #'WeakProtected);
  if (!sizeof(armour))
  {
    while(remove_call_out("_weaken")!=-1);
    min_call_out = 10;
  }
  else
    call_out("_weaken", min_call_out+1);
} 

_cast_ruestung(object Player, mixed Arguments)
{
  int dauer,oldac,newac,con, promill, i;
  string ret;
  if (armour[Player])
  {
    write("Du traegst bereits eine magische Ruestung.\n");
    return 1;
  }

  if ((ret=SPELLBOOK->shield(Player)) && ret!="")
  {
    write(ret);
    return FEHLER;
  }

  if(tmp==0) 
    promill=Player->GetProbability("ruestung");
  if(tmp==1) 
    promill=Player->GetProbability("troyruestung");
  tmp=0;

  if (random(1000)>promill)
    return MISSERFOLG;

  write("Du fuehlst Dich ploetzlich viel besser geschuetzt.\n");
  dauer = ((con=Player->QueryAttribute(A_CON))>30 ? 30 : con) + random(promill/50);
  oldac = Player->QueryProp(P_BODY);
  newac = oldac + random(3*Player->QueryAttribute(A_DEX)/2) + 3/2*Player->QueryAttribute(A_DEX);
  Player->SetProp(P_BODY,newac);
  if (!sizeof(armour))
    call_out("_weaken", min_call_out); 
  armour += ([ Player : ({time()+dauer, oldac}) ]);
 
// Eintrag fuer die Abfrage der aktuellen Sprueche der Magiekundigen
  SPELLBOOK->save_spell(Player, "ruestung"); 

  return ERFOLG;
}

// Fuer Scroll aus der Herzquest! als anderer skill angemeldet!
_cast_troyruestung(object Player, mixed Arguments) {
  tmp=1;
  return _cast_ruestung(Player, Arguments);
}

int remove()
{
  walk_mapping(armour, #'WeakProtected);
}
