/*******************
** Eldarea MUDLib **
********************
**
** obj/vertrag.c - avatarvertrag
**
** CVS DATA
** $Date: 2000/12/04 15:28:47 $
** $Revision: 1.2 $
**
** CVS History
**
** $Log: vertrag.c,v $
** Revision 1.2  2000/12/04 15:28:47  elatar
** prelimary changes
**
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/thing";

#include <properties.h>
#include <wizlevels.h>
#include <defines.h>

string inhalt();

int gelesen;
string unterschrieben;

void create() {
    if (!geteuid(this_object()))
        call_out("remove",0);
    if (!IS_WIZARD(geteuid(this_object())))
        call_out("remove",0);
    if (!clonep())
      return;

    ::create();

    SetProp(P_PLURAL,
      "Avatar-Vertraege");
    SetProp(P_LONG,
      "Dies ist eine Rolle feinste, weissen Papiers, welche auf eine schmale "
      "Spindel aus einem hellen Holz gewickelt ist. Als Ihr sie ein wenig "
      "abrollt, koennt Ihr die edel geschwungenen Lettern aus dunkelblauer "
      "Tinte lesen: AVATAR-VERTRAG . Darunter folgt ein langer Text, den ");
    SetProp(P_NAME,
      "Avatar-Vertrag");
    SetProp(P_GENDER, MALE);
    SetProp(P_ARTICLE, 1);
    SetProp(P_SMELL,
      "Die Schriftrolle riecht ein wenig nach seidigem Papier und Holz.");
    SetProp(P_READ_MSG, #'inhalt);
    AddId(({"vertrag","avatarvertrag","rolle","papierrolle",
      "schriftrolle"}),({"vertraege","magiervertrage","rollen",
      "schriftrollen"}));

    AddDetail(({"seidenpapier","papier"}),
      "Die Rolle besteht aus feinstem, weissen Seidenpapier.");
    AddDetail(({"buchstaben","buchstabe","text","vertragstext","lettern"}),
      "Edel geschwungene Lettern sind mit dunkelblauer Tinte auf die "
      "Schriftrolle geschrieben. Ihr koennt sie lesen");

    AddCmd("unterschreibe|unterzeichne|unterschreib&vertrag|magiervertrag",
        "sign", "Was wollt Ihr unterschreiben?");
}

string long()
{
    string s;

    s="Ihr ";
    if (gelesen)
      s+="vielleicht noch einmal ";
    s+="lesen solltet.\nDieser Vertrag wurde Euch von "+
       capitalize(geteuid(this_object()))+" ueberreicht. Wenn ihr ihn "
       "unterschreibt, wird "+capitalize(geteuid(this_object()))+" Euer "
       "Meister.\n";
    if (unterschrieben)
        s+="Ihr habt ihn unterschrieben.\n";
    return ::long()+s;
}

string inhalt()
{
    gelesen=1;
    PL->More("/doc/help_w/avatargesetz", 1);
    return "";
}

int sign()
{
     if(PL != this_interactive() || PL != environment())
        return 0;
     if(!gelesen)
     {
         write(break_string("Ihr koennt diesen Vertrag erst unterschreiben, "
                            "wenn Ihr ihn gelesen habt."));
         return 1;
     }
     if(unterschrieben==getuid(environment()))
     {
       write("Ihr habt den Vertrag bereits unterschrieben!\n");
       return 1;
     }
     write(break_string("Ihr unterschreibt den Vertrag. Wenn Ihr Euch doch "
                        "anders entscheidet, werft ihn einfach weg."));
     unterschrieben=getuid(environment());
     log_file("VERTRAG", dtime(time())[5..]+": "+capitalize(unterschrieben)+
       " hat den Avatarvertrag unterschrieben.\n");
     AddId("unterschriebenvertrag");
     return 1;
}

void init()
{
  ::init();
  if (environment() && !interactive(environment()))
    call_out("remove",0);
  if ( unterschrieben && getuid(environment())!=unterschrieben
    && getuid(environment())!=geteuid(this_object()))
    call_out("remove",0);
}

int remove()
{
  if (environment())
  {
    if (interactive(environment()))
    {
      tell_object(environment(),break_string(
        "Die Schriftrolle verschwindet mit einem kurzen blauen Aufblitzen in "
        "Euren Haenden und laesst nichts zurueck."));
      if (environment(environment()))
        tell_room(environment(environment()),break_string(
          "Mit einem kurzen blauen Aufblitzen verschwindet die Schriftrolle aus "
          +environment()->name(WESSEN)+" Haenden."),({environment()}));
    }
    else
      tell_room(environment(),break_string(
        "Mit einem kurzen blauen Aufblitzen verschwindet die Schriftrolle ohne "
        "Spuren zu hinterlassen."));
  }
  return ::remove();
}