/*******************
** Eldarea MUDLib **
********************
**
** /std/def_workroom.c - default workroom for new wizards
**
** CVS DATA
** $Date: 1999/11/05 12:30:46 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: def_workroom.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:46  elatar
** Preparing mudlib for cvs control
**
*/

inherit "std/room";

#include <properties.h>
#include <homes.h>

void create()
{
	::create();

	SetProp(P_DAYTIME_LIGHTS, ({4,4,4,4}));
	SetProp(P_INDOORS, 1);
	SetProp(P_INT_SHORT, "Ein grosser, bequemer Arbeitsraum");
	SetProp(P_INT_LONG,
		"Dies ist ein grosszuegiger, bequem eingerichteter Arbeitsraum. In der "
		"suedlichen Haelfte des Raumes steht ein grosser, eleganter "
		"Schreibtisch aus einem hellen, fast weissen Holz. Dahinter steht ein "
		"gepolsterter Stuhl. Die Wand hinter dem Schreibtisch ist mit einem "
		"riesigen Buecherregal ausgefuellt, in dem hunderte unterschiedlichster "
		"Buecher stehen. In der noerdlichen Haelfte des Raumes stehen mehrere, "
		"bequem aussehende Ledersessel und ein flacher, heller Holztisch. Neben "
		"Der Sitzgruppe, an der Westwand, steht ein schmaler Schrank mit "
		"teilweise glaesernen Tueren, in dem Glaeser und Karaffen mit "
		"verschiedenen Getraenken zu sehen sind. Die Nordwand des Raumes wird "
		"wird von grossen Fenstern eingenommen, welche einen herrlichen Blick "
		"nach draussen ueber die Wolken ermoeglichen. Eine helle Holztuere "
		"fuehrt nach Osten.");

	AddDetail(({"raum","arbeitsraum"}),
		"Ein grosser, bequem eingerichteter Arbeisraum.");
  AddDetail(({"tisch","holztisch"}),
    "Welchen Tisch meint ihr, den Schreibtisch oder den Couchtisch?");
  AddDetail(({"schreibtisch"}),
    "Ein grosser, eleganter Schreibtisch steht in der suedlichen Haelfte "
    "des Raumes. Er ist aus einem hellen, fast weissen Holz gefertigt, wie "
    "auch der Rest der Einrichtung. Er ist mit wenigen aber sehr "
    "kunstfertigen Schnitzereien verziert. An beiden Seiten des "
    "Schreibtisches befinden sich mehrere Schubladen.");
  AddDetail(({"stuhl","schreibtischstuhl"}),
    "Hinter dem Schreibtisch steht ein gepolsterter Schreibtischstuhl, "
    "welcher im gleichen Stil wie der Schreibtisch gehalten ist.");
  AddDetail(({"regal","buecherregal","buecher"}),
    "Ein riesiges, mit hunderten unterschiedlichster Buecher gefuelltes "
    "Regal steht an der Suedwand hinter dem Schreibtisch.");
  AddDetail(({"sessel","ledersessel"}),
    "Die Ledersessel in der Nordhaelfte des Raumes sind in einem zu den "
    "Fenstern hin offenen Halbkreis angeordnet. Sie sind mit einem hellen "
    "Leder bezogen. In ihrer Mitte steht der flache, ebenfalls helle "
    "Couchtisch.");
  AddDetail(({"couchtisch"}),
    "Der Couchtisch besteht aus dem gleichen, hellen Holz wie der Rest der "
    "Einrichtung. Seine Oberflaeche ist mit kunstvollen, aber dezenten "
    "Einlegearbeiten versehen, welche ein symbolisches Bild des "
    "Zusammenspiels von Sonne, Mond und Sternen darstellen.");
  AddDetail(({"schrank"}),
    "Ein schmaler Schrank aus hellem Holz steht an der Westwand des Raumes."
    "In der unteren Haelfte des Schranken sind zwei Schranktueren aus Holz "
    "angebracht, in der Mitte ist eine offene Ablageflaeche, auf der einige "
    "Glaeser und zwei Glaskaraffen mit farbigen Getraenken stehen, waehrend "
    "die obere Haelfte des Schrankes Glastueren hat und Glaeser in den "
    "unterschiedlichsten Formen beinhaltet.");
  AddDetail(({"fenster","nordwand"}),
    "Durch die grossen Fenster in der Nordwand des Raumes faellt helles "
    "Licht in den Raum. Nach draussen hat man einen herrlichen Blick ueber "
    "die in helles Sonnenlicht getauchten Wolken und den sich darueber "
    "woelbenden, klaren, azurblauen Himmel.",
    0,
    "Durch die grossen Fenster in der Nordwand des Raumes faellt das "
    "silbrige Licht der Sterne in den Raum. Nach draussen hat man einen "
    "herrlichen Blick ueber die in Sternenlicht getauchten Wolken und den "
    "sich darueber woelbenden, nachtblauen Himmel, an dem Myriaden von "
    "Sternen zu bewundern sind.");
  AddDetail(({"tuer","tuere","hoztuer","holztuere"}),
    "Eine Tuere aus hellem Holz mit einigen kunstvollen Schnitzereien "
    "fuehrt nach Osten.");
}
