/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: boardroom.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/room";

#include <properties.h>
#include <rooms.h>

init()
{	
	object ob;

	room::init();
	if (sizeof(explode(file_name(this_object()),"#"))==1){
		move_player_into_his_room();
		return;
	}
	ob=first_inventory(this_object());
	while (ob){
		if (interactive(ob) && ob != this_player()){
			move_player_into_his_room();
			return;
		}
		ob=next_inventory(ob);
	}
}

move_player_into_his_room()
{
	object broom;

	broom=clone_object(explode(file_name(this_object()),"#")[0]);
	this_player()->move(broom,"go");
}

exit()
{
	remove();
	call_out("remove",30);
}

remove()
{
	object ob;

	ob=first_inventory(this_object());
	while (ob)
	{
		if (interactive(ob)) return;
		ob=next_inventory(ob);
	}
	destruct(this_object());
	return 1;
}

create()
{
	room::create();
	SetProp(P_INT_SHORT,"Raum des schwarzen Brettes");
	SetProp(P_INT_LONG,"Dieser Raum enthaelt das schwarze Brett. Es kann immer nur genau ein Player\n"+
               "in diesem Raum sein, d.h., Du kannst jederzeit Nachrichten ans Brett haengen,\n"+
               "da niemand dieses Brett zur gleichen Zeit nutzen kann.\n"+
               "Eine Leiter fuehrt nach oben in die Gilde.\n");
	SetProp(P_LIGHT,1);
	AddCmd("mail","do_mail",1);
	AddItem("/obj/brett",REFRESH_REMOVE);
	AddExit("oben","/room/adv_guild");
	AddDetail("leiter", "Sie fuerht nach oben.\n");
	call_out("exit",60);
}             


