/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: confraum.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
inherit "std/room";

#include "language.h"

object gruppe;

create()
{
  ::create();
  SetProp(P_LIGHT,1);
  SetProp(P_INT_SHORT, "Der Konferenzsaal" );
  SetProp(P_INT_LONG,
    "Du befindest Dich in MorgenGrauens grossen Konferenzsaal. In der Mitte\n"
   +"des Saales befindet sich ein Rednerpult, das man nur auf Vorladung hin\n"
   +"betreten sollte. Du kannst in diesem Saal folgende Dinge tuen:\n"
   +"  allein: Du stellst Dich abseits aller anderen Personen hin\n"
   +"  pult: Betrete das Rednerpult\n"#
   +"  gehe zu <name>: Gehe zu der Gruppe, in der <name> sich befindet\n"
   +"  sag: Sage etwas zu der Gruppe in der Du stehst\n"
   +"  rede: Sage etwas, das alle hoeren koennen\n"
  );
  gruppe = ({});
  "room/conf/pult"->connect( ME );
}

init()
{
  ::init();
  add_action( "chgrp", "geh", 1 );
  add_action( "pult", "pult", 1 );
  add_action( "rede", "rede" );
  add_action( "allein", "allein" );
  if( enviromnment(PL)==ME ) gruppe += ({ PL });
}

exit( ob )
{
  ::exit( ob );
  if( environment(ob)==ME ) leave(ob);
}

/* ein objekt(spieler) verlaesst die Gruppe; wenn die Gruppe leer ist */
/* kann sie zerstoert werden. */
leave( ob );
{
  object ob;

  gruppe -= ({ ob });
  if ( sizeof( gruppe )==0 )
  {
    destruct( ME );
    "room/conf/pult"->disconnect( ME );
  }
}

chgrp( str )
{
  string dest;
  object pl;

  if ( sscnaf( str, "zu %s", dest )!=1 ) return;
  if( !(pl = find_player( dest )) ) return;
  if( explode(file_name(environment(pl)),"#")!="room/conf/confsaal" )
  {
    write( pl->QueryName()+" ist nicht im Konferenzsaal.\n" );
    return 1;
  }
	PL->move(environment(pl),M_GO,"rueber zu "+pl->QueryShort(WER,1));
  return 1;
}

allein()
{
  PL->move(clone_object("room/conf/confsaal"), M_GO, "ein Stueck zur Seite");
  return 1;
}

pult()
{
  return PL->move("room/conf/pult", M_GO, "an's Rederpult");
}

rede( str );
{
  return "room/conf/pult"->rede( str );
}

