/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: death.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
/* death.c */
/* Mrpr 901120 */

inherit "obj/monster";

/*
 * Function name: init
 * Description:   Init Death
 */
init() 
{

	::init();
	add_action("take_it", "take");
    add_action("take_it", "nimm");

}

/*
 * Function name: reset
 * Description:   Reset Death
 */
reset(arg) 
{

	::reset(arg);

	if (arg)
		return;

    set_name("Tod");
    set_alias("tod"); /* ME m(w)t */
	set_living_name("moot"); /* ME m(w)t */
	set_level(999);
    set_race("unsterblich");
    set_short("Tod in seiner schwarzen Robe");
	set_ac(50);
	set_wc(50);

}

/*
 * Function name: long
 * Description:   Long description
 */
long(str)
{
    str=lower_case(str);
    if (str == "tod")
    {   write("Der Tod scheint Jane Fonda's Diaetprogramm etwas zu ernst genommen zu haben.\n"+
              "Klarer Fall von Magersucht. Neben seiner grausigen Sense traegt er eine Robe\n"+
              "mit schwarzer Kapuze, die ihn bewundernswert gut kleidet. Irgendwas ist auch\n"+
              "mit seinen Augen, oder vielleicht ist es gerade das fehlen seiner Augen, das\n"+
              "Dir das Gefuehl gibt, das Du deine Untersuchungen nicht zu weit treiben\n"+
              "solltest ...\n");
		return 1;
	}
    if (str == "sense")
	{
        write("Eine extrem scharfe Sense. Sie ist so scharf, das selbst der Wind versucht,\n"+
              "nicht ueber die scharfe Schneide zu wehen, um nicht von der grausig aussehenden\n"+
              "Sense entzweigeschnitten zu werden. Sie veranstaltet seltsame Dinge mit dem\n"+
              "Licht, wenn unglueckliche Photonen auf die Schneide treffen und dabei in ihre\n"+
              "Unterbestandteile zerlegt werden.\n");
		return 1;
	}

	if (str == "robe")
	{
        write("Eine schwarze Robe mit zahllosen Taschen. Sie wuerde Dir wohl nicht sehr gut\n"+
              "passen. Sie scheint fuer einen sehr mageren Kunden genaeht worden zu sein.\n"+
              "SEHR mager sogar ...\n");
		return 1;
	}

	return 0;

}

/*
 * Function name: id
 * Description:   Identifies death and his belongings.
 */
id(str)
{
    str=lower_case(str);
    return str == "death" || str == "moot" || str == "tod" || str == "robe" || str=="sense";

}

/*
 * Function name: take_it
 * Description:   Try to take something from death.
 */
take_it(str)
{

	string name;
	int extra;

    str=lower_case(str);
	name = capitalize(this_player()->query_real_name());
	extra = random(90) + 10;

    if (str == "sense" || str == "robe")
	{

        write("Du greifst beherzt nach der "+capitalize(str)+" und versuchst, sie an Dich zu ziehen.\n"+
              "Der Tod runzelt missbilligend die Stirn, klopft Dir mit einer knochigen Hand\n"+
              "auf die Finger und sagt:\n"+
              "DUMMER STERBLICHER! DU HAST DIR GERADE "+extra+" ZUSAETZLICHE JAHRE IM FEGE-\n"+
              "FEUER EINGEHANDELT !\n");
		return 1;

	}

}
