/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: death_mark.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// /ROOM/DEATH/DEATH_MARK.C --- Das Zeichen des Todes
//
// Ueberarbeitung: Tommy@Wunderland
//
// $Date: 1999/11/05 12:30:45 $
// $Revision: 1.1.1.1 $
/* $Log: death_mark.c,v $
/* Revision 1.1.1.1  1999/11/05 12:30:45  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:11  en
/* MUDLib CVS Preperation
/*
 * Revision 1.1  1999/07/31 22:46:15  Largo
 * Initial revision
 *
 */

inherit "std/thing";

#include <properties.h>
#include <moving.h>
#include <death.h>

void start_death();
void message(object player);

void create()
{
  if(!clonep()) return;
  ::create();

  SetProp(P_NAME, "Stempel des Todes");
  SetProp(P_GENDER, MALE);
  AddId("death_mark");
}

void init()
{
  ::init();
  start_death();
}

/*
 * Function name: start_death
 * Description:   Start the death sequence.
 */
void start_death()
{	
  object env;

  env=environment();

  if(!env || !living(env)) return;
  if(!env->QueryProp(P_GHOST))
  {
    tell_object(env, "Du bist kein Geist, der Stempel wird zerstoert!\n");
    call_out("remove", 0);
    return;
  }

  message(env);

  say(break_string(
    "Du siehst eine dunkle Gestalt, die etwas Dunst einsammelt "
    "... oder vielleicht bildest du Dir das auch nur ein ..."));
  write(break_string(
    "Du kannst einen Mann mit dunkler Kapuze neben Deiner Leiche "
    "stehen sehen. Er wischt die blutige Klinge einer grausigen "
    "Sense mit langsamen, gemessenen Bewegungen ab. Ploetzlich "
    "hoert er auf und scheint Dich mit seinen leeren "
    "Augenhoehlen direkt anzusehen..."));

  switch(env->QueryProp(P_GENDER))
  {
    case FEMALE:
      write("\nDer Tod sagt: KOMM MIT MIR, STERBLICHE!\n\n");
      break;
    default:
      write("\nDer Tod sagt: KOMM MIT MIR, STERBLICHER!\n\n");
  }

  write(break_string(
    "Er greift nach Dir, und ploetzlich findest Du Dich an einem "
    "anderen Ort wieder."));
  env->move(DEATH_ROOM, M_GO | M_SILENT | M_NO_SHOW);
}

int move(object dest, int method)
{	
  if(!method & M_NOCHECK) return 0;
  return ::move(dest, method);
}

_query_autoloadobj()
{
  return 1;
}

void message(object player)
{
  int i;
  string fn;
  object killer;

  for(i=0;killer=previous_object(i);i++)
  {
    if(!objectp(killer)) continue;
    if(killer==player) continue;
    fn=file_name(killer);

    if(fn[0..7]=="/secure/") continue;
    if(fn[0..21]=="/room/death/death_mark") continue;

    if(fn=="/gilden/behueter/spells/spellbook") continue;
    if(fn=="/gilden/magiekundige/spells/spellbook") continue;
    if(fn=="/gilden/abenteurer/spells/spellbook") continue;
    break;
  }

  DEATH_ROOM->channel_message(killer, player);
}
