/*******************
** Eldarea MUDLib **
********************
**
** room/death/death_room - Todesraum
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** CVS History
**
** $Log: death_room.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/room";

#include <properties.h>
#include <moving.h>
#include <homes.h>
#include <daemon.h>
#include <wizlevels.h>
#include "sequences.c"

private static mixed *players=({});

object add_player(object player);
void remove_player(int num);
void do_remove();
void remove_death_obj(object player);
int filter(string str);
void room_msg(string str);
void channel_message(object killer, object player);

void create()
{
  ::create();

  SetProp(P_INT_SHORT, "Arbeitszimmer des Todes");
  SetProp(P_INT_LONG,
    "Ein dunkler Raum, erleuchtet von dunklem Licht, das sich "
    "der Dunkelheit nicht so sehr zu widersetzen scheint, indem "
    "es leuchtet, als dass es der dunkelste Punkt in einer "
    "weniger dunklen Umgebung ist. Im seltsamen Licht kannst Du "
    "einen zentral aufgestellen Schreibtisch, der mit Diagrammen "
    "und Buechern bedeckt ist, erkennen. Die Waende verschwinden "
    "hinter Regalen, die gefuellt sind mit in Leder gebundenen, "
    "dunklen Waelzern, von denen geheimnisvolle Runen "
    "leuchten.");
  SetProp(P_INDOORS, 1);
  SetProp(P_LIGHT, 1);

  AddCmd("", "filter", 1);
}

void init()
{
  int res;
  string prayroom;
  object player, me;

  ::init();

  me = this_object();
  player = this_player();

  if(!(prayroom = player->QueryPrayRoom()))
    prayroom = DEFAULT_PRAYROOM;

  if(!player->QueryProp(P_GHOST))
  {
    if(IS_WIZARD(player) && player->QueryProp(P_WANTS_TO_LEARN))
    {
      if(!player->QueryProp(P_INVIS))
        call_out("room_msg", 1, "WAS WILLST DU HIER, "+
          upper_case(player->name())+"? DU BIST UNSTERBLICH, DU "
          "HAST HIER NICHTS ZU SUCHEN!");
    }
    else
    {
      write("Der Tod sagt: WAS TUST DU HIER? DEINE ZEIT IST "
        "NOCH NICHT REIF !\n\n");
      if(catch(res=player->move(prayroom, M_GO | M_SILENT)) ||
        !res && environment(player)==me)
        player->move(DEFAULT_PRAYROOM, M_GO | M_SILENT);
    }
    return;
  }

  add_player(player);
  set_heart_beat(1);
}

object add_player(object player)
{
  int i, sequence_nr;
  mixed dseq;
  string fn;
  object pre, kill_liv, kill_ob;

  kill_liv=0;kill_ob=0;dseq=0;
  for(i=0;pre=previous_object(i);i++)
  {
    if(!objectp(pre)) continue;
    if(pre==player) continue;
    fn=file_name(pre);
    if(fn[0..7]=="/secure/") continue;
    if(fn[0..21]=="/room/death/death_mark") continue;
    if(living(pre))
    {
      kill_liv=pre; // Killer
      break;
    }
    kill_ob=pre; // killendes Objekt
  }
  if(kill_liv && function_exists("QueryProp", kill_liv))
    dseq=kill_liv->QueryProp(P_ENEMY_DEATH_SEQUENCE);
  if(!dseq && kill_ob && function_exists("QueryProp", kill_ob))
    dseq=kill_ob->QueryProp(P_ENEMY_DEATH_SEQUENCE);
  sequence_nr=1+random(sizeof(m_indices(msgs)));
  players+=({({player, 0, dseq, sequence_nr})});
  return kill_liv;
}

void remove_player(int num)
{
  players=players[0..num-1]+players[num+1..];
  if(!sizeof(players)) set_heart_beat(0);
}

void heart_beat()
{
  int j, nr, sz, i, k, gender, sz2, align, wert;
  string *words, *texte, msg;
  mapping newmsgs, tmp;

  while(j<sizeof(players))
    if(!objectp(players[j][0]) ||
       environment(players[j][0])!=this_object())
      players=players[0..j-1]+players[j+1..];
    else j++;
  
  if(!sizeof(players))
  {
    set_heart_beat(0);
    return;
  }

  nr=sizeof(players);
  for(j=sizeof(players)-1;j>=0;j--)
  {
    nr=++players[j][1];
    newmsgs=0;
    msg=0;
    tmp=msgs[players[j][3]];

    if(mappingp(players[j][2])) newmsgs=players[j][2];
    if(newmsgs) msg=newmsgs[nr];
    if(!msg) msg=tmp[nr];
    if(!msg) continue;

// Align einsetzen, falls noetig
    if((sz=sizeof(words=regexplode(msg,"\</*A\>")))>1)
    {
      align=players[j][0]->QueryProp(P_ALIGN);
      for(i=1;i<sz-1;i+=2)
      {
        if(words[i]=="</A>")
        {
           words[i]="";
           continue;
        }
        words[i]="";
        sz2=sizeof(texte=explode(words[i+1],"::"));
        wert=0;
        for(k=0;k<sz2;k++)
          if(k%2)
          {
            sscanf(texte[k],"%d",wert);
            if(align<wert) break;
          }
          else words[i+1]=texte[k];
      }
      msg=implode(words,"");
    }

// Gender einsetzen, falls noetig
    if((sz=sizeof(words=regexplode(msg,"\</*G\>")))>1)
    {
      gender=players[j][0]->QueryProp(P_GENDER);
      for(i=1;i<sz-1;i+=2)
      {
        if(words[i]=="</G>")
        {
          words[i]="";
          continue;
        }
        words[i]="";
        if(sizeof(texte=regexplode(words[i+1],":"))==3)
          words[i+1]=((string)((gender==MALE)?texte[0]:texte[2]));
      }
      msg=implode(words,"");
    }

    tell_object(players[j][0], msg);
  }

  do_remove();
}

void do_remove()
{
  int j, nr, res;
  string prayroom;

  nr=sizeof(players);
  for(j=0;j<nr;j++)
  {
    if(players[j][1]>=70)
    {
      remove_death_obj(players[j][0]);
      players[j][0]->StopHuntingMode(1);
      if(!(prayroom=players[j][0]->QueryPrayRoom()))
        prayroom=DEFAULT_PRAYROOM;
      if(catch(res=players[j][0]->move(prayroom, M_GO)) || !res)
        players[j][0]->move(DEFAULT_PRAYROOM, M_GO);
      remove_player(j);
      do_remove();
      return;
    }
  }
}

void remove_death_obj(object player)
{
  object plobj;

  while(plobj=present("death_mark", player)) plobj->remove();
}

int filter(string str)
{
  string verb;
  object player;

  player = this_player();
  verb   = query_verb();

  if(IS_LEARNER(player) && player->QueryProp(P_WANTS_TO_LEARN))
  {
    switch(verb)
    {
      case "xuh":
      case "guh":
        write("Der Tod sagt: LASS DAS BITTE!\n\n");
        return 1;
      case "zap":
        write("Der Tod sagt: WILLST DU MIR ETWA NOCH MEHR "+
          "ARBEIT MACHEN?\n\n");
        return 1;
    }
    return 0;
  }

  if(IS_LEARNER(player))
  {
    switch(verb)
    {
      case "mschau":
	case "ende":
	case "quit": 
		return 0;
    }
    write("Im Spielermodus kannst du hier garnix machen .... *eg*\n");
    return 1;
  }

  if(verb=="quit" || verb=="ende")
  {
    write("Der Tod sagt: DU KANNST DEM TOD NICHT ENTRINNEN!\n");
    return 0;
  }

  if (verb=="-M" && str) {
    verb=player->QueryProp(P_NAME);
    if (lower_case(verb)!=getuid(player)) verb = capitalize(getuid(player));
    SetProp(P_ARTICLE, 0);
    SetProp(P_NAME, "Geist von "+verb);
    VOICEMASTER->SendToChannel("Moerder", ME, MSG_SAY, str);
    SetProp(P_NAME, 0);
    return 1;
  }

  write("Das ist in Deinem immateriellen Zustand nicht moeglich.\n");
  return 1;
}

void room_msg(string str)
{
  tell_room(this_object(),
    break_string(str, 0, "Der Tod sagt: ")+"\n");
}

void channel_message(object killer, object player)
{
  string opfer, taeter, message, emessage;
  string name1, name2;
  object me;

  me = this_object();
  opfer = player->name(WEN);
  if (player->pk_running()) killer = player;

  if(player->QueryProp(P_GHOST) != 0 || !IS_LEARNER(player))
  {
    me->SetProp(P_ARTICLE,0);

    if(!killer)
    {
      message = capitalize(player->name(WER))+
             " versuchte vergeblich mir zu entkommen...";
      VOICEMASTER->SendToChannel("Tod", me, MSG_SAY, message);
    }
    else
    {
      name1 = killer->QueryProp(P_DC_NAME1);
      name2 = killer->QueryProp(P_DC_NAME2);
      emessage = killer->QueryProp(P_DC_MSG);
      if (killer == player) { // Hilfskonstrukt fuer PKs wieder loeschen
        killer->SetProp(P_DC_NAME1, 0);
        killer->SetProp(P_DC_NAME2, 0);
        killer->SetProp(P_DC_MSG, 0);
      }

      if(living(killer))
      {
        if(!name1) taeter = capitalize(killer->name(WER));
        else taeter = name1;
      }
      else
      {
        if(!name1) {
          taeter = "Etwas geheimnisvolles und unbekanntes";
          log_file("DIE_MSG", dtime(time())[5..]+": P_DC_NAME1 fehlt in "+
            to_string(killer)+"\n");
        } else taeter = name1;
      }
      message = taeter+" hat gerade "+opfer+" umgebracht.";
      VOICEMASTER->SendToChannel("Tod", me, MSG_SAY, message);
      if(emessage)
      {
        if(!name2) name2 = killer->name(WER);
        if(!name2) name2 = name1;
        me->SetProp(P_NAME, name2);
        VOICEMASTER->SendToChannel("Tod", me, MSG_SAY, emessage);
        me->SetProp(P_NAME, 0);
      }
    }
  }
}
