/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: entscheidung.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
/*
 * Der Raum der Entscheidung
 * ---
 * Hierher kommen Spieler bei versuchtem PK.
 * Sie koennen dann einen von drei Hebeln ziehen, der vielleicht Leben
 * oder aber den sicheren Tod (zu 66%) bedeutet.
 *
 * Erweiterungen sind noch in Planung (Begnadigung durch den
 * Angegriffenen zB.).
 *
 */

inherit "std/room";

#include <properties.h>
#include <wizlevels.h>
#include <language.h>
#include <moving.h>
#include <player.h>

void create()
{
  ::create();

  SetProp(P_LIGHT, 1 );
  SetProp(P_INT_SHORT, "Der Raum der Entscheidung");
  SetProp(P_INT_LONG,
    "Du stehst in einem kalten dunklen Verlies - vermutlich nicht ohne Grund. "
    "An einer Wand kannst Du drei Hebel erkennen, einer von ihnen bedeutet "
    "Leben, die beiden anderen den sicheren Tod. Mit <ziehe hebel x> kannst "
    "Du Dich fuer einen der Hebel entscheiden... Viel Glueck, auch wenn Du "
    "es gar nicht verdient hast!");
  SetProp(P_INDOORS,1);
}

void init()
{
  ::init();

  if (IS_ARCH(this_player()))
    return;

  add_action("abc", "", 1);
}

int abc (string str)
{
  string v;

  v=query_verb();
  if (stringp(v)&&v!=""&&
    (member( ({"sag", "sage", "nick", "nicke", "nein", "schau", "schaue"}), v)
      !=-1||v[0]=='\'')) return 0;

  if (stringp(v) && (v=="zieh" || v=="ziehe"))
  {
    if (stringp(str) && str[0..5]=="hebel ")
    {
      int n;

      if ((n=member(({"1","2","3"}), str[6..])) == -1)
      {
        write ("WAS fuer einen Hebel? Es gibt nur 1, 2 oder 3.\n");
        write ("Entscheide Dich.\n");
        write ("Jetzt.\n");
        return 1;
      }
      else
      {
        write ("\nDu ziehst am Hebel "+(n+1)+", und......\n\n");
        if (n==random(3))
        {
          write ("Uff - nochmal Glueck gehabt!!\n\n"+
            "Du verlierst fuer einen Augenblick die Orientierung...\n");
          this_player()->move("/gilden/touristen/room/buero", M_GO|M_NOCHECK);
        }
        else
        {
          write ("Ohjeh... das war wohl der falsche Hebel...\n\n");
          this_player()->SetProp(P_MURDER_MSG, "000");
          this_player()->SetProp(P_DC_MSG,     "111");
          this_player()->SetProp(P_DC_NAME1,   "222");
          this_player()->SetProp(P_DC_NAME2,   "333");
          SetProp(P_DC_MSG,     "Siehste " + capitalize(this_player()->name(WER)) + ", PKs lohnen sich nicht :)");
          SetProp(P_DC_NAME1,   "Der Tod selbst");
          SetProp(P_DC_NAME2,   "Tod");
          this_player()->die();
        }
      }
    }
    else
    {
      write("Syntax: ziehe hebel <n>\n");
    }
  }
  else
  {
    if (IS_WIZARD(this_player()))
      return 0;

    write("Nix da.\n");
  }

  return 1;
}

