/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: mkz.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
//
// ROOM/MKZ.C - Mudkontrollzentrum
// 
// Autoren: Holger@Wunderland 17.02.98
//
// Based on Wunderland Mudlib
//
// $Log: mkz.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:45  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:11  en
// MUDLib CVS Preperation
//
// Revision 1.4  1999/08/05 00:34:30  Largo
// *grummel* ein "/secure/master"
// hatte ich vergessen
//
// Revision 1.3  1999/08/05 00:32:31  Largo
// Ausgaenge in die Regionen neu gesetzt
//
// Revision 1.2  1999/08/05 00:31:07  Largo
// "Wunderland" -> MUDNAME und
// "/secure/master" -> MASTER
//
// Revision 1.1  1999/08/01 18:49:34  Largo
// Initial revision
//

inherit "std/room";

#include <properties.h>
#include <wizlevels.h>
#include <homes.h>
#include <defines.h>
#include <config.h>

string tafel();

void create() {
    ::create();
    SetProp(P_LIGHT,1);
    SetProp(P_INDOORS, 1);
    SetProp(P_INT_SHORT,"Mud-Kontollzentrum");
    SetProp(P_INT_LONG,
	"Du befindest Dich in einem halbfertigen Kontrollraum. Aus riesigen "
	"Schaltkaesten und -tafeln schaut ein Gewirr aus bunten Kabeln "
	"hervor. An einer Wand haengt eine Kontrolltafel, die halbwegs "
        "fertig aussieht, daneben befindet sich ein Pult mit ein "
	"paar leuchtenden Schaltern.\n"
	"Du kannst von hier aus in den Arbeitsraum eines jeden Magiers "
	"kommen, indem Du einfach nur seinen Namen tippst. Ausserdem kannst "
        "Du hier ab Magierlevel 40 Namen banishen. (banish <name> <grund>)");
    
    AddDetail(({"kasten","kaesten","schaltkasten","schaltkaesten"}),
        "Ueberall siehst Du grosse beeindrueckende Schaltkaesten. Was da wohl "
        "drin geschaltet wird?!?");
    AddDetail(({"gewirr","wirrwar","kabel"}),
        "Aus den Schaltkaesten haengt ein Gewirr an losen Kabel heraus. Hier "
        "ist wohl alles noch nicht fertig. Du fragst Dich, wer das hier "
        "jemals entfitzen will.");
    AddDetail(({"faden","faeden"}),
        "Hier laufen wohl alle Faeden des Muds zusammen. Alles scheint man von "
        "hier aus steuern zu koennen...");
    AddDetail(({"wand","waende"}),
        "Die Waende sind recht schmucklos. An einer haengt eine Kontrolltafel.");
    AddDetail(({"boden"}),
        "Der Boden ist frisch gebohnert.");
    AddDetail(({"decke"}),
        "An der Decke ist nichts. Nichtmal eine Lampe.");
    AddDetail(({"mud",lower_case(MUDNAME)}),
        "Genau. Das ist das Kontroll-Zentrum des Muds "MUDNAME"...");
    AddDetail(({"arbeitsraum","workroom"}),
        "Du kannst von hier aus in den Arbeitsraum eines jeden Magiers "
	"kommen, indem Du einfach nur seinen Namen tippst.");
    AddDetail(({"raum","kontrollzentrum","kontrollraum","zentrum"}),
        QueryProp(P_INT_LONG));
    AddDetail(({"pult","schaltpult","kontrollpult"}),
        "Die Knoepfe sind wie folgt beschriftet:\n"+
        "1. Reparatur (preloading wird wiederholt, birgt KEINE Risiken)\n"+
        "2. Hilfsupdate (update von /std und /obj, relativ sicher)\n"+
        "3. Globaler Update (NUR FUER NOTFAELLE, STARKE BEEINTRAECHTIGUNG DES "
        "SPIELS)\n"+
        "4. Armageddon (Zeitspanne 10 Minuten)\n");
    AddDetail(({"tafeln","schalttafeln","kontrolltafeln"}),
        "Ein paar grosse Schalt- und Kontrolltafeln wecken Dein Interesse. "
        "Eine faellt Dir besonders auf.");
    AddDetail(({"tafel","schalttafel","kontrolltafel"}),#'tafel);
            
    AddExit("zentrum", "/d/zentrum/ikz", 0, ({0,
        "&Name geht in das Kontrollzentrum der Region Zentrum."}));
    AddExit("treff", "room/treff", 0, ({0,
	"&Name geht in den Magiertreff."}));
    AddExit("bank", "/secure/zentralbank", 0, ({
        0, "&Name geht in die Zentralbank."}));
        
    AddCmd(({"druecke","drueck"}),"druecke");
    AddCmd("","workroom",1);
}

int workroom() {
    string pln,plw;
    if (query_verb()[0] < 'a' || query_verb()[0] > 'z')
        return 0;
    if (file_size("/players/"+query_verb()) != -2)
        return 0;
    plw="/players/"+query_verb()+"/workroom";
    pln=capitalize(query_verb());
    this_player()->move(plw,130,"in den Arbeitsraum von "+pln,"teleportiert","kommt herein");
    return 1;
}

int secure() {
    object ti;
    if(!ti=this_interactive()) return 0;
    if(!IS_LORD(ti)) return 0;
    return 1;
}
  

string tafel() {
    string s;
    int idle_1, idle_5, magier, leipzig, i;
    mixed tmp;

    leipzig=0;
    idle_5=0;
    idle_1=0;
    magier=0;
    s="";
    for (i=0;i<sizeof(users());i++) {
        tmp=query_ip_number(users()[i]);
        tmp=explode(tmp,".");
        if (sizeof(tmp)==4 && (tmp[0]=="139" && tmp[1]=="18")) leipzig++;
        tmp=query_idle(users()[i]);
        if (tmp>300) idle_5++;
        else
            if (tmp>60) idle_1++;
        if (IS_WIZARD(users()[i])) magier++;
    }
    s+="Diese Kontrolltafel gibt Auskunft ueber ein paar wichtige Daten des "
        "Muds.\n";
    s+=break_string(sprintf("Es %s sich zur Zeit %d Person%s im Mud auf. %d "
        "davon %s Magier. Von den Teilnehmern %s %d zwischen 1 und 5 Minuten, "
        "%d ueber 5 Minuten inaktiv. %d der Mitspieler komm%s aus Leipzig.\n",
        (sizeof(users())==1 ? "haelt" : "halten"), sizeof(users()),
        (sizeof(users())==1 ? "" : "en"), magier,
        (magier==1 ? "ist" : "sind"), 
        (idle_1==1 ? "ist":"sind"), idle_1, idle_5, leipzig,
        (leipzig==1 ? "t":"en")));
    s+=MUDNAME" ist "+dtime(last_reboot_time())+" zuletzt neu gebooted "
        "worden.\nDamit ist es seit "+(string)(time()-last_reboot_time())+
        " Sekunden aktiv, das sind "+uptime()+".\n";
    s+="Das "MUDNAME" existiert seit ca. "+exist_days()+" Tagen.\n";
    PL->More(s,0);
    return "";
}

int druecke(string str) {
    object ti;

    notify_fail("Welchen Knopf willst Du denn druecken?\n");
    if(!str) return 0;

    if(!secure()) {
        notify_fail("Das duerfen erst Magier ab Level 45!\n");
        return 0;
    }

    ti=this_interactive();

    switch (str) {
        case "1":
        case "reparatur":
            write("Ok.\n");
            say(ti->name(WER)+" startet den Reparaturmechanismus.\n");
            MASTER->redo_preload();
            return 1;
        case "2":
        case "hilfsupdate":
            write("Ok.\n");
            say(ti->name(WER)+" loest ein Update der Standardobjekte aus.\n");
            MASTER->update_subtree("std");
            MASTER->update_subtree("obj");
            return 1;
        case "3":
        case "globaler update":
            if (!IS_ARCH(ti)) {
                write(break_string("Diese Funktion ist nur Erzmagiern "
                    "zugaenglich, da sie das Spiel stark beeintraechtigen "
                    "wuerde.", 0, "Eine Stimme schnarrt: ", BS_FOR_COMM));
                return 1;
            }
            write("Ok. Globaler Update gestartet.\n");
            shout(break_string(ti->name(WER)+" hat einen globalen Update "
                "ausgeloest. In den naechsten 3 Minuten koennen seltsame "
                "Effekte auftreten."));
            MASTER->update_subtree();
            return 1;
        case "4":
        case "armageddon":
            if (!IS_ARCH(ti)) {
                write(break_string("Nur Erzmagiern ist es gestattet, "
                    "Armageddon ins Spiel zu holen.", BS_STDLEN, "Eine "
                    "Stimme schnarrt: ", BS_FOR_COMM));
                return 1;
            }
            write("Armageddon ausgeloest.\n");
            shout(ti->name(WER)+" hat Armageddon ins Spiel geholt !\n");
            "obj/shut"->shut(600);
            return 1;
        default:
    }
    return 1;
}

void init() {
  ::init();
  if(IS_LORD(PL))
    add_action("banish","banish");
      
  if(IS_ARCH(PL))
    add_action("mbanish","mbanish");
}

static int banish(string str) {
  string grund, name, *args;
 
  if(!IS_LORD(this_interactive()))
    return 0; 
 
  notify_fail("syntax: banish <name> <grund>\n");

  if(!str || !(args=explode(str," ")))
    return 0;
    
  args-=({""});
  
  if(sizeof(args)<2)
    return 0;

  name=lower_case(args[0]);
  grund=implode(args[1..]," ");
  MASTER->BanishName(name, grund);
  write("OK.\n");
  return 1;
}
 
static int mbanish(string str) {
  string grund, name, *args;
 
  if(!IS_ARCH(this_interactive())) 
    return 0;
 
  notify_fail("syntax: mbanish <name> <grund>\n");
 
  if(!str || !(args=explode(str," ")))
    return 0;

  args-=({""});
  
  if(sizeof(args)<2)
    return 0;

  name=lower_case(args[0]);
  grund=implode(args[1..]," ");
  HURRIKAP->MBanishInsert(name, grund, this_interactive());
  return 1;
}
 
