/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: wohnwagen.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// ROOM/WOHNWAGEN.C --- Default-Startroom
//
// Ellis Wohnwagen frei nach Beschreibung von A.Wolkow
// aus "Der Zauberer der Smaragdenstadt" S.5
//
// Author: Holger@Wunderland
//
// $Revision: 1.1.1.1 $
//
// $Log: wohnwagen.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:45  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:11  en
// MUDLib CVS Preperation
//
// Revision 1.12  1999/05/18 07:23:35  Holger
// Uhr wurde verlegt
//
// Revision 1.11  1999/03/30 14:32:34  Holger
// Diverse Typos gefixt.
// Bestimmte Items werden im Testmud nicht geclont (kein Bug beim laden)
//
// Revision 1.10  1999/01/12 09:47:28  Fiona
// Dino ist umgezogen nach +wunderland/alle/
//
// Revision 1.9  1998/06/01 11:40:56  Holger
// RITEM_FILE statt 1 in newbook()
//
// Revision 1.8  1998/04/16 16:02:44  Fiona
// Buchautomat durch intelligente Buecher ersetzt, dabei erforderlich funs
// eingebaut
//
//

inherit "std/room";

#include <config.h>
#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <moving.h>
#include <uhr.h>

#define BS break_string

#define TRUE 1
#define FALSE 0

int kerze_on;
object* books;

create() {
    ::create();

    kerze_on=FALSE; //  Kerze aus!
    books=({});
    SetProp( P_LIGHT, 2 );
    SetProp( P_INDOORS, 1 );
    SetProp( P_INT_SHORT, "Ellis Wohnwagen" );
    SetProp( P_INT_LONG,
        "Du stehst in dem alten, mittlerweile ziemlich verfallenen "
        "Wohnwagen, mit dem Elli vor vielen Jahren ins Wunderland "
        "gekommen ist. Ein paar Lichtstrahlen durchdringen die "
        "leicht verstaubten Fenster und man kann dadurch den Raum gut "
        "ueberblicken. Die fleissigen Kaeuer schauen wohl hin und "
        "wieder mal nach dem rechten. Im vorderen Teil des Wohnwagens "
        "steht ein Holztisch, um den herum drei Stuehle aufgestellt "
        "wurden. An der Seite steht ein Schrank. Im hinteren Teil des "
        "Wagens erkennst Du zwei einfache Holzbetten. Daneben verrostet "
        "ein alter Blechofen. An der Rueckwand haengt ein kleines, "
        "gemaltes Bild.");
    SetProp( P_INT_LONG_NIGHT,
        "Du stehst in dem alten, mittlerweile ziemlich verfallenen "
        "Wohnwagen, mit dem Elli vor vielen Jahren ins Wunderland "
        "gekommen ist. Eine kleine Kerze auf dem Tisch erhellt den Raum "
        "ein wenig. Im vorderen Teil des Wohnwagens "
        "steht ein Holztisch, um den herum drei Stuehle aufgestellt "
        "wurden. An der Seite steht ein Schrank. Im hinteren Teil des "
        "Wagens erkennst Du zwei einfache Holzbetten. Daneben verrostet "
        "ein alter Blechofen. An der Rueckwand haengt ein kleines, "
        "gemaltes Bild.");

    AddDetail(({"teil"}),
        "Im vorderen Teil des Wohnwagens steht ein Tisch mit drei Stuehlen "
        "drum herum.");
    AddDetail(({"wagen", "raum", "packwagen","wohnwagen"}),
        "Das ist ein alter Packwagen aus Holz, wie ihn Zirkusartisten "
        "haben. Er diente einmal Ellis Familie als Wohnung.");
    AddDetail(({"holz","buchenholz"}),
        "Das ist ganz normales Buchenholz. Nichts besonderes.");
    AddDetail(({"elli"}),
        "Elli war bestimmt schon lange nicht mehr hier.");
    AddDetail(({"wunderland","land"}),
        "Du bist mittendrin im Wunderland.");
    AddDetail(({"lichtstrahlen","strahlen","licht"}),
        "Durch das verstaubte Fenster dringt ein wenig Licht. "
        "Es reicht, um den Wagen zu ueberblicken.",
        "Eine kleine Kerze erhellt den Raum.");
    AddDetail(({"kerze","wachs","wachskerze"}),
        "Auf dem Tisch steht eine kleine Wachskerze. Sie scheint fuer die "
        "Nacht hier zu stehen. Sie ist aus und Du entschliesst Dich, sie "
        "nicht anzuzuenden, damit sie am Abend nicht verbraucht ist.",
        "Auf dem Tisch steht eine kleine Wachskerze. Sie erhellt den Raum "
        "etwas.");  
    AddDetail(({"fenster","loch"}),
        "Die Fenster sind geschlossen und mit einer leichten "
        "Staubschicht ueberzogen. Du wischst mit dem Finger ein "
        "Loch in den Staub und blickst nach draussen. Du siehst "
        "unweit eine kleine Haeuseransammlung. Das muss "
        "Kogida sein!");
    AddDetail( ({ "haeuseransammlung", "haeuser", "kogida" }),
        "Von hier aus kannst Du nichts erkennen, geh doch naeher ran.");
    AddDetail( ({ "Kaeuer" }),
        "Die fleissigen Kaeuer schauen dann und wann mal vorbei, "
        "um etwas aufzuraeumen und die wilden Tiere zu verjagen.");
    AddDetail( ({ "tiere" }),
        "Du drehst dich panisch um, doch ... nichts. Keine wilden "
        "Tiere weit und breit.");
    AddDetail( ({ "holztisch", "tisch" }),
        "Der Holztisch sieht noch ganz solide aus. Ellis Vater hat "
        "ihn mal gezimmert. Die vielen Jahre haben ihm nichts anhaben "
        "koennen. Auf dem Tisch ist nur eine duenne Staubschicht und eine "
        "kleine Kerze. Alles andere wird wohl bei dem Wirbelsturm "
        "heruntergefallen sein.");
    AddDetail( ({ "staubschicht", "schicht", "staub" }),
        "Ganz normaler Staub, wie auf Deinem Monitor.");
    AddDetail( ({ "wirbelsturm", "sturm" }),
        "Ein Wirbelsturm hat den Wohnwagen hierhergetragen.");
    AddDetail( ({ "stuehle", "stuhl" }),
        "Drei ganz normale Stuehle stehen um den Tisch herum.");
    AddDetail( ({ "seite" }),
        "An der Seite steht ein Schrank.");
    AddDetail( ({ "schrank", "hausrat" }),
        "Du stoeberst in allem moeglichen Hausrat herum, findest "+
        "aber nichts, was Dich interessiert.");
    AddDetail( ({ "holzbetten", "holzbett", "betten", "bett" }),
        "Die Betten sind aus einfachen Brettern zusammengesetzt. "
        "Sie sehen dennoch nicht unbequem aus, und die Farmersfamilie "
        "war bestimmt froh, wenn sie sich nach getaner Feldarbeit auf "
        "ihnen zur Ruhe legen konnte. Die Kaeuer muessen das Bettzeug "
        "mitgenommen haben, damit es hier draussen nicht verrottet, "
        "denn Du siehst nur eine Matratze.");
    AddDetail(({ "matratze","streifen"}),
        "Die Matratze ist blau gestreift. ");
    AddDetail(({"kanonenofen","ofen","ofenrohr","rohr","blechofen"}),
        "Ein alter Kanonenofen aus Blech. Er ist so verrostet, dass "
        "man an einigen Stellen schon durchschauen kann. Man sollte "
        "ihn wohl besser nicht mehr in Gang setzen, um zu vermeiden, "
        "dass hier alles abbrennt.");
    AddDetail(({"roststellen","stellen","rost","blech"}),
        "Faszinierende Formen aus rotbraunem Eisenoxidhydrat...");
    AddDetail(({"rueckwand"}),
        "Da haengt ein kleines Bild.");
    AddDetail(({"bild","gemaelde","vordergrund","hintergrund"}),
        "Auf dem kleinen Gemaelde siehst Du die weite Steppe von Kansas, "
        "mit einer kleinen Farm im Vordergrund. Fleissige Farmer "
        "bestellen die Maisfelder. Du denkst : ...home sweet home...");
    AddDetail(({"steppe","kansas","farm","farmer","maisfelder","mais",
        "felder"}),
        "Es ist wirklich ein sehr schoenes Bild. Vielleicht hat Elli es "
        "gemalt?");
    AddDetail(({"wand","waende"}),
        "Die Waende des Wohnwagens sind aus Holz. An der Nord und "
        "Suedwand sind kleine Fenster eingelassen. Ein kleines Bild "
        "ziert die schlichte Westwand. Im Osten ist die Tuer.");
    AddDetail(({"decke"}),
        "Durch die Decke fuehrt das Ofenrohr vom Ofen nach draussen.");
    AddDetail(({"boden","fussboden","bretter","dielenbretter","dielen"}),
        "Der Fussboden besteht aus fein verfugten Dielenbrettern. "
        "Auch er ist ueberzogen mit einer feinen Staubschicht und Du "
        "siehst genau Deine Fussspuren im Staub.");
    AddDetail( ({ "spuren", "fussspuren", "spur" }),
        "Deine Spuren gehen kreuz und quer durch den ganzen Wagen.");
    AddDetail( ({ "tuer" }),
        "Die Tuer ist schon ewig nicht mehr benutzt worden. Sie ist "
        "hoffnungslos verklemmt.");
        
    AddCmd( "zuende|zuend&kerze|wachskerze|ofen|blechofen&an","zuende",
        "Was willst Du zuenden?|Willst Du das vielleicht anzuenden?");
    AddCmd("loesch|loesche&kerze|kerzen|wachskerze|wachskerzen","loesch",
        "Was willst Du loeschen?");

    UHR->add_notify(this_object(), 0, "morgens");
    UHR->add_notify(this_object(), 2, "abends");

    //AddExit( "osten", "/d/wunderland/kogida/room/vorwagen" );

    AddItem("/obj/anfaengerbuch", REFRESH_NONE);
    AddItem("/obj/fackelautomat", REFRESH_REMOVE);
#ifndef __TESTMUD__ 
    //AddItem("/d/wunderland/fiona/obj/schild", REFRESH_REMOVE);
    //AddItem("/d/wunderland/alle/dino/dino", REFRESH_DESTRUCT);
#endif
}

int zuende(string str) {
    if(strstr(str,"kerze")>-1) {
        if (kerze_on==FALSE){
          write(BS("Du willst Dich gerade an der Kerze vergreifen, als "
            "ein Kaeuer hereinkommt und zu Dir sagt: 'Lass die Kerze in "
            "Ruhe! Jedesmal muss ich dann neue Kerzen kaufen, weil es "
            "immer Leute gibt, die es nicht lassen koennen, mitten am "
            "Tag die Kerze anzuzuenden!' Du bekommst ein schlechtes "
            "Gewissen und laesst von Deinem Vorhaben ab. Der Kaeuer "
            "verschwindet wieder.",BS_STDLEN));
          say(BS(capitalize(PL->name(WER,1))+" will sich gerade an der "
            "Kerze vergreifen, als ein Kaeuer herein kommt. Er sagt ein "
            "paar Worte zu "+PL->name(WEM,1)+" und verschwindet wieder. "+
            capitalize(PL->name(WER,1))+" laeuft rot an und laesst die "
            "Kerze in Ruhe.",BS_STDLEN));
        }
        else write("Die Kerze ist doch schon an!\n");
    }
    if(strstr(str,"ofen")>-1) {
        write(BS("Der alte Blechofen ist schon so sehr verrostet, dass es "
          "glatter Selbstmord waere, ihn hier anzuzuenden. Du laesst "
          "von Deinem Vorhaben ab.",BS_STDLEN));
        say(BS(capitalize(PL->name(WER,1))+" will gerade den uralten "
          "Blechofen in Gang setzen. Doch gerade als Du Dich schon in "
          "Sicherheit bringen willst, haelt "+PL->name(WER,1)+" inne und "
          "laesst von diesem riskanten Vorhaben ab.",BS_STDLEN));
    }
    return 1;
}

int loesch() {
    if (kerze_on==TRUE) {
    write(BS("Du willst gerade die Kerze auspusten, als ein Kaeuer "
        "hereinkommt und zu Dir sagt: 'Lass dir Kerze in Ruhe! Jedesmal "
        "muss ich dann mitten in der Nacht aufstehen, weil irgend jemand "
        "sich beschwert, dass es hier im Wohnwagen dunkel ist.' Du "
        "bekommst ein schlechtes Gewissen und laesst von Deinem Vorhaben "
        "ab. Der Kaeuer verschwindet wieder.", BS_STDLEN));
    say(BS(capitalize(PL->name(WER,1))+" will sich gerade an der Kerze "
        "vergreifen, als ein Kaeuer herein kommt. Er sagt ein paar Worte "
        "zu "+PL->name(WEM,1)+" und verschwindet wieder. "+
        capitalize(PL->name(WER,1))+" laeuft rot an und laesst die Kerze "
        "in Ruhe.",BS_STDLEN));
	}
    if(kerze_on==FALSE) write("Die Kerze ist doch schon aus!\n");
    return 1;
}

morgens() {
    tell_room(this_object(), BS("Ein Kaeuer kommt herein. Er schaut sich "
        "kurz um und laechelt Dich an. Dann haelt er die Hand hinter die "
        "Kerze, dass das Wachs nicht auf den Tisch spritzt und pustet die "
        "Kerze aus. Der Kaeuer geht wieder nach draussen.\n", BS_STDLEN,
        0, BS_LEAVE_MY_LFS));
    kerze_on=FALSE;
}

abends() {
    tell_room(this_object(), BS("Ein Kaeuer mit einer Oellampe kommt herein. "
        "Er laechelt Dich sanft an. Vorsichtig zuendet er die kleine "
        "Wachskerze an und verlaesst den Wohnwagen wieder.\n", BS_STDLEN,
        0, BS_LEAVE_MY_LFS));
    kerze_on=TRUE;
}

reset() {
  books=({});
  ::reset();
}

// Funktionen fuer Anfaengerbuch

// Diese Funktion wird aufgerufen, wenn das Handbuch (wahrscheinlich)
// genommen wurde
void NotifyHintbookGone() {
  while (remove_call_out("newbook")!=-1);
  call_out("newbook",1);
}

// Liefert diese Funktion -1 so darf pl kein Buch nehmen, aus
// Zeitgruenden
int GetHintbook(object pl) {
  if (member(books, pl)!=-1) return -1;
  books+=({ pl });
}

// Diese Funktion macht zaubert ein neues Handbuch her. Dabei wird
// auf P_ITEMS geachtet, da nur dann clean_up richtig geht
void newbook() {
  int i;
  mixed* x;
  if (present("/nhintbook")) return;
  tell_room(this_object(),"Ein Anfaengerhandbuch erscheint auf magische Weise.\n");
  x=QueryProp(P_ITEMS);
  for (i=sizeof(x); i--;) // Alte Eintraege entfernen
    if (x[i][RITEM_FILE]=="/obj/anfaengerbuch") x[i]=0;
  x-=({0});
  SetProp(P_ITEMS, x);
  AddItem("/obj/anfaengerbuch", REFRESH_NONE);
}
