/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: callmaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
/*  -*- LPC -*-  */
// M.D. MUDlib
// Basierend auf der Wunderland-Mudlib
//
// /SECURE/CALLMASTER.C --- Master for call_outs in MNPC's
//
// Author: Troy@Wunderland
//
// $Date: 1999/11/05 12:30:45 $
// $Revision: 1.1.1.1 $
/* $Log: callmaster.c,v $
/* Revision 1.1.1.1  1999/11/05 12:30:45  elatar
/* Preparing mudlib for cvs control
/*
/* Revision 1.1.1.1  1999/11/04 12:48:12  en
/* MUDLib CVS Preperation
/*
 * Revision 1.1  1999/08/05 11:59:20  Largo
 * Initial revision
 *
 */

#pragma strong_types

#include <wizlevels.h>

private mapping to_call,ob_call;
private int debug_flag;

int clone_check() // Hiervon soll NUR die Blueprint dasein.
{
  if(clonep()) return (int)destruct(this_object());
  return 0;
}

void create()
{
  to_call = ([]);
  ob_call = ([]);
  call_out("clone_check", 1);
}

private int find_minimum(int *arr)
{
  int min;

  if (arr && sizeof(arr))
    for (min = arr[0]; sizeof(arr); arr = arr[1..])
      if (min > arr[0]) min = arr[0];

  return min;
}

private void reduce_all(int num) // reduziert alle Zeiten um num
{
  mapping new_call;
  int *calls, i;

  if (num < 1) return;
  new_call = ([]);
  calls = (int*)m_indices(to_call);
  for (i = 0; i < sizeof(calls); i++)
    new_call[calls[i]-num] = to_call[calls[i]];
  to_call = new_call;
}

private void reduce_negative(int rest)
{
  int min;

  min = find_minimum((int*)m_indices(to_call)) - rest;
  reduce_all(min);
}

private void do_call()
{
  int min;

  while (remove_call_out("on_call") != -1);
  if (!to_call || !m_sizeof(to_call)) return;
  call_out("on_call", find_minimum((int*)m_indices(to_call)));
}

// Diese Funktion leistet die Hauptarbeit. Sie wird immer dann aufgerufen,
// wenn es Zeit ist ein Objekt oder eine Objektgruppe zu callen.
void on_call()
{
  object *obs, *alt;
  int i, ct;
  string s1, s2;

  reduce_all(find_minimum((int*)m_indices(to_call)));
  alt = (object*)to_call[0];
  efun::m_delete(to_call,0);
 
  if (alt)
  {
    for(obs=({});sizeof(alt);alt=alt[1..])
    if(alt[0] && objectp(alt[0]) && ob_call[alt[0]]) obs += ({alt[0]});
  }
 
  for (i=sizeof(obs); i--;)
    if (obs[i] && member(ob_call,obs[i]))
    {
      s1=to_string(obs[i]);
      if (!debug_flag)
      {
        if (s2=catch(call_other(obs[i],(string)ob_call[obs[i]][1]))) {
          log_file("CALLMASTER", sprintf("Catched %s: %s (%s)\n",
            s1, s2, ctime()));
          continue;
        }
      } else { // Debug an
        while (remove_call_out("check_running")!=-1);
        call_out("check_running", 1); // Neu starten, falls es gleich buggt
        call_other(obs[i],(string)ob_call[obs[i]][1]);
      }
      if (!obs[i] || !ob_call[obs[i]]) continue;
      if (closurep(ob_call[obs[i]][0])) 
        ct = (int)funcall((closure)ob_call[obs[i]][0]);
      else 
        ct = (int)ob_call[obs[i]][0];
      if (!to_call[ct]) to_call[ct] = ({obs[i]});
      else to_call[ct] += ({obs[i]});
    }

  do_call();
}

// Anmeldung (Jedes Obj kann nur 1x angemeldet sein!)
public void check_in(object ob, mixed ct, string cfunkt)
{
  int rest;

  if ((rest = find_call_out("on_call")) > -1) reduce_negative(rest);
  while (remove_call_out("on_call") != -1);

  if (closurep(ct)) rest = (int)funcall(ct);
  else if(intp(ct)) rest = (int)ct;
  else return do_call();

  if (!to_call[rest]) to_call[rest] = ({ob});
  else to_call[rest] += ({ob});
  if (!ob_call[ob]) ob_call[ob] = ({ct, ( cfunkt ? cfunkt : "go" ) });
  do_call();
}

// Abmeldung
public void check_out(object ob)
{ 
  if (ob_call[ob]) ob_call = m_delete(ob_call, ob);

  walk_mapping(to_call, lambda( ({'x, 'y, 'ob}),
    ({#'=, 'y, ({#'filter_array, 'y, #'!=, 'ob})}) ), ob);
}

// Diese Funktion destructet alle angemeldeten Objecte. Falls man etwas
// am Callmaster aendert und ihn so neu laden muss, wuerden sonst alle
// Objecte nur rumstehen. So muessen sie sich auf jeden Fall neu anmelden.
// Bei MNPCs kein Problem, kann es jedoch zu eigenartigen Situationen fuehren,
// wenn andere Objecte den Callmaster benutzen...  Fini
void ___remove_all_obj()
{
  object* x;
  int i;

  if (!IS_ARCH(this_interactive())) return;
  log_file("CALLMASTER", "All removed by "+
    capitalize(getuid(this_interactive()))+" ("+ctime()+")\n");
  x = m_indices(ob_call);
  for (i = sizeof(x); --i;)
  {
    if (x[i])
    {
      printf("%O\n", x[i]);
      x[i]->remove();
      if (x[i]) destruct(x[i]);
    }
  }
  printf("ok.\n");
}

// Diese Funktion erlaubt das Ausschalten von catch() bei den Aufrufen
// der Objektfunktionen. Somit kann man Fehler in diesen leichter finden,
// da sie dann auf -D auftauchen.
// Werte von modus: -1   Modus abfragen
//                   0   Debug aus (bzw catch() an)
//                   1   Debug an (fuer ein Fehlerereignis)
//                   2   Debug an (bis es ausgeschaltet wird)
// ACHTUNG: Nach einem Fehlerereignis koennte es evt. vorkommen, dass der
// Callmaster nicht weiterlaeuft. Man kann ihn mit check_running()
// wieder anstossen. (Im Regelfall startet er sich selbst neu.)
int ___enable_debug(int modus) {
  if (modus==-1) return debug_flag;
  if (!IS_ARCH(this_interactive())) return -1;
  return debug_flag=modus;
}

// Diese Funktion liefert die Zeit bis zum naechsten anstehenden Call
// zurueck. Wenn kein Call ansteht liefert sie -1. Steht der Callmaster,
// obwohl Objekte aufgerufen werden sollen, wird er neu gestartet und -2
// zurueckgeliefert.
public int check_running() {
  int rest;
  while (remove_call_out("check_running")!=-1);
  rest=find_call_out("on_call");
  if (rest>=0) return rest;
  if (!to_call || !m_sizeof(to_call)) return -1;
  log_file("CALLMASTER", sprintf("Restarting Callmaster at %s (Debug was %d)\n",
    ctime(), debug_flag));
  if (debug_flag==1) {
    debug_flag=0;
  }
  do_call();
  return -2;
}

// ([ Zeit: ({ opjectp, ... }), ... ])
mapping query_calls()
{
  return to_call+([]);
}

// ([ objectp: ({ (int/closure)Zeit, (string)Fun }), ... ])
mapping query_objects()
{
  return ob_call+([]);
}

int is_calling(object ob)
{
  int *i;

  for (i = (int *)m_indices(ob_call); sizeof(i); i = i[1..])
    if (member_array(ob, ob_call[i[0]]) > -1)
      return 1;
  return 0;
}
