/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: combat.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// SECURE/COMBAT.C - the combat master object
//
// Autor: Holger@Wunderland
//
// Ermoeglicht Statistik von Waffen und Ruestungen. Waffen werden beim
// Zuecken, Ruestungen beim Anziehen registriert, wenn sie aus dem Pfad
// von 'wmode' bzw. 'amode' stammen. Funktionen sind alle ausschliesslich
// fuer Erzmagier zugelassen.
//
// Bitte nicht staendig die Statistik laufen lassen! (teuer)
//
// Waffen-Statistik:
//   Aktivierung     : weapon_mode(string teilpfad) aufrufen
//   Abschaltung     : weapon_mode(0) aufrufen
//   Liste erstellen : dump_weapons() aufrufen (Pfad WEAPFILE)
//   Objekt ansehen  : print_weapon(object waffe) aufrufen
//
// Armour-Statistik (noch nicht implementiert!!!):
//   Aktivierung     : armour_mode(string teilpfad) aufrufen
//   Abschaltung     : armour_mode(0) aufrufen
//   Liste erstellen : dump_armours() aufrufen (Pfad ARMFILE)
//   Objekt ansehen  : print_armour(object ruestung) aufrufen
//
// Zuruecksetzen:
//   Waffen-Statistik : clear_weapons()
//   Armour-Statistik : clear_armours()
//   Alles            : clear_all()
//
// $Revision: 1.1.1.1 $
//
// $Log: combat.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:45  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:12  en
// MUDLib CVS Preperation
//
// Revision 1.5  1999/07/25 22:51:35  Holger
// ALTLISTDIR angelegt um ein alternatives Logfile anlegen zu koennen
//
// Revision 1.4  1999/05/03 00:40:10  Holger
// Diverse Kleinigkeiten
//
// Revision 1.3  1999/04/22 23:31:51  Holger
// Logging verbessert, intended

#include <wizlevels.h>
#include <combat.h>
#include <weapon.h>
#include <properties.h>

#pragma strict_types

#define SAVEFILE   "/secure/ARCH/save/combat"
#define LISTDIR    "/secure/ARCH/"

// Soll das Logfile nicht ins alternative Verzeichnis, dann die Kommentierung
// umkehren
#define ALTLISTDIR "/d/aussenwelt/LORD/"
//#define ALTLISTDIR ""

// LISTDIR (bzw. ALTLISTDIR) + WEAPFILE/ARMFILE
#define WEAPFILE "lists/weapons"
#define ARMFILE  "lists/armours"

private mixed wmode, amode;
private mapping weapons, armours;
// ([ typ : ([ pfad : 
//             ({ int max, int min, int alle, int anzahl, string* dtypes }); 
//             ({ int max, int min, int alle, int anzahl });
//                       int hands; int datum; int flen; int value;
//                       int maxlife; int gewicht; int bulkiness ]) ])

#define WDAM 0
#define WDEF 1

#define ADAM 0
#define ADEF 1

#define HAND 2
#define DATE 3
#define FLEN 4
#define VALU 5
#define LIFE 6
#define WEIG 7
#define BULK 8

private static void save_me();
private static void restore_me();

void create() {
  if(clonep(this_object())) { destruct(this_object()); return; }
  seteuid(getuid(this_object()));
  if(mappingp(weapons) && mappingp(armours))
    return;
  restore_me();
  if(!mappingp(weapons) || !mappingp(armours)) {
    weapons=([]);
    armours=([]);
  }
}

private static int secure() {
  if(this_interactive() && IS_ARCH(this_interactive()))
    return 1;
  return 0;
}

private static void save_me() {
  efun::save_object(SAVEFILE);
}

private static void restore_me() {
  efun::restore_object(SAVEFILE);
}

void clear_weapons() {
  if(!secure()) return;
  weapons=([]);
  save_me();
}

void clear_armours() {
  if(!secure()) return;
  armours=([]);
  save_me();
}
 
void clear_all() {
  clear_weapons();
  clear_armours();
}



// Validitaets-Logging

int valid_weapon_type(string t) {
  if(VALID_WEAPON_TYPE(t))
    return 1;
  log_file("COMBAT",sprintf("%s: Invalid WT (%s): %O\n",
    dtime(time())[5..], t, previous_object()));
 return 0;
}

int valid_armour_type(string t) {
  if(VALID_ARMOUR_TYPE(t))
     return 1;
  log_file("COMBAT",sprintf("%s: Invalid AT (%s): %O\n",
    dtime(time())[5..], t, previous_object()));
  return 0;
}



// Modi umschalten - argl ist ein Pfadbestandteil oder 0

mixed weapon_mode(mixed argl) {
  if(!secure())
    return -2;
  if(argl && !stringp(argl))
    return -1;
  wmode=argl;
  save_me();
  return wmode;
}

mixed armour_mode(mixed argl) {
  if(!secure())
    return -1;
  if(argl && !stringp(argl))
    return -1;
  amode=argl;
  save_me();
  return amode;
}



// Waffen Check Statistik

// aus living/combat aufgerufen
void RegisterWeapon(object ob) {
  string fil, typ;
  int smin, datum, laenge;
  if(!ob || !stringp(wmode)) return;
  fil=load_name(ob);
  if(strstr(fil,wmode)!=0) return;
  typ=(string)ob->QueryProp(P_WEAPON_TYPE);
  if(!member(weapons, typ)) weapons[typ]=([]);
  datum  = get_dir(fil+".c", 4)[0];
  laenge = get_dir(fil+".c", 2)[0];
  if(member(weapons[typ],fil) &&
     datum==weapons[typ][fil, DATE] &&
     laenge==weapons[typ][fil, FLEN]) return;
  smin=(int)ob->QueryProp(P_WC); // weil sonst Min immer 0 ist
  weapons[typ] += ([fil :
    ({0,smin,0,0,({})});
    ({0,0,0,0});
    (int)ob->QueryProp(P_NR_HANDS); 
    datum;
    laenge;
    (int)ob->QueryProp(P_VALUE);
    (int)ob->QueryProp(P_MAX_LIFETIME);
    (int)ob->QueryProp(P_WEIGHT);
    (int)ob->Query(P_BULKINESS)]);
  save_me();
}

// aus living/combat aufgerufen
void CheckWeaponDamage(object weap, object pl, object enemy, int damage,
                       string *damage_type) {
  if(stringp(wmode)) {
    string typ, fil;
    fil=load_name(weap);
    typ=(string)weap->QueryProp(P_WEAPON_TYPE);
    if(!member(weapons, typ) || !member(weapons[typ],fil)) return;
    if(damage>weapons[typ][fil, WDAM][0]) weapons[typ][fil, WDAM][0]=damage;
    if(damage<weapons[typ][fil, WDAM][1]) weapons[typ][fil, WDAM][1]=damage;
    weapons[typ][fil, WDAM][2] += damage;
    weapons[typ][fil, WDAM][3] ++;
    weapons[typ][fil, WDAM][4] = 
      m_indices(mkmapping(weapons[typ][fil, WDAM][4]+damage_type));
  }
  return;
}

// aus living/combat aufgerufen
void CheckWeaponDefend(object weapon, object pl, object enemy, int damage,
                       string *damage_type, int protect) {
  // not implemented yet
}

private static string gen_wentry(string what, string typ) {
  return sprintf("%-:58s  %:1d %:6d %:6d %:4d %:4d %:4d %:4d %:4d\n",
    what,
    weapons[typ][what, HAND],
    weapons[typ][what, VALU],
    weapons[typ][what, LIFE],
    weapons[typ][what, WEIG],
    weapons[typ][what, BULK],
    weapons[typ][what, WDAM][0],
    weapons[typ][what, WDAM][1],
    (weapons[typ][what, WDAM][3]?
    weapons[typ][what, WDAM][2]/weapons[typ][what, WDAM][3]:0));
}

// dumped alle Waffen
void dump_weapons() {
  string text;
  mixed *all, *types;
  int i;
  types = m_indices(weapons);
  text = "COMBAT-MASTER Weapon-Dump "+dtime(time())+"\n";
  for(i=sizeof(types);i--;) {
    text += sprintf("%-54s  %:5s %:6s %:6s %:4s %:4s %:4s %:4s %:4s\n",
      "ALLE WAFFEN TYP '"+types[i]+"': PFAD",
      "HANDS", "VALU", "LIFE", "WEIG", "BULK", "MAX", "MIN", "MITT");
    all = m_indices(weapons[types[i]]);
    text += implode(map_array(all, #'gen_wentry, types[i]),"");
  }
  rm(LISTDIR+WEAPFILE);
  write_file(LISTDIR+WEAPFILE, text);
  if(stringp(ALTLISTDIR) && strlen(ALTLISTDIR)) {
    rm(ALTLISTDIR+WEAPFILE);
    write_file(ALTLISTDIR+WEAPFILE, text);
  }
}

// Infos ueber eine bestimmte Waffe
void print_weapon(object argl) {
  string typ, fil;
  if(!objectp(argl)) return;
  if(!stringp(typ=(string)argl->QueryProp(P_WEAPON_TYPE))) {
    printf("Kein P_WEAPON_TYPE gesetzt!\n");
    return;
  }
  fil=load_name(argl);
  if(!member(weapons, typ) || !member(weapons[typ], fil)) {
    printf("Keine Daten ueber '%s'.\n",fil);
    return;
  }
  printf("TYP   : %s\nFILE  : %s\nDATE  : %s\nLENGTH: %d\nHANDS : %d\n"
    "VALUE : %d\nLIFETM: %d\nWEIGHT: %d\nBULKI : %d\n"
    "MAX   : %d\nMIN   : %d\nMITTEL: %d\nDAMTYP: %s\n",
    typ, fil, dtime(weapons[typ][fil, DATE]),weapons[typ][fil, FLEN],
    weapons[typ][fil, HAND], weapons[typ][fil, VALU],
    weapons[typ][fil, LIFE], weapons[typ][fil, WEIG],
    weapons[typ][fil, BULK], weapons[typ][fil, WDAM][0],
    weapons[typ][fil, WDAM][1], (weapons[typ][fil, WDAM][3]?
    weapons[typ][fil, WDAM][2]/weapons[typ][fil, WDAM][3]:0), 
    implode(weapons[typ][fil, WDAM][4],", "));
}



// Armour Check Statistik

// aus living/combat aufgerufen
void RegisterArmour(object ob) {
  // not implemented yet
}

// aus living/combat aufgerufen
void CheckArmourDamage(object arm, object pl, object enemy, int damage,
                       string *damage_type) {
  // not implemented yet
}

// aus living/combat aufgerufen
void CheckArmourDefend(object arm, object pl, object enemy, int damage,
                       string *damage_type, int protect) {
  // not implemented yet
}

// dumped alle Ruestungen
void dump_armours() {
  string text;
  text = "NOT IMPLEMETED YET!\n";
  rm(LISTDIR+ARMFILE);
  write_file(LISTDIR+WEAPFILE, text);
  if(stringp(ALTLISTDIR) && strlen(ALTLISTDIR)) {
    rm(ALTLISTDIR+ARMFILE);
    write_file(ALTLISTDIR+ARMFILE, text);
  }
}

// Infos ueber eine bestimmte Ruestung
void print_armour(object argl) {
  printf("NOT IMPLEMETED YET!\n");
}


// Selbstschutz

int query_prevent_shadow() { return 1; }

void reset() {
  save_me();
}

