/*******************
** Eldarea MUDLib **
********************
**
** secure/config.h - mud configuration
**
** CVS DATA
** $Date: 2000/11/30 16:06:18 $
** $Revision: 1.2 $
**
** general configuration is done here, the selection of gamedriver mode
** and the language to use
**
** CVS History
**
** $Log: config.h,v $
** Revision 1.2  2000/11/30 16:06:18  elatar
** Mudhost changed and various other small changes
**
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/

#ifndef __CONFIG_H__
#define __CONFIG_H__

#define MUDHOST "eldarea"
#define MUDCOMP "mtq036.wzl.rwth-aachen.de"
#define MUD_IP  "137.226.129.36"
#define MUD_PORT 6346
#define MUD_WWW "www.eldarea.de"
#define FTPD_IP "137.226.129.36"
#define UDPSERV "137.226.129.36"

#define MUDLIB         "Eldarea MUDLib"
#define MUDLIB_VERSION "0.01"

#define ADMIN_EMAIL "mud@eldarea.de"
#define ROOTNPC "Root"

// DEVMUD kann globales Define beim Driverstart sein
#ifndef DEVMUD
#  if (__HOST_NAME__==MUDHOST)
#    define MUDNAME "Eldarea"
#  else
#    define TESTMUD
#    define MUDNAME "Testmud-"+capitalize(__HOST_NAME__)
#  endif   
#else
#  define MUDNAME "DevEldarea"
#endif

// define general pathnames
#define MASTER         "secure/master"
#define MAILPATH       "mail/"
#define SAVEPATH       "save/"
#define NEWSPATH       "news/"
#define NEWSSERVER     "secure/news"
#define SECURESAVEPATH "secure/save/"
#define COMBAT_MASTER  "secure/combat"
#define WIZARDDIR      "players"
#define DOMAINDIR      "d"
#define PROJECTDIR     "p"
#define GUILDDIR       "gilden"
#define SPELLBOOKDIR   "spellbooks"
#define GLOBALDIR      "global"
#define MEMORY         "/secure/memory"

#define NETDEAD_ROOM "/room/netztot"
#define NETDEAD_CHECK_TIME 100

// define special userids
#define BACKBONEID " S T D "
#define ROOTID     " R O O T "
#define MAILID     " M A I L "
#define NEWSID     " N E W S "

#define MAX_LOG_SIZE 50000

#define BACKBONE_WIZINFO_SIZE 9
#define LIVING_NAME 3
#define NAME_LIVING 4
#define LAST_REBOOT 5
#define NETDEAD_MAP 6
#define IP_NAMES    7
#define MEMORY_BUFF 8

#ifndef SIMUL_EFUN_FILE
#define SIMUL_EFUN_FILE       "secure/simul_efun"
#endif
#ifndef SPARE_SIMUL_EFUN_FILE
#define SPARE_SIMUL_EFUN_FILE "secure/spare_simul_efun"
#endif

#endif

