/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:45 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: del_player.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:45  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
//
// /SECURE/DEL_PLAYER.C   -   removes savefile and all other files of
//                            players
//
// Author:  Mohammed@Wunderland
//
// $Log: del_player.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:45  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:12  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/05 00:25:19  Largo
// "secure/master" -> MASTER
//
// Revision 1.1  1999/08/02 10:00:59  Largo
// Initial revision
//

inherit "/std/shells/filesys/asynchron";

#include <properties.h>
#include <wizlevels.h>
#include <service.h>
#include <config.h>

#define DELETE_LOG	"/log/player/DEL_PLAYER"    // logfile

// Array ({ ({ bis Stufe, bis Alter (h), minimum Abwesend (d) )}, .. })
#define DELETE_SETTINGS ({ \
	({ 1,   1, 3*30 }), \
	({ 5,   6, 8*30 }), \
	({ 10, 12,  365 }), \
	})


#pragma strong_types

// prototypes
private int check_and_delete(string user);

mapping properties;
int age, simul;
mixed* delset=DELETE_SETTINGS;
int delnum;

void create() {
  if(clonep()) {
     destruct(this_object());
     return;
  }
  seteuid(getuid(this_object()));
  delnum=sizeof(delset);
}

private int secure() {
  if(!previous_object())
    return 0;
  if(geteuid(previous_object()) == ROOTID)
    return 1;
  if (this_interactive() != this_player())
    return 0;
  if(!IS_ARCH(this_interactive()))
    return 0;
  return 1;
}

// Hiermit startet man das alles. Ist s gesetzt, nur eine Simulation
public mixed delete_players(int s) {
  int i;
  mixed users;
  if (!secure()) return 0;
  simul=s;
  users=({});

  for(i='a';i<='z';i++) {
    users+=get_dir(sprintf("/save/%c/*",i));
  }
  asynchron(users-({ ".", ".." }), #'check_and_delete);
  return "Loeschung gestartet..."+(simul?" (simuliert)":"");
}

private int check_and_delete(string user) {
  int lvl, absent, i, d;
  string longname;
  properties = ([]);
  age = 0;
  if (user[<2..]!=".o") {
    write_file(DELETE_LOG, "WRONG: "+user+"\n");
    return 0;
  }
  longname=user[0..0]+"/"+(user=user[0..<3])+".o";
  restore_object("/save/"+longname[0..<3]);
  if (!properties) {
    write_file(DELETE_LOG, "NO PROPS: "+user+"\n");
    return 0;
  }
  if (MASTER->show_dir("/secure/save/"+longname,"fiona")=="No files found.\n") {
    write_file(DELETE_LOG, "NO SECSAVE: "+user+"\n");
    return 0;
  }
  absent = time()-file_date("/save/"+user[0..0]+"/"+user+".o");
  absent/=3600*24; // Tage
  age/=1800; // Stunden (age ist in 2 Sek Ticks)
  lvl=properties[P_LEVEL];

// Array ({ ({ bis Stufe, bis Alter (h), minimum Abwesend (d) )}, .. })
  for (i=delnum; i--;) {
    if (lvl>delset[i][0]) continue;
    if (age>delset[i][1]) continue;
    if (absent<delset[i][2]) continue;
    if (properties[P_TESTPLAYER]) {
      write_file(DELETE_LOG, "testpl: "+user+(stringp(properties[P_TESTPLAYER])?
        " "+properties[P_TESTPLAYER]:"")+"\n");
      break; // Nicht loeschen
    }
    write_file(DELETE_LOG,
      sprintf("removed: %:-13s lvl %:2d age %:4dh abs %:4dd\n",
      user, lvl, age, absent));
    d=1;
    if (simul) break;
    (void)rm("/secure/save/"+longname);
    (void)rm("/save/"+longname);
    (void)rm("/mail/"+longname);
    (void)rm("/players/gum/obj/kerbholz/save/"+longname);
    (void)rm("/etc/plans/"+user+".project");
    (void)rm("/etc/plans/"+user+".plan");
    MASTER->RemoveFromCache(user);
    //LIB_SENSOR->CallDeletePlayer(user);
    break;
  }
  if (!d && absent>356) {
    write_file(DELETE_LOG, 
      sprintf("OLD: %:-13s lvl %:2d age %:4dh abs %:4dd\n",
      user, lvl, age, absent));
  }
  return 1;
}

int remove() {
  remove_call_out("asynchron");
  destruct(this_object());
  return 1;

}
